<?php
// thank-you.php
include "../../config.php";
$order_id = $_GET['order_id'] ?? null;
if (!$order_id) {
    echo "Order ID is missing!";
    exit;
}

// Fetch the order details using the 'getorder' API
$orderDetails = file_get_contents(API_URL . "?gofor=getorder&order_id=" . $order_id);
$orderDetails = json_decode($orderDetails, true);

if (isset($orderDetails['Order List'])) {
    $order = $orderDetails['Order List'];
    $orderDetail = $orderDetails['Order Detail'];
    $productDetails = $orderDetails['Product Detail'];
    $customerDetails = $orderDetails['Customer Detail'];
    $addressDetails = $orderDetails['Address Detail'];
} else {
    echo "Failed to fetch order details.";
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">


<head>
    <?php include 'meta-tags.php';?>
    <link rel="shortcut icon" type="image/x-icon" href="assets/images/47 x 47-01.png">
    <!-- plugins css -->
    <link rel="stylesheet preload" href="assets/css/plugins.css" as="style">
    <link rel="stylesheet preload" href="assets/css/style.css" as="style">

</head>

<body>
<style>

    .main{
        display: flex;
            flex-direction: row;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
            padding: 40px;
    }
   

    .image-side {
        flex: 1;
        text-align: center;
        padding: 20px;
    }

    .image-side img {
        max-width: 100%;
        height: auto;
        border-radius: 10px;
    }

    .text-side {
        flex: 1;
        padding: 20px;
        color: #2f4f2f;
    }

    .text-side h1 {
        font-size: 2.5em;
        margin-bottom: 20px;
        color: #2e7d32;
    }

    .text-side p {
        font-size: 1.2em;
        line-height: 1.6;
    }

    @media (max-width: 768px) {
        .main {
            flex-direction: column;
        }
    }
</style>

    <!-- rts header area start -->
    <?php include "header.php";?>
    <!-- rts header area end -->


    <div class="main">
        <!-- Left Side: Image -->
        <div class="image-side">
            <img src="assets/images/Thank-You.jpg" alt="Dr's Siddha Herbal Medicine">
        </div>

        <!-- Right Side: Text -->
        <div class="text-side">
            <h1>Thank You for Your Order!</h1>
            <p>
              We value your trust and will deliver on it. If you have any doubts, we are a click away. Dr's.Siddha will keep delivering the most natural herbal products for health & longevity. We value our customer experience very much. Please feel free to share your feedback & drop down your suggestion.
            </p>
            <!-- <p>
                If you have any questions or concerns, feel free to reach out to our support team. We’re here to help you on your journey to better health, naturally.
            </p> -->
			<div>
				<a href="invoice.php?order_id=<?php echo $order_id;?>" class="rts-btn btn-primary" style="display:inline-block;" target="_blank">
					View Invoice
				</a>&nbsp;&nbsp;
				<a href="index.php" class="rts-btn btn-secondary" style="display:inline-block;">
					Goto Homepage
				</a>
			</div>
        </div>
    </div>

 <!-- whatsapp float icon -->  
	<?php include 'whatsapp.php';?>
    <!-- rts footer one area start -->
    <?php include 'footer.php';?>
    <!-- rts footer one area end -->





    <?php include "search-input.php";?>
    <div id="anywhere-home" class="anywere"></div>
    <!-- progress area start -->
    <div class="progress-wrap">
        <svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
            <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" style="transition: stroke-dashoffset 10ms linear 0s; stroke-dasharray: 307.919, 307.919; stroke-dashoffset: 307.919;"></path>
        </svg>
    </div>
    <!-- progress area end -->


    <!-- plugins js -->
    <script defer src="assets/js/plugins.js"></script>

    <!-- custom js -->
    <script defer src="assets/js/main.js"></script>
    <!-- header style two End -->
	<script>
	const API = "<?php echo API_URL; ?>";
	</script>
	<script src="assets/js/common.js"></script>
	<script defer src="assets/js/cart.js"></script>
	<script defer src="assets/js/wishlist.js"></script>
	<script src="assets/js/quantity-control.js"></script>


</body>


</html>