<?php
// landing-product.php
include "../../config.php"; // update path as needed
// === Set product ID manually here ===
$product_id = 259; // <-- change this to any product ID you want
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Loading Product...</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<style>
body { font-family: Arial, sans-serif; margin: 20px; }
.product-box { max-width: 400px; margin: auto; border: 1px solid #ddd; padding: 20px; border-radius: 10px; display: none; }
.product-box img { width: 100%; border-radius: 10px; }
.price { font-size: 22px; font-weight: bold; margin: 10px 0; color: #e91e63; }
.qty-box { display: flex; align-items: center; margin: 15px 0; }
.qty-box button { width: 35px; height: 35px; font-size: 18px; }
.qty-box input { width: 60px; text-align: center; font-size: 18px; margin: 0 5px; }
.buy-btn { background: #28a745; color: #fff; padding: 12px 20px; border: none; border-radius: 5px; cursor: pointer; font-size: 18px; width: 100%; }
.buy-btn:hover { background: #218838; }
</style>
</head>
<body>

<div class="product-box" id="productBox">
  <img id="productImage" src="" alt="">
  <h2 id="productName"></h2>
  <p class="price" id="productPrice"></p>
  <p class="unit" id="productUnit"></p>
  <div class="qty-box">
    <button onclick="updateQty(-1)">-</button>
    <input type="text" id="quantity" value="1" readonly>
    <button onclick="updateQty(1)">+</button>
  </div>

  <button class="buy-btn" id="buyNowBtn">Buy Now</button>
</div>

<!-- Hidden values -->
<input type="hidden" id="productId">
<input type="hidden" id="productNameHidden">
<input type="hidden" id="productPriceHidden">
<input type="hidden" id="productUnitHidden">
<input type="hidden" id="productImageHidden">

<script>
function updateQty(val) {
  let qty = parseInt(document.getElementById("quantity").value) + val;
  if (qty < 1) qty = 1;
  document.getElementById("quantity").value = qty;
}

// Fetch product details from API using the manual product_id
const productId = <?php echo $product_id; ?>;

if (productId > 0) {
  fetch(`<?php echo API_URL; ?>?gofor=productdetail&product_id=${productId}`)
    .then(res => res.json())
    .then(data => {
      if (data && data.product_details && data.product_details.length > 0) {
        const product = data.product_details[0];

        document.getElementById("productBox").style.display = "block";
        document.getElementById("productImage").src = product.product_image1 || "images/default-product.jpg";
        document.getElementById("productImage").alt = product.product_name || "Product";
        document.getElementById("productName").innerText = product.product_name || "Product Name";

        // Use first attribute's MRP if exists
        const price = data.product_attributes && data.product_attributes.length > 0
                      ? data.product_attributes[0].product_mrp
                      : 0;
        document.getElementById("productPrice").innerText = `₹${price}`;
		
		const measuring_unit = data.product_attributes && data.product_attributes.length > 0
                      ? data.product_attributes[0].product_measuring_unit_id
                      : 0;
		document.getElementById("productUnit").innerText = `${measuring_unit}`;

        // Set hidden inputs
        document.getElementById("productId").value = product.product_id;
        document.getElementById("productNameHidden").value = product.product_name;
        document.getElementById("productPriceHidden").value = price;
		document.getElementById("productUnitHidden").value = measuring_unit;
        document.getElementById("productImageHidden").value = product.product_image1;
      } else {
        alert("Product not found");
      }
    })
    .catch(err => console.error("Error fetching product:", err));
} else {
  alert("Invalid Product ID");
}

// Buy Now button
document.getElementById("buyNowBtn").addEventListener("click", function() {
  const productId = document.getElementById("productId").value;
  const productName = document.getElementById("productNameHidden").value;
  const productPrice = document.getElementById("productPriceHidden").value;
  const productUnit = document.getElementById("productUnitHidden").value;
  const productImage = document.getElementById("productImageHidden").value;
  const qty = document.getElementById("quantity").value;

  localStorage.setItem("landingProduct", JSON.stringify({
    id: productId,
    name: productName,
    price: productPrice,
	unit: productUnit,
    image: productImage,
    qty: qty
  }));

  window.location.href = "checkout.php?from=landing";
});
</script>

</body>
</html>
