<?php
// landing-invoice.php
include "../../config.php";
?>
<html class="no-js" lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>Shopping Cart | Dr Siddha diabetes combo</title>
    <meta name="description" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="shortcut icon" type="image/x-icon" href="assets/img/favicon.png">
    <!-- CSS here -->
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/animate.min.css">
    <link rel="stylesheet" href="assets/css/magnific-popup.css">
    <link rel="stylesheet" href="assets/css/fontawesome-all.min.css">
    <link rel="stylesheet" href="assets/css/mCustomScrollbar.min.css">
    <link rel="stylesheet" href="assets/css/jquery-ui.css">
    <link rel="stylesheet" href="assets/css/flaticon.css">
    <link rel="stylesheet" href="assets/css/slick.css">
    <link rel="stylesheet" href="assets/css/default.css">
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/responsive.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.1/css/all.min.css"
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <style>
		.invoice-box {padding:20px}
		.title { font-size: 24px; font-weight: bold; }
		.invoice-details, .items { width: 100%; margin-top: 20px; }
		.items th, .items td { border: 1px solid #ddd; padding: 8px; text-align: left; }
		.text-right {text-align:right !important;}
		.created-date{ font-size:16px;line-height:20px; }
		.address { font-size:16px;line-height:22px;font-style:normal; }
		.product-table table, .product-table th, .product-table td {border: 1px solid #DFDFDF;border-collapse: collapse;font-size:14px !important}
		.gt-div span {font-size:14px !important;line-height:20px}
		.download-btn{
			padding: 7px 15px;
			color: #FFF;border: 1px solid var(--Main);
			border-radius: 12px;
			background-color: var(--Main);font-size:14px
		}
	</style>
	<style>
	.special-header .header-action > ul li.offcanvas-btn a i{
		margin-top: 15px;
	}
	.fa-brands, .fa-classic.fa-brands, .fab {
		margin-top: 12px;
	}
	</style>
</head>

<body>
    <?php include "header.php";?>

    <!-- main-area -->
    <main>
        <!-- Cart Section -->
        <section class="cart-area pt-120 pb-120" style="background: #f9f9f9;">
            <div class="container">
                <div class="wg-box">
					<div class="row mb-4">
						<div class="col-md-12 text-right">
							<button class="btn solid-btn" id="download-pdf">Download PDF <i class="fa-solid fa-download"></i></button>
						</div>
					</div>

					<?php
						$order_id = $_GET['order_id'];
						$url = API_URL . '?gofor=getorder&order_id='.$order_id;
						$json = file_get_contents($url);
						$orderData = json_decode($json, true);     
						$order = $orderData['Order List'];
						$customer = $orderData['Customer Detail'][0];
						$products = $orderData['Product Detail'];
						$orderDetails = $orderData['Order Detail'];
						$addressDetails = $orderData['Address Detail'][0];
					?>

					<div class="invoice-box p-4 rounded shadow-sm bg-white">
						<!-- Header -->
						<div class="row border-bottom pb-3 mb-3">
							<div class="col-md-6">
								<img src="https://drsiddha.com/assets/images/logo.png" alt="logo" class="logo-img" style="max-width:180px;">
							</div>
							<div class="col-md-6 text-right">
								<p class="mb-0 fs-13">
									<strong>DRS SIDDHA</strong><br>
									1st Floor, Golluvar Agraharam Road,<br>
									Kanniyappan Colony 1st Street,<br>
									Washermanpet, Chennai-600021<br>
									Mobile: 739 738 6570<br>
									Email: drssiddha@gmail.com<br>
									Website: www.drsiddha.com
								</p>
							</div>
						</div>

						<!-- Invoice Info -->
						<div class="row mb-4">
							<div class="col-md-6">
								<h5>Billing Information</h5>
								<p class="mb-0">
									<?php echo $customer['first_name'].' '.$customer['last_name']; ?><br>
									Phone: <?php echo $customer['mobilenumber']; ?><br>
									Address: <?php echo $addressDetails['doorno'].' '.$addressDetails['street'].' '.$addressDetails['location'].' '.$addressDetails['city'].' '.$addressDetails['state'].' '.$addressDetails['pincode']; ?><br>
									Payment Method: 
									<?php
										$paymentMode = $orderData["Order List"]["payment_mode"];
										$paymentStatus = $orderData["Order List"]["payment_status"];
										echo strtolower($paymentMode) === "onlinepayment" ? "Online Payment | " . ($paymentStatus === "Paid" ? "Paid" : "Failed") : htmlspecialchars($paymentMode);
									?>
								</p>
							</div>
							<div class="col-md-6 text-right">
								<h5>Shipping Information</h5>
								<p class="mb-0">
									<?php echo $customer['first_name'].' '.$customer['last_name']; ?><br>
									Phone: <?php echo $customer['mobilenumber']; ?><br>
									Address: <?php echo $addressDetails['doorno'].' '.$addressDetails['street'].' '.$addressDetails['location'].' '.$addressDetails['city'].' '.$addressDetails['state'].' '.$addressDetails['pincode']; ?><br>
									Shipping Method: Courier / Postal
								</p>
							</div>
						</div>

						<!-- Product Table -->
						<div class="table-responsive mb-4">
							<table class="table table-bordered table-striped text-center">
								<thead class="thead-light">
									<tr>
										<th>#</th>
										<th>Product</th>
										<th>GST (%)</th>
										<th>QTY</th>
										<th>Unit Price (₹)</th>
										<th>Sub Total (₹)</th>
										<th>Tax (₹)</th>
										<th>Total (₹)</th>
									</tr>
								</thead>
								<tbody>
									<?php
										$subtotal = $subquantity = $subtax = $subproduct_tot = 0;
										$counter = 0;
										foreach ($orderDetails as $item) {
											foreach ($products as $product) {
												if ($product['product_id'] == $item['product_id']) {
													$productName = $product['product_name'];
													$productUnit = $item['prod_attri_id'];
													$quantity = $item['quantity'];
													$mrp = $product['product_mrp'];
													$gst = $product['product_sgst'] + $product['product_cgst'];

													$unitPrice = round($mrp / (1 + ($gst / 100)), 2);
													$tax_per_unit = $mrp - $unitPrice;

													$base_price_total = $unitPrice * $quantity;
													$tax_total = $tax_per_unit * $quantity;
													$product_tot = $mrp * $quantity;

													$subtotal += $base_price_total;
													$subquantity += $quantity;
													$subtax += $tax_total;
													$subproduct_tot += $product_tot;
									?>
									<tr>
										<th><?php echo ++$counter; ?></th>
										<td><?php echo $productName.' ('.$productUnit.')'; ?></td>
										<td><?php echo number_format($gst,2); ?></td>
										<td><?php echo $quantity; ?></td>
										<td><?php echo number_format($unitPrice,2); ?></td>
										<td><?php echo number_format($base_price_total,2); ?></td>
										<td><?php echo number_format($tax_total,2); ?></td>
										<td><?php echo number_format($product_tot,2); ?></td>
									</tr>
									<?php }}} ?>
									<tr class="font-weight-bold">
										<td colspan="3">Total</td>
										<td><?php echo number_format($subquantity,0); ?></td>
										<td></td>
										<td><?php echo number_format($subtotal,2); ?></td>
										<td><?php echo number_format($subtax,2); ?></td>
										<td><?php echo number_format($subproduct_tot,2); ?></td>
									</tr>
								</tbody>
							</table>
						</div>

						<!-- Totals -->
						<?php
							include "convertToIndianCurrency.php";
							$gtot = $orderData["Order List"]["total_amount"];
							$gst_split = number_format($subtax/2, 2);
						?>
						<div class="row mt-4">
							<div class="col-md-6">
								<p class="mb-2">CGST: ₹<?php echo $gst_split; ?> | SGST: ₹<?php echo $gst_split; ?></p>
								<p>Amount (In Words): <?php echo convertToIndianCurrency($gtot); ?></p>
							</div>
							<div class="col-md-6 text-right">
								<p>Total: ₹<?php echo number_format($subproduct_tot,2); ?></p>
								<p>Discount: ₹0.00</p>
								<p>Delivery Charges: ₹<?php echo number_format($orderData["Order List"]["delivery_charge"],2); ?></p>
								<h5 class="mt-2">GRAND TOTAL: ₹<?php echo number_format($orderData["Order List"]["total_amount"],2); ?></h5>
							</div>
						</div>
					</div>
				</div>
            </div>
        </section>
    </main>
    <!-- main-area-end -->

    <!-- footer-area (reuse from index.html) -->
    <?php include "footer.php";?>
    <!-- footer-area-end -->

    <!-- JS here -->
    <script src="assets/js/vendor/jquery-3.6.0.min.js"></script>
    <script src="assets/js/bootstrap.min.js"></script>
    <script src="assets/js/isotope.pkgd.min.js"></script>
    <script src="assets/js/imagesloaded.pkgd.min.js"></script>
    <script src="assets/js/jquery.magnific-popup.min.js"></script>
    <script src="assets/js/jquery.easypiechart.min.js"></script>
    <script src="assets/js/jquery.mCustomScrollbar.min.js"></script>
    <script src="assets/js/jquery.inview.min.js"></script>
    <script src="assets/js/jquery.parallaxScroll.js"></script>
    <script src="assets/js/jquery.easing.js"></script>
    <script src="assets/js/jquery-ui.min.js"></script>
    <script src="assets/js/validator.js"></script>
    <script src="assets/js/nav-tool.js"></script>
    <script src="assets/js/slick.min.js"></script>
    <script src="assets/js/ajax-form.js"></script>
    <script src="assets/js/wow.min.js"></script>
    <script src="assets/js/main.js"></script>
	<!-- HTML2PDF Script -->
	<script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.10.1/html2pdf.bundle.min.js"></script>
    <script>
	document.getElementById("download-pdf").addEventListener("click", function () {
		const invoice = document.querySelector(".invoice-box");
		html2pdf().from(invoice).set({
			margin: 10,
			filename: "<?php echo $orderData["Order List"]["invoice_number"]; ?>.pdf",
			image: { type: 'jpeg', quality: 0.98 },
			html2canvas: { scale: 2 },
			jsPDF: { unit: 'mm', format: 'a4', orientation: 'portrait' }
		}).save();
	});
	</script>
</body>
</html>
