<?php
// landing-invoice.php
include "../../config.php";
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <?php include 'meta-tags.php';?>
    <link rel="shortcut icon" type="image/x-icon" href="assets/images/47 x 47-01.png">
    <link rel="stylesheet preload" href="assets/css/plugins.css" as="style">
    <link rel="stylesheet preload" href="assets/css/style.css" as="style">
</head>

<body>
<style>
    .main{
        display: flex;
        flex-direction: row;
        align-items: center;
        justify-content: center;
        min-height: 100vh;
        padding: 40px;
    }
    .image-side {
        flex: 1;
        text-align: center;
        padding: 20px;
    }
    .image-side img {
        max-width: 100%;
        height: auto;
        border-radius: 10px;
    }
    .text-side {
        flex: 1;
        padding: 20px;
        color: #2f4f2f;
    }
    .text-side h1 {
        font-size: 2.5em;
        margin-bottom: 20px;
        color: #2e7d32;
    }
    .text-side p {
        font-size: 1.2em;
        line-height: 1.6;
    }
    @media (max-width: 768px) {
        .main {
            flex-direction: column;
        }
    }
</style>
<style>
    .invoice-box {padding:20px}
    .title { font-size: 24px; font-weight: bold; }
    .invoice-details, .items { width: 100%; margin-top: 20px; }
    .items th, .items td { border: 1px solid #ddd; padding: 8px; text-align: left; }
    .text-right {text-align:right !important;}
    .created-date{ font-size:16px;line-height:20px; }
    .address { font-size:16px;line-height:22px;font-style:normal; }
    .product-table table, .product-table th, .product-table td {border: 1px solid #DFDFDF;border-collapse: collapse;font-size:14px !important}
    .gt-div span {font-size:14px !important;line-height:20px}
    .download-btn{
        padding: 7px 15px;
        color: #FFF;border: 1px solid var(--Main);
        border-radius: 12px;
        background-color: var(--Main);font-size:14px
    }
</style>

<?php include "header.php";?>

<div class="rts-navigation-area-breadcrumb bg_light-1">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="navigator-breadcrumb-wrapper">
                    <a href="index.php">Home</a>
                    <i class="fa-regular fa-chevron-right"></i>
                    <a class="current" href="javascript:;">Invoice</a>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="section-seperator bg_light-1">
    <div class="container">
        <hr class="section-seperator">
    </div>
</div>

<div class="rts-cart-area rts-section-gap bg_light-1">
    <div class="container">
        <div class="row g-5">
            <div class="wg-box">
				<div class="row">
					<div class="col-md-12 text-right">
						<button class="download-btn" id="download-pdf">Download PDF</button>
					</div>
				</div>
				<?php
					$order_id=$_GET['order_id'];
					// Fetch order data from the API
					$url = API_URL . '?gofor=getorder&order_id='.$order_id;
					$json = file_get_contents($url);
					$orderData = json_decode($json, true); 	
					// Extract order, customer, and product information
					$order = $orderData['Order List'];
					$customer = $orderData['Customer Detail'][0];
					$products = $orderData['Product Detail'];
					$orderDetails = $orderData['Order Detail'];
					$addressDetails = $orderData['Address Detail'][0];
				?>
				<div class="invoice-box">
					<div class="card-body p-30 p-t-10 invoice">
						 <div style="border-bottom:1px solid #DFDFDF;" class="row">
							 <div class="col-md-12">
								 <div class="table-responsive p-t-30">
									  <table style="overflow:hidden" class="" width="100%">
										<colgroup>
											<col width="60%"/>
											<col width="40%"/>
										</colgroup>
										<tr>
											<td><img src="images/logo/logo.png" alt='logo' class="logo-img" /></td>
											<td><span style="font-size:13px;line-height:0px">Almaa Herbal Nature Pvt Ltd<br>#10, Pillaiyar Koil Street, Saidapet,<br> Chennai - 600015, Tamil Nadu, India<br>Phone : 044 - 4635 9999 <br>Mobile : 900 3000 888 / 740 140 3010<br> Email : almaahospital@gmail.com  <br> Website : www.almaherbal.com</span></td>
										</tr>
									  </table>
								  </div>
							  </div>
						  </div>
						  <br/>
						<div class="row">
						  <div class="col-md-12 text-right mb-30">
								<h5 class="card-title">INVOICE No. <?php echo $orderData["Order List"]["invoice_number"];?></h5>
								<span class="created-date"><?php echo $orderData["Order List"]["created"];?></span>
						  </div>
						  <div class="col-md-6">
							<h3>Billing Information</h3>
							<address class="address">
							  Name: <?php echo $customer['first_name'];?> <?php echo $customer['last_name'];?><br>
							  Phone: <?php echo $customer['mobilenumber'];?><br>
							  Address: <?php echo $addressDetails['doorno'];?> <?php echo $addressDetails['street'];?> <?php echo $addressDetails['location'];?> <?php echo $addressDetails['city'];?> <?php echo $addressDetails['state'];?> <?php echo $addressDetails['pincode'];?><br><br>
							  <?php
								$paymentMode = $orderData["Order List"]["payment_mode"];
								$paymentStatus = $orderData["Order List"]["payment_status"];

								if (strtolower($paymentMode) === "onlinepayment") {
									$statusText = ($paymentStatus === "Paid") ? "Paid" : "Failed";
									echo "Payment Method : Online Payment | $statusText";
								} else {
									echo "Payment Method : " . htmlspecialchars($paymentMode);
								}
								?>
							  <br>
							</address>
						  </div>
						  <div class="col-md-6">
							<div style="float:left !important">
								<h3>Shipping Information</h3>
								<address class="address">
								  Name: <?php echo $customer['first_name'];?> <?php echo $customer['last_name'];?><br>
								  Phone: <?php echo $customer['mobilenumber'];?><br>
								  Address: <?php echo $addressDetails['doorno'];?> <?php echo $addressDetails['street'];?> <?php echo $addressDetails['location'];?> <?php echo $addressDetails['city'];?> <?php echo $addressDetails['state'];?> <?php echo $addressDetails['pincode'];?><br><br>
								  Shipping Method : Courier / Postal<br>
								</address>
							</div>
						  </div>
						</div>
						<br>
						<div class="table-responsive">
						 <table class="product-table">
							<colgroup>
								<col width="5%"/>
								<col width="30%"/>
								<col width="10%"/>
								<col width="10%"/>
								<col width="10%"/>
								<col width="10%"/>
								<col width="10%"/>
								<col width="15%"/>
							</colgroup>
							<thead>
							  <tr>
								<th>#</th>
								<th>Product</th>
								<th>GST (%)</th>
								<th>QTY</th>
								<th>Unit Price (₹)</th>
								<th>Sub Total (₹)</th>
								<th>Tax (₹)</th>
								<th>Total (₹)</th>
							  </tr>
							</thead>
							<tbody>												
							<?php											
								$subtotal = 0;
								$subquantity = 0;
								$subtax = 0;
								$subproduct_tot = 0;
								foreach ($orderDetails as $item) {
									// Find the matching product in Product Detail by product_id
									foreach ($products as $product) {
										if ($product['product_id'] == $item['product_id']) {
										$productName = $product['product_name'];
										$productUnit = $item['prod_attri_id'];
										$quantity = $item['quantity'];
										$mrp = $product['product_mrp']; // MRP includes GST
										$gst = $product['product_sgst'] + $product['product_cgst']; // Total GST %

										$unitPrice = round($mrp / (1 + ($gst / 100)), 2); // Base price per unit
										$tax_per_unit = $mrp - $unitPrice;

										$base_price_total = $unitPrice * $quantity;
										$tax_total = $tax_per_unit * $quantity;
										$product_tot = $mrp * $quantity;

										$subtotal += $base_price_total;
										$subquantity += $quantity;
										$subtax += $tax_total;
										$subproduct_tot += $product_tot;

							?>
							  <tr>
								<th scope="row"><?php echo ++$counter;?></th>
								<td><?php echo $productName;?> (<?php echo $productUnit;?>)</td>
								<td><?php echo number_format($gst, 2);?></td>
								<td><?php echo number_format($quantity, 0);?></td>
								<td><?php echo number_format($unitPrice, 2);?></td>
								<td><?php echo number_format($base_price_total, 2);?></td>
								<td><?php echo number_format($tax_total, 2);?></td>
								<td><?php echo number_format($product_tot, 2);?></td>
							  </tr>
								<?php } } } ?>
							  
							  <tr>
								<td colspan="3"><strong>Total</strong> </td>
								<td class="tbldata"><strong><?php echo number_format($subquantity, 0);?></strong></td>
								<td class="tbldata"></td>
								<td class="tbldata"><strong><?php echo number_format($subtotal, 2);?></strong></td>
								<td class="tbldata"><strong><?php echo number_format($subtax, 2);?></strong></td>
								<td class="tbldatar"><strong><?php echo number_format($subproduct_tot, 2);?></strong></td>
							  </tr>
							  
							</tbody>
						  </table>
						</div>
						
						<?php
							include "convertToIndianCurrency.php";
							$gtot = $orderData["Order List"]["total_amount"];
							$gst_split = number_format($subtax/2, 2);
						?>
						<div class="invoice-total">
						  <div class="row">
							<div style="margin-top:50px" class="col-md-7">
								<p class="fs-10"><span style="margin-right:10px">CGST: ₹<?php echo number_format($gst_split, 2);?></span> <span style="margin-right:10px">SGST: ₹<?php echo number_format($gst_split, 2);?></span>  
								<br>Amount (In words) : <?php echo convertToIndianCurrency($gtot);?></p>
							</div>
							<div class="col-md-2 gt-div">
							  <span class="text-right text-gray fs-13">Total</span><br>
							   <!--<span class="text-right text-gray fs-13">Tax</span><br> -->
							  <span class="text-right text-gray fs-13">Discount</span>
							  
							  <br>
							  <span class="text-right text-gray fs-13">Delivery&nbsp;Charges </span>
							  
							  <br>
							  <span style="font-size:12px;" class="text-right m-t-10 fs-10"><strong>GRAND TOTAL </strong></span>
							</div>
							<div class="col-md-2 gt-div text-right">
							  <span>₹ <?php echo number_format($subproduct_tot, 2);?></span><br>
							  <!--<span><i class="fa fa-inr"></i>  </span><br> -->
							  <span>₹  0.00</span>						 
							  <br>
							  <span>₹  <?php echo number_format($orderData["Order List"]["delivery_charge"], 2);?></span>
							  <br/>
							  <span class="total">₹ <?php echo number_format($orderData["Order List"]["total_amount"], 2);?></span>
							</div>
						  </div>
					  </div>
					</div>


					
				  </div>
				  
			</div>
            
        </div>
    </div>
</div>

<?php include 'whatsapp.php';?>
<?php include 'above-footer.php'; ?>
<?php include 'footer.php';?>
<?php include "search-input.php";?>
<div id="anywhere-home" class="anywere"></div>
<div class="progress-wrap">
    <svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
        <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" style="transition: stroke-dashoffset 10ms linear 0s; stroke-dasharray: 307.919, 307.919; stroke-dashoffset: 307.919;"></path>
    </svg>
</div>


<script>
const API = "<?php echo API_URL; ?>";
</script>
<script>
document.getElementById("download-pdf").addEventListener("click", function () {
  const invoice = document.querySelector(".invoice-box");
  html2pdf().from(invoice).save("<?php echo $orderData["Order List"]["invoice_number"];?>.pdf");
});
</script>

</body>
</html>
