<?php
// landing-product.php
include "../../config.php"; // update path as needed
// === Set product ID manually here ===
$product_id = 259; // <-- change this to any product ID you want
?>
<!doctype html>
<html class="no-js" lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>Dr Siddha diabetes combo</title>
    <meta name="description" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="shortcut icon" type="image/x-icon" href="assets/img/favicon.png">
    <!-- Place favicon.ico in the root directory -->

    <!-- CSS here -->
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/animate.min.css">
    <link rel="stylesheet" href="assets/css/magnific-popup.css">
    <link rel="stylesheet" href="assets/css/fontawesome-all.min.css">
    <link rel="stylesheet" href="assets/css/mCustomScrollbar.min.css">
    <link rel="stylesheet" href="assets/css/jquery-ui.css">
    <link rel="stylesheet" href="assets/css/flaticon.css">
    <link rel="stylesheet" href="assets/css/slick.css">
    <link rel="stylesheet" href="assets/css/default.css">
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/responsive.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.1/css/all.min.css"
        integrity="sha512-2SwdPD6INVrV/lHTZbO2nodKhrnDdJK9/kg2XD1r9uGqPo1cUbujc+IYdlYdEErWNu69gVcYgdxlmVmzTWnetw=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
	
</head>

<body>

    <?php include "header.php";?>


    <!-- main-area -->
    <main>

        <!-- banner-area -->
        <section id="home" class="banner-area special-banner-area">
            <div class="container">
                <div class="row justify-content-center align-items-center">
                    <div class="col-lg-6 col-md-11 order-0 order-lg-2">
                        <div class="slider-img wow fadeInRight" data-wow-delay=".4s" ">
                                <img src=" assets/img/slider_img.webp" alt="">
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="banner-content slider-content">
                            <h6 class="sub-title wow fadeInUp" data-wow-delay=".2s">Drs. Siddha Diabetes Combo – Natural
                                Blood Sugar Balance</h6>
                            <h2 class="wow fadeInUp" data-wow-delay=".4s" style="font-size: 45px;">Diabetes Reversal
                                with Authentic Siddha Medicine </h2><br>
                            <h6 class="wow fadeInUp" data-wow-delay=".4s"></h6>Take Control of Your Health with the
                            Power of Siddha</h6>
                            <div class="banner-btn">
                                <!-- Shop Now Button -->
								<a href="#price" class="btn special-btn wow fadeInLeft shop-now-btn" data-product-id="<?php echo $product_id; ?>">
									Shop Now <i class="fa-solid fa-bag-shopping"></i>
								</a>
                                <a href="contact.php" class="btn solid-btn wow fadeInRight" data-wow-delay=".6s">Whats
                                    app Now<i class="fa-brands fa-whatsapp"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- banner-area-end -->

        <!-- features-area -->
        <section id="features" class="capsule-features-area bar-features pt-120">
            <div class="container">
                <div class="row">
                    <div class="col-lg-3 col-sm-6">
                        <div class="capsule-features-item mb-30">
                            <div class="cf-icon">
                                <img src="assets/img/down/cf_icon01.webp" alt="">
                            </div>
                            <div class="cf-content">
                                <h5 class="title">100% Herbal, Safe & Chemical-free products</h5>
                            </div>
                            <!-- <div class="cf-overlay-icon"><img src="assets/img/down/cf_icon01.webp" alt=""></div> -->
                        </div>
                    </div>
                    <div class="col-lg-3 col-sm-6">
                        <div class="capsule-features-item mb-30">
                            <div class="cf-icon">
                                <img src="assets/img/down/cf_icon02.webp" alt="">
                            </div>
                            <div class="cf-content">
                                <h5 class="title">Based on classical Siddha texts</h5>
                            </div>
                            <!-- <div class="cf-overlay-icon"><img src="assets/img/down/cf_icon01.webp" alt=""></div> -->
                        </div>
                    </div>
                    <div class="col-lg-3 col-sm-6">
                        <div class="capsule-features-item mb-30">
                            <div class="cf-icon">
                                <img src="assets/img/down/cf_icon03.webp" alt="">
                            </div>
                            <div class="cf-content">
                                <h5 class="title">Trusted by thousands of families</h5>
                            </div>
                            <!-- <div class="cf-overlay-icon"><img src="assets/img/down/cf_icon01.webp" alt=""></div> -->
                        </div>
                    </div>
                    <div class="col-lg-3 col-sm-6">
                        <div class="capsule-features-item mb-30">
                            <div class="cf-icon">
                                <img src="assets/img/down/cf_icon04.webp" alt="">
                            </div>
                            <div class="cf-content">
                                <h5 class="title">Suggested by Senior Siddha doctors</h5>
                            </div>
                            <!-- <div class="cf-overlay-icon"><img src="assets/img/down/cf_icon01.webp" alt=""></div> -->
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- features-area-end -->
		
        <!-- choose-area -->
        <section id="why-us" class="choose-area protein-choose position-relative pt-120 pb-120">
            <div class="choose-bg"></div>
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-xl-7 col-lg-6 order-0 order-lg-2">
                        <div class="choose-content">
                            <div class="section-title protein-title mb-20">
                                <h6 class="sub-title">Why Choose Us</h6>
                                <h3 class="title" style="font-size: 40px;">Why Dr Siddha Diabetes Reversal Combo? </h3>
                            </div>
                            <h5 style="font-weight:600;">Why Dr Siddha Diabetes Reversal Combo?</h5>
                            <ul class="why-us-list">
                                <li><i class="fa-solid fa-check"></i>Managing diabetes is not just about lowering sugar
                                    – it’s about restoring balance to your body, mind, and lifestyle.</li>
                                <li><i class="fa-solid fa-check"></i>This 3-in-1 combo (Kashaya Chooranam, Capsules,
                                    Herbal Powder) works synergistically to address the root cause of sugar imbalance.
                                </li>
                                <li><i class="fa-solid fa-check"></i>Formulated in GMP-certified facilities for safety,
                                    purity, and effectiveness.</li>
                                <li><i class="fa-solid fa-check"></i>Safe, natural, and effective for confident diabetes
                                    management.</li>
                                <li><i class="fa-solid fa-check"></i>Ingredients are clinically shown to improve insulin
                                    sensitivity, slow sugar absorption, and protect pancreatic function.</li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-xl-5 col-lg-6">
                        <div class="position-relative">
                            <div class="choose-list-wrap">
                                <ul>
                                    <li>
                                        <div class="icon">
                                            <i class="fa-solid fa-notes-medical"></i>
                                        </div>
                                        <div class="content">
                                            <h4>Natural Blood Sugar Control</h4>
                                            <p>Reduce HbA1c 2X Faster and regulates glucose levels</p>
                                        </div>
                                    </li>
                                    <li>
                                        <div class="icon">
                                            <i class="fa-solid fa-person-walking"></i>
                                        </div>
                                        <div class="content">
                                            <h4>Boosts Energy & Reduces Fatigue</h4>
                                            <p>Feel the old you pumping hard and restores stamina and vitality.</p>
                                        </div>
                                    </li>
                                    <li>
                                        <div class="icon">
                                            <i class="fa-solid fa-weight-scale"></i>
                                        </div>
                                        <div class="content">
                                            <h4>Supports Weight Management</h4>
                                            <p>Sculpted Version of Yourself Fenugreek and Black Cumin help reduce sugar
                                                cravings.</p>
                                        </div>
                                    </li>
                                </ul>
                            </div>
                            <div class="choose-img">
                                <img class="main-img" src="assets/img/choose_img.png" alt="">

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- choose-area-end -->

        <!-- ingredient-area -->
        <section id="ingredient" class="ingredient-area pt-90 pb-120">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-xl-9 col-lg-10">
                        <div class="capsule-section-title text-center mb-50">
                            <span class="sub-title">Ingredients</span>
                            <h6 class="title" style="font-size: 40px;">Packed With Powerful Herbal Ingredients</h6>
                        </div>
                    </div>
                </div>
                <div class="row ingredients-wrapper align-items-center">
                    <div class="col-lg-4 order-1 col-md-6">
                        <div class="ingredients-item wow fadeInLeft" data-wow-delay=".2s">
                            <div class="ingredients-icon">
                                <i class="fa-solid fa-hand-point-left"></i>
                            </div>
                            <div class="ingredients-content">
                                <h5 class="title">varai Panchangam (Whole plant of Senna Auriculata)
                                </h5>
                                <p>Modern studies have shown that it helps the body use insulin more effectively and
                                    protects the pancreas from damage.</p>
                            </div>
                        </div>
                        <div class="ingredients-item wow fadeInLeft" data-wow-delay=".3s">
                            <div class="ingredients-icon">
                                <i class="fa-solid fa-hand-point-left"></i>
                            </div>
                            <div class="ingredients-content">
                                <h5 class="title">Vendhayam (Fenugreek Seeds)</h5>
                                <p>Clinical research has proven that it lowers fasting blood sugar and improves
                                    cholesterol levels naturally.</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 order-0 order-lg-2">
                        <div class="ingredients-img">
                            <img src="assets/img/down/ingredients_img.webp" alt="">
                        </div>
                    </div>
                    <div class="col-lg-4 order-3 col-md-6">
                        <div class="ingredients-item wow fadeInRight" data-wow-delay=".2s">
                            <div class="ingredients-icon">
                                <i class="fa-solid fa-hand-point-right"></i>
                            </div>
                            <div class="ingredients-content">
                                <h5 class="title">Naval Kottai <br> (Jamun Seeds)</h5>
                                <p> Controlling excessive thirst & frequent urination, Scientific evidence shows
                                    regulates glucose levels and supports sugar control.</p>
                            </div>
                        </div>
                        <div class="ingredients-item wow fadeInRight" data-wow-delay=".3s">
                            <div class="ingredients-icon">
                                <i class="fa-solid fa-hand-point-right"></i>
                            </div>
                            <div class="ingredients-content">
                                <h5 class="title">Karunjeeragam (Black Cumin Seeds)
                                </h5>
                                <p>A powerful herb with antioxidant and anti-inflammatory effects. it improves insulin
                                    sensitivity, boosts metabolism.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- ingredient-area-end -->

        <!-- shop-details-area -->
        <section id="price" class="shop-details-area special-shop ">
            <div class="container">
                <div class="row align-items-center justify-content-center">
                    <div class="col-5">
                        <div class="section-title special-title mb-30">
                            <h6 class="sub-title">Diabetes Combo</h6>
                            <h2 class="title" style="font-size: 30px;">Aavarai kudineer + Diabetop + Sanjeevi chooranam
                            </h2>
                        </div>
                        <div class="shop-details-price">
                            <div class="rating">
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="far fa-star"></i>
                            </div>
                            <h2 class="price">₹999</h2>
                        </div>
                        <div class="shop-details-content">
                            <p>The Dr. Siddha Diabetes Combo is a doctor-formulated 3-in-1 herbal pack (Kashaya
                                Chooranam, Capsules & Poly Herbal Powder) created especially for working South Indians
                                who face stress, long hours, and sugar imbalance. Unlike chemical tablets that only
                                suppress symptoms, our Siddha based intervention works strongly on the root cause,
                                helping your body naturally improve energy and reduce sugar levels.</p>
								<!-- Cart + Qty + Checkout -->
								<div class="shop-purchase-info" data-product-id="<?php echo $product_id; ?>">
									<div class="cart-plus-minus">
										<form action="#" class="num-block">
											<input type="text" class="in-num" value="1" readonly>
											<div class="qtybutton-box">
												<span class="minus dis"><i class="fa-solid fa-minus"></i></span>
												<span class="plus"><i class="fa-solid fa-plus"></i></span>
											</div>
										</form>
									</div>
									<div class="purchase-btn">
										<a href="#" class="btn special-btn checkout-btn">Buy Now <i class="fa-solid fa-cart-shopping"></i></a>
									</div>
								</div>
                        </div>
                    </div>
                    <div class="col-7">
                        <div class="shop-details-img-wrap">
                            <div class="tab-content" id="myTabContentTwo">
                                <div class="tab-pane show active" id="details-thumb01" role="tabpanel"
                                    aria-labelledby="details-thumb01-tab">
                                    <div class="shop-details-img">
                                        <img src="assets/img/shop_details_img01.png" alt="">
                                        <div class="img-shape"></div>
                                    </div>
                                </div>
                                <div class="tab-pane" id="details-thumb02" role="tabpanel"
                                    aria-labelledby="details-thumb02-tab">
                                    <div class="shop-details-img">
                                        <img src="assets/img/shop_details_img02.png" alt="">
                                        <div class="img-shape"></div>
                                    </div>
                                </div>
                                <div class="tab-pane" id="details-thumb03" role="tabpanel"
                                    aria-labelledby="details-thumb03-tab">
                                    <div class="shop-details-img">
                                        <img src="assets/img/shop_details_img03.png" alt="">
                                        <div class="img-shape"></div>
                                    </div>
                                </div>
                            </div>
                            <ul class="nav nav-tabs shop-details-nav-wrap" id="myTabTwo" role="tablist">
                                <li class="nav-item" role="presentation">
                                    <a href="#" class="nav-link active" id="details-thumb01-tab" data-bs-toggle="tab"
                                        data-bs-target="#details-thumb01" role="tab" aria-controls="details-thumb01"
                                        aria-selected="true">
                                        <img src="assets/img/sd_nav_img01.png" alt="">
                                        <div class="img-shape"></div>
                                        <span class="rating"><i class="fas fa-star"></i>4.9</span>
                                    </a>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <a href="#" class="nav-link" id="details-thumb02-tab" data-bs-toggle="tab"
                                        data-bs-target="#details-thumb02" role="tab" aria-controls="details-thumb02"
                                        aria-selected="false">
                                        <img src="assets/img/sd_nav_img02.png" alt="">
                                        <div class="img-shape"></div>
                                        <span class="rating"><i class="fas fa-star"></i>4.5</span>
                                    </a>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <a href="#" class="nav-link" id="details-thumb03-tab" data-bs-toggle="tab"
                                        data-bs-target="#details-thumb03" role="tab" aria-controls="details-thumb03"
                                        aria-selected="false">
                                        <img src="assets/img/sd_nav_img03.png" alt="">
                                        <div class="img-shape"></div>
                                        <span class="rating"><i class="fas fa-star"></i>4.8</span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- shop-details-area-end -->

        <!-- blog-area -->
        <section id="blog" class="blog-area protein-blog pt-120 pb-90">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-xl-6 col-lg-8">
                        <div class="section-title protein-title text-center mb-50">

                            <h3>Products in this Combo</h3>

                        </div>
                    </div>
                </div>
                <div class="row justify-content-center">
                    <div class="col-lg-4 col-md-6 col-sm-9">
                        <div class="blog-post-item mb-30 wow fadeInUp" data-wow-delay=".2s">
                            <div class="blog-post-thumb">
                                <img src="assets/img/shop_details_img01.png" alt="" style="height: 250px; width: auto;">

                            </div>
                            <div class="blog-post-content">

                                <h4 class="title">Aavarai Kudineer<br> (100 grams)</h4>
                               
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 col-sm-9">
                        <div class="blog-post-item mb-30 wow fadeInUp" data-wow-delay=".4s">
                            <div class="blog-post-thumb">
                                <img src="assets/img/shop_details_img02.png" alt="" style="height: 250px; width: auto;">
                            </div>
                            <div class="blog-post-content">

                                <h4 class="title">Diabetop Capsules (60)</h4>
                              

                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 col-sm-9">
                        <div class="blog-post-item mb-30 wow fadeInUp" data-wow-delay=".6s">
                            <div class="blog-post-thumb">
                                <img src="assets/img/shop_details_img03.png" alt="" style="height: 250px; width: auto;">

                            </div>
                            <div class="blog-post-content">

                                <h4 class="title">Sanjeevi Chooranam <br> (100 grams)</h4>
                             

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- blog-area-end -->


        <!-- formula-area -->
        <section id="how-to-use" class="formula-area">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-6">

                        <img src="assets/img/shop_details_img01.png" alt="">

                    </div>
                    <div class="col-lg-6">
                        <div class="section-title special-title">

                            <h2 class="title">How to use</h2>
                            <h4>Dr Siddha Diabetes Reversal Combo</h4>
                        </div>
                        <div class="faq-wrapper">
						  <div class="accordion" id="accordionUsage">

							<div class="card">
							  <div class="card-header" id="headingSeven">
								<h2 class="mb-0">
								  <button class="btn-block text-start" type="button" data-bs-toggle="collapse"
									data-bs-target="#collapseSeven" aria-expanded="true"
									aria-controls="collapseSeven">
									How to use Diabetop Capsules?
								  </button>
								</h2>
							  </div>
							  <div id="collapseSeven" class="collapse show" aria-labelledby="headingSeven"
								data-bs-parent="#accordionUsage">
								<div class="card-body">
								  One capsule morning and night before food.
								</div>
							  </div>
							</div>

							<div class="card">
							  <div class="card-header" id="headingEight">
								<h2 class="mb-0">
								  <button class="btn-block text-start collapsed" type="button"
									data-bs-toggle="collapse" data-bs-target="#collapseEight"
									aria-expanded="false" aria-controls="collapseEight">
									How to use Aavarai kudineer?
								  </button>
								</h2>
							  </div>
							  <div id="collapseEight" class="collapse" aria-labelledby="headingEight"
								data-bs-parent="#accordionUsage">
								<div class="card-body">
								  Prepare a decoction with 3 grams of Aavarai kudineer chooranam and 100 ml of water.  
								  Reduce it to 50 ml and take it morning and night before food.
								</div>
							  </div>
							</div>

							<div class="card">
							  <div class="card-header" id="headingNine">
								<h2 class="mb-0">
								  <button class="btn-block text-start collapsed" type="button"
									data-bs-toggle="collapse" data-bs-target="#collapseNine"
									aria-expanded="false" aria-controls="collapseNine">
									How to use Sanjeevi chooranam?
								  </button>
								</h2>
							  </div>
							  <div id="collapseNine" class="collapse" aria-labelledby="headingNine"
								data-bs-parent="#accordionUsage">
								<div class="card-body">
								  Add 3 grams of Chooranam with 100 ml of water and take it morning and night before food.
								</div>
							  </div>
							</div>

						  </div>
						</div>

                    </div>
                </div>
            </div>
        </section>
        <!-- formula-area-end -->

        <!-- testimonial-area -->
        <section id="feedbacks" class="testimonial-area pt-120 pb-70">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-xl-7 col-lg-8">
                        <div class="capsule-section-title text-center mb-50">
                            <span class="sub-title">Testimonials</span>
                            <h2 class="title">Client feedbacks</h2>
                        </div>
                    </div>
                </div>
                <div class="row testimonial-active">
                    <div class="col-xl-4">
                        <div class="testimonial-item">
                            <div class="testimonial-rating">
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="far fa-star"></i>
                            </div>
                            <div class="testimonial-content">
                                <p>"I was diagnosed with early diabetes. After using Drs. Siddha Combo for 3 months, my
                                    sugar levels are stable"</p>
                            </div>
                            <div class="testi-avatar-wrap">
                                <div class="testi-avatar-thumb">
                                    <img src="assets/img/testi_avatar01.png" alt="">
                                </div>
                                <div class="testi-avatar-info">
                                    <h5>Ravi, 38</h5>
                                    <span> Coimbatore.</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-4">
                        <div class="testimonial-item">
                            <div class="testimonial-rating">
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="far fa-star"></i>
                            </div>
                            <div class="testimonial-content">
                                <p>"I was tired of side effects from tablets. This herbal combo has helped me manage my
                                    sugar naturally without weakness."</p>
                            </div>
                            <div class="testi-avatar-wrap">
                                <div class="testi-avatar-thumb">
                                    <img src="assets/img/testi_avatar02.png" alt="">
                                </div>
                                <div class="testi-avatar-info">
                                    <h5>Meena, 44</h5>
                                    <span>Madurai</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-4">
                        <div class="testimonial-item">
                            <div class="testimonial-rating">
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="far fa-star"></i>
                            </div>
                            <div class="testimonial-content">
                                <p>"Easy to use, affordable, and effective. My doctor also approved me using this along
                                    with my regular medicines."</p>
                            </div>
                            <div class="testi-avatar-wrap">
                                <div class="testi-avatar-thumb">
                                    <img src="assets/img/testi_avatar03.png" alt="">
                                </div>
                                <div class="testi-avatar-info">
                                    <h5>Suresh, 41</h5>
                                    <span>Chennai</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-4">
                        <div class="testimonial-item">
                            <div class="testimonial-rating">
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="far fa-star"></i>
                            </div>
                            <div class="testimonial-content">
                                <p>"After taking Dr Siddha Diabetes Reversal Combo My sugar cravings reduced, and I feel
                                    more active, Stress levels are better"</p>
                            </div>
                            <div class="testi-avatar-wrap">
                                <div class="testi-avatar-thumb">
                                    <img src="assets/img/testi_avatar01.png" alt="">
                                </div>
                                <div class="testi-avatar-info">
                                    <h5>Priya, 35</h5>
                                    <span>Trichy</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- testimonial-area-end -->

        <!-- faq-area -->
        <section id="faq" class="faq-area protein-faq special-faq">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-6">
                        <div class="section-title special-title mb-35">
                            <h6 class="sub-title">Faq</h6>
                            <h2 class="title">Get Every Answers From Here</h2>
                        </div>
                        <!-- FAQ Section 1 -->
						<div class="faq-wrapper">
						  <div class="accordion" id="accordionGeneral">

							<div class="card">
							  <div class="card-header" id="headingOne">
								<h2 class="mb-0">
								  <button class="btn-block text-start collapsed" type="button"
									data-bs-toggle="collapse" data-bs-target="#collapseOne"
									aria-expanded="false" aria-controls="collapseOne">
									Can I take Dr Siddha Diabetes Reversal Combo along with my allopathy medicines?
								  </button>
								</h2>
							  </div>
							  <div id="collapseOne" class="collapse" aria-labelledby="headingOne"
								data-bs-parent="#accordionGeneral">
								<div class="card-body">
								  Yes, it is safe. But consult your doctor for dosage adjustments.
								</div>
							  </div>
							</div>

							<div class="card">
							  <div class="card-header" id="headingTwo">
								<h2 class="mb-0">
								  <button class="btn-block text-start" type="button" data-bs-toggle="collapse"
									data-bs-target="#collapseTwo" aria-expanded="true"
									aria-controls="collapseTwo">
									How long will it take to see results?
								  </button>
								</h2>
							  </div>
							  <div id="collapseTwo" class="collapse show" aria-labelledby="headingTwo"
								data-bs-parent="#accordionGeneral">
								<div class="card-body">
								  Most users notice changes in 6–8 weeks with regular use and lifestyle balance.
								</div>
							  </div>
							</div>

							<div class="card">
							  <div class="card-header" id="headingThree">
								<h2 class="mb-0">
								  <button class="btn-block text-start collapsed" type="button"
									data-bs-toggle="collapse" data-bs-target="#collapseThree"
									aria-expanded="false" aria-controls="collapseThree">
									Is this suitable for prediabetes?
								  </button>
								</h2>
							  </div>
							  <div id="collapseThree" class="collapse" aria-labelledby="headingThree"
								data-bs-parent="#accordionGeneral">
								<div class="card-body">
								  Absolutely. It helps prevent further sugar imbalance and supports metabolism.
								</div>
							  </div>
							</div>

							<div class="card">
							  <div class="card-header" id="headingFour">
								<h2 class="mb-0">
								  <button class="btn-block text-start collapsed" type="button"
									data-bs-toggle="collapse" data-bs-target="#collapseFour"
									aria-expanded="false" aria-controls="collapseFour">
									Are there any side effects?
								  </button>
								</h2>
							  </div>
							  <div id="collapseFour" class="collapse" aria-labelledby="headingFour"
								data-bs-parent="#accordionGeneral">
								<div class="card-body">
								  No harmful side effects. All ingredients are natural and safe.
								</div>
							  </div>
							</div>

							<div class="card">
							  <div class="card-header" id="headingFive">
								<h2 class="mb-0">
								  <button class="btn-block text-start collapsed" type="button"
									data-bs-toggle="collapse" data-bs-target="#collapseFive"
									aria-expanded="false" aria-controls="collapseFive">
									How long can I continue using it?
								  </button>
								</h2>
							  </div>
							  <div id="collapseFive" class="collapse" aria-labelledby="headingFive"
								data-bs-parent="#accordionGeneral">
								<div class="card-body">
								  Safe for long-term daily use, as it is herbal. Avail our free on-call consultation with the purchase of Dr Siddha Diabetes Reversal Combo.
								</div>
							  </div>
							</div>

							<div class="card">
							  <div class="card-header" id="headingSix">
								<h2 class="mb-0">
								  <button class="btn-block text-start collapsed" type="button"
									data-bs-toggle="collapse" data-bs-target="#collapseSix"
									aria-expanded="false" aria-controls="collapseSix">
									Is this product certified?
								  </button>
								</h2>
							  </div>
							  <div id="collapseSix" class="collapse" aria-labelledby="headingSix"
								data-bs-parent="#accordionGeneral">
								<div class="card-body">
								  Yes, formulated from classical siddha scriptures & prepared under GMP-certified facility with quality checks.
								</div>
							  </div>
							</div>

						  </div>
						</div>
                    </div>
                    <div class="col-lg-6">
                        <div class="sup-info-img">
                            <img src="assets/img/down/ingredients_img.webp" alt="">
                            <div class="img-shape"></div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- faq-area-end -->

        <!-- contact-form-area -->
        <!-- <section id="contact-form" class="contact-form-area pt-90 pb-90">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-lg-7">
                        <div class="section-title text-center mb-40">
                           
                            <h2 class="title">Request a Free Consultation</h2>
                            <p>Fill in your details and our team will contact you soon.</p>
                        </div>
                        <form id="customerForm" class="contact-form" method="post" action="#">
                            <div class="row">
                                <div class="col-md-12 mb-3">
                                    <input type="text" name="name" class="form-control" placeholder="Your Name"
                                        required>
                                </div>
                                <div class="col-md-12 mb-3">
                                    <input type="text" name="location" class="form-control" placeholder="Your Location"
                                        required>
                                </div>
                                <div class="col-md-12 mb-3">
                                    <input type="tel" name="phone" class="form-control" placeholder="Phone Number"
                                        required pattern="[0-9]{10,}">
                                </div>
                                <div class="col-md-12 mb-3">
                                    <select name="issue" class="form-control" required>
                                        <option value="">Select Related Issue</option>
                                        <option value="Diabetes">Diabetes Combo pack</option>
                                        <option value="Prediabetes">Prediabetes</option>
                                        <option value="Weight Management">Weight Management</option>
                                        <option value="General Consultation">General Consultation</option>
                                        <option value="Other">Other</option>
                                    </select>
                                </div>
                                <div class="col-md-12 text-center">
                                    <button type="submit" class="btn special-btn" style="padding: 10px;">Submit
                                        Details</button>
                                </div>
                            </div>
                        </form>
                        <div id="formMessage" class="text-center mt-3"></div>
                    </div>
                </div>
            </div>
        </section> -->
        <!-- contact-form-area-end -->


        <!-- Replace the contact-form-area section with this updated code -->

<section id="contact-form" class="contact-form-area pt-90 pb-90">
    <div class="container">
        <div class="row justify-content-center align-items-center">
            <!-- Left: Image -->
            <div class="col-lg-6 mb-4 mb-lg-0">
                <div class="h-100 d-flex align-items-center justify-content-center">
                    <img src="assets/img/slider_img.webp" alt="Contact Us" class="img-fluid" style="max-height:400px;">
                </div>
            </div>
            <!-- Right: Form -->
            <div class="col-lg-6">
                <div class="section-title text-center mb-40">
                    <h2 class="title">Request a Free Consultation</h2>
                    <p>Fill in your details and our team will contact you soon.</p>
                </div>
                <form id="customerForm" class="contact-form" method="post" action="#">
                    <div class="row">
                        <div class="col-md-12 mb-3">
                            <input type="text" name="name" class="form-control" placeholder="Your Name"
                                required>
                        </div>
                        <div class="col-md-12 mb-3">
                            <input type="text" name="location" class="form-control" placeholder="Your Location"
                                required>
                        </div>
                        <div class="col-md-12 mb-3">
                            <input type="tel" name="phone" class="form-control" placeholder="Phone Number"
                                required pattern="[0-9]{10,}">
                        </div>
                        <div class="col-md-12 mb-3">
                            <select name="issue" class="form-control" required>
                                <option value="">Select Related Issue</option>
                                <option value="Diabetes">Diabetes Combo pack</option>
                                <option value="Prediabetes">Prediabetes</option>
                                <option value="Weight Management">Weight Management</option>
                                <option value="General Consultation">General Consultation</option>
                                <option value="Other">Other</option>
                            </select>
                        </div>
                        <div class="col-md-12 text-center">
                            <button type="submit" class="btn special-btn" style="padding: 10px;">Submit
                                Details</button>
                        </div>
                    </div>
                </form>
                <div id="formMessage" class="text-center mt-3"></div>
            </div>
        </div>
    </div>
</section>  


        <!-- sticky-buy-now-cta -->
<style>
    #stickyBuyNow {
        position: fixed;
        bottom: 115px;
        right: 80px;
        z-index: 9999;
        box-shadow: 0 4px 16px rgba(0,0,0,0.12);
        border-radius: 30px;
       
        font-size: 18px;
        transition: opacity 0.2s;
        display: block;
    }
    @media (max-width: 575.98px) {
        #stickyBuyNow {
            width: 90vw;
            left: 5vw;
            right: 5vw;
            font-size: 16px;
            padding: 12px 0;
        }
    }
</style>
<!-- Sticky Buy Now -->
<button id="stickyBuyNow" class="btn special-btn" data-product-id="<?php echo $product_id; ?>">
    Buy Now <i class="fa-solid fa-bag-shopping"></i>
</button>
<script>
    // //Scroll to price section on click
    // document.getElementById('stickyBuyNow').onclick = function () {
        // var priceSection = document.getElementById('price');
        // if (priceSection) {
            // priceSection.scrollIntoView({ behavior: 'smooth' });
        // }
    // };
</script>
<!-- sticky-buy-now-cta-end -->







    </main>
    <!-- main-area-end -->


    <!-- footer-area -->
    <?php include "footer.php";?>
    <!-- footer-area-end -->




    <!-- JS here -->
    <script src="assets/js/vendor/jquery-3.6.0.min.js"></script>
    <script src="assets/js/bootstrap.min.js"></script>
    <script src="assets/js/isotope.pkgd.min.js"></script>
    <script src="assets/js/imagesloaded.pkgd.min.js"></script>
    <script src="assets/js/jquery.magnific-popup.min.js"></script>
    <script src="assets/js/jquery.easypiechart.min.js"></script>
    <script src="assets/js/jquery.mCustomScrollbar.min.js"></script>
    <script src="assets/js/jquery.inview.min.js"></script>
    <script src="assets/js/jquery.parallaxScroll.js"></script>
    <script src="assets/js/jquery.easing.js"></script>
    <script src="assets/js/jquery-ui.min.js"></script>
    <script src="assets/js/validator.js"></script>
    <script src="assets/js/nav-tool.js"></script>
    <script src="assets/js/slick.min.js"></script>
    <script src="assets/js/ajax-form.js"></script>
    <script src="assets/js/wow.min.js"></script>
    <script src="assets/js/main.js"></script>
	
	<script>
	async function fetchProduct(productId) {
		const res = await fetch(`<?php echo API_URL; ?>?gofor=productdetail&product_id=${productId}`);
		const data = await res.json();
		if (data && data.product_details && data.product_details.length > 0) {
			const product = data.product_details[0];
			const price = (data.product_attributes && data.product_attributes.length > 0)
				? data.product_attributes[0].product_mrp
				: 0;
			const unit = (data.product_attributes && data.product_attributes.length > 0)
				? data.product_attributes[0].product_measuring_unit_id
				: '';

			return {
				id: product.product_id,
				name: product.product_name,
				price: price,
				unit: unit,
				image: product.product_image1 || 'images/default-product.jpg'
			};
		}
		return null;
	}

	async function handleBuyNow(productId, qty = 1) {
		const product = await fetchProduct(productId);
		if (!product) return alert('Product not found.');

		product.qty = qty;
		localStorage.setItem('landingProduct', JSON.stringify(product));
		window.location.href = 'checkout.php?from=landing';
	}

	// ===== Shop Now =====
	document.querySelectorAll('.shop-now-btn').forEach(btn => {
		btn.addEventListener('click', function(e) {
			e.preventDefault();
			const productId = this.dataset.productId;
			handleBuyNow(productId);
		});
	});

	// ===== Cart + Qty + Checkout =====
	document.querySelectorAll('.shop-purchase-info').forEach(container => {
		const qtyInput = container.querySelector('.in-num');
		const checkoutBtn = container.querySelector('.checkout-btn');
		const plusBtn = container.querySelector('.plus');
		const minusBtn = container.querySelector('.minus');
		const productId = container.dataset.productId;

		if (checkoutBtn) {
			checkoutBtn.addEventListener('click', function(e) {
				e.preventDefault();
				handleBuyNow(productId, parseInt(qtyInput.value) || 1);
			});
		}

		if (plusBtn) {
			plusBtn.addEventListener('click', function() {
				let val = parseInt(qtyInput.value) || 1;
				qtyInput.value = val + 1;
			});
		}
		if (minusBtn) {
			minusBtn.addEventListener('click', function() {
				let val = parseInt(qtyInput.value) || 1;
				if (val > 1) qtyInput.value = val - 1;
			});
		}
	});

	// ===== Sticky Buy Now =====
	document.querySelectorAll('#stickyBuyNow').forEach(btn => {
		btn.addEventListener('click', function() {
			const productId = this.dataset.productId;
			handleBuyNow(productId);
		});
	});
	</script>
</body>

</html>