<!doctype html>
<html class="no-js" lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>Shopping Cart | Dr Siddha diabetes combo</title>
    <meta name="description" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="shortcut icon" type="image/x-icon" href="assets/img/favicon.png">
    <!-- CSS here -->
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/animate.min.css">
    <link rel="stylesheet" href="assets/css/magnific-popup.css">
    <link rel="stylesheet" href="assets/css/fontawesome-all.min.css">
    <link rel="stylesheet" href="assets/css/mCustomScrollbar.min.css">
    <link rel="stylesheet" href="assets/css/jquery-ui.css">
    <link rel="stylesheet" href="assets/css/flaticon.css">
    <link rel="stylesheet" href="assets/css/slick.css">
    <link rel="stylesheet" href="assets/css/default.css">
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/responsive.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.1/css/all.min.css"
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <style>
        /* Extra responsive tweaks for cart page */
        @media (max-width: 991.98px) {
            .cart-table th, .cart-table td {
                font-size: 15px;
                padding: 10px 6px;
            }
            .cart-table img {
                width: 50px !important;
                height: 50px !important;
                margin-right: 8px !important;
            }
            .cart-summary {
                margin-top: 30px;
            }
        }
        @media (max-width: 767.98px) {
            .cart-table-wrap {
                overflow-x: auto;
            }
            .cart-table {
                min-width: 600px;
            }
            .section-title .title {
                font-size: 24px !important;
            }
            .cart-summary {
                padding: 16px !important;
            }
            .cart-area {
                padding-top: 40px !important;
                padding-bottom: 40px !important;
            }
            .cart-summary {
                margin-top: 24px;
            }
        }
        @media (max-width: 575.98px) {
            .cart-table th, .cart-table td {
                font-size: 12px;
                padding: 6px 2px;
            }
            .cart-table img {
                width: 32px !important;
                height: 32px !important;
                margin-right: 6px !important;
            }
            .cart-summary {
                padding: 8px !important;
            }
            .btn.special-btn, .btn.solid-btn {
                font-size: 14px !important;
                padding: 7px 10px !important;
            }
            .section-title .title {
                font-size: 18px !important;
            }
            .cart-summary h4 {
                font-size: 16px !important;
            }
            .cart-summary ul li {
                font-size: 13px !important;
            }
            .cart-table h5 {
                font-size: 14px !important;
            }
            .cart-table span {
                font-size: 11px !important;
            }
        }
        /* Make cart summary always visible below table on mobile */
        @media (max-width: 991.98px) {
            .row.justify-content-end.mt-4 {
                justify-content: center !important;
            }
        }
    </style>
</head>

<body>
    <!-- preloader -->
    <!-- <div id="preloader">
        <div id="loading-center">
            <div class="loader loader-five">
                <div class="loader-outter"></div>
                <div class="loader-inner"></div>
            </div>
        </div>
    </div> -->
    <!-- preloader-end -->

    <!-- header-area (reuse from index.html) -->
    <header>
        <div id="sticky-header" class="menu-area special-header transparent-header">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="menu-wrap">
                            <nav class="menu-nav show">
                                <div class="logo">
                                    <a href="index.html"><img src="assets/img/down/DR Siddha Logo.png" alt="Logo"></a>
                                </div>
                                <div class="navbar-wrap main-menu d-none d-lg-flex">
                                    <ul class="navigation">
                                        <li><a href="index.html#home" class="section-link">Home</a></li>
                                        <li><a href="index.html#why-us" class="section-link">Why Us</a></li>
                                        <li><a href="index.html#ingredient" class="section-link">Ingredient</a></li>
                                        <li><a href="index.html#price" class="section-link">Price</a></li>
                                        <li><a href="index.html#how-to-use" class="section-link">How to Use</a></li>
                                        <li><a href="index.html#feedbacks" class="section-link">Testimonials</a></li>
                                        <li><a href="index.html#faq" class="section-link">FAQ</a></li>
                                    </ul>
                                </div>
                                <div class="header-action d-none d-sm-block">
                                    <ul>
                                        <li class="header-shop-cart"><a href="cart.html"><i
                                                    class="fa-solid fa-cart-shopping"></i><span>2</span></a>
                                        </li>
                                        <li class="offcanvas-btn d-none d-lg-block"><a href="#"
                                                class="navSidebar-button"><i class="fa-solid fa-bars"></i></a></li>
                                    </ul>
                                </div>
                            </nav>
                        </div>
                        <div class="menu-backdrop"></div>
                    </div>
                </div>
            </div>
        </div>
    </header>
    <!-- header-area-end -->

    <!-- main-area -->
    <main>
        <!-- Cart Section -->
        <section class="cart-area pt-120 pb-120" style="background: #f9f9f9;">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-xl-10">
                        <div class="section-title special-title mb-40 text-center">
                            <h2 class="title">Your Shopping Cart</h2>
                            <p>Review your selected products before checkout</p>
                        </div>
                        <div class="cart-table-wrap table-responsive">
                            <table class="table cart-table align-middle">
                                <thead>
                                    <tr>
                                        <th>Product</th>
                                        <th>Price</th>
                                        <th>Quantity</th>
                                        <th>Subtotal</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <!-- Cart Item 1 -->
                                    <tr>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <img src="assets/img/shop_details_img01.png" alt="" style="width:70px; height:70px; object-fit:contain; margin-right:15px;">
                                                <div>
                                                    <h5 class="mb-1" style="font-size: 18px;">Aavarai kudineer (100g)</h5>
                                                    <span style="font-size: 13px; color: #888;">Herbal Decoction Powder</span>
                                                </div>
                                            </div>
                                        </td>
                                        <td>₹399</td>
                                        <td>
                                            <div class="cart-plus-minus d-inline-flex align-items-center">
                                                <button class="btn btn-light btn-sm minus"><i class="fa-solid fa-minus"></i></button>
                                                <input type="text" class="form-control text-center mx-1" value="1" style="width: 40px; display:inline-block;" readonly>
                                                <button class="btn btn-light btn-sm plus"><i class="fa-solid fa-plus"></i></button>
                                            </div>
                                        </td>
                                        <td>₹399</td>
                                        <td>
                                            <button class="btn btn-danger btn-sm"><i class="fa fa-trash"></i></button>
                                        </td>
                                    </tr>
                                    <!-- Cart Item 2 -->
                                    <tr>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <img src="assets/img/shop_details_img02.png" alt="" style="width:70px; height:70px; object-fit:contain; margin-right:15px;">
                                                <div>
                                                    <h5 class="mb-1" style="font-size: 18px;">Diabetop Capsules (60)</h5>
                                                    <span style="font-size: 13px; color: #888;">Herbal Capsules</span>
                                                </div>
                                            </div>
                                        </td>
                                        <td>₹349</td>
                                        <td>
                                            <div class="cart-plus-minus d-inline-flex align-items-center">
                                                <button class="btn btn-light btn-sm minus"><i class="fa-solid fa-minus"></i></button>
                                                <input type="text" class="form-control text-center mx-1" value="1" style="width: 40px; display:inline-block;" readonly>
                                                <button class="btn btn-light btn-sm plus"><i class="fa-solid fa-plus"></i></button>
                                            </div>
                                        </td>
                                        <td>₹349</td>
                                        <td>
                                            <button class="btn btn-danger btn-sm"><i class="fa fa-trash"></i></button>
                                        </td>
                                    </tr>
                                    <!-- Cart Item 3 -->
                                    <tr>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <img src="assets/img/shop_details_img03.png" alt="" style="width:70px; height:70px; object-fit:contain; margin-right:15px;">
                                                <div>
                                                    <h5 class="mb-1" style="font-size: 18px;">Sanjeevi chooranam (100g)</h5>
                                                    <span style="font-size: 13px; color: #888;">Poly Herbal Powder</span>
                                                </div>
                                            </div>
                                        </td>
                                        <td>₹299</td>
                                        <td>
                                            <div class="cart-plus-minus d-inline-flex align-items-center">
                                                <button class="btn btn-light btn-sm minus"><i class="fa-solid fa-minus"></i></button>
                                                <input type="text" class="form-control text-center mx-1" value="1" style="width: 40px; display:inline-block;" readonly>
                                                <button class="btn btn-light btn-sm plus"><i class="fa-solid fa-plus"></i></button>
                                            </div>
                                        </td>
                                        <td>₹299</td>
                                        <td>
                                            <button class="btn btn-danger btn-sm"><i class="fa fa-trash"></i></button>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <!-- Cart Summary -->
                        <div class="row justify-content-end mt-4">
                            <div class="col-12 col-sm-10 col-md-8 col-lg-6 col-xl-5">
                                <div class="cart-summary p-4 rounded" style="background: #fff; box-shadow: 0 2px 10px #eee;">
                                    <h4 class="mb-3">Order Summary</h4>
                                    <ul class="list-group mb-3">
                                        <li class="list-group-item d-flex justify-content-between align-items-center border-0 px-0 pb-0">
                                            Subtotal
                                            <span>₹1,047</span>
                                        </li>
                                        <li class="list-group-item d-flex justify-content-between align-items-center border-0 px-0">
                                            Shipping
                                            <span>₹49</span>
                                        </li>
                                        <li class="list-group-item d-flex justify-content-between align-items-center border-0 px-0">
                                            <strong>Total</strong>
                                            <strong>₹1,096</strong>
                                        </li>
                                    </ul>
                                    <a href="checkout.html" class="btn special-btn w-100">Proceed to Checkout <i class="fa-solid fa-arrow-right"></i></a>
                                </div>
                            </div>
                        </div>
                        <div class="text-center mt-4">
                            <a href="index.html#price" class="btn solid-btn"><i class="fa fa-arrow-left"></i> Continue Shopping</a>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>
    <!-- main-area-end -->

    <!-- footer-area (reuse from index.html) -->
    <footer class="footer-area special-footer">
        <div class="footer-top-wrap">
            <div class="container">
                <div class="row justify-content-between">
                    <!-- ...footer widgets as in index.html... -->
                </div>
            </div>
        </div>
        <div class="copyright-wrap">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="copyright-text">
                            <p>Copyright By @<a href="index.html">Drs siddha</a> - 2025</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>
    <!-- footer-area-end -->

    <!-- JS here -->
    <script src="assets/js/vendor/jquery-3.6.0.min.js"></script>
    <script src="assets/js/bootstrap.min.js"></script>
    <script>
        // Quantity increment/decrement (demo only)
        document.querySelectorAll('.cart-plus-minus').forEach(function (el) {
            var minus = el.querySelector('.minus');
            var plus = el.querySelector('.plus');
            var input = el.querySelector('input');
            minus.onclick = function () {
                var val = parseInt(input.value, 10);
                if (val > 1) input.value = val - 1;
            };
            plus.onclick = function () {
                var val = parseInt(input.value, 10);
                input.value = val + 1;
            };
        });
    </script>
</body>
</html>