import 'package:drssiddha/app/data/my_colors.dart';
import 'package:flutter/material.dart';

class LoaderWidget extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    return Container(
      color: Colors.white,
      height: MediaQuery.of(context).size.height,
      width: MediaQuery.of(context).size.width,
      child: Align(
        alignment: Alignment.center,
        child: Container(
          padding: EdgeInsets.all(8.0),
          height: 80,
          width: 250.0,
          color: Colors.white,
          child: Center(
            child: Row(
              mainAxisAlignment: MainAxisAlignment.center,
              crossAxisAlignment: CrossAxisAlignment.center,
              children: [
              CircularProgressIndicator(
                backgroundColor: MyColors.primary,
                valueColor: new AlwaysStoppedAnimation<Color>(MyColors.primaryValue),
              ),
              SizedBox(
                width: 10,
              ),
              Text(
                "Please Wait....",
                style: TextStyle(color: MyColors.grey_100_, fontSize: 14),
              )
            ]),
          ),
        ),
      ),
    );
  }
}
