import 'package:drssiddha/app/model/user_model.dart';
import 'package:drssiddha/app/pages/login/logout.dart';
import 'package:drssiddha/app/pages/my_orders/my_orders.dart';
import 'package:drssiddha/app/pages/products/product_category.dart';
import 'package:drssiddha/app/pages/profile/profile.dart';
import 'package:drssiddha/app/widget/my_text.dart';
import 'package:drssiddha/app/widgets/coming_soon.dart';
import 'package:flutter/material.dart';
import 'package:drssiddha/app/data/my_colors.dart';
import 'package:drssiddha/app/pages/home/home.dart';

class DrawerMenu extends StatefulWidget {
  User userData;
  DrawerMenu(this.userData);
  static final String routeName = 'home';
  @override
  State<StatefulWidget> createState() {
    return new _DrawerMenuPage(this.userData);
  }
}

class _DrawerMenuPage extends State<DrawerMenu> {
  User userData;
  _DrawerMenuPage(this.userData);
  @override
  void initState() {
    super.initState();
  }

  final List<dynamic> pages = [
    SubMenuItem("Home", HomePage(), Icons.home),
    SubMenuItem("Products", ProductsCategoryPage(), Icons.shopping_cart),
    SubMenuItem("Franchises", ComingSoonsPage("Franchises", "home"),
        Icons.local_hospital),
    SubMenuItem(
        "Dealers", ComingSoonsPage("Dealers", "home"), Icons.developer_board),
    SubMenuItem("My Orders", MyOrdersPage(), Icons.shopping_basket),
    SubMenuItem("Profile", ProfileViewPage(), Icons.person),
    SubMenuItem("Logout", Logout(), Icons.lock)
  ];

  @override
  Widget build(BuildContext context) => Drawer(
        child: Scaffold(
          appBar: PreferredSize(
            preferredSize: Size.fromHeight(180),
            child: Container(
                padding: EdgeInsets.only(top: 22.0, left: 0.0),
                width: double.infinity,
                color: MyColors.primaryValue,
                height: 200.0,
                child: new Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: <Widget>[
                    Container(
                      height: 170,
                      child: Column(
                        mainAxisAlignment: MainAxisAlignment.center,
                        children: <Widget>[
                          // Container(height: 30),
                          CircleAvatar(
                            radius: 32,
                            backgroundColor: MyColors.grey_20,
                            child: CircleAvatar(
                              radius: 30,
                              backgroundColor: Colors.transparent,
                              backgroundImage:
                                  AssetImage("assets/images/drs-logo.png"),
                            ),
                          ),
                          Container(height: 7),
                          Text(
                              // ignore: unnecessary_null_comparison
                              userData != null
                                  ? 'Welcome, ' + userData.name!
                                  : 'Welcome, Guest',
                              style: MyText.body2(context)!.copyWith(
                                  color: MyColors.primary,
                                  fontWeight: FontWeight.w500)),
                          Container(height: 2),
                          Text(
                              // ignore: unnecessary_null_comparison
                              userData != null
                                  ? userData.userEmail!
                                  : 'Email@email.com',
                              style: MyText.caption(context)!.copyWith(
                                  color: MyColors.primary,
                                  fontWeight: FontWeight.w500))
                        ],
                      ),
                    ),
                    Container(height: 8),
                  ],
                )),
          ),
          body: ListView.builder(
            itemBuilder: (BuildContext context, int index) {
              dynamic page = pages[index];
              return page is MenuItem
                  ? _buildExpandableMenu(page, context)
                  : _buildSubMenu(page, context);
            },
            itemCount: pages.length,
          ),
        ),
      );

  Widget _buildExpandableMenu(MenuItem page, BuildContext context) {
    return ExpansionTile(
      //leading: CircleAvatar(backgroundImage: AssetImage(page.image),),
      leading: Icon(page.icon),
      //leading: Icon(Icons.dashboard),
      title: Text(page.title!),
      children: _buildSubMenus(page.items!, context),
    );
  }

  List<Widget> _buildSubMenus(List<SubMenuItem> items, BuildContext context) {
    final List<Widget> subMenus = [];
    items.forEach((item) => subMenus.add(_buildSubMenu(item, context)));
    return subMenus;
  }

  Widget _buildSubMenu(SubMenuItem item, BuildContext context) {
    return Column(
      children: <Widget>[
        Container(
          height: 45,
          //padding: EdgeInsets.fromLTRB(5, 1, 10, 1),
          //margin: EdgeInsets.fromLTRB(5, 1, 10, 1),
          child: ListTile(
            leading: Icon(
              item.icon,
              color: MyColors.subTitleTextColor,
            ),
            title: Text(
              item.title,
              style: TextStyle(
                  color: MyColors.subTitleTextBlackColor,
                  letterSpacing: 1.5,
                  fontSize: 15),
            ),
            onTap: () => Navigator.pushReplacement(
            context,
            MaterialPageRoute(
                builder: (BuildContext ctx) => item.page))
          ),
        ),
      ],
    );
  }

  // void _openPage(Object page, BuildContext context) {
  //  Navigator.pushReplacement(
  //           context,
  //           MaterialPageRoute(
  //               builder: (BuildContext ctx) => page));
  // }
}

class MenuItem {
  final String? title;
  final IconData? icon;
  final List<SubMenuItem>? items;
  MenuItem({Key? key, @required this.title, this.icon, this.items});
}

class SubMenuItem {
  final String title;
  final IconData icon;
  final Widget page;
  SubMenuItem(this.title, this.page, this.icon);
}
