import 'package:drssiddha/app/data/my_colors.dart';
import 'package:drssiddha/app/pages/cart/cart_page.dart';
import 'package:drssiddha/app/provider/cart_provider.dart';
import 'package:drssiddha/app/widgets/badge.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:provider/provider.dart';

class CommonAppBar extends StatelessWidget implements PreferredSizeWidget  {

  @override
  Widget build(BuildContext context) {
    return AppBar(
                  backgroundColor: MyColors.primaryValue,
                  iconTheme: IconThemeData(color: MyColors.primary),
                  title: Container(
                      width: 150,
                      height: 50.0,
                      child: Image.asset("assets/images/drs-logo.png",
                          fit: BoxFit.cover)),
                  // title: Text('Drs_Siddha', style: TextStyle(color: Colors.white),),
                  centerTitle: true,
                  elevation: 0,
                  automaticallyImplyLeading: false,
                  leading: Consumer<CartProvider>(
                    builder: (_, cart, ch) => cart.getTotalQuantity > 0
                        ? Badge(
                            child: ch,
                            value: cart.getTotalQuantity.toString(),
                            color: MyColors.logobody,
                          )
                        : Container(),
                    child: Consumer<CartProvider>(
                      builder: (_, cart, ch) {
                        return cart.getTotalQuantity > 0
                            ? Padding(
                                padding: const EdgeInsets.only(right: 5.0),
                                child: IconButton(
                                  icon: Icon(
                                    Icons.shopping_cart,
                                    size: 30,
                                    color: MyColors.primary,
                                  ),
                                  onPressed: () {
                                    Navigator.pushReplacement(
                                        context,
                                        MaterialPageRoute(
                                            builder: (BuildContext ctx) =>
                                                CartPage()));
                                    // Navigator.of(context).pushNamed(CartPage.routeName);
                                  },
                                ),
                              )
                            : Container();
                      },
                    ),
                  )
    );
  }
  @override
  Size get preferredSize => new Size.fromHeight(kToolbarHeight);
}