import 'package:drssiddha/app/data/my_colors.dart';
import 'package:drssiddha/app/pages/home/drs_siddha_groups/drs_siddha_groups.dart';
import 'package:drssiddha/app/pages/home/gallery/gallery.dart';
import 'package:drssiddha/app/pages/home/home.dart';
import 'package:drssiddha/app/pages/home/news_events/news_events.dart';
import 'package:drssiddha/app/pages/home/resources/resources.dart';
import 'package:drssiddha/app/widgets/loader.dart';
import 'package:flutter/material.dart';

class ComingSoonsPage extends StatefulWidget {
  final title;
  final page;
  ComingSoonsPage(this.title, this.page);

  @override
  ComingSoonsPageState createState() =>
      new ComingSoonsPageState(this.title, this.page);
}

class ComingSoonsPageState extends State<ComingSoonsPage> {
  final title;
  final page;
  ComingSoonsPageState(this.title, this.page);
  // var _infoData;
  bool _load = false;

  @override
  void initState() {
    super.initState();
    // fetchHome();
  }

  returnPage() {
    if (page == "home") {
      Navigator.pushReplacement(context,
          MaterialPageRoute(builder: (BuildContext ctx) => HomePage()));
    } else if (page == "drsSiddhaGroup") {
      Navigator.pushReplacement(
          context,
          MaterialPageRoute(
              builder: (BuildContext ctx) => DrsSiddhaGroupsPage()));
    } else if (page == "newsevents") {
      Navigator.pushReplacement(context,
          MaterialPageRoute(builder: (BuildContext ctx) => NewsEventsPage()));
    } else if (page == "resources") {
      Navigator.pushReplacement(context,
          MaterialPageRoute(builder: (BuildContext ctx) => ResourcesPage()));
    } else if (page == "gallery") {
      Navigator.pushReplacement(context,
          MaterialPageRoute(builder: (BuildContext ctx) => GalleryPage()));
    }else {
      Navigator.pushReplacement(context,
          MaterialPageRoute(builder: (BuildContext ctx) => HomePage()));
    }
  }

  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: () {
        return returnPage();
      },
      child: new Scaffold(
        backgroundColor: Colors.white,
        appBar: AppBar(
          backgroundColor: MyColors.primaryValue,
          centerTitle: true,
          title: Text(
            title,
            style: TextStyle(color: MyColors.primary, fontSize: 18),
          ),
          leading: IconButton(
            icon: const Icon(Icons.arrow_back_ios,
                size: 16, color: MyColors.primary),
            onPressed: () {
              returnPage();
            },
          ),
          automaticallyImplyLeading: true,
        ),
        body: _load
            ? LoaderWidget()
            : Center(
                child: Container(
                    alignment: Alignment.center,
                    child: Text('Will be updated Soon...')),
              ),
      ),
    );
  }
}
