import 'dart:async';

import 'package:drssiddha/app/data/my_colors.dart';
import 'package:drssiddha/app/utility/auth_utils.dart';
import 'package:drssiddha/app/utility/network_utils.dart';
import 'package:drssiddha/app/widget/my_text.dart';
import 'package:dio/dio.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_form_builder/flutter_form_builder.dart';

class DialogFormAlert extends StatefulWidget {
  final title;
  DialogFormAlert(this.title);
  @override
  _DialogFormAlertState createState() => _DialogFormAlertState(this.title);
}

class _DialogFormAlertState extends State<DialogFormAlert> {
  final title;
  _DialogFormAlertState(this.title);
  GlobalKey<ScaffoldState> _scaffoldKey = new GlobalKey<ScaffoldState>();

  final GlobalKey<FormState> _fbKey = GlobalKey<FormState>();
  bool _enableBtn = true;
  String? name, contactNumber, email, location, message;

  final focus1 = FocusNode();
  final focus2 = FocusNode();
  final focus3 = FocusNode();
  final focus4 = FocusNode();
  final focus5 = FocusNode();

  @override
  void initState() {
    super.initState();
  }

  startTime() async {
    
    _fbKey.currentState!.reset();
    return Timer(Duration(milliseconds: 1000), navigator);
  }

  /// Navigation to route after user succes payment
  void navigator() {
    Navigator.of(context, rootNavigator: true).pop();
  }

  // void _showToast(BuildContext context, String _msg) {
  //   final scaffold = Scaffold.of(context);
  //   scaffold.showSnackBar(
  //     SnackBar(
  //       backgroundColor: Colors.redAccent,
  //       content: Text(_msg),
  //     ),
  //   );
  // }

  updateMemberForm(context, title) async {
    try {
      FormData formData = new FormData.fromMap({
        'post_data': "1",
        'apikey': AuthUtils.api,
        // 'user_id': userData.userId,
        // 'role_id': userData.roleId,
        // 'title': title,
        'authorizedpersonName': name,
        'companyName': email,
        'contactNumber': contactNumber,
        'Address': location,
        'serviceProvided': title,
        'additionalNotes': message,
      });
      var responseJson =
          await NetworkUtils.insertData('joinus_form.php', formData);
      if (responseJson['result'] == 'success') {
        //  NetworkUtils.showSnackBar(_scaffoldKey, responseJson['msg']);
        await NetworkUtils.alertDlg(context, responseJson['msg']);
        startTime();

        // return true;

        // Navigator.pushReplacement(
        //     context,
        //     MaterialPageRoute(
        //         builder: (BuildContext ctx) => JoinAsVendorPage()));
      } else {
        // NetworkUtils.alertDlg(context, responseJson['msg']);
        NetworkUtils.showSnackBar(_scaffoldKey, responseJson['msg']);
        startTime();
        // return true;
      }
    } catch (error) {
      // NetworkUtils.alertDlg(context, error.toString());
      NetworkUtils.showSnackBar(_scaffoldKey, error.toString());
      // NetworkUtils.alertDlg(context, responseJson['msg']);
      startTime();
      // return true;
    }
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      key: _scaffoldKey,
      body: Container(
        child: AlertDialog(
          contentPadding: EdgeInsets.all(5.0),
          title: Container(
              // color: MyColors.primaryValue,
              width: MediaQuery.of(context).size.width - 50,
              child: Padding(
                padding: const EdgeInsets.only(top: 10.0, bottom: 10.0),
                child: Text(title,
                    textAlign: TextAlign.center,
                    style: TextStyle(
                        fontSize: 14,
                        fontWeight: FontWeight.bold,
                        color: MyColors.primaryValue)),
              )),
          scrollable: true,
          elevation: 0.0,
          content: Container(
            height: MediaQuery.of(context).size.height - 270,
            width: double.maxFinite,
            //         ConstrainedBox(
            // constraints: BoxConstraints(maxHeight: 200.0, maxWidth: 500.0, minWidth: 500.0),
            child: Scrollbar(
              child: ListView(
                children: [
                  Align(
                    alignment: Alignment.topCenter,
                    child: Container(
                      child: Form(
                        key: _fbKey,
                        onChanged: () {
                          _fbKey.currentState!.validate();
                        },
                        // autovalidateMode: AutovalidateMode.always,
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: <Widget>[
                            Container(height: 10),
                            // Align(
                            //     alignment: Alignment.bottomLeft,
                            //     child: Text("NAME",
                            //         style: MyText.body1(context).copyWith(
                            //             color: MyColors.grey_60,
                            //             fontSize: 12.0))),
                            // Container(height: 5),
                            Card(
                              shape: RoundedRectangleBorder(
                                borderRadius: BorderRadius.circular(3),
                              ),
                              clipBehavior: Clip.antiAliasWithSaveLayer,
                              margin: EdgeInsets.all(0),
                              elevation: 0,
                              child: Padding(
                                padding: const EdgeInsets.only(
                                    top: 0.0, bottom: 0.0),
                                child: Container(
                                  alignment: Alignment.centerLeft,
                                  padding: EdgeInsets.symmetric(
                                      horizontal: 0.0, vertical: 0.0),
                                  child: FormBuilderTextField(
                                    textCapitalization:
                                        TextCapitalization.sentences,
                                    // onFieldSubmitted: (val) {
                                    //   FocusScope.of(context)
                                    //       .requestFocus(focus2);
                                    // },
                                    focusNode: focus1,
                                    name: "Name",
                                    decoration: InputDecoration(
                                        contentPadding: EdgeInsets.symmetric(
                                            horizontal: 5.0, vertical: 0),
                                        hintText: " Name",
                                        hintStyle: TextStyle(
                                            fontSize: 13.0,
                                            color: MyColors.allTextColor),
                                        //  labelText: "REGISTER NUMBER",
                                        border: OutlineInputBorder(
                                            borderRadius:
                                                BorderRadius.circular(3.0))),
                                   validator: FormBuilderValidators.compose([
                                FormBuilderValidators.required(context,
                                          errorText: "Name required"),
                                      // FormBuilderValidators.numeric(),
                                      // FormBuilderValidators.max(6),
                                    ]),
                                    onSaved: (value) {
                                      setState(() {
                                        
                                      name = value;
                                      });
                                    },
                                  ),
                                ),
                              ),
                            ),

                            Container(height: 10),
                            // Align(
                            //     alignment: Alignment.bottomLeft,
                            //     child: Text("CONTACT NUMBER",
                            //         style: MyText.body1(context)
                            //             .copyWith(color: MyColors.grey_60))),
                            // Container(height: 5),
                            Card(
                              shape: RoundedRectangleBorder(
                                borderRadius: BorderRadius.circular(3),
                              ),
                              clipBehavior: Clip.antiAliasWithSaveLayer,
                              margin: EdgeInsets.all(0),
                              elevation: 0,
                              child: Padding(
                                padding: const EdgeInsets.only(
                                    top: 0.0, bottom: 0.0),
                                child: Container(
                                  alignment: Alignment.centerLeft,
                                  padding: EdgeInsets.symmetric(
                                      horizontal: 0, vertical: 0.0),
                                  child: FormBuilderTextField(
                                    keyboardType: TextInputType.number,
                                    // onFieldSubmitted: (val) {
                                    //   FocusScope.of(context)
                                    //       .requestFocus(focus3);
                                    // },
                                    focusNode: focus2,
                                    name: "mobile",
                                    decoration: InputDecoration(
                                        contentPadding: EdgeInsets.symmetric(
                                            horizontal: 5.0, vertical: 0),
                                        hintText: "Contact Number",
                                        hintStyle: TextStyle(
                                            fontSize: 13.0,
                                            color: MyColors.allTextColor),
                                        border: OutlineInputBorder(
                                            borderRadius:
                                                BorderRadius.circular(3.0))),
                                    validator: FormBuilderValidators.compose([
                                FormBuilderValidators.required(context,
                                          errorText: "Contact Number required"),
                                      FormBuilderValidators.numeric(context),
                                      FormBuilderValidators.minLength(context, 10),
                                      FormBuilderValidators.maxLength(context, 10),
                                    ]),
                                    onSaved: (value) {
                                      setState(() {
                                      contactNumber = value;
                                      });
                                    },
                                  ),
                                ),
                              ),
                            ),
                            Container(height: 10),
                            // Align(
                            //     alignment: Alignment.bottomLeft,
                            //     child: Text("EMAIL",
                            //         style: MyText.body1(context)
                            //             .copyWith(color: MyColors.grey_60))),
                            // Container(height: 5),
                            Card(
                              shape: RoundedRectangleBorder(
                                borderRadius: BorderRadius.circular(3),
                              ),
                              clipBehavior: Clip.antiAliasWithSaveLayer,
                              margin: EdgeInsets.all(0),
                              elevation: 0,
                              child: Padding(
                                padding: const EdgeInsets.only(
                                    top: 0.0, bottom: 0.0),
                                child: Container(
                                  alignment: Alignment.centerLeft,
                                  padding: EdgeInsets.symmetric(
                                      horizontal: 0, vertical: 0.0),
                                  child: FormBuilderTextField(
                                    textCapitalization:
                                        TextCapitalization.sentences,
                                    // onFieldSubmitted: (val) {
                                    //   FocusScope.of(context)
                                    //       .requestFocus(focus4);
                                    // },
                                    focusNode: focus3,
                                    name: "Email",
                                    decoration: InputDecoration(
                                        contentPadding: EdgeInsets.symmetric(
                                            horizontal: 5.0, vertical: 0),
                                        hintText: "Email",
                                        hintStyle: TextStyle(
                                            fontSize: 13.0,
                                            color: MyColors.allTextColor),
                                        //  labelText: "REGISTER NUMBER",
                                        border: OutlineInputBorder(
                                            borderRadius:
                                                BorderRadius.circular(3.0))),
                                   validator: FormBuilderValidators.compose([
                                FormBuilderValidators.required(context,
                                          errorText: "Email required"),
                                      FormBuilderValidators.email(context)
                                      // FormBuilderValidators.numeric(),
                                      // FormBuilderValidators.max(6),
                                    ]),
                                    onSaved: (value) {
                                      setState(() {
                                        
                                      email = value;
                                      });
                                    },
                                  ),
                                ),
                              ),
                            ),
                            Container(height: 10),
                            // Align(
                            //     alignment: Alignment.bottomLeft,
                            //     child: Text("LOCATION",
                            //         style: MyText.body1(context)
                            //             .copyWith(color: MyColors.grey_60))),
                            // Container(height: 5),
                            Card(
                              shape: RoundedRectangleBorder(
                                borderRadius: BorderRadius.circular(3),
                              ),
                              clipBehavior: Clip.antiAliasWithSaveLayer,
                              margin: EdgeInsets.all(0),
                              elevation: 0,
                              child: Padding(
                                padding: const EdgeInsets.only(
                                    top: 0.0, bottom: 0.0),
                                child: Container(
                                  alignment: Alignment.centerLeft,
                                  padding: EdgeInsets.symmetric(
                                      horizontal: 0, vertical: 0.0),
                                  child: FormBuilderTextField(
                                    textCapitalization:
                                        TextCapitalization.sentences,
                                    // onFieldSubmitted: (val) {
                                    //   FocusScope.of(context)
                                    //       .requestFocus(focus5);
                                    // },
                                    focusNode: focus4,
                                    name: "Location",
                                    decoration: InputDecoration(
                                        contentPadding: EdgeInsets.symmetric(
                                            horizontal: 5.0, vertical: 0),
                                        hintText: "Location",
                                        hintStyle: TextStyle(
                                            fontSize: 13.0,
                                            color: MyColors.allTextColor),
                                        //  labelText: "REGISTER NUMBER",
                                        border: OutlineInputBorder(
                                            borderRadius:
                                                BorderRadius.circular(3.0))),
                                   validator: FormBuilderValidators.compose([
                                FormBuilderValidators.required(context,
                                          errorText: "Location required"),
                                      // FormBuilderValidators.numeric(),
                                      // FormBuilderValidators.max(6),
                                    ]),
                                    onSaved: (value) {
                                      setState(() {
                                      location = value;
                                      });
                                    },
                                  ),
                                ),
                              ),
                            ),
                            Container(height: 10),

                            // Align(
                            //     alignment: Alignment.bottomLeft,
                            //     child: Text("Message",
                            //         style: MyText.body1(context)
                            //             .copyWith(color: MyColors.grey_60))),
                            // Container(height: 5),
                            Card(
                              shape: RoundedRectangleBorder(
                                borderRadius: BorderRadius.circular(3),
                              ),
                              clipBehavior: Clip.antiAliasWithSaveLayer,
                              margin: EdgeInsets.all(0),
                              elevation: 0,
                              child: Padding(
                                padding: const EdgeInsets.only(
                                    top: 0.0, bottom: 0.0),
                                child: Container(
                                  alignment: Alignment.centerLeft,
                                  padding: EdgeInsets.symmetric(
                                      horizontal: 0, vertical: 0.0),
                                  child: FormBuilderTextField(
                                    textCapitalization:
                                        TextCapitalization.sentences,
                                    maxLines: 3,
                                    // onFieldSubmitted: (val) {
                                    //   FocusScope.of(context)
                                    //       .requestFocus(focus5);
                                    // },
                                    focusNode: focus5,
                                    name: "Message",
                                    decoration: InputDecoration(
                                        contentPadding: EdgeInsets.symmetric(
                                            horizontal: 5.0, vertical: 5),
                                        hintText: "Message",
                                        hintStyle: TextStyle(
                                            fontSize: 13.0,
                                            color: MyColors.allTextColor),
                                        //  labelText: "REGISTER NUMBER",
                                        border: OutlineInputBorder(
                                            borderRadius:
                                                BorderRadius.circular(3.0))),
                                    validator: FormBuilderValidators.compose([
                                FormBuilderValidators.required(context,
                                          errorText: "Message required"),
                                      // FormBuilderValidators.numeric(),
                                      // FormBuilderValidators.max(6),
                                    ]),
                                    onSaved: (value) {
                                      setState(() {
                                        
                                      message = value;
                                      });
                                    },
                                  ),
                                ),
                              ),
                            ),

                            Container(height: 20),
                            Padding(
                                // this is new
                                padding: EdgeInsets.only(
                                    bottom: MediaQuery.of(context)
                                        .viewInsets
                                        .bottom)),
                            // Align(
                            //   alignment: Alignment.center,
                            //   child: Container(
                            //     // width: double.infinity,
                            //     height: 30,
                            //     // child: AbsorbPointer(
                            //     //   absorbing: !enabled,
                            //     child: FlatButton(
                            //       child: Text("SUBMIT",
                            //           style: MyText.subhead(context).copyWith(
                            //               fontWeight: FontWeight.bold,
                            //               fontSize: 14.0,
                            //               color: Colors.white,
                            //               letterSpacing: 0.5)),
                            //       color: MyColors.primary,
                            //       onPressed: !_enableBtn
                            //           ? null
                            //           : () {
                            //               final FormBuilderState form =
                            //                   _fbKey.currentState;

                            //               if (!form.validate()) {
                            //                 // showMessage(
                            //                 //     'Form is not valid!  Please review and correct.');
                            //               } else {
                            //                 form.save(); //This invokes each onSaved event

                            //                 print("Form Saved Datas:");

                            //                 form.save(); //This invokes each onSaved event
                            //                 print(
                            //                     '========================================');
                            //                 print('Submitting to back end...');

                            //                 updateProfile(context, title);
                            //                 Navigator.pop(context);
                            //               }
                            //             },
                            //     ),
                            //   ),
                            // ),
                            // ),
                          ],
                        ),
                      ),
                    ),
                  ),
                ],
              ),
            ),
          ),
          actions: <Widget>[
            // ignore: deprecated_member_use
            new FlatButton(
              child: new Text(
                'CANCEL',
                style: TextStyle(color: Colors.black),
              ),
              onPressed: () {
                Navigator.of(context).pop("");
              },
            ),
            // ignore: deprecated_member_use
            new FlatButton(
              child: Text("SUBMIT",
                  style: MyText.subhead(context)!.copyWith(
                      fontWeight: FontWeight.bold,
                      fontSize: 14.0,
                      color: Colors.white,
                      letterSpacing: 0.5)),
              color: MyColors.primary,
              onPressed: _enableBtn ? () {
                FocusScope.of(context).requestFocus(FocusNode());
                final FormState form = _fbKey.currentState!;

                if (!form.validate()) {
                  NetworkUtils.showSnackBar(_scaffoldKey,
                      'Form is not valid!  Please review and correct.');
                      _enableBtn = true;
                } else {
                  print(name);
                  print(contactNumber);
                  print(email);
                  print(message);
                  print(title);
                  form.save(); //This invokes each onSaved event

                  print("Form Saved Datas:");

                  form.save(); //This invokes each onSaved event
                  print('========================================');
                  print('Submitting to back end...');
                   _enableBtn = false;
                  updateMemberForm(context, title);

                  // Navigator.of(context).pop("");
                  // Navigator.pop();

                  // updateProfile(context, title);
                  // Navigator.pop(context);
                }
              } : null,
            ),
          ],
        ),
      ),
    );

    // return Container();
  }
}
