import 'package:drssiddha/app/data/my_colors.dart';
import 'package:drssiddha/app/model/user_model.dart';
import 'package:drssiddha/app/pages/home/home.dart';
import 'package:drssiddha/app/pages/login/login.dart';
import 'package:drssiddha/app/utility/auth_utils.dart';
import 'package:drssiddha/app/widget/my_text.dart';
import 'package:connectivity/connectivity.dart';
import 'package:flutter/material.dart';
import 'dart:ui';

class NoitemInternetImageRoute extends StatefulWidget {
  NoitemInternetImageRoute();

  @override
  NoitemInternetImageRouteState createState() =>
      new NoitemInternetImageRouteState();
}

class NoitemInternetImageRouteState extends State<NoitemInternetImageRoute> {
  bool finishLoading = false;
  User? userData = User();

  @override
  void initState() {
    super.initState();

    fetchSessionAndNavigate();
  }

  fetchSessionAndNavigate() async {
    setState(() {
      finishLoading = true;
    });

    userData = await AuthUtils.loadSharedPrefs();
    // print(userData.fid);
    // print(userData.username);
    setState(() {
      finishLoading = false;
    });
    //  await _fetchHome();
  }

  @override
  Widget build(BuildContext context) {
    return new   Scaffold(
      backgroundColor: Colors.white,
      appBar: PreferredSize(
          preferredSize: Size.fromHeight(0),
          child: Container(color: Colors.white)),
      body: Align(
        alignment: Alignment.center,
        child: Container(
          alignment: Alignment.center,
          width: 280,
          child: Stack(
            children: <Widget>[
              finishLoading  ? CircularProgressIndicator()
                  : Column(
                      mainAxisSize: MainAxisSize.min,
                      crossAxisAlignment: CrossAxisAlignment.center,
                      children: <Widget>[
                        Image.asset(
                            'assets/images/img_no_internet_satellite.png',
                            width: 250,
                            height: 250),
                        Text("Whoops!",
                            style: MyText.display1(context)!.copyWith(
                                color: MyColors.primary,
                                fontWeight: FontWeight.bold)),
                        Container(height: 10),
                        Text(
                            "No internet connections found. Check your connection or try again",
                            textAlign: TextAlign.center,
                            style: MyText.medium(context)!
                                .copyWith(color: MyColors.primary)),
                        Container(height: 25),
                        Container(
                          width: 180, height: 40,
                          // ignore: deprecated_member_use
                          child: FlatButton(
                            child: Text("RETRY",
                                style: TextStyle(color: Colors.white)),
                            color: MyColors.primary,
                            shape: RoundedRectangleBorder(
                                borderRadius: BorderRadius.circular(20)),
                            onPressed: () {
                              setState(() {
                                finishLoading = false;
                              });
                              delayShowingContent();
                            },
                          ),
                        )
                      ],
                    )
                 ,
            ],
          ),
        ),
      ),
    );
  }

  void delayShowingContent() async {
    setState(() {
        finishLoading = true;
      });
    var connectivityResult = await (Connectivity().checkConnectivity());
    if (connectivityResult == ConnectivityResult.mobile ||connectivityResult == ConnectivityResult.mobile) {
      if (userData != null) {
        Navigator.pushReplacement(
            context,
            MaterialPageRoute(
                builder: (BuildContext ctx) => HomePage()));
      } else {
        Navigator.pushReplacement(
            context,
            MaterialPageRoute(
                builder: (BuildContext ctx) => LoginPage()));
      }
    } else {
      Future.delayed(Duration(seconds: 2), () {
        setState(() {
          finishLoading = false;
        });
      });
    }
    
    
      
    
  }
}
