import 'dart:async';
import 'dart:convert';
import 'dart:io';
import 'package:drssiddha/app/auth_flow.dart';
import 'package:drssiddha/app/pages/home/home.dart';
import 'package:drssiddha/app/widget/my_text.dart';
import 'package:drssiddha/app/widget/noitem_internet_image.dart';
import 'package:drssiddha/app/widgets/no_Internet.dart';
// import 'package:data_connection_checker/data_connection_checker.dart';
import 'package:flutter/material.dart';
import 'package:drssiddha/app/data/my_colors.dart';
import 'package:drssiddha/app/pages/login/login.dart';
import 'package:shared_preferences/shared_preferences.dart';
import 'auth_utils.dart';
import 'package:dio/dio.dart';
import 'package:html/parser.dart' show parse;
import 'package:drssiddha/locator.dart';
import 'package:package_info/package_info.dart';

class NetworkUtils {
  static final String host = productionHost;
  static final String productionHost = 'http://drsiddha.com/backend/appapi/';
      // 'http://www.almaherbal.com/drsiddha/api/';
  static final String developmentHost =
      'http://192.168.1.138:81/doctorsiddha/api/';
  static final String noImage = host + '/uploads/no_image.png';
  static final String api = AuthUtils.api;

  static noimage() async {
    return noImage;
  }

  static String parseHtmlString(_responseText) {
    var document = parse(_responseText);
    String parsedString = parse(document.body!.text).documentElement!.text;
    return parsedString;
  }

  static Future<void> networkDlg(BuildContext context, String message) async =>
      showDialog<void>(
          context: context,
          builder: (context) => Dialog(
                backgroundColor: Colors.transparent,
                child: Container(
                  child: Card(
                    shape: RoundedRectangleBorder(
                      borderRadius: BorderRadius.circular(4),
                    ),
                    color: Colors.white,
                    clipBehavior: Clip.antiAliasWithSaveLayer,
                    child: Column(
                      mainAxisSize: MainAxisSize.min,
                      children: <Widget>[
                        Container(
                          width: double.infinity,
                          color: MyColors.primaryValue,
                          child: Image.asset(
                            'assets/images/drs-logo.png', width: 150.0,
                            height: 50,
                            // color: Colors.white,
                          ),
                        ),
                       
                        Container(
                          padding: EdgeInsets.fromLTRB(15, 15, 15, 0),
                          child: Text(message,
                              textAlign: TextAlign.justify,
                              style: MyText.body2(context)!
                                  .copyWith(color: MyColors.grey_100_)),
                        ),
                        Row(
                          mainAxisAlignment: MainAxisAlignment.end,
                          children: <Widget>[
                           
                            // ignore: deprecated_member_use
                            FlatButton(
                              child: Text("OKay"),
                              textColor: MyColors.primaryValue,
                              color: Colors.transparent,
                              onPressed: () {
                                Navigator.pop(context);
                                Navigator.of(context).pushReplacement(
                                    MaterialPageRoute(
                                        builder: (BuildContext context) =>
                                            new NoInternet()));
                              },
                            )
                          ],
                        )
                      ],
                    ),
                  ),
                ),
              ));
  

  static Future<void> checkDataConnectivity(
      BuildContext context, route) async {
    try {
      final result = await InternetAddress.lookup('google.com');
      if (result.isNotEmpty && result[0].rawAddress.isNotEmpty) {
        print('connected');
      }
    } on SocketException catch (_) {
      print('not connected');
      Navigator.of(context).pushReplacement(PageRouteBuilder(
          pageBuilder: (_, __, ___) => new NoitemInternetImageRoute()));
    }

    /* var connectivityResult = await (Connectivity().checkConnectivity());
    if (connectivityResult == ConnectivityResult.mobile || connectivityResult == ConnectivityResult.wifi) {
      
    print(connectivityResult);     
    } else {
      Navigator.of(context).pushReplacement(PageRouteBuilder(
          pageBuilder: (_, __, ___) => new NoitemInternetImageRoute()));
    } */
    // return false;
  }


  
  static showSnackBar(GlobalKey<ScaffoldState> scaffoldKey, String message) {
    // ignore: deprecated_member_use
    scaffoldKey.currentState!.showSnackBar(new SnackBar(
      // ignore: unnecessary_null_comparison
      content: new Text(message!=null ? message :  "You are offline"),
      duration: Duration(seconds: 30),
    ));
  }

  static getAuthToken(old_endPoint, old_formData) async { 
    final NavigationService _navigationService = locator<NavigationService>();
    SharedPreferences prefs = await SharedPreferences.getInstance();
    prefs.remove('authtoken');
    final PackageInfo info = await PackageInfo.fromPlatform();
     
    String textValue = '';
    var uri = host + "authorization.php";
    
    FormData formData = new FormData.fromMap({
      'post_data': "1",
      'apikey': AuthUtils.api,
      'version': info.version,
      'user_id': 0,
      'token': textValue
    }); 
    print(uri);
    try {
      var dio = new Dio();
      final response = await dio.post(uri, data: formData);
      print("Response auth status: ${response.statusCode}");
      print('Response auth status: ${response.data}');
      var arrVal = json.decode(response.data);
      //AuthUtils.setAuthToken(prefs, arrVal['jwt_token']); // setAuthToken(SharedPreferences prefs, var token)
      
      prefs.setString('authtoken', arrVal['jwt_token']);
      print('jwt_token');
      print(arrVal['jwt_token']);
      _navigationService.navigateTo('/');
      return null;
      //print(AuthUtils.authToken(prefs));
      //return insertData(old_endPoint, old_formData);
      //result: success, msg: token generated, jwt_token: eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpYXQiOjE2Mjg2ODEyNDksIm5iZiI6MTYyODY4MTI1OSwiZXhwIjoxNjI4NjgxNDI5LCJkYXRhIjp7ImN1c3RvbWVyIjoiR3Vlc3QifX0.iMe89PzphzSCrseYGS_TJwSvRpuokqGndMDD6i_Nc6A
    } catch (exception) {
      print(exception);
      if (exception.toString().contains('SocketException')) {
        return 'NetworkError';
      } else {
        return null;
      }
    }
  }
  
  static insertData(var endPoint, formData) async {
    var uri = host + endPoint;
    var authToken = '';
    SharedPreferences prefs = await SharedPreferences.getInstance();
    if(prefs.containsKey('authtoken')) {
      authToken = prefs.getString('authtoken')!;
    }
    print(authToken);
    print(uri);
    try {
      var dio = new Dio();
      //final response = await dio.post(uri, data: formData);
      final response = await dio.post(uri, data: formData,
        options: Options(
          followRedirects: false,
          validateStatus: (status) {
            return status! < 500;
          },
          headers: {
            //HttpHeaders.authorizationHeader: 'Bearer $token', // set content-length
            Headers.wwwAuthenticateHeader: 'Bearer '+ authToken, // set content-length
          },
        ), 
      );

      print("Response status: ${response.statusCode}");
      print('Response status: ${response.data}');
      var responseJson = json.decode(response.data);
      print(responseJson);
      if(responseJson['result'] == 'TokenError') {
        print("network testing");
        return getAuthToken(endPoint, formData);
      }
      if(response.statusCode==403) {
        return getAuthToken(endPoint, formData);
      } else {
        return json.decode(response.data);
      }
     // return json.decode(response.data);
    } catch (e) {
      if (e is DioError) {
        //handle DioError here by error type or by error code
        if(e.response?.statusCode==400) {
          print('Dio error!');
          print('STATUS: ${e.response?.statusCode}');
          print('DATA: ${e.response?.data}');
          print('HEADERS: ${e.response?.headers}');
          return getAuthToken(endPoint, formData);
        } else if (e.response != null) {
          print('Dio error!');
          print('STATUS: ${e.response?.statusCode}');
          print('DATA: ${e.response?.data}');
          print('HEADERS: ${e.response?.headers}');
        } else {
          // Error due to setting up or sending the request
          print('Error sending request!');
          print(e.message);
        }
      }
      /* print(exception);
      if (exception.toString().contains('SocketException')) {
        return 'NetworkError';
      } else {
        return null;
      } */
    }
  }

  

  static Future<void> alertDlg(BuildContext context, String message) {
    // final bloc1 = Provider.of<CartProvider>(context);
    return showDialog(
        context: context,
        builder: (context) => Dialog(
              backgroundColor: Colors.transparent,
              child: Container(
                child: Card(
                  shape: RoundedRectangleBorder(
                    borderRadius: BorderRadius.circular(4),
                  ),
                  color: Colors.white,
                  clipBehavior: Clip.antiAliasWithSaveLayer,
                  child: Column(
                    mainAxisSize: MainAxisSize.min,
                    children: <Widget>[
                      Container(
                        width: double.infinity,
                        color: MyColors.primaryValue,
                        child: Image.asset(
                          'assets/images/drs-logo.png', width: 150.0,
                          height: 50,
                          // color: Colors.white,
                        ),
                      ),
                      // Container(
                      //   alignment: Alignment.centerLeft,
                      //   padding: EdgeInsets.symmetric(horizontal: 15),
                      //   width: double.infinity,
                      //   height: 50,
                      //   color: MyColors.primary,
                      //   child: Text("Dr\'s Siddha",
                      //       textAlign: TextAlign.center,
                      //       style: MyText.title(context)
                      //           .copyWith(color: MyColors.primary)),
                      // ),
                      Container(
                        padding: EdgeInsets.fromLTRB(15, 15, 15, 0),
                        child: Text(message,
                            textAlign: TextAlign.justify,
                            style: MyText.body2(context)!
                                .copyWith(color: MyColors.grey_100_)),
                      ),
                      Row(
                        mainAxisAlignment: MainAxisAlignment.end,
                        children: <Widget>[
                          // new FlatButton(
                          //   child: Text("DECLINE"),
                          //   textColor: Colors.red[700],
                          //   color: Colors.transparent,
                          //   onPressed: () {
                          //     Navigator.pop(context);
                          //   },
                          // ),
                          // ignore: deprecated_member_use
                          FlatButton(
                            child: Text("OKay"),
                            textColor: MyColors.primaryValue,
                            color: Colors.transparent,
                            onPressed: () {
                              // bloc1.toStoreCartItems();
                              Navigator.pop(context);
                              // SystemChannels.platform
                              //     .invokeMethod('SystemNavigator.pop');
                            },
                          )
                        ],
                      )
                    ],
                  ),
                ),
              ),
            ));
  }

  static Future<void> alertDlgWithRedirect(
      BuildContext context, String title, String message, String redirectPage) {
    return showDialog(
      barrierDismissible: true,
        context: context,
        builder: (context) => Dialog(
              backgroundColor: Colors.transparent,
              child: Container(
                child: Card(
                  shape: RoundedRectangleBorder(
                    borderRadius: BorderRadius.circular(4),
                  ),
                  color: Colors.white,
                  clipBehavior: Clip.antiAliasWithSaveLayer,
                  child: Column(
                    mainAxisSize: MainAxisSize.min,
                    children: <Widget>[
                      Container(
                        width: double.infinity,
                        color: MyColors.primaryValue,
                        child: Image.asset(
                          'assets/images/drs-logo.png', width: 150.0,
                          height: 50,
                          // color: Colors.white,
                        ),
                      ),
                      Container(
                        alignment: Alignment.centerLeft,
                        padding: EdgeInsets.symmetric(horizontal: 15),
                        width: double.infinity,
                        height: 50,
                        color: Colors.white,
                        child: Text(title,
                            textAlign: TextAlign.center,
                            style: MyText.title(context)!
                                .copyWith(color: MyColors.primary)),
                      ),
                      Container(
                        padding: EdgeInsets.fromLTRB(15, 15, 15, 0),
                        child: Text(message,
                            textAlign: TextAlign.justify,
                            style: MyText.body2(context)!
                                .copyWith(color: MyColors.grey_100_)),
                      ),
                      Row(
                        mainAxisAlignment: MainAxisAlignment.end,
                        children: <Widget>[
                          // new FlatButton(
                          //   child: Text("DECLINE"),
                          //   textColor: Colors.red[700],
                          //   color: Colors.transparent,
                          //   onPressed: () {
                          //     Navigator.pop(context);
                          //   },
                          // ),
                          // ignore: deprecated_member_use
                          FlatButton(
                            child: Text("OKay"),
                            textColor: MyColors.primary,
                            color: Colors.transparent,
                            onPressed: () {
                              // bloc1.toStoreCartItems();
                              Navigator.pop(context);
                              if (redirectPage == 'home') {
                                Navigator.pushReplacement(
                                    context,
                                    MaterialPageRoute(
                                        builder: (BuildContext ctx) =>
                                            HomePage()));
                              } else {
                                Navigator.pushReplacement(
                                    context,
                                    MaterialPageRoute(
                                        builder: (BuildContext ctx) =>
                                            LoginPage()));
                              }
                              // SystemChannels.platform
                              //     .invokeMethod('SystemNavigator.pop');
                            },
                          )
                        ],
                      )
                    ],
                  ),
                ),
              ),
            ));
  }
}


