import 'dart:convert';

import 'package:drssiddha/app/model/user_model.dart';
import 'package:shared_preferences/shared_preferences.dart';

class AuthUtils {
  static final String endPoint = '/login/authentication';
  static final String api = 'KvGhsy3ZuSJtzP833dZZhwEy';

  // Keys to store and fetch data from SharedPreferences
  static final String apiKey = 'api_key';
  static final String sessToken = 'sess_token';
  static final String alumnusId = 'alumnus_id';
  static final String name = 'name';
  static final String email = 'email';
  static final String age = 'age';
  static final String gender = 'gender';

  static String getToken(SharedPreferences prefs) {
    return prefs.getString(sessToken)!;
  }

   static read(String key) async {
    final prefs = await SharedPreferences.getInstance();
    return json.decode(prefs.getString(key)!);
  }

  static save(String key, value) async {
    final prefs = await SharedPreferences.getInstance();
    prefs.setString(key, json.encode(value));
    
  }

  static remove(String key) async {
    final prefs = await SharedPreferences.getInstance();
    prefs.remove(key);
  }

  static loadSharedPrefs() async {
    try {
      User user = User.fromJson(await AuthUtils.read("userdata"));
        
        // print(user.firstName);
        if(user != null){
          return user;
        }

        return null;
      // });
    } catch (Excepetion) {
    }
  }

	
}