// import 'package:flutter/material.dart';
// import 'package:shared_preferences/shared_preferences.dart';

// class CartItem {
//   String? id;
//   String? tProductid;
//   String? productTitle;
//   String? img;
//   String? price;
//   String? unitTypeID;
//   String? unitTypeName;
//   int? quantity;

//   CartItem(
//       {this.id,
//       this.tProductid,
//       this.productTitle,
//       this.img,
//       this.price,
//       this.unitTypeID,
//       this.unitTypeName,
//       this.quantity});

//   Map<String, dynamic> toMap() {
//     return {
//       'id': this.id,
//       'tProductid': this.tProductid,
//       'productTitle': this.productTitle,
//       'img': this.img,
//       'price': this.price,
//       'unitTypeID': this.unitTypeID,
//       'unitTypeName': this.unitTypeName,
//       'quantity': this.quantity,
//     };
//   }
// }

// class CartProvider with ChangeNotifier {
//   Map<String, CartItem> _cartItems = {};

//   int totalQuantity = 0;

//   Map<String, CartItem> get cartItems {
//     return _cartItems;
//   }

//   int get itemCount {
//     // ignore: unnecessary_null_comparison
//     return _cartItems == null ? 0 : _cartItems.length;
//   }

//   getQuantity(String _productVId) {
//     if ((_cartItems.containsKey(_productVId))) {
//       print('Prov qty :' + _cartItems[_productVId]!.quantity.toString());
//       return _cartItems[_productVId]!.quantity;
//     }
//     return 1;
//   }

//   int get getTotalQuantity {
//     int totalCount = 0;
//     _cartItems.forEach((itm, v) {
//       totalCount += v.quantity!;
//     });
//     return totalCount;
//   }

//   void addItemSess(
//     String? productViewId,
//     String? productId,
//     String? title,
//     String? img,
//     String? price,
//     String? unitTypeID,
//     String? unitTypeName,
//     String? qty,
//   ) async {
//     if (_cartItems.containsKey(productViewId!)) {
//       // change quantity...
//       _cartItems.update(
//         productViewId,
//         (existingCartItem) => CartItem(
//           id: existingCartItem.id,
//           tProductid: existingCartItem.tProductid,
//           productTitle: existingCartItem.productTitle,
//           img: existingCartItem.img,
//           price: existingCartItem.price,
//           unitTypeID: existingCartItem.unitTypeID,
//           unitTypeName: existingCartItem.unitTypeName,
//           quantity: int.parse(qty!),
//         ),
//       );
//     } else {
//       // print(price);
//       _cartItems.putIfAbsent(
//         productViewId,
//         () => CartItem(
//           id: DateTime.now().toString(),
//           tProductid: productId,
//           productTitle: title,
//           img: img,
//           price: price,
//           unitTypeID: unitTypeID,
//           unitTypeName: unitTypeName,
//           quantity: int.parse(qty!),
//         ),
//       );
//     }
//     notifyListeners();
//   }

//   void addItem(
//     String productViewId,
//     String productid,
//     String title,
//     String img,
//     String unitTypeID,
//     String unitTypeName,
//     String price,
//   ) async {
//     if (_cartItems.containsKey(productViewId)) {
//       // change quantity...
//       _cartItems.update(
//         productViewId,
//         (existingCartItem) => CartItem(
//           id: existingCartItem.id,
//           tProductid: existingCartItem.tProductid,
//           productTitle: existingCartItem.productTitle,
//           img: existingCartItem.img,
//           price: existingCartItem.price,
//           unitTypeID: existingCartItem.unitTypeID,
//           unitTypeName: existingCartItem.unitTypeName,
//           quantity: existingCartItem.quantity! + 1,
//         ),
//       );
//     } else {
//       _cartItems.putIfAbsent(
//         productViewId,
//         () => CartItem(
//           id: DateTime.now().toString(),
//           tProductid: productid,
//           productTitle: title,
//           img: img,
//           price: price,
//           unitTypeID: unitTypeID,
//           unitTypeName: unitTypeName,
//           quantity: 1,
//         ),
//       );
//     }
//     notifyListeners();
//   }

//   void removeItem(String productVId) async {
//     _cartItems.remove(productVId);
//     print("_cartItems length");
//     print(_cartItems.length);
//     print(_cartItems);

//     notifyListeners();
//   }

//   void removeSingleItem(String productVId) async {
//     print(productVId);
//     if (!_cartItems.containsKey(productVId)) {
//       return;
//     }
//     if (_cartItems[productVId]!.quantity! > 1) {
//       _cartItems.update(
//           productVId,
//           (existingCartItem) => CartItem(
//                 id: existingCartItem.id,
//                 tProductid: existingCartItem.tProductid,
//                 productTitle: existingCartItem.productTitle,
//                 price: existingCartItem.price,
//                 img: existingCartItem.img,
//                 unitTypeID: existingCartItem.unitTypeID,
//                 unitTypeName: existingCartItem.unitTypeName,
//                 quantity: existingCartItem.quantity! - 1,
//               ));
//     } else {
//       _cartItems.remove(productVId);
//     }
   
//     notifyListeners();
//   }

//   void clear() async {
//     _cartItems = {};
//     SharedPreferences prefs = await SharedPreferences.getInstance();
//     prefs.remove('cartItems');
//     notifyListeners();
//   }
// }



import 'package:flutter/material.dart';
import 'package:shared_preferences/shared_preferences.dart';

class CartItem {
  String? id;
  String? tProductid;
  String? productTitle;
  String? img;
  String? price;
  String? unitTypeID;
  String? unitTypeName;
  int? quantity;

  CartItem(
      {this.id,
      this.tProductid,
      this.productTitle,
      this.img,
      this.price,
      this.unitTypeID,
      this.unitTypeName,
      this.quantity});

  Map<String, dynamic> toMap() {
    return {
      'id': this.id,
      'tProductid': this.tProductid,
      'productTitle': this.productTitle,
      'img': this.img,
      'price': this.price,
      'unitTypeID': this.unitTypeID,
      'unitTypeName': this.unitTypeName,
      'quantity': this.quantity,
    };
  }
}

class CartProvider with ChangeNotifier {
  Map<String, CartItem> _cartItems = {};

  int totalQuantity = 0;

  Map<String, CartItem> get cartItems {
    return _cartItems;
  }

  int get itemCount {
    // ignore: unnecessary_null_comparison
    return _cartItems == null ? 0 : _cartItems.length;
  }

  getQuantity(String _productVId) {
    if ((_cartItems.containsKey(_productVId))) {
      print('Prov qty :' + _cartItems[_productVId]!.quantity.toString());
      return _cartItems[_productVId]!.quantity;
    }
    return 1;
  }

  int get getTotalQuantity {
    int totalCount = 0;
    _cartItems.forEach((itm, v) {
      totalCount += v.quantity!;
    });
    return totalCount;
  }

  void addItemSess(
    String? productViewId,
    String? productId,
    String? title,
    String? img,
    String? price,
    String? unitTypeID,
    String? unitTypeName,
    String? qty,
  ) async {
    if (_cartItems.containsKey(productViewId)) {
      // change quantity...
      _cartItems.update(
        productViewId!,
        (existingCartItem) => CartItem(
          id: existingCartItem.id,
          tProductid: existingCartItem.tProductid,
          productTitle: existingCartItem.productTitle,
          img: existingCartItem.img,
          price: existingCartItem.price,
          unitTypeID: existingCartItem.unitTypeID,
          unitTypeName: existingCartItem.unitTypeName,
          quantity: int.parse(qty!),
        ),
      );
    } else {
      // print(price);
      _cartItems.putIfAbsent(
        productViewId!,
        () => CartItem(
          id: DateTime.now().toString(),
          tProductid: productId,
          productTitle: title,
          img: img,
          price: price,
          unitTypeID: unitTypeID,
          unitTypeName: unitTypeName,
          quantity: int.parse(qty!),
        ),
      );
    }
    notifyListeners();
  }

  void addItem(
    String productViewId,
    String productid,
    String title,
    String img,
    String unitTypeID,
    String unitTypeName,
    String price,
  ) async {
    if (_cartItems.containsKey(productViewId)) {
      // change quantity...
      _cartItems.update(
        productViewId,
        (existingCartItem) { 
          int qt =existingCartItem.quantity! + 1;
          print(qt);
          return CartItem(
          id: existingCartItem.id,
          tProductid: existingCartItem.tProductid,
          productTitle: existingCartItem.productTitle,
          img: existingCartItem.img,
          price: existingCartItem.price,
          unitTypeID: existingCartItem.unitTypeID,
          unitTypeName: existingCartItem.unitTypeName,
          quantity: qt,
        ); }
      );
      
    } else {
      _cartItems.putIfAbsent(
        productViewId,
        () => CartItem(
          id: DateTime.now().toString(),
          tProductid: productid,
          productTitle: title,
          img: img,
          price: price,
          unitTypeID: unitTypeID,
          unitTypeName: unitTypeName,
          quantity: 1,
        ),
      );
    }
    notifyListeners();
  }

  void removeItem(String productVId) async {
    _cartItems.remove(productVId);
    print("_cartItems length");
    print(_cartItems.length);
    print(_cartItems);

    notifyListeners();
  }

  void removeSingleItem(String productVId) async {
    if (!_cartItems.containsKey(productVId)) {
      return;
    }
    if (_cartItems[productVId]!.quantity! > 1) {
      print(_cartItems[productVId]!.quantity);
      _cartItems.update(
          productVId,
          (existingCartItem) => CartItem(
                id: existingCartItem.id,
                tProductid: existingCartItem.tProductid,
                productTitle: existingCartItem.productTitle,
                price: existingCartItem.price,
                img: existingCartItem.img,
                unitTypeID: existingCartItem.unitTypeID,
                unitTypeName: existingCartItem.unitTypeName,
                quantity: existingCartItem.quantity! - 1,
              ));
    } else {
      _cartItems.remove(productVId);
    }
   
    notifyListeners();
  }

  void clear() async {
    _cartItems = {};
    SharedPreferences prefs = await SharedPreferences.getInstance();
    prefs.remove('cartItems');
    notifyListeners();
  }
}
