import 'dart:convert';

import 'package:drssiddha/app/model/user_model.dart';
import 'package:drssiddha/app/pages/home/home.dart';
import 'package:drssiddha/app/utility/auth_utils.dart';
import 'package:drssiddha/app/utility/network_utils.dart';
import 'package:dio/dio.dart';
import 'package:flutter/foundation.dart';
import 'package:flutter/material.dart';
import 'package:shared_preferences/shared_preferences.dart';



class LoginData {
  String? email;
  String? password;
}

class AuthProvider with ChangeNotifier {
  // String userData;
  User? userData;

  bool get isAuth {
    return userData != null;
  }

  registerUser(BuildContext context, User userReg) async {
    try {
      FormData formData = new FormData.fromMap({
        'post_data': "1",
        'apikey': AuthUtils.api,
        'name': userReg.name,
        'user_name': userReg.userName,
        'user_email': userReg.userEmail,
        'user_phonenumber': userReg.userPhone,
        'user_address': userReg.userAddress,
        'user_landmark': userReg.userlandmark,
        'user_district': userReg.district,
        'user_state': userReg.state,
        'user_country': userReg.country,
        'user_pincode': userReg.pincode,
        'doctor_regno': userReg.doctorRegNo,
        'role_id': userReg.roleId,
      });
      var responseJson =
          await NetworkUtils.insertData('registration.php', formData);
      if (responseJson['result'] == 'success') {
        UserModel _userAllData = UserModel.fromJson(responseJson);
          userData = _userAllData.data;
         AuthUtils.save("userdata", userData);    
        notifyListeners();
        NetworkUtils.alertDlgWithRedirect(context, "Welcome to Dr\'s.Siddha,", responseJson['msg'], 'home');
        // AuthUtils.insertDetails(_sharedPreferences, responseJson['data']);
        // Navigator.pushReplacementNamed(context, '/home');
       
      } if(responseJson['result'] == 'Doctor_success'){
        NetworkUtils.alertDlgWithRedirect(context, "Welcome to Dr\'s.Siddha,", responseJson['msg'], 'login');
      }
      if(responseJson['result'] == 'error') {
        NetworkUtils.alertDlg(context, responseJson['msg']);
      }
    } catch (error) {
      NetworkUtils.alertDlg(context, error.toString());
    }
  }

   

  


  

  Future<Map<String, Object>> getUserData() async {
    final prefs = await SharedPreferences.getInstance();
    
    final extractedUserData =
        json.decode(prefs.getString('userData')!) as Map<String, Object>;
    
    notifyListeners();
    return extractedUserData;
  }

  Future<void> logout() async {
   
    notifyListeners();
    final prefs = await SharedPreferences.getInstance();
    prefs.remove('userData');
  }

  
}
