// import 'dart:async';

// import 'package:drssiddha/app/data/my_colors.dart';
// import 'package:drssiddha/app/pages/cart/cart_page.dart';
// import 'package:drssiddha/app/pages/home/home.dart';
// import 'package:drssiddha/app/utility/network_utils.dart';
// import 'package:flutter/cupertino.dart';
// import 'package:flutter/material.dart';
// import 'package:flutter_webview_plugin/flutter_webview_plugin.dart';

// class Webview extends StatefulWidget {
//   var infoNew, locationNew;
//   Webview(this.infoNew, this.locationNew);
//   @override
//   State<StatefulWidget> createState() {
//     var batchDetailState = new _WebviewState(this.infoNew, this.locationNew);
//     return batchDetailState;
//   }
// }

// class _WebviewState extends State<Webview> {
//   _WebviewState(this.info, this.location);
//   final info;
//   final location;

//   final flutterWebviewPlugin = new FlutterWebviewPlugin();

//   BuildContext? context;
//   StreamSubscription? _onDestroy;
//   StreamSubscription<String>? _onUrlChanged;
//   StreamSubscription<WebViewStateChanged>? _onStateChanged;
//   String? token;
//   var _payURL;
//   var _payURL1, _curURL;

//   @override
//   void dispose() {
//     // Every listener should be canceled, the same should be done with this stream.
//     _onDestroy!.cancel();
//     _onUrlChanged!.cancel();
//     _onStateChanged!.cancel();

//     flutterWebviewPlugin.dispose();
//     super.dispose();
//   }

//   @override
//   void initState() {
//     super.initState();
//     NetworkUtils.checkDataConnectivity(context);
//     flutterWebviewPlugin.close();

//     flutterWebviewPlugin.onStateChanged.listen((state) async {
//       if (state.type == WebViewState.finishLoad) {
//         String script = 'window.addEventListener("click", receiveMessage, false);' +
//             'function receiveMessage(evt) {if (evt.target.className=="btn btn-primary ng-scope") { window.location.href = "' +
//             NetworkUtils.productionHost +
//             'maybankpayment"; }; }';
//         flutterWebviewPlugin.evalJavascript(script);
//       }
//     });

//     _onDestroy = flutterWebviewPlugin.onDestroy.listen((_) {
//       print("destroy");
//       if (_curURL == _payURL) {
//         print("my destroy");
//         Navigator.pushReplacement(context,
//             MaterialPageRoute(builder: (BuildContext ctx) => HomePage()));
//       }
//       if (_curURL == _payURL1) {
//         print("my destroy");
//         Navigator.pushReplacement(context,
//             MaterialPageRoute(builder: (BuildContext ctx) => CartPage()));
//       }
//     });

//     _onStateChanged =
//         flutterWebviewPlugin.onStateChanged.listen((WebViewStateChanged state) {
//       print("onStateChanged: ${state.type} ${state.url}");
//     });

//     _onUrlChanged = flutterWebviewPlugin.onUrlChanged.listen((String url) {
//       if (mounted) {
//         setState(() {
//           print("URL changed: $url");
//           _payURL = NetworkUtils.host + 'payment_success.php';
//           _payURL1 = NetworkUtils.host + 'payment_error.php';
//           _curURL = url;
//           print(_payURL);
//           print(_payURL1);
//           print(_curURL);
//           if (url == _payURL) {
//             print("My Redirect URL: $url");

//             flutterWebviewPlugin.close();
//           }
//           if (url == _payURL1) {
//             print("My Redirect URL: $url");

//             flutterWebviewPlugin.close();
//           }
//         });
//       }
//     });
//   }

//   @override
//   Widget build(BuildContext context) {
//     setState(() => this.context = context);
//     return new MaterialApp(
//       debugShowCheckedModeBanner: false,
//       routes: {
//         "/": (_) => new WebviewScaffold(
//               withJavascript: true,
//               url: location,
//               appBar: AppBar(
//                 automaticallyImplyLeading: true,
//                 backgroundColor: MyColors.primaryValue,
//                 title: Text(
//                   info,
//                   style: TextStyle(fontSize: 16, color: MyColors.primary),
//                 ),
//                 iconTheme: new IconThemeData(color: MyColors.primary),
//                 elevation: 0,
//                 leading: IconButton(
//                   iconSize: 18,
//                   icon: Icon(Icons.arrow_back),
//                   onPressed: () {
//                     // Navigator.pop(context);
//                     Navigator.of(context, rootNavigator: true).pop(context);
//                   },
//                 ),
//               ),
//               withZoom: true,
//               withLocalStorage: true,
//               hidden: true,
//               initialChild: Center(
//                 child: Row(
//                     mainAxisAlignment: MainAxisAlignment.center,
//                     crossAxisAlignment: CrossAxisAlignment.center,
//                     children: [
//                       CircularProgressIndicator(
//                         backgroundColor: MyColors.primary,
//                         valueColor: new AlwaysStoppedAnimation<Color>(
//                             MyColors.primaryValue),
//                       ),
//                       SizedBox(
//                         width: 10,
//                       ),
//                       Text(
//                         "Please Wait....",
//                         style:
//                             TextStyle(color: MyColors.grey_100_, fontSize: 14),
//                       )
//                     ]),
//               ),
//             ),
//       },
//     );
//   }
// }


import 'dart:async';
import 'dart:io';
import 'package:drssiddha/app/data/my_colors.dart';
import 'package:drssiddha/app/pages/cart/cart_page.dart';
import 'package:drssiddha/app/pages/home/home.dart';
import 'package:drssiddha/app/provider/cart_provider.dart';
import 'package:drssiddha/app/utility/network_utils.dart';
import 'package:firebase_analytics/firebase_analytics.dart';
import 'package:flutter/material.dart';
import 'package:provider/provider.dart';
import 'package:webview_flutter/webview_flutter.dart';


class Webview extends StatefulWidget {
  var infoNew,locationNew;
  Webview(this.infoNew,this.locationNew);
	@override
	State<StatefulWidget> createState() {
		var batchDetailState = new _PayviewState(this.infoNew,this.locationNew);
		return batchDetailState;
	}
}

class _PayviewState extends State<Webview> {
  _PayviewState(this.info,this.location);
  final info;
  final location;
  final Completer<WebViewController> _controller =
      Completer<WebViewController>();
  var _payURL;
  var _payURL1,_curURL, _payURL2;

  @override
  void initState() {
    //https://www.almaherbal.com/appapi/thankyou.php
    //https://www.almaherbal.com/appapi/thankyou.php
    _payURL = NetworkUtils.host + 'payment_success.php';
    _payURL1 = NetworkUtils.host + 'payment_error.php';
    // _payURL2 = NetworkUtils.host + '/thankyou_error.php';
    super.initState();
    if (Platform.isAndroid) WebView.platform = SurfaceAndroidWebView();
  }

  _addAnalytics() async {
    final FirebaseAnalytics analytics = FirebaseAnalytics();
    final bloc = Provider.of<CartProvider>(context);
    for(int i = 0; i < bloc.cartItems.length; i++) {                
      analytics.logAddToCart(
        currency: 'INR',
        value: double.parse(bloc.cartItems.values.toList()[i].price!),
        itemId: bloc.cartItems.values.toList()[i].id!,
        itemName: bloc.cartItems.values.toList()[i].productTitle!,
        itemCategory: bloc.cartItems.values.toList()[i].productTitle!,
        quantity: bloc.cartItems.values.toList()[i].quantity!,
        price: double.parse(bloc.cartItems.values.toList()[i].price!),
      ); 
    }
  }
  

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      /* appBar: AppBar(
        backgroundColor: MyColors.primary,
        automaticallyImplyLeading: true,
        child: Icon(Icons.arrow_back_ios, size: 16, color: MyColors.logoGold)),
        title: Text(
          info,
          style: TextStyle(color: MyColors.logoGold, fontSize: 18),
          // style: TextStyle(
          //     fontFamily: "Gotik",
          //     fontSize: 18.0,
          //     color: Colors.black54,
          //     fontWeight: FontWeight.w700),
        ),
        elevation: 0.0,

        //title: Text(info,style: TextStyle(fontSize: 18, color: Colors.indigo[900],),),
          iconTheme: new IconThemeData(color: Colors.indigo[900]),
          //elevation: 0,
          leading: IconButton(
            iconSize: 16,
            icon:Icon(Icons.arrow_back_ios),
          onPressed: () {
            Navigator.pop(context);
          },
        ),
      ), */
      appBar: AppBar(
        // backgroundColor: MyColors.primary,
        iconTheme: IconThemeData(
            color: MyColors.primary,
          ),
        leading: InkWell(
            onTap: () {
              Navigator.pop(context);
            },
            child:
                Icon(Icons.arrow_back_ios, size: 18)),
        title: Text(info, style: TextStyle( fontSize: 18, color: MyColors.primary, fontWeight: FontWeight.bold, letterSpacing: 1.0),
        ),
        elevation: 0.0,
        centerTitle: true,
      ), 
      // We're using a Builder here so we have a context that is below the Scaffold
      // to allow calling Scaffold.of(context) so we can show a snackbar.
      body: Builder(builder: (BuildContext context) {
        return WebView(
          initialUrl: location, //'https://www.almaherbal.com/appapi/invoice.php?order_id=25270',
          javascriptMode: JavascriptMode.unrestricted,
          onWebViewCreated: (WebViewController webViewController) {
            _controller.complete(webViewController);
          },
          onProgress: (int progress) {
            print("WebView is loading (progress : $progress%)");
          },
          javascriptChannels: <JavascriptChannel>{
            _toasterJavascriptChannel(context),
          },
          navigationDelegate: (NavigationRequest request) {
            if (request.url.startsWith('https://www.youtube.com/')) {
              print('blocking navigation to $request}');
              return NavigationDecision.prevent;
            }
            print('allowing navigation to $request');
            return NavigationDecision.navigate;
          },
          onPageStarted: (String url) {
            setState(() {
              _curURL = url;   
            });
            print('Page started loading: $url');
            
            setState(() {
              _curURL = url;              
            });
            print('Page finished loading: $url');
            //https://www.almaherbal.com/appapi/thankyou.php
            if (_curURL == _payURL) {
              print("my destroy");
              print("_addAnalytics");
              // _addAnalytics();
              
              Provider.of<CartProvider>(context, listen: false).clear();              
              Navigator.pushReplacement(
                  context,
                  MaterialPageRoute(
                      builder: (BuildContext ctx) => HomePage()));
            }
            if (_curURL == _payURL1) {
              print("my destroy");
              Navigator.pushReplacement(
                  context,
                  MaterialPageRoute(
                      builder: (BuildContext ctx) => CartPage()));
            } 
            // if (_curURL == _payURL2) {
            //   print("my destroy");
            //   // Provider.of<CartProvider>(context, listen: false).clear();
            //   Navigator.pushReplacement(
            //       context,
            //       MaterialPageRoute(
            //           builder: (BuildContext ctx) => CartPage()));
            // }
            if (_curURL == "https://www.drsiddha.com/") {
              print("my destroy");
              Navigator.pushReplacement(
                  context,
                  MaterialPageRoute(
                      builder: (BuildContext ctx) => CartPage()));
            }

          
          },
          onPageFinished: (String url) {
            setState(() {
              _curURL = url;              
            });
            print('Page finished loading: $url');
            //https://www.almaherbal.com/appapi/thankyou.php
            if (_curURL == _payURL) {
              print("my destroy");
              print("_addAnalytics");
              // _addAnalytics();
              Provider.of<CartProvider>(context, listen: false).clear();              
              Navigator.pushReplacement(
                  context,
                  MaterialPageRoute(
                      builder: (BuildContext ctx) => HomePage()));
            }
            if (_curURL == _payURL1) {
              print("my destroy");
              Navigator.pushReplacement(
                  context,
                  MaterialPageRoute(
                      builder: (BuildContext ctx) => CartPage()));
            } 
            // if (_curURL == _payURL2) {
            //   print("my destroy");
            //   // Provider.of<CartProvider>(context, listen: false).clear();
            //   Navigator.pushReplacement(
            //       context,
            //       MaterialPageRoute(
            //           builder: (BuildContext ctx) => CartPage()));
            // }
            if (_curURL == "https://www.drsiddha.com/") {
              print("my destroy");
              Navigator.pushReplacement(
                  context,
                  MaterialPageRoute(
                      builder: (BuildContext ctx) => CartPage()));
            }

          },
          gestureNavigationEnabled: true,
        );
      }),
     // floatingActionButton: favoriteButton(),
    );
  }

  JavascriptChannel _toasterJavascriptChannel(BuildContext context) {
    return JavascriptChannel(
        name: 'Toaster',
        onMessageReceived: (JavascriptMessage message) {
          // ignore: deprecated_member_use
          Scaffold.of(context).showSnackBar(
            SnackBar(content: Text(message.message)),
          );
        });
  }

  /* Widget favoriteButton() {
    return FutureBuilder<WebViewController>(
        future: _controller.future,
        builder: (BuildContext context,
            AsyncSnapshot<WebViewController> controller) {
          if (controller.hasData) {
            return FloatingActionButton(
              onPressed: () async {
                final String url = (await controller.data!.currentUrl())!;
                // ignore: deprecated_member_use
                Scaffold.of(context).showSnackBar(
                  SnackBar(content: Text('Favorited $url')),
                );
              },
              child: const Icon(Icons.favorite),
            );
          }
          return Container();
        });
  } */
}