import 'package:drssiddha/app/data/my_colors.dart';
import 'package:drssiddha/app/model/user_model.dart';
import 'package:drssiddha/app/pages/profile/profile.dart';
import 'package:drssiddha/app/utility/auth_utils.dart';
import 'package:drssiddha/app/utility/network_utils.dart';
import 'package:drssiddha/app/widget/my_text.dart';
import 'package:dio/dio.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_form_builder/flutter_form_builder.dart';
import 'package:drssiddha/app/widgets/loader.dart';

Pattern pattern =
    r'^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$';

RegExp regex = new RegExp(pattern.toString());

class ProfileEditPage extends StatefulWidget {
  @override
  _ProfileEditPageState createState() => _ProfileEditPageState();
}

class _ProfileEditPageState extends State<ProfileEditPage> {
  final GlobalKey<FormState> _fbKey = GlobalKey<FormState>();
  GlobalKey<ScaffoldState> _scaffoldKey = new GlobalKey<ScaffoldState>();

  final TextEditingController passwordController = new TextEditingController();

  String? member;
  bool enabled = true;
  bool _enableBtn = false;
  bool _load = true;
  User updatedUserData = User();
  User userData = User();

  final focus1 = FocusNode();
  final focus2 = FocusNode();
  final focus3 = FocusNode();
  final focus4 = FocusNode();
  final focus5 = FocusNode();
  final focus6 = FocusNode();
  final focus7 = FocusNode();
  final focus8 = FocusNode();
  final focus9 = FocusNode();
  final focus10 = FocusNode();
  final focus11 = FocusNode();
  final focus12 = FocusNode();
  final focus13 = FocusNode();

  @override
  void initState() {
    super.initState();
    NetworkUtils.checkDataConnectivity(context, 'home');
    _fetchHome();
  }

  _fetchHome() async {
    userData = await AuthUtils.loadSharedPrefs();
    setState(() {
      updatedUserData = userData;
      _load = false;
    });
  }

  void showMessage(String message, [MaterialColor color = Colors.red]) {
    // ignore: deprecated_member_use
    _scaffoldKey.currentState!.showSnackBar(
        new SnackBar(backgroundColor: color, content: new Text(message)));
  }

 

  updateProfile() async {
    setState(() {
      _load = true;
    });

    try {
      FormData formData = new FormData.fromMap({
        'post_data': "1",
        'apikey': AuthUtils.api,
        'user_id': userData.userId,
        'role_id': userData.roleId,
        'name': updatedUserData.name,
        'user_phonenumber': updatedUserData.userPhone,
        'user_email': updatedUserData.userEmail,
        'user_address': updatedUserData.userAddress,
        'user_landmark': updatedUserData.userlandmark,
        'user_district': updatedUserData.district,
        'user_state': updatedUserData.state,
        'user_country': updatedUserData.country,
        'user_pincode': updatedUserData.pincode,
      });
      var responseJson =
          await NetworkUtils.insertData('update_userdata.php', formData);
      if (responseJson['result'] == 'success') {
        UserModel _userAllData = UserModel.fromJson(responseJson);
        userData = _userAllData.data!;
        AuthUtils.save("userdata", userData);
        setState(() {
          _load = false;
        });
        showMessage(responseJson['msg']);

        Navigator.pushReplacement(
            context,
            MaterialPageRoute(
                builder: (BuildContext ctx) => ProfileViewPage()));
      } else {
        NetworkUtils.alertDlg(context, responseJson['msg']);
      }
    } catch (error) {
      NetworkUtils.alertDlg(context, error.toString());
    }
  }

   _returnwillPop() {
    Navigator.of(context).pushReplacement(
        PageRouteBuilder(pageBuilder: (_, __, ___) => ProfileViewPage()));
  }


  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: () async {
        return _returnwillPop();
      },
      child: Scaffold(
        key: _scaffoldKey,
        backgroundColor: Colors.white,
        appBar: AppBar(
          backgroundColor: MyColors.primaryValue,
          centerTitle: true,
          title: Text(
            "Profile Update",
            style: TextStyle(
                letterSpacing: 0.5,
                // fontFamily: "Gotik",
                fontSize: 18.0,
                color: MyColors.primary,
                // fontWeight: FontWeight.w700
                ),
          ),
          leading: InkWell(
              onTap: () {
                Navigator.pushReplacement(
                    context,
                    MaterialPageRoute(
                        builder: (BuildContext ctx) => ProfileViewPage()));
              },
              child: Icon(
                Icons.arrow_back_ios,
                size: 16,
                color: MyColors.primary,
              )),
          elevation: 0.0,
        ),
        body: _load
            ? LoaderWidget()
            : SingleChildScrollView(
                padding: EdgeInsets.all(20),
                scrollDirection: Axis.vertical,
                child: Align(
                  alignment: Alignment.topCenter,
                  child: Container(
                    child: Form(
                      key: _fbKey,
                      onChanged: () {
                        setState(() {
                          _enableBtn = _fbKey.currentState!.validate();
                        });
                      },
                      autovalidateMode: AutovalidateMode.always,
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: <Widget>[
                          Container(height: 15),
                          Align(
                              alignment: Alignment.bottomLeft,
                              child: Text("NAME",
                                  style: MyText.body1(context)!
                                      .copyWith(color: MyColors.grey_60))),
                          Container(height: 5),
                          Card(
                            shape: RoundedRectangleBorder(
                              borderRadius: BorderRadius.circular(3),
                            ),
                            clipBehavior: Clip.antiAliasWithSaveLayer,
                            margin: EdgeInsets.all(0),
                            elevation: 0,
                            child: Padding(
                              padding:
                                  const EdgeInsets.only(top: 0.0, bottom: 0.0),
                              child: Container(
                                alignment: Alignment.centerLeft,
                                padding: EdgeInsets.symmetric(
                                    horizontal: 0, vertical: 0.0),
                                child: FormBuilderTextField(
                                  initialValue: updatedUserData.name,
                                  // onFieldSubmitted: (val) {
                                  //   FocusScope.of(context).requestFocus(focus2);
                                  // },
                                  focusNode: focus1,
                                  name: "Name",
                                  decoration: InputDecoration(
                                    contentPadding: EdgeInsets.symmetric(
                                            horizontal: 10.0, vertical: 0),
                                      hintText: "NAME",
                                      //  labelText: "REGISTER NUMBER",
                                      border: OutlineInputBorder(
                                          borderRadius:
                                              BorderRadius.circular(3.0))),
                                  validator: FormBuilderValidators.compose([
                                FormBuilderValidators.required(context,
                                        errorText: "Name required"),
                                    // FormBuilderValidators.numeric(),
                                    // FormBuilderValidators.max(6),
                                  ]),
                                  onSaved: (value) {
                                    setState(() {
                                      updatedUserData.name = value;
                                    });
                                  },
                                ),
                              ),
                            ),
                          ),
                          Container(height: 15),
                          Align(
                              alignment: Alignment.bottomLeft,
                              child: Text("MOBILE",
                                  style: MyText.body1(context)!
                                      .copyWith(color: MyColors.grey_60))),
                          Container(height: 5),
                          Card(
                            shape: RoundedRectangleBorder(
                              borderRadius: BorderRadius.circular(3),
                            ),
                            clipBehavior: Clip.antiAliasWithSaveLayer,
                            margin: EdgeInsets.all(0),
                            elevation: 0,
                            child: Padding(
                              padding:
                                  const EdgeInsets.only(top: 0.0, bottom: 0.0),
                              child: Container(
                                alignment: Alignment.centerLeft,
                                padding: EdgeInsets.symmetric(
                                    horizontal: 0, vertical: 0.0),
                                child: FormBuilderTextField(
                                  readOnly: true,
                                  initialValue: updatedUserData.userPhone,
                                  keyboardType: TextInputType.number,
                                  // onFieldSubmitted: (val) {
                                  //   FocusScope.of(context).requestFocus(focus3);
                                  // },
                                  focusNode: focus2,
                                  name: "Mobile",
                                  decoration: InputDecoration(
                                     contentPadding: EdgeInsets.symmetric(
                                            horizontal: 10.0, vertical: 0),
                                      hintText: "MOBILE NUMBER",
                                      //  labelText: "REGISTER NUMBER",
                                      border: OutlineInputBorder(
                                          borderRadius:
                                              BorderRadius.circular(3.0))),
                                  validator: FormBuilderValidators.compose([
                                FormBuilderValidators.required(context,
                                        errorText: "Mobile number required"),
                                    FormBuilderValidators.numeric(context),
                                    FormBuilderValidators.minLength(context, 10),
                                    FormBuilderValidators.maxLength(context, 10),
                                  ]),
                                  onSaved: (value) {
                                    setState(() {
                                      updatedUserData.userPhone = value;
                                    });
                                  },
                                ),
                              ),
                            ),
                          ),
                          Container(height: 15),
                          Align(
                              alignment: Alignment.bottomLeft,
                              child: Text("EMAIL",
                                  style: MyText.body1(context)!
                                      .copyWith(color: MyColors.grey_60))),
                          Container(height: 5),
                          Card(
                            shape: RoundedRectangleBorder(
                              borderRadius: BorderRadius.circular(3),
                            ),
                            clipBehavior: Clip.antiAliasWithSaveLayer,
                            margin: EdgeInsets.all(0),
                            elevation: 0,
                            child: Padding(
                              padding:
                                  const EdgeInsets.only(top: 0.0, bottom: 0.0),
                              child: Container(
                                alignment: Alignment.centerLeft,
                                padding: EdgeInsets.symmetric(
                                    horizontal: 0, vertical: 0.0),
                                child: FormBuilderTextField(
                                  
                                  initialValue: updatedUserData.userEmail,
                                  keyboardType: TextInputType.emailAddress,
                                  // onFieldSubmitted: (val) {
                                  //   FocusScope.of(context).requestFocus(focus4);
                                  // },
                                  focusNode: focus3,
                                  name: "Email",
                                  decoration: InputDecoration(
                                     contentPadding: EdgeInsets.symmetric(
                                            horizontal: 10.0, vertical: 0),
                                      hintText: "EMAIL",
                                      //  labelText: "REGISTER NUMBER",
                                      border: OutlineInputBorder(
                                          borderRadius:
                                              BorderRadius.circular(3.0))),
                                  validator: FormBuilderValidators.compose([
                                FormBuilderValidators.required(context,
                                        errorText: "Email required"),
                                    FormBuilderValidators.email(context),
                                    // FormBuilderValidators.max(6),
                                  ]),
                                  onSaved: (value) {
                                    setState(() {
                                      updatedUserData.userEmail = value;
                                    });
                                  },
                                ),
                              ),
                            ),
                          ),
                          Container(height: 15),
                          Align(
                              alignment: Alignment.bottomLeft,
                              child: Text("ADDRESS",
                                  style: MyText.body1(context)!
                                      .copyWith(color: MyColors.grey_60))),
                          Container(height: 5),
                          Card(
                            shape: RoundedRectangleBorder(
                              borderRadius: BorderRadius.circular(3),
                            ),
                            clipBehavior: Clip.antiAliasWithSaveLayer,
                            margin: EdgeInsets.all(0),
                            elevation: 0,
                            child: Padding(
                              padding:
                                  const EdgeInsets.only(top: 0.0, bottom: 0.0),
                              child: Container(
                                alignment: Alignment.centerLeft,
                                padding: EdgeInsets.symmetric(
                                    horizontal: 0, vertical: 0.0),
                                child: FormBuilderTextField(
                                  initialValue: updatedUserData.userAddress,
                                  maxLines: 6,
                                  // onFieldSubmitted: (val) {
                                  //   FocusScope.of(context).requestFocus(focus5);
                                  // },
                                  focusNode: focus4,
                                  name: "address",
                                  decoration: InputDecoration(
                                     contentPadding: EdgeInsets.symmetric(
                                            horizontal: 10.0, vertical: 10),
                                      hintText: "ADDRESS",
                                      //  labelText: "REGISTER NUMBER",
                                      border: OutlineInputBorder(
                                          borderRadius:
                                              BorderRadius.circular(3.0))),
                                  validator: FormBuilderValidators.compose([
                                FormBuilderValidators.required(context,
                                        errorText: "Address required"),
                                    // FormBuilderValidators.numeric(),
                                    // FormBuilderValidators.max(6),
                                  ]),
                                  onSaved: (value) {
                                    setState(() {
                                      updatedUserData.userAddress = value;
                                    });
                                  },
                                ),
                              ),
                            ),
                          ),
                          Container(height: 15),
                          Align(
                              alignment: Alignment.bottomLeft,
                              child: Text("LANDMARK",
                                  style: MyText.body1(context)!
                                      .copyWith(color: MyColors.grey_60))),
                          Container(height: 5),
                          Card(
                            shape: RoundedRectangleBorder(
                              borderRadius: BorderRadius.circular(3),
                            ),
                            clipBehavior: Clip.antiAliasWithSaveLayer,
                            margin: EdgeInsets.all(0),
                            elevation: 0,
                            child: Padding(
                              padding:
                                  const EdgeInsets.only(top: 0.0, bottom: 0.0),
                              child: Container(
                                alignment: Alignment.centerLeft,
                                padding: EdgeInsets.symmetric(
                                    horizontal: 0, vertical: 0.0),
                                child: FormBuilderTextField(
                                  initialValue: updatedUserData.userlandmark,
                                  // onFieldSubmitted: (val) {
                                  //   FocusScope.of(context).requestFocus(focus6);
                                  // },
                                  focusNode: focus5,
                                  name: "Landmark",
                                  decoration: InputDecoration(
                                     contentPadding: EdgeInsets.symmetric(
                                            horizontal: 10.0, vertical: 0),
                                      hintText: "LANDMARK",
                                      //  labelText: "REGISTER NUMBER",
                                      border: OutlineInputBorder(
                                          borderRadius:
                                              BorderRadius.circular(3.0))),
                                  validator: FormBuilderValidators.compose([
                                FormBuilderValidators.required(context,
                                        errorText: "Landmark required"),
                                    // FormBuilderValidators.numeric(),
                                    // FormBuilderValidators.max(6),
                                  ]),
                                  onSaved: (value) {
                                    setState(() {
                                      updatedUserData.userlandmark = value;
                                    });
                                  },
                                ),
                              ),
                            ),
                          ),
                          Container(height: 15),
                          Align(
                              alignment: Alignment.bottomLeft,
                              child: Text("DISTRICT",
                                  style: MyText.body1(context)!
                                      .copyWith(color: MyColors.grey_60))),
                          Container(height: 5),
                          Card(
                            shape: RoundedRectangleBorder(
                              borderRadius: BorderRadius.circular(3),
                            ),
                            clipBehavior: Clip.antiAliasWithSaveLayer,
                            margin: EdgeInsets.all(0),
                            elevation: 0,
                            child: Padding(
                              padding:
                                  const EdgeInsets.only(top: 0.0, bottom: 0.0),
                              child: Container(
                                alignment: Alignment.centerLeft,
                                padding: EdgeInsets.symmetric(
                                    horizontal: 0, vertical: 0.0),
                                child: FormBuilderTextField(
                                  initialValue: updatedUserData.district,
                                  // onFieldSubmitted: (val) {
                                  //   FocusScope.of(context).requestFocus(focus7);
                                  // },
                                  focusNode: focus6,
                                  name: "District",
                                  decoration: InputDecoration(
                                     contentPadding: EdgeInsets.symmetric(
                                            horizontal: 10.0, vertical: 0),
                                      hintText: "DISTRICT",
                                      //  labelText: "REGISTER NUMBER",
                                      border: OutlineInputBorder(
                                          borderRadius:
                                              BorderRadius.circular(3.0))),
                                  validator: FormBuilderValidators.compose([
                                FormBuilderValidators.required(context,),
                                    // FormBuilderValidators.numeric(),
                                    // FormBuilderValidators.max(6),
                                  ]),
                                  onSaved: (value) {
                                    setState(() {
                                      updatedUserData.district = value;
                                    });
                                  },
                                ),
                              ),
                            ),
                          ),
                          Container(height: 15),
                          Align(
                              alignment: Alignment.bottomLeft,
                              child: Text("STATE",
                                  style: MyText.body1(context)!
                                      .copyWith(color: MyColors.grey_60))),
                          Container(height: 5),
                          Card(
                            shape: RoundedRectangleBorder(
                              borderRadius: BorderRadius.circular(3),
                            ),
                            clipBehavior: Clip.antiAliasWithSaveLayer,
                            margin: EdgeInsets.all(0),
                            elevation: 0,
                            child: Padding(
                              padding:
                                  const EdgeInsets.only(top: 0.0, bottom: 0.0),
                              child: Container(
                                alignment: Alignment.centerLeft,
                                padding: EdgeInsets.symmetric(
                                    horizontal: 0, vertical: 0.0),
                                child: FormBuilderTextField(
                                  initialValue: updatedUserData.state,
                                  // onFieldSubmitted: (val) {
                                  //   FocusScope.of(context).requestFocus(focus8);
                                  // },
                                  focusNode: focus7,
                                  name: "State",
                                  decoration: InputDecoration(
                                     contentPadding: EdgeInsets.symmetric(
                                            horizontal: 10.0, vertical: 0),
                                      hintText: "STATE",
                                      //  labelText: "REGISTER NUMBER",
                                      border: OutlineInputBorder(
                                          borderRadius:
                                              BorderRadius.circular(3.0))),
                                  validator: FormBuilderValidators.compose([
                                FormBuilderValidators.required(context,),
                                    // FormBuilderValidators.numeric(),
                                    // FormBuilderValidators.max(6),
                                  ]),
                                  onSaved: (value) {
                                    setState(() {
                                      updatedUserData.state = value;
                                    });
                                  },
                                ),
                              ),
                            ),
                          ),
                          Container(height: 15),
                          Align(
                              alignment: Alignment.bottomLeft,
                              child: Text("COUNTRY",
                                  style: MyText.body1(context)!
                                      .copyWith(color: MyColors.grey_60))),
                          Container(height: 5),
                          Card(
                            shape: RoundedRectangleBorder(
                              borderRadius: BorderRadius.circular(3),
                            ),
                            clipBehavior: Clip.antiAliasWithSaveLayer,
                            margin: EdgeInsets.all(0),
                            elevation: 0,
                            child: Padding(
                              padding:
                                  const EdgeInsets.only(top: 0.0, bottom: 0.0),
                              child: Container(
                                alignment: Alignment.centerLeft,
                                padding: EdgeInsets.symmetric(
                                    horizontal: 0, vertical: 0.0),
                                child: FormBuilderTextField(
                                  initialValue: updatedUserData.country,
                                  // onFieldSubmitted: (val) {
                                  //   FocusScope.of(context).requestFocus(focus9);
                                  // },
                                  focusNode: focus8,
                                  name: "Country",
                                  decoration: InputDecoration(
                                     contentPadding: EdgeInsets.symmetric(
                                            horizontal: 10.0, vertical: 0),
                                      hintText: "COUNTRY",
                                      //  labelText: "REGISTER NUMBER",
                                      border: OutlineInputBorder(
                                          borderRadius:
                                              BorderRadius.circular(3.0))),
                                  validator: FormBuilderValidators.compose([
                                FormBuilderValidators.required(context,),
                                    // FormBuilderValidators.numeric(),
                                    // FormBuilderValidators.max(6),
                                  ]),
                                  onSaved: (value) {
                                    setState(() {
                                      updatedUserData.country = value;
                                    });
                                  },
                                ),
                              ),
                            ),
                          ),
                          Container(height: 15),
                          Align(
                              alignment: Alignment.bottomLeft,
                              child: Text("ZIPCODE",
                                  style: MyText.body1(context)!
                                      .copyWith(color: MyColors.grey_60))),
                          Container(height: 5),
                          Card(
                            shape: RoundedRectangleBorder(
                              borderRadius: BorderRadius.circular(3),
                            ),
                            clipBehavior: Clip.antiAliasWithSaveLayer,
                            margin: EdgeInsets.all(0),
                            elevation: 0,
                            child: Padding(
                              padding:
                                  const EdgeInsets.only(top: 0.0, bottom: 0.0),
                              child: Container(
                                alignment: Alignment.centerLeft,
                                padding: EdgeInsets.symmetric(
                                    horizontal: 0, vertical: 0.0),
                                child: FormBuilderTextField(
                                  initialValue: updatedUserData.pincode,
                                  focusNode: focus9,
                                  name: "Zipcode",
                                  keyboardType: TextInputType.number,
                                  decoration: InputDecoration(
                                     contentPadding: EdgeInsets.symmetric(
                                            horizontal: 10.0, vertical: 0),
                                      hintText: "ZIPCODE",
                                      //  labelText: "REGISTER NUMBER",
                                      border: OutlineInputBorder(
                                          borderRadius:
                                              BorderRadius.circular(3.0))),
                                  validator: FormBuilderValidators.compose([
                                FormBuilderValidators.required(context,
                                        errorText: "Postal code required"),
                                    FormBuilderValidators.numeric(context),
                                    FormBuilderValidators.minLength(context, 6),
                                    FormBuilderValidators.maxLength(context, 6),
                                  ]),
                                  onSaved: (value) {
                                    setState(() {
                                      updatedUserData.pincode = value;
                                    });
                                  },
                                ),
                              ),
                            ),
                          ),
                          Container(height: 30),
                          Container(
                            width: double.infinity,
                            height: 45,
                            child: AbsorbPointer(
                              absorbing: !enabled,
                              // ignore: deprecated_member_use
                              child: FlatButton(
                                child: Text("UPDATE",
                                    style: MyText.subhead(context)!.copyWith(
                                        fontWeight: FontWeight.bold,
                                        color: Colors.white,
                                        letterSpacing: 1.5)),
                                color: MyColors.primary,
                                onPressed: !_enableBtn
                                    ? null
                                    : () {
                                        setState(() {
                                          enabled = false;
                                        });
                                        print(updatedUserData.name);
                                        final FormState form =
                                            _fbKey.currentState!;

                                        if (!form.validate()) {
                                          showMessage(
                                              'Form is not valid!  Please review and correct.');
                                        } else {
                                          form.save(); //This invokes each onSaved event

                                          print("Form Saved Datas:");

                                          form.save(); //This invokes each onSaved event
                                          print(
                                              '========================================');
                                          print('Submitting to back end...');

                                          updateProfile();
                                        }
                                      },
                              ),
                            ),
                          ),
                        ],
                      ),
                    ),
                  ),
                ),
              ),
      ),
    );
  }
}
