import 'package:drssiddha/app/data/my_colors.dart';
import 'package:drssiddha/app/model/user_model.dart';
import 'package:drssiddha/app/pages/home/home.dart';
// import 'package:drssiddha/app/pages/profile/edit_profile';
import 'package:drssiddha/app/pages/profile/profile_edit.dart';
import 'package:drssiddha/app/utility/auth_utils.dart';
import 'package:drssiddha/app/utility/network_utils.dart';
import 'package:drssiddha/app/widget/my_text.dart';
import 'package:flutter/material.dart';

class ProfileViewPage extends StatefulWidget {
  ProfileViewPage();

  @override
  ProfilePolygonRouteState createState() => new ProfilePolygonRouteState();
}

class ProfilePolygonRouteState extends State<ProfileViewPage> {
  User userData = User();
  bool _load = true;
  @override
  void initState() {
    super.initState();
    NetworkUtils.checkDataConnectivity(context, 'home');
    _fetchSessionAndNavigate();
  }

  _fetchSessionAndNavigate() async {
    userData = await AuthUtils.loadSharedPrefs();
    setState(() {
      _load = false;
    });
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      body: NestedScrollView(
        headerSliverBuilder: (BuildContext context, bool innerBoxIsScrolled) {
          return <Widget>[
            SliverAppBar(
              backgroundColor: MyColors.primaryValue,
              expandedHeight: 200.0,
              floating: false,
              pinned: true,
              flexibleSpace: FlexibleSpaceBar(
                background: Image.asset('assets/images/bg_polygon.png',
                    fit: BoxFit.cover),
              ),
              leading: InkWell(
                  onTap: () {
                    Navigator.pushReplacement(
                        context,
                        MaterialPageRoute(
                            builder: (BuildContext ctx) => HomePage()));
                  },
                  child: Icon(Icons.arrow_back_ios,
                      size: 18, color: MyColors.primary)),
              bottom: PreferredSize(
                preferredSize: Size.fromHeight(50),
                child: Container(
                  
                  transform: Matrix4.translationValues(0, 50, 0),
                  child: CircleAvatar(
                    radius: 50,
                    backgroundColor: Colors.grey[200],
                    // backgroundImage: AssetImage('assets/images/About_Drs.png'),
                    child: Image.asset('assets/images/About_Drs.png', width: 50, height: 50,),
                  ),
                ),
              ),
            ),
          ];
        },
        body: SingleChildScrollView(
          child: Container(
            padding: EdgeInsets.symmetric(horizontal: 20),
            child: Column(
              children: <Widget>[
                Container(height: 70),
                Text(userData.name!,
                    style: MyText.headline(context)!.copyWith(
                        color: Colors.grey[900],
                        fontWeight: FontWeight.normal)),
                Container(height: 5),
                Text(userData.roleId == '1' ? 'Doctor' : 'Customer',
                    textAlign: TextAlign.center,
                    style: MyText.subhead(context)!
                        .copyWith(color: Colors.grey[900])),
                userData.roleId == '1' ? Container(height: 5) : Container(),
                userData.roleId == '1'
                    ? Text(userData.roleId! == '1' ? userData.doctorRegNo! : '',
                        textAlign: TextAlign.center,
                        style: MyText.subhead(context)!
                            .copyWith(color: Colors.grey[900]))
                    : Container(),
                Container(height: 5),
                Text(userData.userEmail!,
                    textAlign: TextAlign.center,
                    style: MyText.subhead(context)!
                        .copyWith(color: Colors.grey[900])),
                Container(height: 15),
                Divider(
                  thickness: 0.5,
                ),
                Container(height: 25),
                Row(
                  children: <Widget>[
                    Container(width: 20),
                    Expanded(
                      flex: 1,
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: <Widget>[
                          Text("Phone",
                              style: MyText.title(context)!.copyWith(
                                  fontSize: 16,
                                  color: MyColors.grey_60,
                                  fontWeight: FontWeight.normal)),
                          Container(height: 5),
                          Text(userData.userPhone!,
                              style: MyText.subhead(context)!.copyWith(
                                color: MyColors.grey_100_,
                              ))
                        ],
                      ),
                    ),
                    Expanded(
                      flex: 1,
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: <Widget>[
                          Text("Location",
                              style: MyText.title(context)!.copyWith(
                                  fontSize: 16,
                                  color: MyColors.grey_60,
                                  fontWeight: FontWeight.normal)),
                          Container(height: 5),
                          Text(userData.country!,
                              style: MyText.subhead(context)!.copyWith(
                                color: MyColors.grey_100_,
                              ))
                        ],
                      ),
                    ),
                    Container(width: 20)
                  ],
                ),
                Container(height: 20),
                Row(
                  children: <Widget>[
                    Container(width: 20),
                    Expanded(
                      flex: 1,
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: <Widget>[
                          Text("Address",
                              style: MyText.title(context)!.copyWith(
                                  fontSize: 16,
                                  color: MyColors.grey_60,
                                  fontWeight: FontWeight.normal)),
                          Container(height: 5),
                          Text(userData.userAddress!,
                              style: MyText.subhead(context)!.copyWith(
                                color: MyColors.grey_100_,
                              )),
                          Container(height: 5),
                          Text(userData.userlandmark!,
                              style: MyText.subhead(context)!.copyWith(
                                color: MyColors.grey_100_,
                              )),
                          Container(height: 5),
                          Text(userData.district!,
                              style: MyText.subhead(context)!.copyWith(
                                color: MyColors.grey_100_,
                              )),
                              Container(height: 5),
                          Text(userData.state!,
                              style: MyText.subhead(context)!.copyWith(
                                color: MyColors.grey_100_,
                              )),
                          Container(height: 5),
                          Text(userData.pincode!,
                              style: MyText.subhead(context)!.copyWith(
                                color: MyColors.grey_100_,
                              ))
                        ],
                      ),
                    ),
                  ],
                ),
                Container(height: 50),
              ],
            ),
          ),
        ),
      ),
      floatingActionButton: FloatingActionButton(
        backgroundColor: MyColors.primaryValue,
        child: Icon(Icons.edit, color: MyColors.primary),
        onPressed: () {
          Navigator.pushReplacement(
              context,
              MaterialPageRoute(
                  builder: (BuildContext ctx) => ProfileEditPage()));
        },
      ),
    );
  }
}
