import 'package:drssiddha/app/data/my_colors.dart';
import 'package:drssiddha/app/pages/products/category_products_material.dart';
import 'package:simple_autocomplete_formfield/simple_autocomplete_formfield.dart';
import 'package:drssiddha/app/model/material_type_products_model.dart';
import 'package:drssiddha/app/pages/cart/cart_page.dart';
import 'package:drssiddha/app/pages/home/home.dart';
import 'package:drssiddha/app/pages/products/product_detail.dart';
import 'package:drssiddha/app/provider/cart_provider.dart';
import 'package:drssiddha/app/utility/network_utils.dart';
import 'package:drssiddha/app/widget/my_text.dart';
import 'package:drssiddha/app/widgets/badge.dart';
import 'package:drssiddha/app/widgets/loader.dart';
import 'package:dio/dio.dart';
import 'package:flutter/material.dart';
import 'package:provider/provider.dart';
import 'package:drssiddha/app/utility/auth_utils.dart';
import 'package:drssiddha/app/pages/products/product_category.dart';

class SearchProductPage extends StatefulWidget {
  @override
  _SearchProductPageState createState() => _SearchProductPageState();
}

class _SearchProductPageState extends State<SearchProductPage> {
  GlobalKey<ScaffoldState> _scaffoldKey = new GlobalKey<ScaffoldState>();
  TextEditingController _searchController = TextEditingController();

  List<String> _searchItems = [];

  int quantity = 0;
  bool _load = true;
  String searchText = '';
  @override
  void initState() {
    super.initState();
    NetworkUtils.checkDataConnectivity(context, 'home');
    _searchController.addListener(() {
      searchText1 = _searchController.text;
    });
    fetchHome();
  }

  // List _searchKeys = [];
  List<MaterialProduct>? _productsInfo;
  String? searchText1;

  void fetchHome() async {
    try {
      FormData formData = new FormData.fromMap({
        'post_data': "1",
        'apikey': AuthUtils.api,
      });
      var responseJson =
          await NetworkUtils.insertData('product_keyword.php', formData);
      if (responseJson['result'] == 'success') {
        setState(() {
          _searchItems = responseJson['data'].cast<String>();
        });
        print(_searchItems);
        _load = false;
      } else {
        setState(() {
          _load = false;
        });
        NetworkUtils.alertDlg(context, responseJson['msg']);
      }
    } catch (e) {
      setState(() {
        _load = false;
      });
      NetworkUtils.alertDlg(context, e.toString());

      print('Server Exception!!!');
      print(e);
      return null;
    }
  }

  void searchProduct(_searchText) async {
    setState(() {
      _productsInfo = [];
      _load = true;
    });
    try {
      FormData formData = new FormData.fromMap(
          {'post_data': "1", 'apikey': AuthUtils.api, 'keyword': _searchText});
      var responseJson =
          await NetworkUtils.insertData('search_product.php', formData);
      if (responseJson['result'] == 'success') {
        MaterialProductsModel _allSearchProducts =
            MaterialProductsModel.fromJson(responseJson);

        setState(() {
          _productsInfo = _allSearchProducts.data;
          print(_productsInfo!.length);
          _load = false;
        });
      } else {
        setState(() {
          _load = false;
        });
        NetworkUtils.alertDlg(context, responseJson['msg']);
      }
    } catch (e) {
      setState(() {
        _load = false;
      });
      // NetworkUtils.alertDlg(context, e.toString());

      print('Server Exception!!!');
      print(e);
      return null;
    }
  }

   _returnwillPop() {
    Navigator.of(context).pushReplacement(
        PageRouteBuilder(pageBuilder: (_, __, ___) => HomePage()));
  }


  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: () async {
        return _returnwillPop();
      },
      child: Scaffold(
          backgroundColor: Colors.white,
          key: _scaffoldKey,
          appBar: AppBar(
            backgroundColor: MyColors.primaryValue,
            iconTheme: IconThemeData(color: MyColors.primary),
            leading: InkWell(
                onTap: () {
                  Navigator.pushReplacement(
                      context,
                      MaterialPageRoute(
                          builder: (BuildContext ctx) =>
                              ProductsCategoryPage()));
                },
                child: Icon(Icons.arrow_back_ios, size: 16)),
            title: Text(
              'Search',
              style: TextStyle(fontSize: 18, color: MyColors.primary),
            ),
            // centerTitle: true,
            elevation: 0,
            actions: <Widget>[
              Consumer<CartProvider>(
                builder: (_, cart, ch) => Badge(
                  child: ch!,
                  value: cart.getTotalQuantity.toString(),
                  color: MyColors.logobody,
                ),
                child: Consumer<CartProvider>(
                  builder: (_, cart, ch) {
                    return cart.getTotalQuantity > 0
                        ? Padding(
                            padding: const EdgeInsets.only(right: 20.0),
                            child: IconButton(
                              icon: Icon(
                                Icons.shopping_cart,
                                size: 30,
                                color: MyColors.primary,
                              ),
                              onPressed: () {
                                Navigator.pushReplacement(
                                    context,
                                    MaterialPageRoute(
                                        builder: (BuildContext ctx) =>
                                            CartPage()));
                              },
                            ),
                          )
                        : Container();
                  },
                ),
              )
            ],
          ),
          body: SingleChildScrollView(
            child: Container(
              color: Colors.white,
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                mainAxisAlignment: MainAxisAlignment.start,
                children: <Widget>[
                  Padding(
                    padding: const EdgeInsets.all(10.0),
                    child: Card(
                      shape: RoundedRectangleBorder(
                        borderRadius: BorderRadius.circular(5),
                      ),
                      clipBehavior: Clip.antiAliasWithSaveLayer,
                      // height: 70.0,
                      elevation: 4.0,
                      child: Container(
                        padding: EdgeInsets.all(8.0),
                        width: MediaQuery.of(context).size.width,
                        child: Row(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          mainAxisAlignment: MainAxisAlignment.start,
                          children: [
                            Padding(
                              padding:
                                  const EdgeInsets.fromLTRB(0.0, 0.0, 0.0, 0.0),
                              child: Container(
                                // height: 70.0,
                                width: MediaQuery.of(context).size.width - 100,
                                child: Padding(
                                  padding: const EdgeInsets.all(0.0),
                                  child: SimpleAutocompleteFormField<String>(
                                    // initialValue: ,
                                    controller: _searchController,
                                    maxSuggestions: 10,
                                    decoration: InputDecoration(
                                        labelText: 'Search product',
                                        border: UnderlineInputBorder()),
                                    suggestionsHeight: 100.0,
                                    itemBuilder: (context, sproduct) => Padding(
                                      padding: EdgeInsets.all(8.0),
                                      child: Column(
                                          crossAxisAlignment:
                                              CrossAxisAlignment.start,
                                          children: [
                                            Text(sproduct!,
                                                style: TextStyle(
                                                    fontWeight:
                                                        FontWeight.bold)),
                                            // Text(person.address)
                                          ]),
                                    ),
                                    onSearch: (search) async => _searchItems
                                        .where((sproduct) => sproduct
                                            .toLowerCase()
                                            .contains(search.toLowerCase()))
                                        .toList(),

                                    itemFromString: (string) =>
                                        _searchItems.singleWhere(
                                            (item) =>
                                                item.toLowerCase() ==
                                                string.toLowerCase(),
                                            // ignore: null_check_always_fails
                                            orElse: () => null!),
                                    onChanged: (value) {
                                      setState(() {
                                        searchText = value!;
                                        print(searchText);
                                        // selectedProduct = value;

                                        if (searchText.isNotEmpty) {
                                          searchProduct(searchText);
                                        }
                                      });
                                    },
                                  ),
                                ),
                              ),
                            ),
                            SizedBox(width: 5.0),
                            Align(
                              alignment: Alignment.topCenter,
                              child: GestureDetector(
                                onTap: () {
                                  _productsInfo = [];
                                  setState(() {
                                    searchText1 = _searchController.text;
                                  });
                                  print(searchText1);
                                  if (searchText1!.isNotEmpty) {
                                    searchProduct(searchText1);
                                  }

                                  FocusScope.of(context)
                                      .requestFocus(new FocusNode());
                                },
                                child: Container(
                                  decoration: BoxDecoration(
                                    color: MyColors.primaryValue,
                                    borderRadius:
                                        BorderRadius.all(Radius.circular(10.0)),
                                  ),
                                  height: 50.0,
                                  width: 50.0,
                                  child: Padding(
                                    padding: const EdgeInsets.all(5.0),
                                    child: Icon(
                                      Icons.search,
                                      color: MyColors.primary,
                                    ),
                                  ),
                                ),
                              ),
                            ),
                          ],
                        ),
                      ),
                    ),
                  ),

                  _load
                      ? LoaderWidget()
                      : Scrollbar(
                          child: _productsInfo == null
                              ? Center(child: Container())
                              : Container(
                                  child: ListView.builder(
                                      physics: NeverScrollableScrollPhysics(),
                                      shrinkWrap: true,
                                      padding: EdgeInsets.symmetric(
                                          horizontal: 10.0, vertical: 10.0),
                                      itemCount: _productsInfo!.length,
                                      // Product product = _productsInfo[index];
                                      itemBuilder:
                                          (BuildContext context, index) {
                                        return itemGrid(
                                            context, _productsInfo![index]);
                                      }),
                                )),
                  // ),
                ],
              ),
            ),
          )),
    );
  }

  Widget itemGrid(context, MaterialProduct product) {
    // final cart = Provider.of<CartProvider>(context, listen: false);
    // quantity = cart.getQuantity(product.productId);
    return InkWell(
      onTap: () {
        Navigator.of(context).push(PageRouteBuilder(
            pageBuilder: (_, __, ___) => new ProductDetail(product)));
      },
      child: Padding(
        padding: const EdgeInsets.only(top: 0.0, bottom: 14.0),
        child: Container(
          decoration: BoxDecoration(
              color: Colors.white,
              borderRadius: BorderRadius.all(Radius.circular(10.0)),
              boxShadow: [
                BoxShadow(
                  color: Color(0xFF656565).withOpacity(0.15),
                  blurRadius: 4.0,
                  spreadRadius: 1.0,
//           offset: Offset(4.0, 10.0)
                )
              ]),
          child: Wrap(
            children: <Widget>[
              Row(
                crossAxisAlignment: CrossAxisAlignment.start,
                // mainAxisAlignment: MainAxisAlignment.spaceBetween,
                // mainAxisSize: MainAxisSize.min,
                children: <Widget>[
                  /// Set Animation image to detailProduk layout
                  Material(
                    child: GestureDetector(
                      onTap: () async {
                        await showDialog(
                            context: context,
                            builder: (_) => ImageDialog(product.imageLink));
                      },
                      child: Stack(
                        children: <Widget>[
                          Align(
                            alignment: Alignment.center,
                            child: Container(
                              height: 150.0,
                              width: 120.0,
                              // MediaQuery.of(context).size.width / 3.0,
                              decoration: BoxDecoration(
                                  color: Colors.white,
                                  borderRadius: BorderRadius.only(
                                      topLeft: Radius.circular(7.0),
                                      topRight: Radius.circular(7.0)),
                                  image: DecorationImage(
                                      image: NetworkImage(product.imageLink!),
                                      fit: BoxFit.cover)),
                            ),
                          ),
                        ],
                      ),
                    ),
                  ),
                  Container(
                    height: 150,
                    // color: Colors.green,
                    width: MediaQuery.of(context).size.width - 150,
                    child: Padding(
                      padding: const EdgeInsets.only(
                          left: 8.0, right: 0.0, top: 5.0),
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        mainAxisAlignment: MainAxisAlignment.start,
                        children: <Widget>[
                          // Padding(padding: EdgeInsets.only(top: 7.0)),
                          Container(
                            child: Text(
                              product.productName == null
                                  ? ' '
                                  : product.productName!,
                              overflow: TextOverflow.ellipsis,
                              maxLines: 3,
                              // textAlign: TextAlign.justify,
                              style: MyText.headline(context)!.copyWith(
                                  color: MyColors.titleTextColor,
                                  letterSpacing: 0.5,
                                  fontSize: 16.0,
                                  fontWeight: FontWeight.bold),
                            ),
                          ),
                          Divider(
                            height: 1.0,
                          ),
                          SizedBox(height: 5.0),
                          Container(
                            child: Text(
                                product.indication == null
                                    ? ' '
                                    : product.indication!,
                                maxLines: 4,
                                // textAlign: TextAlign.left,
                                // customTextAlign: _alignFn(),
                                style: MyText.subhead(context)!.copyWith(
                                    color: MyColors.allTextColor,
                                    letterSpacing: 0.5,
                                    fontSize: 15.0)),
                          ),
                          Expanded(child: SizedBox(height: 10.0)),
                          Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              product.productPackage!.isEmpty
                                  ? Container()
                                  : Align(
                                      alignment: Alignment.bottomCenter,
                                      child: Row(
                                        crossAxisAlignment:
                                            CrossAxisAlignment.end,
                                        mainAxisAlignment:
                                            MainAxisAlignment.spaceBetween,
                                        children: <Widget>[
                                          Center(
                                            child: Text(
                                              product.productPackage![0]
                                                          .typeName ==
                                                      null
                                                  ? ' '
                                                  : product.productPackage![0]
                                                      .typeName!,
                                              style: TextStyle(
                                                  // fontFamily: "Sans",
                                                  color: MyColors.grey_90,
                                                  fontWeight: FontWeight.w800,
                                                  fontSize: 16.0),
                                            ),
                                          ),
                                          Padding(
                                            padding: const EdgeInsets.only(
                                                right: 10.0),
                                            child: Text(
                                              '₹ ' +
                                                  product
                                                      .productPackage![0].price!,
                                              style: TextStyle(
                                                  // fontFamily: "Sans",
                                                  fontWeight: FontWeight.w800,
                                                  fontSize: 16.0),
                                            ),
                                          ),
                                        ],
                                      ),
                                    ),
                              SizedBox(height: 5.0),
                            ],
                          ),
                        ],
                      ),
                    ),
                  ),
                ],
              ),
            ],
          ),
        ),
      ),
    );
  }
}
