import 'package:drssiddha/app/data/my_colors.dart';
import 'package:drssiddha/app/model/material_type_products_model.dart';
import 'package:drssiddha/app/pages/products/product_detail.dart';
import 'package:drssiddha/app/model/user_model.dart';
import 'package:drssiddha/app/pages/cart/cart_page.dart';
import 'package:drssiddha/app/provider/cart_provider.dart';
import 'package:drssiddha/app/utility/auth_utils.dart';
import 'package:drssiddha/app/utility/network_utils.dart';
import 'package:drssiddha/app/widget/my_text.dart';
import 'package:drssiddha/app/widgets/badge.dart';
import 'package:drssiddha/app/widgets/loader.dart';
import 'package:dio/dio.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:provider/provider.dart';
import 'package:flutter_html/flutter_html.dart';
// import 'package:html/parser.dart' show parse;

class ProductIngredientsPage extends StatefulWidget {
  final MaterialProduct product;
  ProductIngredientsPage(this.product);
  @override
  _ProductIngredientsState createState() =>
      _ProductIngredientsState(this.product);
}

class _ProductIngredientsState extends State<ProductIngredientsPage> {
  final MaterialProduct product;
  _ProductIngredientsState(this.product);
  GlobalKey<ScaffoldState> _scaffoldKey = new GlobalKey<ScaffoldState>();
  TextEditingController _qtyControl = TextEditingController();

  int quantity = 1;
  bool _load = false;
  CartItem tempCartItem = CartItem();
  User userData = User();
  ProductPackage? _currentSelectedValue;
  String? price;
  String? unitTypeID;
  String? unitTypeName;
  int stockQty = 0;

  @override
  void initState() {
    super.initState();
     getInitialData();
    NetworkUtils.checkDataConnectivity(context, 'home');
    // print(prodId);
    _fetchHome();
  }

   _clearItems() {
    setState(() {
      _qtyControl.clear();
      price = null;
      unitTypeID = null;
      unitTypeName = null;
      tempCartItem = CartItem();
      stockQty = 0;
      _currentSelectedValue = ProductPackage();
    });
  }

  getInitialData() {
    // setState(() {
      _currentSelectedValue = product.productPackage![0];
      price = _currentSelectedValue!.price;
      unitTypeID = _currentSelectedValue!.typeId;
      stockQty = int.parse(_currentSelectedValue!.stockQty!);
      unitTypeName = _currentSelectedValue!.typeName;
      WidgetsBinding.instance!.addPostFrameCallback((timeStamp) {
        final bloc = Provider.of<CartProvider>(context, listen: false);
        quantity = bloc.getQuantity(product.productId! + '-' + unitTypeID!);
        print('quantity.toString()');
        print(quantity.toString());
        _qtyControl.text = quantity.toString();
      });
      tempCartItem.id = product.productId!;
      tempCartItem.quantity = quantity;
      tempCartItem.price = price;
      tempCartItem.unitTypeID = unitTypeID;
    // });
  }

  _fetchHome() async {
    userData = await AuthUtils.loadSharedPrefs();

    setState(() {
      _load = false;
    });
  }

  addTOCart() async {
    setState(() {
      _load = true;
    });
    try {
      FormData formData = new FormData.fromMap({
        'post_data': "1",
        'apikey': AuthUtils.api,
        'user_id': userData.userId,
        'role_id': userData.roleId,
        'device_id': 0,
        'product_id': tempCartItem.id,
        'quantity': tempCartItem.quantity,
        'price': tempCartItem.price,
        'unittype_id': tempCartItem.unitTypeID,
      });
      var responseJson =
          await NetworkUtils.insertData('temp_cart.php', formData);
      if (responseJson['result'] == 'success') {
        // final prefs = await SharedPreferences.getInstance();
        // UserModel _userAllData = UserModel.fromJson(responseJson);
        //   userData = _userAllData.data;
        //  AuthUtils.save("userdata", userData);

        NetworkUtils.alertDlg(context, responseJson['msg']);
        // Navigator.pushReplacement(context,
        //           MaterialPageRoute(builder: (BuildContext ctx) => HomePage()));
        // AuthUtils.insertDetails(_sharedPreferences, responseJson['data']);
        // Navigator.pushReplacementNamed(context, '/home');

      } else {
        NetworkUtils.alertDlg(context, responseJson['msg']);
      }
    } catch (error) {
      // NetworkUtils.alertDlg(context, error.toString());
    }
    setState(() {
      _load = false;
    });
  }

  // String _parseHtmlString(_responseText) {
  //   var document = parse(_responseText);
  //   String parsedString = parse(document.body.text).documentElement.text;
  //   return parsedString;
  // }

  @override
  Widget build(BuildContext context) {
    final bloc = Provider.of<CartProvider>(context);
    return _load
        ? LoaderWidget()
        : Scaffold(
            // resizeToAvoidBottomInset: false,
            // resizeToAvoidBottomPadding: false,
            backgroundColor: Colors.white,
            key: _scaffoldKey,
            appBar: AppBar(
              backgroundColor: MyColors.appBarColor,
              iconTheme: IconThemeData(color: MyColors.appBarTextColor),
              leading: InkWell(
                  onTap: () {
                    // Navigator.of(context).pop();
                    Navigator.pushReplacement(
                        context,
                        MaterialPageRoute(
                            builder: (BuildContext ctx) =>
                                ProductDetail(product)));
                  },
                  child: Icon(
                    Icons.arrow_back_ios,
                    size: 16,
                    color: MyColors.appBarTextColor,
                  )),
              title: Text(
                product.productName!,
                style: TextStyle(
                    letterSpacing: 1.0,
                    color: MyColors.appBarTextColor,
                    fontSize: 18,
                    fontWeight: FontWeight.normal),
              ),
              centerTitle: true,
              elevation: 0,
              actions: <Widget>[
                Consumer<CartProvider>(
                  builder: (_, cart, ch) => Badge(
                    child: ch!,
                    value: cart.getTotalQuantity.toString(),
                    color: MyColors.logobody,
                  ),
                  child: Consumer<CartProvider>(
                    builder: (_, cart, ch) {
                      return cart.getTotalQuantity > 0
                          ? Padding(
                              padding: const EdgeInsets.only(right: 5.0),
                              child: IconButton(
                                icon: Icon(
                                  Icons.shopping_cart,
                                  size: 30,
                                  color: MyColors.appBarTextColor,
                                ),
                                onPressed: () {
                                  Navigator.pushReplacement(
                                      context,
                                      MaterialPageRoute(
                                          builder: (BuildContext ctx) =>
                                              CartPage()));
                                  // Navigator.of(context).pushNamed(CartPage.routeName);
                                },
                              ),
                            )
                          : Container();
                    },
                  ),
                )
              ],
            ),

            // drawer: new DrawerMenu(),
            body: Stack(
              children: <Widget>[
                Container(
                  height: MediaQuery.of(context).size.height - 90,
                  color: Colors.white,
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    mainAxisAlignment: MainAxisAlignment.start,
                    children: <Widget>[
                      Row(
                        children: <Widget>[
                          Container(
                            width: MediaQuery.of(context).size.width,
                            color: Colors.grey[200],
                            child: Padding(
                              padding: const EdgeInsets.all(5.0),
                              child: Text(
                                'Ingredients',
                                textAlign: TextAlign.center,
                                style: MyText.subhead(context)!.copyWith(
                                    color: MyColors.titleTextColor,
                                    fontWeight: FontWeight.normal,
                                    // fontSize: 16.0,
                                    letterSpacing: 1.0),
                              ),
                            ),
                          ),
                        ],
                      ),

                      // Divider(
                      //   color: Colors.black,
                      //   height: 1.0,
                      // ),
                      Padding(
                        padding: const EdgeInsets.only(top: 0.0),
                        child: Container(
                          // height: 205.0,
                          // width: 600.0,
                          decoration:
                              BoxDecoration(color: Colors.white, boxShadow: [
                            BoxShadow(
                              color: Color(0xFF656565).withOpacity(0.15),
                              blurRadius: 1.0,
                              spreadRadius: 0.2,
                            )
                          ]),
                          child: Padding(
                            padding: EdgeInsets.only(top: 0.0),
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: <Widget>[
                                Align(
                                  alignment: Alignment.topLeft,
                                  child: Column(
                                    mainAxisAlignment: MainAxisAlignment.start,
                                    crossAxisAlignment:
                                        CrossAxisAlignment.start,
                                    children: [
                                      Container(
                                        color: MyColors.subTitleTextColor,
                                        child: Row(
                                          children: [
                                            Container(
                                              color: MyColors.subTitleTextColor,
                                              width: MediaQuery.of(context)
                                                      .size
                                                      .width /
                                                  4,
                                              child: Padding(
                                                padding: const EdgeInsets.only(
                                                    top: 5.0,
                                                    right: 5.0,
                                                    bottom: 5.0,
                                                    left: 5.0),
                                                child: Text(
                                                  'Sanskrit Name',
                                                  textAlign: TextAlign.center,
                                                  style: MyText.subhead(context)!
                                                      .copyWith(
                                                          color: Colors.white,
                                                          fontSize: 13.0),
                                                ),
                                              ),
                                            ),
                                            Container(
                                              color: MyColors.subTitleTextColor,
                                              width: MediaQuery.of(context)
                                                      .size
                                                      .width /
                                                  4,
                                              child: Padding(
                                                padding: const EdgeInsets.only(
                                                    top: 5.0,
                                                    right: 5.0,
                                                    bottom: 5.0,
                                                    left: 5.0),
                                                child: Text(
                                                  'Botonical Name',
                                                  textAlign: TextAlign.center,
                                                  style: MyText.subhead(context)!
                                                      .copyWith(
                                                          color: Colors.white,
                                                          fontSize: 13.0),
                                                ),
                                              ),
                                            ),
                                            Container(
                                              color: MyColors.subTitleTextColor,
                                              width: MediaQuery.of(context)
                                                      .size
                                                      .width /
                                                  4,
                                              child: Padding(
                                                padding: const EdgeInsets.only(
                                                    top: 5.0,
                                                    right: 5.0,
                                                    bottom: 5.0,
                                                    left: 5.0),
                                                child: Text(
                                                  'Part Used',
                                                  textAlign: TextAlign.center,
                                                  style: MyText.subhead(context)!
                                                      .copyWith(
                                                          color: Colors.white,
                                                          fontSize: 13.0),
                                                ),
                                              ),
                                            ),
                                            Container(
                                              color: MyColors.subTitleTextColor,
                                              width: MediaQuery.of(context)
                                                      .size
                                                      .width /
                                                  4,
                                              child: Padding(
                                                padding: const EdgeInsets.only(
                                                    top: 5.0,
                                                    right: 5.0,
                                                    bottom: 5.0,
                                                    left: 5.0),
                                                child: Text(
                                                  '%',
                                                  textAlign: TextAlign.center,
                                                  style: MyText.subhead(context)!
                                                      .copyWith(
                                                          color: Colors.white,
                                                          fontSize: 13.0),
                                                ),
                                              ),
                                            ),
                                          ],
                                        ),
                                      ),
                                      Container(
                                        height:
                                            MediaQuery.of(context).size.height -
                                                300,
                                        width:
                                            MediaQuery.of(context).size.width,
                                        child: ListView.builder(
                                            shrinkWrap: true,
                                            itemCount: product
                                                        .productIngredients!
                                                        // ignore: unnecessary_null_comparison
                                                        .length ==
                                                    null
                                                ? 0
                                                : product
                                                    .productIngredients!.length,
                                            physics: ScrollPhysics(),
                                            itemBuilder:
                                                (BuildContext context, index) {
                                              return Row(
                                                children: [
                                                  Container(
                                                    width:
                                                        MediaQuery.of(context)
                                                                .size
                                                                .width /
                                                            4,
                                                    child: Padding(
                                                      padding:
                                                          const EdgeInsets.only(
                                                              top: 5.0,
                                                              right: 5.0,
                                                              bottom: 5.0,
                                                              left: 5.0),
                                                      child: Html(
                                                        data: product
                                                                    .productIngredients![
                                                                        index]
                                                                    .sanskritName ==
                                                                null
                                                            ? ''
                                                            : product
                                                                .productIngredients![
                                                                    index]
                                                                .sanskritName,
                                                        // defaultTextStyle: MyText
                                                        //         .subhead(
                                                        //             context)!
                                                        //     .copyWith(
                                                        //         color: MyColors
                                                        //             .allTextColor,
                                                        //         fontSize: 13.0),
                                                      ),
                                                    ),
                                                  ),
                                                  Container(
                                                    width:
                                                        MediaQuery.of(context)
                                                                .size
                                                                .width /
                                                            4,
                                                    child: Padding(
                                                      padding:
                                                          const EdgeInsets.only(
                                                              top: 5.0,
                                                              right: 5.0,
                                                              bottom: 5.0,
                                                              left: 5.0),
                                                      child: Html(
                                                        data: product
                                                                    .productIngredients![
                                                                        index]
                                                                    .botanicalName ==
                                                                null
                                                            ? ''
                                                            : product
                                                                .productIngredients![
                                                                    index]
                                                                .botanicalName,
                                                        // defaultTextStyle: MyText
                                                        //         .subhead(
                                                        //             context)!
                                                        //     .copyWith(
                                                        //         color: MyColors
                                                        //             .allTextColor,
                                                        //         fontSize: 13.0),
                                                      ),
                                                    ),
                                                  ),
                                                  Container(
                                                    width:
                                                        MediaQuery.of(context)
                                                                .size
                                                                .width /
                                                            4,
                                                    child: Padding(
                                                      padding:
                                                          const EdgeInsets.only(
                                                              top: 5.0,
                                                              right: 5.0,
                                                              bottom: 5.0,
                                                              left: 5.0),
                                                      child: Html(
                                                        data: product
                                                                    .productIngredients![
                                                                        index]
                                                                    .partUsed ==
                                                                null
                                                            ? ''
                                                            : product
                                                                .productIngredients![
                                                                    index]
                                                                .partUsed,
                                                        // defaultTextStyle: MyText
                                                        //         .subhead(
                                                        //             context)!
                                                        //     .copyWith(
                                                        //         color: MyColors
                                                        //             .allTextColor,
                                                        //         fontSize: 13.0),
                                                      ),
                                                    ),
                                                  ),
                                                  Container(
                                                    width:
                                                        MediaQuery.of(context)
                                                                .size
                                                                .width /
                                                            4,
                                                    child: Padding(
                                                      padding:
                                                          const EdgeInsets.only(
                                                              top: 5.0,
                                                              right: 5.0,
                                                              bottom: 5.0,
                                                              left: 5.0),
                                                      child: Text(
                                                        product
                                                                    .productIngredients![
                                                                        index]
                                                                    .ingredientsQuantity ==
                                                                null
                                                            ? ''
                                                            : product
                                                                .productIngredients![
                                                                    index]
                                                                .ingredientsQuantity!,
                                                        textAlign:
                                                            TextAlign.center,
                                                        style: MyText.subhead(
                                                                context)!
                                                            .copyWith(
                                                                color: MyColors
                                                                    .allTextColor,
                                                                fontSize: 13.0),
                                                      ),
                                                    ),
                                                  ),
                                                ],
                                              );
                                            }),
                                      ),
                                    ],
                                  ),
                                ),
                                SizedBox(height: 20),
                              ],
                            ),
                          ),
                        ),
                      ),
                    ],
                  ),
                ),
                Positioned(
                  bottom: 0,
                  left: 0,
                  right: 0,
                  child: Container(
                    height: 140.0,
                    color: Colors.grey[200],
                    padding: EdgeInsets.all(5.0),
                    child: Align(
                      alignment: Alignment.topLeft,
                      child: Column(
                        mainAxisAlignment: MainAxisAlignment.start,
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                         Container(
                                color: Colors.grey[200],
                                padding: EdgeInsets.all(10.0),
                                child: Align(
                                  alignment: Alignment.topLeft,
                                  child: Column(
                                    mainAxisAlignment: MainAxisAlignment.start,
                                    crossAxisAlignment:
                                        CrossAxisAlignment.start,
                                    children: [
                                      Row(
                                        mainAxisAlignment:
                                            MainAxisAlignment.spaceBetween,
                                        children: [
                                          Column(
                                            children: [
                                              Padding(
                                                padding: const EdgeInsets.only(
                                                    top: 10.0,
                                                    right: 0.0,
                                                    bottom: 5.0,
                                                    left: 0.0),
                                                child: Container(
                                                  child: Text('Package :',
                                                      textAlign: TextAlign.left,
                                                      style: MyText.subhead(
                                                              context)!
                                                          .copyWith(
                                                              color: MyColors
                                                                  .subTitleTextBlackColor)),
                                                ),
                                              ),
                                              Padding(
                                                padding: const EdgeInsets.only(
                                                    top: 0.0,
                                                    right: 0.0,
                                                    bottom: 0.0,
                                                    left: 10.0),
                                                child: Container(
                                                  width: MediaQuery.of(context)
                                                              .size
                                                              .width /
                                                          4 +
                                                      10,
                                                  height: 30,
                                                  decoration: BoxDecoration(
                                                      color: Colors.white,
                                                      borderRadius:
                                                          BorderRadius.all(
                                                        Radius.circular(0.0),
                                                      ),
                                                      border: Border.all(
                                                          color: Colors.grey)),
                                                  padding: EdgeInsets.only(
                                                      left: 10.0,
                                                      top: 0.0,
                                                      bottom: 0.0,
                                                      right: 5.0),
                                                  child: Card(
                                                    shape:
                                                        RoundedRectangleBorder(
                                                      borderRadius:
                                                          BorderRadius.circular(
                                                              3),
                                                    ),
                                                    clipBehavior: Clip
                                                        .antiAliasWithSaveLayer,
                                                    margin: EdgeInsets.all(0),
                                                    elevation: 0,
                                                    child: Container(
                                                      width: 70,
                                                      color: Colors.white,
                                                      // height: 60,
                                                      alignment:
                                                          Alignment.centerLeft,
                                                      padding:
                                                          EdgeInsets.symmetric(
                                                              horizontal: 0),
                                                      child:
                                                          DropdownButtonHideUnderline(
                                                        child: DropdownButton<
                                                            ProductPackage>(
                                                          hint: Text('Select',
                                                              style: TextStyle(
                                                                  fontSize:
                                                                      11)),
                                                          isExpanded: true,
                                                          value:
                                                              _currentSelectedValue,
                                                          isDense: true,
                                                          onChanged:
                                                              (newValue) {
                                                            // _clearItems();
                                                            setState(() {
                                                              _currentSelectedValue =
                                                                  newValue!;
                                                              price = newValue
                                                                  .price!;
                                                              unitTypeID =
                                                                  newValue
                                                                      .typeId!;
                                                              unitTypeName =
                                                                  newValue
                                                                      .typeName!;
                                                              print(unitTypeID);
                                                              stockQty = int
                                                                  .parse(newValue
                                                                      .stockQty!);

                                                              tempCartItem.id =
                                                                  newValue
                                                                      .productId!;
                                                              tempCartItem
                                                                  .quantity = 1;
                                                              tempCartItem
                                                                      .unitTypeID =
                                                                  newValue
                                                                      .typeId!;
                                                              tempCartItem
                                                                      .unitTypeName =
                                                                  newValue
                                                                      .typeName!;
                                                              tempCartItem
                                                                      .price =
                                                                  price!;

                                                              print(price);
                                                              // print('product.productId');
                                                              // print(product.productId);
                                                              quantity = bloc
                                                                  .getQuantity(product
                                                                          .productId! +
                                                                      '-' +
                                                                      unitTypeID!);
                                                              // if (quantity >
                                                              //     1) {
                                                              _qtyControl.text =
                                                                  quantity
                                                                      .toString();
                                                              // } else {
                                                              //   _qtyControl
                                                              //       .text = '1';
                                                              //   quantity = 1;
                                                              // }

                                                              // print('quantity');
                                                              // print('quantity : ' + quantity.toString());
                                                            });
                                                          },
                                                          items: product
                                                              .productPackage!
                                                              .map((value) {
                                                            return DropdownMenuItem<
                                                                ProductPackage>(
                                                              value: value,
                                                              child: Text(
                                                                  // ignore: unnecessary_null_comparison
                                                                  value.typeName! !=
                                                                          null
                                                                      ? value
                                                                          .typeName!
                                                                      : ""),
                                                            );
                                                          }).toList(),
                                                        ),
                                                      ),
                                                    ),
                                                  ),
                                                ),
                                              ),
                                            ],
                                          ),
                                          SizedBox(width: 10.0),
                                          Column(
                                            children: [
                                              Padding(
                                                padding: const EdgeInsets.only(
                                                    top: 10.0,
                                                    right: 0.0,
                                                    bottom: 5.0,
                                                    left: 0.0),
                                                child: Container(
                                                  child: Text('Price :',
                                                      textAlign: TextAlign.left,
                                                      style: MyText.subhead(
                                                              context)!
                                                          .copyWith(
                                                              color: MyColors
                                                                  .subTitleTextBlackColor)),
                                                ),
                                              ),
                                              Container(
                                                height: 30,
                                                width: MediaQuery.of(context)
                                                            .size
                                                            .width /
                                                        4 -
                                                    20,
                                                decoration: BoxDecoration(
                                                  // color: Colors.white,
                                                  borderRadius:
                                                      BorderRadius.all(
                                                    Radius.circular(0.0),
                                                  ),
                                                  // border: Border.all(
                                                  //     color: Colors.grey)
                                                ),
                                                child: Padding(
                                                  padding:
                                                      const EdgeInsets.only(
                                                          top: 0.0,
                                                          right: 5.0,
                                                          bottom: 0.0,
                                                          left: 5.0),
                                                  child: Align(
                                                    alignment: Alignment.center,
                                                    child: Padding(
                                                      padding:
                                                          const EdgeInsets.all(
                                                              4.0),
                                                      child: Text(
                                                        price == null
                                                            ? ' '
                                                            : '₹ ' + price!,
                                                        style: MyText.title(
                                                                context)!
                                                            .copyWith(
                                                                color: MyColors
                                                                    .grey_100_,
                                                                fontSize: 16.0),
                                                      ),
                                                    ),
                                                  ),
                                                ),
                                              ),
                                            ],
                                          ),
                                          SizedBox(width: 10.0),
                                          Column(
                                            children: [
                                              Padding(
                                                padding: const EdgeInsets.only(
                                                    top: 10.0,
                                                    right: 0.0,
                                                    bottom: 5.0,
                                                    left: 0.0),
                                                child: Container(
                                                  child: Text('Qty :',
                                                      textAlign: TextAlign.left,
                                                      style: MyText.subhead(
                                                              context)!
                                                          .copyWith(
                                                              color: MyColors
                                                                  .subTitleTextBlackColor)),
                                                ),
                                              ),
                                              Container(
                                                height: 30,
                                                width: MediaQuery.of(context)
                                                            .size
                                                            .width /
                                                        4 -
                                                    40,
                                                decoration: BoxDecoration(
                                                    color: Colors.white,
                                                    borderRadius:
                                                        BorderRadius.all(
                                                      Radius.circular(0.0),
                                                    ),
                                                    border: Border.all(
                                                        color: Colors.grey)),
                                                child: Padding(
                                                  padding:
                                                      const EdgeInsets.only(
                                                          top: 5.0,
                                                          right: 0.0,
                                                          bottom: 0.0,
                                                          left: 0.0),
                                                  child: Card(
                                                    shape:
                                                        RoundedRectangleBorder(
                                                      borderRadius:
                                                          BorderRadius.circular(
                                                              3),
                                                    ),
                                                    clipBehavior: Clip
                                                        .antiAliasWithSaveLayer,
                                                    margin: EdgeInsets.all(0),
                                                    elevation: 0,
                                                    child: Container(
                                                      // color: Colors.grey[200],
                                                      alignment:
                                                          Alignment.centerLeft,
                                                      padding:
                                                          EdgeInsets.symmetric(
                                                              horizontal: 0),
                                                      child: TextFormField(
                                                        // initialValue:
                                                        //     quantity.toString(),
                                                        controller: _qtyControl,
                                                        validator: (value) {
                                                          if (value!.isEmpty) {
                                                            return 'Qty required';
                                                          }
                                                          // if (!(regex.hasMatch(value))) {
                                                          //   return 'Invalid Email';
                                                          // }
                                                          return null;
                                                        },
                                                        keyboardType:
                                                            TextInputType
                                                                .number,
                                                        textAlign:
                                                            TextAlign.center,
                                                        style: TextStyle(
                                                            color: MyColors
                                                                .grey_100_,
                                                            fontWeight:
                                                                FontWeight
                                                                    .bold),
                                                        decoration:
                                                            InputDecoration(
                                                          isDense: true,
                                                          contentPadding:
                                                              EdgeInsets.only(
                                                                  top: 7,
                                                                  bottom: 7,
                                                                  left: 0,
                                                                  right: 0),
                                                          labelText: "",
                                                          labelStyle: TextStyle(
                                                            letterSpacing: 0.5,
                                                            color: MyColors
                                                                .grey_60,
                                                          ),
                                                          enabledBorder:
                                                              UnderlineInputBorder(
                                                            borderSide:
                                                                BorderSide(
                                                                    color: Colors
                                                                        .black,
                                                                    width: 2),
                                                          ),
                                                          focusedBorder:
                                                              UnderlineInputBorder(
                                                            borderSide:
                                                                BorderSide(
                                                                    color: Colors
                                                                        .black,
                                                                    width: 2),
                                                          ),
                                                        ),
                                                        onChanged: (value) {
                                                          setState(() {
                                                            quantity =
                                                                int.parse(
                                                                    value);
                                                          });
                                                        },
                                                      ),
                                                    ),
                                                  ),
                                                ),
                                              ),
                                            ],
                                          ),
                                          SizedBox(
                                            width: 10.0,
                                          ),
                                          Align(
                                            alignment: Alignment.center,
                                            child: Padding(
                                              padding: const EdgeInsets.only(
                                                  top: 10.0),
                                              child: Container(
                                                width: MediaQuery.of(context)
                                                            .size
                                                            .width /
                                                        4 -
                                                    20,
                                                child:
                                                    // price != null &&
                                                    //         unitTypeID != null &&
                                                    //         quantity > 0
                                                    //     ?
                                                    // ignore: deprecated_member_use
                                                    RaisedButton(
                                                  padding: EdgeInsets.all(5.0),
                                                  onPressed: quantity > 0
                                                      ? () {
                                                          if (stockQty <
                                                              quantity) {
                                                            NetworkUtils.alertDlg(
                                                                context,
                                                                'Stock is not available');
                                                            _clearItems();
                                                            getInitialData();
                                                          } else {
                                                            bloc.addItemSess(
                                                                product.productId! +
                                                                    '-' +
                                                                    unitTypeID!,
                                                                product
                                                                    .productId!,
                                                                product
                                                                    .productName!,
                                                                product
                                                                    .imageLink!,
                                                                price!,
                                                                unitTypeID!,
                                                                unitTypeName!,
                                                                quantity
                                                                    .toString());

                                                            setState(() {
                                                              tempCartItem
                                                                      .quantity =
                                                                  quantity;
                                                            });
                                                            print(
                                                                'tempCartItem.quantity');
                                                            print(tempCartItem
                                                                .quantity);
                                                            addTOCart();
                                                            _clearItems();
                                                            getInitialData();
                                                           
                                                          }
                                                        }
                                                      : null,
                                                  color: MyColors.buttonBGColor,
                                                  child: Text(
                                                    'Add to Cart',
                                                    textAlign: TextAlign.center,
                                                    style: MyText
                                                            .subhead(context)!
                                                        .copyWith(
                                                            color: MyColors
                                                                .buttonTextColor,
                                                            fontWeight:
                                                                FontWeight.bold,
                                                            letterSpacing: 0.5,
                                                            fontSize: 12.0),
                                                  ),
                                                ),
                                                // : Container(),
                                              ),
                                            ),
                                          )
                                        ],
                                      ),
                                    ],
                                  ),
                                ),
                              ),
                          SizedBox(height: 5.0),
                          Container(
                                width: MediaQuery.of(context).size.width,
                                color: MyColors.subTitleTextColor,
                                child: 
                                     Padding(
                                        padding: const EdgeInsets.all(5.0),
                                        child: Text(
                                          'Available Quantity' ' - ' +
                                              stockQty.toString(),
                                          textAlign: TextAlign.center,
                                          style: MyText.subtitle(context)!
                                              .copyWith(
                                                  color: Colors.white,
                                                  fontWeight: FontWeight.normal,
                                                  fontSize: 12.0,
                                                  letterSpacing: 1.0),
                                        ),
                                      )
                                   
                          ),
                        ],
                      ),
                    ),
                  ),
                )
              ],
            ),
          );
  }
}
