import 'package:drssiddha/app/data/my_colors.dart';
import 'package:drssiddha/app/model/material_type_products_model.dart';
import 'package:drssiddha/app/pages/products/product_ingredients.dart';

import 'package:drssiddha/app/model/user_model.dart';
import 'package:drssiddha/app/pages/cart/cart_page.dart';
import 'package:drssiddha/app/provider/cart_provider.dart';
import 'package:drssiddha/app/utility/auth_utils.dart';
import 'package:drssiddha/app/utility/network_utils.dart';
import 'package:drssiddha/app/widget/my_text.dart';
import 'package:drssiddha/app/widgets/badge.dart';
import 'package:drssiddha/app/widgets/loader.dart';
import 'package:dio/dio.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:provider/provider.dart';
import 'package:flutter_html/flutter_html.dart';
import 'package:html/parser.dart' show parse;

class ProductDetail extends StatefulWidget {
  final MaterialProduct product;
  ProductDetail(this.product);
  @override
  _ProductDetailState createState() => _ProductDetailState(this.product);
}

class _ProductDetailState extends State<ProductDetail> {
  final MaterialProduct product;
  _ProductDetailState(this.product);
  GlobalKey<ScaffoldState> _scaffoldKey = new GlobalKey<ScaffoldState>();
  TextEditingController _qtyControl = TextEditingController();

  int quantity = 1;
  bool _load = true;
  CartItem tempCartItem = CartItem();
  User userData = User();
  ProductPackage? _currentSelectedValue;
  String? price;
  String? unitTypeID;
  String? unitTypeName;
  int stockQty = 0;

  @override
  void initState() {
    super.initState();
    getInitialData();
    NetworkUtils.checkDataConnectivity(context, 'home');
    _fetchHome();
  }

  _clearItems() {
    setState(() {
      _qtyControl.clear();
      price = null;
      unitTypeID = null;
      unitTypeName = null;
      tempCartItem = CartItem();
      stockQty = 0;
      _currentSelectedValue = ProductPackage();
    });
  }

  getInitialData() {
    // setState(() {
      _currentSelectedValue = product.productPackage![0];
      price = _currentSelectedValue!.price;
      unitTypeID = _currentSelectedValue!.typeId;
      stockQty = int.parse(_currentSelectedValue!.stockQty!);
      unitTypeName = _currentSelectedValue!.typeName;
      WidgetsBinding.instance!.addPostFrameCallback((timeStamp) {
        final bloc = Provider.of<CartProvider>(context, listen: false);
        quantity = bloc.getQuantity(product.productId! + '-' + unitTypeID!);
        print('quantity.toString()');
        print(quantity.toString());
        _qtyControl.text = quantity.toString();
      });
      tempCartItem.id = product.productId!;
      tempCartItem.quantity = quantity;
      tempCartItem.price = price;
      tempCartItem.unitTypeID = unitTypeID;
    // });
  }

  _fetchHome() async {
    userData = await AuthUtils.loadSharedPrefs();

    setState(() {
      _load = false;
    });
  }

  addTOCart() async {
    print('tempCart');
    print(tempCartItem.id);
    print(tempCartItem.quantity);
    print(tempCartItem.price);
    print(tempCartItem.unitTypeID);
    setState(() {
      _load = true;
    });
    try {
      FormData formData = new FormData.fromMap({
        'post_data': "1",
        'apikey': AuthUtils.api,
        'user_id': userData.userId,
        'role_id': userData.roleId,
        'device_id': 0,
        'product_id': tempCartItem.id,
        'quantity': tempCartItem.quantity,
        'price': tempCartItem.price,
        'unittype_id': tempCartItem.unitTypeID,
      });
      var responseJson =
          await NetworkUtils.insertData('temp_cart.php', formData);
      if (responseJson['result'] == 'success') {
        // final prefs = await SharedPreferences.getInstance();
        // UserModel _userAllData = UserModel.fromJson(responseJson);
        //   userData = _userAllData.data;
        //  AuthUtils.save("userdata", userData);

        NetworkUtils.alertDlg(context, responseJson['msg']);
        // Navigator.pushReplacement(context,
        //           MaterialPageRoute(builder: (BuildContext ctx) => HomePage()));
        // AuthUtils.insertDetails(_sharedPreferences, responseJson['data']);
        // Navigator.pushReplacementNamed(context, '/home');

      } else {
        NetworkUtils.alertDlg(context, responseJson['msg']);
      }
    } catch (error) {
      NetworkUtils.alertDlg(context, error.toString());
    }
    setState(() {
      _load = false;
    });
  }

  // void fetchHome(prodId) async {
  //   try {
  //     FormData formData =
  //         new FormData.fromMap({'post_data': "1", 'product_id': prodId});
  //     var responseJson =
  //         await NetworkUtils.insertData('/product_detail.php', formData);
  //     if (responseJson['result'] == 'success') {
  //       ProductModel productData = ProductModel.fromJson(responseJson);
  //       //  print(_allMaster);

  //       setState(() {
  //         // print(responseJson['data']);
  //         // print(_states);
  //         product = productData.data;
  //         // print(product);
  //         // _products = _productsInfo[0];
  //         // print(_productsInfo[0].categoryName);
  //         _load = false;
  //       });
  //     } else {
  //       setState(() {
  //         _load = false;
  //       });
  //       NetworkUtils.alertDlg(context, responseJson['msg']);
  //     }
  //   } catch (e) {
  //     setState(() {
  //       _load = false;
  //     });
  //     NetworkUtils.alertDlg(context, e.toString());

  //     print('Server Exception!!!');
  //     print(e);
  //     return null;
  //   }
  // }

  // _convertNetworkImages() {
  //   imagesNetwork = [];
  //   for (var i = 0; i < product.images.length; i++) {
  //     imagesNetwork.add(NetworkImage(product.images[i]));
  //     // print(imagesNetwork);
  //   }

  //   return imagesNetwork;
  // }

  String _parseHtmlString(_responseText) {
    var document = parse(_responseText);
    String parsedString = parse(document.body!.text).documentElement!.text;
    return parsedString;
  }

//  _imagesListView() {
//     List<NetworkImage> result = [];
//     for (var i = 0; i < images.length; i++) {
//       // NetworkImage(images(i));
//       result.add(NetworkImage(images[i]));
//       print(result[i]);
//     }
//     return result;
//   }

  @override
  Widget build(BuildContext context) {
    // final productId =
    //     ModalRoute.of(context).settings.arguments as String; // is the id!
    final bloc = Provider.of<CartProvider>(context);
    return _load
        ? LoaderWidget()
        : Scaffold(
            backgroundColor: Colors.white,
            key: _scaffoldKey,
            appBar: AppBar(
              backgroundColor: MyColors.appBarColor,
              iconTheme: IconThemeData(color: MyColors.appBarTextColor),
              // title: Image.asset("assets/images/logo-small.png", fit: BoxFit.cover),
              leading: InkWell(
                  onTap: () {
                    Navigator.of(context).pop();
                    // Navigator.pushReplacement(
                    //     context,
                    //     MaterialPageRoute(
                    //         builder: (BuildContext ctx) => AllProductsListPage()));
                  },
                  child: Icon(
                    Icons.arrow_back_ios,
                    size: 16,
                    color: MyColors.appBarTextColor,
                  )),
              title: Text(
                product.productName!,
                style: TextStyle(
                    letterSpacing: 0.5,
                    color: MyColors.appBarTextColor,
                    fontSize: 18,
                    fontWeight: FontWeight.normal),
              ),
              centerTitle: true,
              elevation: 0,
              actions: <Widget>[
                Consumer<CartProvider>(
                  builder: (_, cart, ch) => Badge(
                    child: ch!,
                    value: cart.getTotalQuantity.toString(),
                    color: MyColors.logobody,
                  ),
                  child: Consumer<CartProvider>(
                    builder: (_, cart, ch) {
                      return cart.getTotalQuantity > 0
                          ? Padding(
                              padding: const EdgeInsets.only(right: 5.0),
                              child: IconButton(
                                icon: Icon(
                                  Icons.shopping_cart,
                                  size: 30,
                                  color: MyColors.appBarTextColor,
                                ),
                                onPressed: () {
                                  Navigator.pushReplacement(
                                      context,
                                      MaterialPageRoute(
                                          builder: (BuildContext ctx) =>
                                              CartPage()));
                                  // Navigator.of(context).pushNamed(CartPage.routeName);
                                },
                              ),
                            )
                          : Container();
                    },
                  ),
                )
              ],
            ),
            // drawer: new DrawerMenu(),
            body: SingleChildScrollView(
              child: Container(
                color: Colors.white,
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  mainAxisAlignment: MainAxisAlignment.start,
                  children: <Widget>[
                    // SizedBox(
                    //   height: 10.0,
                    // ),
                    Align(
                      alignment: Alignment.center,
                      child: Container(
                        color: MyColors.imageBGColor,
                        height: MediaQuery.of(context).size.height / 3,
                        width: MediaQuery.of(context).size.width,
                        child: Image.network(
                          product.imageLink!,
                          fit: BoxFit.contain,
                        ),
                      ),
                    ),

                    Row(
                      children: <Widget>[
                        Padding(
                          padding: const EdgeInsets.only(
                              top: 15.0, right: 20.0, bottom: 10.0, left: 20.0),
                          child: Text(
                            product.productName!,
                            style: MyText.headline(context)!.copyWith(
                                color: MyColors.titleTextColor,
                                // fontWeight: FontWeight.bold,
                                fontSize: 18.0,
                                letterSpacing: 1.0),
                          ),
                        ),
                      ],
                    ),

                    // Divider(
                    //   color: Colors.black,
                    //   height: 1.0,
                    // ),
                    Padding(
                      padding: const EdgeInsets.only(top: 0.0),
                      child: Container(
                        // height: 205.0,
                        // width: 600.0,
                        decoration:
                            BoxDecoration(color: Colors.white, boxShadow: [
                          BoxShadow(
                            color: Color(0xFF656565).withOpacity(0.15),
                            blurRadius: 1.0,
                            spreadRadius: 0.2,
                          )
                        ]),
                        child: Padding(
                          padding: EdgeInsets.only(top: 0.0),
                          child: Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: <Widget>[
                              Row(
                                mainAxisAlignment:
                                    MainAxisAlignment.spaceBetween,
                                children: [
                                  Padding(
                                    padding: const EdgeInsets.only(
                                        top: 0.0,
                                        right: 0.0,
                                        bottom: 0.0,
                                        left: 20.0),
                                    child: Text(
                                        _parseHtmlString(product.productType),
                                        textAlign: TextAlign.justify,
                                        style: MyText.subhead(context)!.copyWith(
                                            color: MyColors.subTitleTextColor)),
                                  ),
                                  product.productIngredients?.isEmpty ?? true
                                      ? Container()
                                      : InkWell(
                                          onTap: () {
                                            Navigator.pushReplacement(
                                                context,
                                                MaterialPageRoute(
                                                    builder: (BuildContext
                                                            ctx) =>
                                                        ProductIngredientsPage(
                                                            product)));
                                          },
                                          child: Padding(
                                            padding: const EdgeInsets.only(
                                                top: 0.0,
                                                right: 10.0,
                                                bottom: 0.0,
                                                left: 0.0),
                                            child: Text("View Ingredients > ",
                                                textAlign: TextAlign.justify,
                                                style: MyText.subhead(context)!
                                                    .copyWith(
                                                        color: MyColors
                                                            .allTextColor,
                                                        fontSize: 13.0,
                                                        letterSpacing: 0.5)),
                                          ),
                                        ),
                                ],
                              ),
                              Container(
                                color: Colors.grey[200],
                                padding: EdgeInsets.all(10.0),
                                child: Align(
                                  alignment: Alignment.topLeft,
                                  child: Column(
                                    mainAxisAlignment: MainAxisAlignment.start,
                                    crossAxisAlignment:
                                        CrossAxisAlignment.start,
                                    children: [
                                      Row(
                                        mainAxisAlignment:
                                            MainAxisAlignment.spaceBetween,
                                        children: [
                                          Column(
                                            children: [
                                              Padding(
                                                padding: const EdgeInsets.only(
                                                    top: 10.0,
                                                    right: 0.0,
                                                    bottom: 5.0,
                                                    left: 0.0),
                                                child: Container(
                                                  child: Text('Package :',
                                                      textAlign: TextAlign.left,
                                                      style: MyText.subhead(
                                                              context)!
                                                          .copyWith(
                                                              color: MyColors
                                                                  .subTitleTextBlackColor)),
                                                ),
                                              ),
                                              Padding(
                                                padding: const EdgeInsets.only(
                                                    top: 0.0,
                                                    right: 0.0,
                                                    bottom: 0.0,
                                                    left: 10.0),
                                                child: Container(
                                                  width: MediaQuery.of(context)
                                                              .size
                                                              .width /
                                                          4 +
                                                      10,
                                                  height: 30,
                                                  decoration: BoxDecoration(
                                                      color: Colors.white,
                                                      borderRadius:
                                                          BorderRadius.all(
                                                        Radius.circular(0.0),
                                                      ),
                                                      border: Border.all(
                                                          color: Colors.grey)),
                                                  padding: EdgeInsets.only(
                                                      left: 10.0,
                                                      top: 0.0,
                                                      bottom: 0.0,
                                                      right: 5.0),
                                                  child: Card(
                                                    shape:
                                                        RoundedRectangleBorder(
                                                      borderRadius:
                                                          BorderRadius.circular(
                                                              3),
                                                    ),
                                                    clipBehavior: Clip
                                                        .antiAliasWithSaveLayer,
                                                    margin: EdgeInsets.all(0),
                                                    elevation: 0,
                                                    child: Container(
                                                      width: 70,
                                                      color: Colors.white,
                                                      // height: 60,
                                                      alignment:
                                                          Alignment.centerLeft,
                                                      padding:
                                                          EdgeInsets.symmetric(
                                                              horizontal: 0),
                                                      child:
                                                          DropdownButtonHideUnderline(
                                                        child: DropdownButton<
                                                            ProductPackage>(
                                                          hint: Text('Select',
                                                              style: TextStyle(
                                                                  fontSize:
                                                                      11)),
                                                          isExpanded: true,
                                                          value:
                                                              _currentSelectedValue,
                                                          isDense: true,
                                                          onChanged:
                                                              (newValue) {
                                                            // _clearItems();
                                                            setState(() {
                                                              _currentSelectedValue =
                                                                  newValue!;
                                                              price = newValue
                                                                  .price;
                                                              unitTypeID =
                                                                  newValue
                                                                      .typeId;
                                                              unitTypeName =
                                                                  newValue
                                                                      .typeName;
                                                              print(unitTypeID);
                                                              stockQty = int
                                                                  .parse(newValue
                                                                      .stockQty!);

                                                              tempCartItem.id =
                                                                  newValue
                                                                      .productId!;
                                                              tempCartItem
                                                                  .quantity = 1;
                                                              tempCartItem
                                                                      .unitTypeID =
                                                                  newValue
                                                                      .typeId!;
                                                              tempCartItem
                                                                      .unitTypeName =
                                                                  newValue
                                                                      .typeName!;
                                                              tempCartItem
                                                                      .price =
                                                                  price!;

                                                              print(price);
                                                              // print('product.productId');
                                                              // print(product.productId);
                                                              quantity = bloc
                                                                  .getQuantity(product
                                                                          .productId! +
                                                                      '-' +
                                                                      unitTypeID!);
                                                              // if (quantity >
                                                              //     1) {
                                                              _qtyControl.text =
                                                                  quantity
                                                                      .toString();
                                                              // } else {
                                                              //   _qtyControl
                                                              //       .text = '1';
                                                              //   quantity = 1;
                                                              // }

                                                              // print('quantity');
                                                              // print('quantity : ' + quantity.toString());
                                                            });
                                                          },
                                                          items: product
                                                              .productPackage!
                                                              .map((value) {
                                                            return DropdownMenuItem<
                                                                ProductPackage>(
                                                              value: value,
                                                              child: Text(
                                                                  value.typeName !=
                                                                          null
                                                                      ? value
                                                                          .typeName!
                                                                      : ""),
                                                            );
                                                          }).toList(),
                                                        ),
                                                      ),
                                                    ),
                                                  ),
                                                ),
                                              ),
                                            ],
                                          ),
                                          SizedBox(width: 10.0),
                                          Column(
                                            children: [
                                              Padding(
                                                padding: const EdgeInsets.only(
                                                    top: 10.0,
                                                    right: 0.0,
                                                    bottom: 5.0,
                                                    left: 0.0),
                                                child: Container(
                                                  child: Text('Price :',
                                                      textAlign: TextAlign.left,
                                                      style: MyText.subhead(
                                                              context)!
                                                          .copyWith(
                                                              color: MyColors
                                                                  .subTitleTextBlackColor)),
                                                ),
                                              ),
                                              Container(
                                                height: 30,
                                                width: MediaQuery.of(context)
                                                            .size
                                                            .width /
                                                        4 -
                                                    20,
                                                decoration: BoxDecoration(
                                                  // color: Colors.white,
                                                  borderRadius:
                                                      BorderRadius.all(
                                                    Radius.circular(0.0),
                                                  ),
                                                  // border: Border.all(
                                                  //     color: Colors.grey)
                                                ),
                                                child: Padding(
                                                  padding:
                                                      const EdgeInsets.only(
                                                          top: 0.0,
                                                          right: 5.0,
                                                          bottom: 0.0,
                                                          left: 5.0),
                                                  child: Align(
                                                    alignment: Alignment.center,
                                                    child: Padding(
                                                      padding:
                                                          const EdgeInsets.all(
                                                              4.0),
                                                      child: Text(
                                                        price == null
                                                            ? ' '
                                                            : '₹ ' + price!,
                                                        style: MyText.title(
                                                                context)!
                                                            .copyWith(
                                                                color: MyColors
                                                                    .grey_100_,
                                                                fontSize: 16.0),
                                                      ),
                                                    ),
                                                  ),
                                                ),
                                              ),
                                            ],
                                          ),
                                          SizedBox(width: 10.0),
                                          Column(
                                            children: [
                                              Padding(
                                                padding: const EdgeInsets.only(
                                                    top: 10.0,
                                                    right: 0.0,
                                                    bottom: 5.0,
                                                    left: 0.0),
                                                child: Container(
                                                  child: Text('Qty :',
                                                      textAlign: TextAlign.left,
                                                      style: MyText.subhead(
                                                              context)!
                                                          .copyWith(
                                                              color: MyColors
                                                                  .subTitleTextBlackColor)),
                                                ),
                                              ),
                                              Container(
                                                height: 30,
                                                width: MediaQuery.of(context)
                                                            .size
                                                            .width /
                                                        4 -
                                                    40,
                                                decoration: BoxDecoration(
                                                    color: Colors.white,
                                                    borderRadius:
                                                        BorderRadius.all(
                                                      Radius.circular(0.0),
                                                    ),
                                                    border: Border.all(
                                                        color: Colors.grey)),
                                                child: Padding(
                                                  padding:
                                                      const EdgeInsets.only(
                                                          top: 5.0,
                                                          right: 0.0,
                                                          bottom: 0.0,
                                                          left: 0.0),
                                                  child: Card(
                                                    shape:
                                                        RoundedRectangleBorder(
                                                      borderRadius:
                                                          BorderRadius.circular(
                                                              3),
                                                    ),
                                                    clipBehavior: Clip
                                                        .antiAliasWithSaveLayer,
                                                    margin: EdgeInsets.all(0),
                                                    elevation: 0,
                                                    child: Container(
                                                      // color: Colors.grey[200],
                                                      alignment:
                                                          Alignment.centerLeft,
                                                      padding:
                                                          EdgeInsets.symmetric(
                                                              horizontal: 0),
                                                      child: TextFormField(
                                                        // initialValue:
                                                        //     quantity.toString(),
                                                        controller: _qtyControl,
                                                        validator: (value) {
                                                          if (value!.isEmpty) {
                                                            return 'Qty required';
                                                          }
                                                          // if (!(regex.hasMatch(value))) {
                                                          //   return 'Invalid Email';
                                                          // }
                                                          return null;
                                                        },
                                                        keyboardType:
                                                            TextInputType
                                                                .number,
                                                        textAlign:
                                                            TextAlign.center,
                                                        style: TextStyle(
                                                            color: MyColors
                                                                .grey_100_,
                                                            fontWeight:
                                                                FontWeight
                                                                    .bold),
                                                        decoration:
                                                            InputDecoration(
                                                          isDense: true,
                                                          contentPadding:
                                                              EdgeInsets.only(
                                                                  top: 7,
                                                                  bottom: 7,
                                                                  left: 0,
                                                                  right: 0),
                                                          labelText: "",
                                                          labelStyle: TextStyle(
                                                            letterSpacing: 0.5,
                                                            color: MyColors
                                                                .grey_60,
                                                          ),
                                                          enabledBorder:
                                                              UnderlineInputBorder(
                                                            borderSide:
                                                                BorderSide(
                                                                    color: Colors
                                                                        .black,
                                                                    width: 2),
                                                          ),
                                                          focusedBorder:
                                                              UnderlineInputBorder(
                                                            borderSide:
                                                                BorderSide(
                                                                    color: Colors
                                                                        .black,
                                                                    width: 2),
                                                          ),
                                                        ),
                                                        onChanged: (value) {
                                                          setState(() {
                                                            quantity =
                                                                int.parse(
                                                                    value);
                                                          });
                                                        },
                                                      ),
                                                    ),
                                                  ),
                                                ),
                                              ),
                                            ],
                                          ),
                                          SizedBox(
                                            width: 10.0,
                                          ),
                                          Align(
                                            alignment: Alignment.center,
                                            child: Padding(
                                              padding: const EdgeInsets.only(
                                                  top: 10.0),
                                              child: Container(
                                                width: MediaQuery.of(context)
                                                            .size
                                                            .width /
                                                        4 -
                                                    20,
                                                child:
                                                    // price != null &&
                                                    //         unitTypeID != null &&
                                                    //         quantity > 0
                                                    //     ?
                                                    // ignore: deprecated_member_use
                                                    RaisedButton(
                                                  padding: EdgeInsets.all(5.0),
                                                  onPressed: quantity > 0
                                                      ? () {
                                                          if (stockQty <
                                                              quantity) {
                                                            NetworkUtils.alertDlg(
                                                                context,
                                                                'Stock is not available');
                                                            _clearItems();
                                                            getInitialData();
                                                          } else {
                                                            bloc.addItemSess(
                                                                product.productId! +
                                                                    '-' +
                                                                    unitTypeID!,
                                                                product
                                                                    .productId!,
                                                                product
                                                                    .productName!,
                                                                product
                                                                    .imageLink!,
                                                                price!,
                                                                unitTypeID!,
                                                                unitTypeName!,
                                                                quantity
                                                                    .toString());

                                                            setState(() {
                                                              tempCartItem
                                                                      .quantity =
                                                                  quantity;
                                                            });
                                                            print(
                                                                'tempCartItem.quantity');
                                                            print(tempCartItem
                                                                .quantity);
                                                            addTOCart();
                                                            _clearItems();
                                                            getInitialData();
                                                           
                                                          }
                                                        }
                                                      : null,
                                                  color: MyColors.buttonBGColor,
                                                  child: Text(
                                                    'Add to Cart',
                                                    textAlign: TextAlign.center,
                                                    style: MyText
                                                            .subhead(context)!
                                                        .copyWith(
                                                            color: MyColors
                                                                .buttonTextColor,
                                                            fontWeight:
                                                                FontWeight.bold,
                                                            letterSpacing: 0.5,
                                                            fontSize: 12.0),
                                                  ),
                                                ),
                                                // : Container(),
                                              ),
                                            ),
                                          )
                                        ],
                                      ),
                                    ],
                                  ),
                                ),
                              ),
                              Container(
                                width: MediaQuery.of(context).size.width,
                                color: MyColors.subTitleTextColor,
                                child: 
                                    Padding(
                                        padding: const EdgeInsets.all(5.0),
                                        child: Text(
                                          'Available Quantity' ' - ' +
                                              stockQty.toString(),
                                          textAlign: TextAlign.center,
                                          style: MyText.subtitle(context)!
                                              .copyWith(
                                                  color: Colors.white,
                                                  fontWeight: FontWeight.normal,
                                                  fontSize: 12.0,
                                                  letterSpacing: 1.0),
                                        ),
                                      )
                                    
                              ),
                              SizedBox(height: 10.0),
                              Align(
                                alignment: Alignment.topLeft,
                                child: Column(
                                  mainAxisAlignment: MainAxisAlignment.start,
                                  crossAxisAlignment: CrossAxisAlignment.start,
                                  children: [
                                    Padding(
                                      padding: const EdgeInsets.only(
                                          top: 5.0,
                                          right: 0.0,
                                          bottom: 5.0,
                                          left: 20.0),
                                      child: Text('Dosage : ',
                                          textAlign: TextAlign.left,
                                          style: MyText.subhead(context)!
                                              .copyWith(
                                                  color: MyColors
                                                      .subTitleTextBlackColor,
                                                  fontWeight: FontWeight.normal,
                                                  fontSize: 14.0)),
                                    ),
                                    Padding(
                                      padding: const EdgeInsets.only(
                                          top: 0.0,
                                          right: 20.0,
                                          bottom: 20.0,
                                          left: 20.0),
                                      child: Text(
                                        product.dosage!,
                                        style: MyText.subhead(context)!.copyWith(
                                            color: MyColors.allTextColor,
                                            fontSize: 13.0),
                                      ),
                                    ),
                                  ],
                                ),
                              ),
                              // Align(
                              //   alignment: Alignment.topLeft,
                              //   child: Column(
                              //     mainAxisAlignment: MainAxisAlignment.start,
                              //     crossAxisAlignment: CrossAxisAlignment.start,
                              //     children: [
                              //       Padding(
                              //         padding: const EdgeInsets.only(
                              //             top: 5.0,
                              //             right: 0.0,
                              //             bottom: 5.0,
                              //             left: 20.0),
                              //         child: Text('How To Use : ',
                              //             textAlign: TextAlign.left,
                              //             style: MyText.subhead(context)
                              //                 .copyWith(
                              //                     color: MyColors
                              //                         .subTitleTextBlackColor,
                              //                     fontWeight: FontWeight.normal,
                              //                     fontSize: 14.0)),
                              //       ),
                              //       Padding(
                              //         padding: const EdgeInsets.only(
                              //             top: 0.0,
                              //             right: 20.0,
                              //             bottom: 20.0,
                              //             left: 20.0),
                              //         child: Text(
                              //           product.productUsage,
                              //           style: MyText.subhead(context).copyWith(
                              //               color: MyColors.allTextColor,
                              //               fontSize: 13.0),
                              //         ),
                              //       ),
                              //     ],
                              //   ),
                              // ),
                              Align(
                                alignment: Alignment.topLeft,
                                child: Column(
                                  mainAxisAlignment: MainAxisAlignment.start,
                                  crossAxisAlignment: CrossAxisAlignment.start,
                                  children: [
                                    Padding(
                                      padding: const EdgeInsets.only(
                                          top: 5.0,
                                          right: 0.0,
                                          bottom: 5.0,
                                          left: 20.0),
                                      child: Text('Indication : ',
                                          textAlign: TextAlign.left,
                                          style: MyText.subhead(context)!
                                              .copyWith(
                                                  color: MyColors
                                                      .subTitleTextBlackColor,
                                                  fontWeight: FontWeight.normal,
                                                  fontSize: 14.0)),
                                    ),
                                    Padding(
                                      padding: const EdgeInsets.only(
                                          top: 0.0,
                                          right: 20.0,
                                          bottom: 20.0,
                                          left: 20.0),
                                      child: Html(
                                        data: product.indication,
                                        // defaultTextStyle:
                                        //     MyText.subhead(context)!.copyWith(
                                        //         color: MyColors.allTextColor,
                                        //         fontSize: 13.0),
                                      ),
                                    ),
                                  ],
                                ),
                              ),
                              Align(
                                alignment: Alignment.topLeft,
                                child: Column(
                                  mainAxisAlignment: MainAxisAlignment.start,
                                  crossAxisAlignment: CrossAxisAlignment.start,
                                  children: [
                                    Padding(
                                      padding: const EdgeInsets.only(
                                          top: 5.0,
                                          right: 0.0,
                                          bottom: 5.0,
                                          left: 20.0),
                                      child: Text('Presentation : ',
                                          textAlign: TextAlign.left,
                                          style: MyText.subhead(context)!
                                              .copyWith(
                                                  color: MyColors
                                                      .subTitleTextBlackColor,
                                                  fontWeight: FontWeight.normal,
                                                  fontSize: 14.0)),
                                    ),
                                    Padding(
                                      padding: const EdgeInsets.only(
                                          top: 0.0,
                                          right: 20.0,
                                          bottom: 20.0,
                                          left: 20.0),
                                      child: Html(
                                        data: product.presentation,
                                        // defaultTextStyle:
                                        //     MyText.subhead(context)!.copyWith(
                                        //         color: MyColors.allTextColor,
                                        //         fontSize: 13.0),
                                      ),
                                    ),
                                  ],
                                ),
                              ),
                              Align(
                                alignment: Alignment.topLeft,
                                child: Column(
                                  mainAxisAlignment: MainAxisAlignment.start,
                                  crossAxisAlignment: CrossAxisAlignment.start,
                                  children: [
                                    Padding(
                                      padding: const EdgeInsets.only(
                                          top: 5.0,
                                          right: 0.0,
                                          bottom: 5.0,
                                          left: 20.0),
                                      child: Text('Reference Book : ',
                                          textAlign: TextAlign.left,
                                          style: MyText.subhead(context)!
                                              .copyWith(
                                                  color: MyColors
                                                      .subTitleTextBlackColor,
                                                  fontWeight: FontWeight.normal,
                                                  fontSize: 14.0)),
                                    ),
                                    Padding(
                                      padding: const EdgeInsets.only(
                                          top: 0.0,
                                          right: 20.0,
                                          bottom: 20.0,
                                          left: 20.0),
                                      child: Html(
                                        data: product.referenceBook,
                                        // defaultTextStyle:
                                        //     MyText.subhead(context)!.copyWith(
                                        //         color: MyColors.allTextColor,
                                        //         fontSize: 13.0),
                                      ),
                                    ),
                                  ],
                                ),
                              ),
                              Align(
                                alignment: Alignment.topLeft,
                                child: Column(
                                  mainAxisAlignment: MainAxisAlignment.start,
                                  crossAxisAlignment: CrossAxisAlignment.start,
                                  children: [
                                    Padding(
                                      padding: const EdgeInsets.only(
                                          top: 5.0,
                                          right: 0.0,
                                          bottom: 5.0,
                                          left: 20.0),
                                      child: Text('Useful for : ',
                                          textAlign: TextAlign.left,
                                          style: MyText.subhead(context)!
                                              .copyWith(
                                                  color: MyColors
                                                      .subTitleTextBlackColor,
                                                  fontWeight: FontWeight.normal,
                                                  fontSize: 14.0)),
                                    ),
                                    Padding(
                                      padding: const EdgeInsets.only(
                                          top: 0.0,
                                          right: 20.0,
                                          bottom: 20.0,
                                          left: 20.0),
                                      child: Html(
                                        data: product.usefullFor,
                                        // defaultTextStyle:
                                        //     MyText.subhead(context)!.copyWith(
                                        //         color: MyColors.allTextColor,
                                        //         fontSize: 13.0),
                                      ),
                                    ),
                                  ],
                                ),
                              ),
                            ],
                          ),
                        ),
                      ),
                    ),
                  ],
                ),
              ),
            ));
  }
}
