import 'package:drssiddha/app/data/my_colors.dart';
import 'package:drssiddha/app/pages/cart/cart_page.dart';
import 'package:drssiddha/app/pages/home/home.dart';
import 'package:drssiddha/app/pages/products/category_products_material.dart';
import 'package:drssiddha/app/pages/products/search_product.dart';
import 'package:drssiddha/app/provider/cart_provider.dart';
import 'package:drssiddha/app/utility/auth_utils.dart';
import 'package:drssiddha/app/widgets/badge.dart';

import 'package:drssiddha/app/widgets/loader.dart';
import 'package:drssiddha/app/utility/network_utils.dart';
import 'package:dio/dio.dart';
import 'package:flutter/material.dart';
import 'package:provider/provider.dart';

class ProductsCategoryPage extends StatefulWidget {
  ProductsCategoryPage({Key? key}) : super(key: key);

  @override
  _ProductsCategoryPageState createState() => _ProductsCategoryPageState();
}

class _ProductsCategoryPageState extends State<ProductsCategoryPage> {
  List drawerMenuList = [];
  bool _load = true;

  @override
  void initState() {
    super.initState();
    NetworkUtils.checkDataConnectivity(context, 'home');
    fetchHome();
  }

  void fetchHome() async {
    try {
      FormData formData = new FormData.fromMap({
        'post_data': "1",
        'apikey': AuthUtils.api,
      });
      var responseJson =
          await NetworkUtils.insertData('category.php', formData);
      if (responseJson['result'] == 'success') {
        // NewMaster _allMaster = NewMaster.fromJson(responseJson);

        setState(() {
          drawerMenuList = responseJson['data'];
          print(drawerMenuList);
          _load = false;
        });
      } else {
        setState(() {
          _load = false;
        });
        NetworkUtils.alertDlg(context, responseJson['msg']);
      }
    } catch (e) {
      setState(() {
        _load = false;
      });
      NetworkUtils.alertDlg(context, e.toString());

      print('Server Exception!!!');
      print(e);
      return null;
    }
  }

   _returnwillPop() {
    Navigator.of(context).pushReplacement(
        PageRouteBuilder(pageBuilder: (_, __, ___) => HomePage()));
  }


  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: () async {
        return _returnwillPop();
      },
      child: Scaffold(
          backgroundColor: Colors.white,
          // key: _scaffoldKey,
          appBar: AppBar(
            backgroundColor: MyColors.appBarColor, //(0XFFBad600),
            iconTheme: IconThemeData(color: MyColors.appBarTextColor),
            elevation: 0,
            centerTitle: true,
            leading: InkWell(
                onTap: () {
                  // Navigator.of(context).pop();
                  // Navigator.pushNamed(context, '/home');
                  Navigator.pushReplacement(
                      context,
                      MaterialPageRoute(
                          builder: (BuildContext ctx) => HomePage()));
                },
                child: Icon(Icons.arrow_back_ios, size: 16)),
            title: Text(
              'Products',
              style: TextStyle(
                  color: MyColors.appBarTextColor,
                  fontSize: 18,
                  letterSpacing: 0.5,
                  // fontWeight: FontWeight.w700
                  ),
            ),
            actions: <Widget>[
              Consumer<CartProvider>(
                builder: (_, cart, ch) => Badge(
                  child: ch!,
                  value: cart.getTotalQuantity.toString(),
                  color: MyColors.logobody,
                ),
                child: Consumer<CartProvider>(
                  builder: (_, cart, ch) {
                    return cart.getTotalQuantity > 0
                        ? Padding(
                            padding: const EdgeInsets.only(right: 5.0),
                            child: IconButton(
                              icon: Icon(
                                Icons.shopping_cart,
                                size: 30,
                                color: MyColors.appBarTextColor,
                              ),
                              onPressed: () {
                                Navigator.pushReplacement(
                                    context,
                                    MaterialPageRoute(
                                        builder: (BuildContext ctx) =>
                                            CartPage()));
                              },
                            ),
                          )
                        : Container();
                  },
                ),
              )
            ],
          ),
          floatingActionButton: FloatingActionButton(
            tooltip: 'Search Product',
        backgroundColor: MyColors.buttonBGColor,
        child: Icon(Icons.search, color: MyColors.buttonTextColor),
        onPressed: () {
          Navigator.pushReplacement(
              context,
              MaterialPageRoute(
                  builder: (BuildContext ctx) => SearchProductPage()));
        },
      ),
          body: _load
              ? LoaderWidget()
              : SingleChildScrollView(
                  child: ListView.builder(
                    shrinkWrap: true,
                    physics: NeverScrollableScrollPhysics(),
                    itemCount: drawerMenuList.length,
                    itemBuilder: (context, i) {
                      //  value = cartItems[position]["quantity"];
                      ///
                      /// Widget for list view slide delete
                      ///
                      return Padding(
                        padding: const EdgeInsets.all(8.0),
                        child: Card(
                          child: ListTile(
                            onTap: () {
                              Navigator.push(
                                  context,
                                  MaterialPageRoute(
                                      builder: (context) =>
                                          CategoryProductsMaterialTypePage(
                                              drawerMenuList[i])));
                            },
                            title: Text(
                              drawerMenuList[i]["displayName"],
                              style: TextStyle(
                                  color: MyColors.titleTextColor,
                                  letterSpacing: 0.5,
                                  fontWeight: FontWeight.w800),
                            ),
                            trailing: Icon(
                              Icons.arrow_forward_ios,
                              size: 16.0,
                              color: MyColors.buttonBGColor,
                            ),
                          ),
                        ),
                      );
                    },
                  ),
                )),
    );
  }
}
