import 'package:drssiddha/app/data/my_colors.dart';
import 'package:drssiddha/app/model/material_type_products_model.dart';
import 'package:drssiddha/app/pages/cart/cart_page.dart';
import 'package:drssiddha/app/pages/products/product_category.dart';
import 'package:drssiddha/app/pages/products/product_detail.dart';
import 'package:drssiddha/app/pages/products/search_product.dart';
import 'package:drssiddha/app/provider/cart_provider.dart';
import 'package:drssiddha/app/utility/auth_utils.dart';
import 'package:drssiddha/app/utility/network_utils.dart';
import 'package:drssiddha/app/widget/my_text.dart';
import 'package:drssiddha/app/widgets/badge.dart';
import 'package:drssiddha/app/widgets/loader.dart';
import 'package:dio/dio.dart';
import 'package:flutter/material.dart';
import 'package:provider/provider.dart';
// import 'package:html/parser.dart' show parse;

class CategoryProductsMaterialTypePage extends StatefulWidget {
  final category;
  CategoryProductsMaterialTypePage(this.category);
  @override
  _CategoryProductsMaterialTypePageState createState() =>
      _CategoryProductsMaterialTypePageState(this.category);
}

class _CategoryProductsMaterialTypePageState
    extends State<CategoryProductsMaterialTypePage> {
  GlobalKey<ScaffoldState> _scaffoldKey = new GlobalKey<ScaffoldState>();
  final category;
  _CategoryProductsMaterialTypePageState(this.category);
  ScrollController? controller;

  var _category;

  int quantity = 0;
  bool _load = true;
  List<MaterialProduct> _products = [];
  // List<MaterialProductsModel> _allProductsALL = [];
  // bool _selectSC = false;
  String? subCategoryName;
  String? selectSCName;
  // int _defaultChoiceIndex;

  @override
  void initState() {
    super.initState();
    NetworkUtils.checkDataConnectivity(context, 'home');
    _category = category;
    print(category);
    // print(category[0]['categoryId']);
    fetchHome(category['categoryId']);
  }

  // List<Datum> _productsInfo;

  void fetchHome(categoryId) async {
    try {
      FormData formData = new FormData.fromMap({
        'post_data': "1",
        'apikey': AuthUtils.api,
        'category_id': categoryId
      });
      var responseJson = await NetworkUtils.insertData('product.php', formData);
      if (responseJson['result'] == 'success') {
        MaterialProductsModel _allProductsData =
            MaterialProductsModel.fromJson(responseJson);
        //  print(_allMaster);

        setState(() {
          // print(responseJson['data']);
          // print(_states);

          _products = _allProductsData.data!;
          print(_products.length);
          _load = false;
        });
      } else {
        setState(() {
          _load = false;
        });
        NetworkUtils.alertDlg(context, responseJson['msg']);
      }
    } catch (e) {
      setState(() {
        _load = false;
      });
      NetworkUtils.alertDlg(context, e.toString());

      print('Server Exception!!!');
      print(e);
      return null;
    }
  }

  // String _parseHtmlString(_responseText) {
  //   var document = parse(_responseText);
  //   String parsedString = parse(document.body.text).documentElement.text;
  //   return parsedString;
  // }

   _returnwillPop() {
    Navigator.of(context).pushReplacement(
        PageRouteBuilder(pageBuilder: (_, __, ___) => ProductsCategoryPage()));
  }


  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: () async {
        return _returnwillPop();
      },
      child: Scaffold(
          backgroundColor: Colors.white,
          key: _scaffoldKey,
          appBar: AppBar(
            backgroundColor: MyColors.appBarColor,
            iconTheme: IconThemeData(
              color: MyColors.appBarTextColor,
            ),
            // title: Image.asset("assets/images/logo-small.png", fit: BoxFit.cover),
            leading: InkWell(
                onTap: () {
                  // Navigator.of(context).pop();
                  Navigator.pushReplacement(
                      context,
                      MaterialPageRoute(
                          builder: (BuildContext ctx) =>
                              ProductsCategoryPage()));
                },
                child: Icon(Icons.arrow_back_ios, size: 16)),
            title: Text(
              category['displayName'],
              style: TextStyle(
                  color: MyColors.appBarTextColor,
                  fontSize: 18,
                  // fontWeight: FontWeight.w700,
                  letterSpacing: 0.5),
            ),
            centerTitle: true,
            elevation: 0,
            actions: <Widget>[
              Consumer<CartProvider>(
                builder: (_, cart, ch) => Badge(
                  child: ch!,
                  value: cart.getTotalQuantity.toString(),
                  color: MyColors.logobody,
                ),
                child: Consumer<CartProvider>(
                  builder: (_, cart, ch) {
                    return cart.getTotalQuantity > 0
                        ? Padding(
                            padding: const EdgeInsets.only(right: 5.0),
                            child: IconButton(
                              icon: Icon(
                                Icons.shopping_cart,
                                size: 30,
                                color: MyColors.appBarTextColor,
                              ),
                              onPressed: () {
                                Navigator.pushReplacement(
                                    context,
                                    MaterialPageRoute(
                                        builder: (BuildContext ctx) =>
                                            CartPage()));
                              },
                            ),
                          )
                        : Container();
                  },
                ),
              )
            ],
          ),
          floatingActionButton: FloatingActionButton(
            backgroundColor: MyColors.buttonBGColor,
            child: Icon(Icons.search, color: MyColors.buttonTextColor),
            onPressed: () {
              Navigator.pushReplacement(
                  context,
                  MaterialPageRoute(
                      builder: (BuildContext ctx) => SearchProductPage()));
            },
          ),
          // drawer: new DrawerMenu(),
          body: _load
              ? LoaderWidget()
              : SingleChildScrollView(
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: <Widget>[
                      ListView.builder(
                          physics: NeverScrollableScrollPhysics(),
                          shrinkWrap: true,
                          padding: EdgeInsets.symmetric(
                              horizontal: 10.0, vertical: 10.0),
                          itemCount: _products.length,
                          // Product product = _productsInfo[index];
                          itemBuilder: (BuildContext context, index) {
                            return itemGrid(context, _products[index]);
                          }),
                      // ),
                    ],
                  ),
                )),
    );
  }

  Widget itemGrid(context, MaterialProduct product) {
    // final cart = Provider.of<CartProvider>(context, listen: false);
    // quantity = cart.getQuantity(product.productId);
    return InkWell(
      onTap: () {
        Navigator.of(context).push(PageRouteBuilder(
            pageBuilder: (_, __, ___) => new ProductDetail(product)));

        // Navigator.pushReplacementNamed(context, '/productDetail',
        //     arguments: product.productId);
        //
      },
      child: Padding(
        padding: const EdgeInsets.only(top: 0.0, bottom: 14.0),
        child: Container(
          decoration: BoxDecoration(
              color: Colors.white,
              borderRadius: BorderRadius.all(Radius.circular(10.0)),
              boxShadow: [
                BoxShadow(
                  color: Color(0xFF656565).withOpacity(0.15),
                  blurRadius: 4.0,
                  spreadRadius: 1.0,
//           offset: Offset(4.0, 10.0)
                )
              ]),
          child: Wrap(
            children: <Widget>[
              Row(
                crossAxisAlignment: CrossAxisAlignment.start,
                // mainAxisAlignment: MainAxisAlignment.spaceBetween,
                // mainAxisSize: MainAxisSize.min,
                children: <Widget>[
                  /// Set Animation image to detailProduk layout
                  Material(
                    child: GestureDetector(
                      onTap: () async {
                        await showDialog(
                            context: context,
                            builder: (_) => ImageDialog(product.imageLink));
                      },
                      child: Stack(
                        children: <Widget>[
                          Align(
                            alignment: Alignment.center,
                            child: Container(
                              height: 150.0,
                              width: 120.0,
                              // MediaQuery.of(context).size.width / 3.0,
                              decoration: BoxDecoration(
                                  color: Colors.white,
                                  borderRadius: BorderRadius.only(
                                      topLeft: Radius.circular(7.0),
                                      topRight: Radius.circular(7.0)),
                                  image: DecorationImage(
                                      image: NetworkImage(product.imageLink!),
                                      fit: BoxFit.cover)),
                            ),
                          ),
                        ],
                      ),
                    ),
                  ),
                  Container(
                    height: 150,
                    // color: Colors.green,
                    width: MediaQuery.of(context).size.width - 150,
                    child: Padding(
                      padding: const EdgeInsets.only(
                          left: 8.0, right: 0.0, top: 5.0),
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        mainAxisAlignment: MainAxisAlignment.start,
                        children: <Widget>[
                          // Padding(padding: EdgeInsets.only(top: 7.0)),
                          Container(
                            child: Text(
                              product.productName == null
                                  ? ' '
                                  : product.productName!,
                              overflow: TextOverflow.ellipsis,
                              maxLines: 3,
                              // textAlign: TextAlign.justify,
                              style: MyText.headline(context)!.copyWith(
                                  color: MyColors.titleTextColor,
                                  letterSpacing: 0.5,
                                  fontSize: 16.0,
                                  fontWeight: FontWeight.bold),
                            ),
                          ),
                          Divider(
                            height: 1.0,
                          ),
                          SizedBox(height: 5.0),
                          Container(
                            child: Text(
                                product.indication == null
                                    ? ' '
                                    : product.indication!,
                                maxLines: 4,
                                // textAlign: TextAlign.left,
                                // customTextAlign: _alignFn(),
                                style: MyText.subhead(context)!.copyWith(
                                    color: MyColors.allTextColor,
                                    letterSpacing: 0.5,
                                    fontSize: 15.0)),
                          ),
                          Expanded(child: SizedBox(height: 10.0)),
                          Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              product.productPackage!.isEmpty
                                  ? Container()
                                  : Align(
                                      alignment: Alignment.bottomCenter,
                                      child: Row(
                                        crossAxisAlignment:
                                            CrossAxisAlignment.end,
                                        mainAxisAlignment:
                                            MainAxisAlignment.spaceBetween,
                                        children: <Widget>[
                                          Center(
                                            child: Text(
                                              product.productPackage![0]
                                                          .typeName ==
                                                      null
                                                  ? ' '
                                                  : product.productPackage![0]
                                                      .typeName!,
                                              style: TextStyle(
                                                  // fontFamily: "Sans",
                                                  color: MyColors.grey_90,
                                                  fontWeight: FontWeight.w800,
                                                  fontSize: 16.0),
                                            ),
                                          ),
                                          Padding(
                                            padding: const EdgeInsets.only(
                                                right: 10.0),
                                            child: Text(
                                              '₹ ' +
                                                  product
                                                      .productPackage![0].price!,
                                              style: TextStyle(
                                                  // fontFamily: "Sans",
                                                  fontWeight: FontWeight.w800,
                                                  fontSize: 16.0),
                                            ),
                                          ),
                                        ],
                                      ),
                                    ),
                              SizedBox(height: 5.0),
                            ],
                          ),
                        ],
                      ),
                    ),
                  ),
                ],
              ),
            ],
          ),
        ),
      ),
    );
  }
  // }

}

class ImageDialog extends StatelessWidget {
  final image;
  ImageDialog(this.image);
  @override
  Widget build(BuildContext context) {
    return Dialog(
      child: InkWell(
        onTap: () {
          Navigator.of(context).pop();
        },
        child: Container(
          width: 200,
          height: 500,
          decoration: BoxDecoration(
              color: MyColors.imageBGColor,
              image: DecorationImage(
                  image: NetworkImage(image), fit: BoxFit.contain)),
        ),
      ),
    );
  }
}
