import 'package:drssiddha/app/data/my_colors.dart';
import 'package:drssiddha/app/model/my_orders_model.dart';
import 'package:drssiddha/app/pages/my_orders/my_orders.dart';
import 'package:drssiddha/app/utility/network_utils.dart';
import 'package:drssiddha/app/widget/my_text.dart';
import 'package:flutter/material.dart';

class OrderDetailView extends StatefulWidget {
  final Order oneOrder;
  OrderDetailView(this.oneOrder);
  @override
  _OrderDetailViewState createState() => _OrderDetailViewState(this.oneOrder);
}

class _OrderDetailViewState extends State<OrderDetailView> {
  final Order oneOrder;
  _OrderDetailViewState(this.oneOrder);
  // final List<cartItem> items = new List();
  TextEditingController myController = TextEditingController();

  @override
  void initState() {
    super.initState();
    NetworkUtils.checkDataConnectivity(context, 'home');
    // _fetchSessionAndNavigate();
    setState(() {});
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      // key: _scffoldKey,
      appBar: AppBar(
        // iconTheme: IconThemeData(color: Colors.white),
        // centerTitle: true,
        backgroundColor: MyColors.primaryValue,
        leading: InkWell(
            onTap: () {
              // Navigator.of(context).pop();
              // Navigator.of(context, rootNavigator: true).pop(context);
              // Navigator.pop(context);
              Navigator.pushReplacement(
                  context,
                  MaterialPageRoute(
                      builder: (BuildContext ctx) => MyOrdersPage()));
            },
            child:
                Icon(Icons.arrow_back_ios, size: 16, color: MyColors.primary)),
        title: Text(
          'Order Details',
          style: TextStyle(
              color: MyColors.primary, fontSize: 18, letterSpacing: 0.5),
        ),
        elevation: 0.0,
        centerTitle: true,
      ),

      body: SingleChildScrollView(
          child: Column(
        children: <Widget>[
          Padding(
            padding: const EdgeInsets.only(left: 8.0, right: 10.0, top: 5.0),
            child: Column(
              // crossAxisAlignment: CrossAxisAlignment.sp,
              mainAxisAlignment: MainAxisAlignment.spaceAround,
              children: <Widget>[
                // Padding(padding: EdgeInsets.only(top: 7.0)),
                Row(
                  children: <Widget>[
                    Container(
                      child: Text(
                        oneOrder.orderId == null
                            ? ''
                            : 'Order No. : ' + oneOrder.orderId!,
                        overflow: TextOverflow.ellipsis,
                        maxLines: 3,
                        // textAlign: TextAlign.justify,
                        style: MyText.headline(context)!.copyWith(
                            color: MyColors.grey_100_,
                            letterSpacing: 0.5,
                            fontSize: 16.0,
                            fontWeight: FontWeight.bold),
                      ),
                    ),
                    Expanded(
                        child: SizedBox(
                      width: 10.0,
                    )),
                    Container(
                      child: Text(
                          oneOrder.orderDate == null ? '' : oneOrder.orderDate!,
                          maxLines: 1,
                          textAlign: TextAlign.justify,
                          style: MyText.subhead(context)!.copyWith(
                              color: MyColors.grey_100_, letterSpacing: 0.5)),
                    ),
                  ],
                ),
                // Divider(
                //   height: 1.0,
                // ),
                SizedBox(height: 10.0),
                Row(
                  children: <Widget>[
                    Container(
                      child: Row(
                        children: <Widget>[
                          Text(
                              oneOrder.numberOfProducts == null
                                  ? ''
                                  : oneOrder.numberOfProducts.toString(),
                              maxLines: 1,
                              textAlign: TextAlign.justify,
                              style: MyText.subhead(context)!.copyWith(
                                  color: MyColors.grey_100_,
                                  letterSpacing: 0.5,
                                  fontWeight: FontWeight.bold)),
                          Text(' Item(s)',
                              maxLines: 1,
                              textAlign: TextAlign.justify,
                              style: MyText.subhead(context)!.copyWith(
                                  color: MyColors.grey_100_,
                                  letterSpacing: 0.5)),
                        ],
                      ),
                    ),
                    Expanded(
                        child: SizedBox(
                      width: 10.0,
                    )),
                    Container(
                      child: Row(
                        children: <Widget>[
                          Text(oneOrder.deliveryStatus!,
                              maxLines: 1,
                              textAlign: TextAlign.justify,
                              style: MyText.subhead(context)!.copyWith(
                                  color: MyColors.primaryValue,
                                  letterSpacing: 0.5)),
                        ],
                      ),
                    ),
                  ],
                ),
                SizedBox(height: 5.0),
              ],
            ),
          ),
          ListView.builder(
            shrinkWrap: true,
            physics: NeverScrollableScrollPhysics(),
            itemCount: oneOrder.items!.length,
            itemBuilder: (context, i) {
              //  value = cartItems[position]["quantity"];
              ///
              /// Widget for list view slide delete
              ///
              print(oneOrder.items![i].productName);
              print('oneOrder.items![i].productName');
              return individualCartItem(context, oneOrder.items![i]);
            },
            scrollDirection: Axis.vertical,
          ),
          Padding(
            padding: const EdgeInsets.all(10.0),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: <Widget>[
                Text(
                  "Order Information ",
                  style: MyText.subhead(context)!.copyWith(
                      color: Colors.grey[700],
                      fontSize: 14.0,
                      fontWeight: FontWeight.bold),
                ),
                Container(height: 5),
                Padding(
                  padding: const EdgeInsets.all(0.0),
                  child: Row(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Container(
                        width: MediaQuery.of(context).size.width / 2 - 30,
                        child: Text(
                          "Shipping Address ",
                          style: MyText.subhead(context)!.copyWith(
                              color: Colors.grey[700], fontSize: 14.0),
                        ),
                      ),
                      Container(
                        width: MediaQuery.of(context).size.width / 2,
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: <Widget>[
                            Text(oneOrder.shippingAddress!,
                                style: MyText.subhead(context)!.copyWith(
                                    color: MyColors.grey_100_,
                                    fontSize: 14.0,
                                    letterSpacing: 0.5)),
                            Container(height: 2),
                            Text(oneOrder.shippingLandmark!,
                                style: MyText.subhead(context)!.copyWith(
                                    color: MyColors.subTitleTextBlackColor,
                                    fontSize: 14.0,
                                    letterSpacing: 0.5)),
                            Container(height: 2),
                            Text(oneOrder.shippingCity!,
                                style: MyText.subhead(context)!.copyWith(
                                    color: MyColors.subTitleTextBlackColor,
                                    fontSize: 14.0,
                                    letterSpacing: 0.5)),
                            Container(height: 2),
                            Text(oneOrder.shippingState!,
                                style: MyText.subhead(context)!.copyWith(
                                    color: MyColors.subTitleTextBlackColor,
                                    fontSize: 14.0,
                                    letterSpacing: 0.5)),
                            Container(height: 2),
                            Text(oneOrder.shippingPincode!,
                                style: MyText.subhead(context)!.copyWith(
                                    color: MyColors.subTitleTextBlackColor,
                                    fontSize: 14.0,
                                    letterSpacing: 0.5)),
                            Container(height: 2),
                            Text(oneOrder.shippingPhone!,
                                style: MyText.subhead(context)!.copyWith(
                                    color: MyColors.subTitleTextBlackColor,
                                    fontSize: 14.0,
                                    letterSpacing: 0.5)),
                            Container(height: 2),
                            Text(oneOrder.shippingEmail!,
                                style: MyText.subhead(context)!.copyWith(
                                    color: MyColors.subTitleTextBlackColor,
                                    fontSize: 14.0,
                                    letterSpacing: 0.5)),
                          ],
                        ),
                      ),
                    ],
                  ),
                ),
                Divider(),
                ListView.builder(
                  shrinkWrap: true,
                  physics: NeverScrollableScrollPhysics(),
                  itemCount: oneOrder.priceDetail!.length,
                  itemBuilder: (context, i) {
                    PriceDetail priceDetails1 = oneOrder.priceDetail![i];
                    return Padding(
                      padding: const EdgeInsets.only(top: 5.0),
                      child: Row(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          Container(
                            width: MediaQuery.of(context).size.width / 2 - 30,
                            child: Text(
                              priceDetails1.title!,
                              style: MyText.subhead(context)!.copyWith(
                                  color: Colors.grey[700], fontSize: 14.0),
                            ),
                          ),
                          Container(
                            width: MediaQuery.of(context).size.width / 2,
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: <Widget>[
                                Text(
                                    priceDetails1.title == 'Payment Mode'
                                        ? priceDetails1.value!
                                        : '₹ ' +
                                            priceDetails1.value!
                                                .replaceFirst('.00', ""),
                                    style: MyText.subhead(context)!.copyWith(
                                        color: MyColors.subTitleTextBlackColor,
                                        fontSize: 14.0,
                                        letterSpacing: 0.5)),
                              ],
                            ),
                          ),
                        ],
                      ),
                    );
                  },
                  scrollDirection: Axis.vertical,
                ),
              ],
            ),
          ),
        ],
      )),
      bottomNavigationBar: footer(
          context,
          oneOrder.numberOfProducts,
          oneOrder.invoiceAmount,
          oneOrder.deliveryCharge,
          'oneOrder.tax',
          oneOrder.discount,
          oneOrder.totalAmount),
    );
  }

  Widget individualCartItem(
    context1,
    final Item item,
  ) {
    return Padding(
      padding: const EdgeInsets.only(top: 0.0, bottom: 0.0),
      child: Padding(
        padding: const EdgeInsets.only(top: 0.0, bottom: 0.0),
        // padding: const EdgeInsets.only(top: 1.0, left: 13.0, right: 13.0),

        /// Background Constructor for card
        child: Container(
          // height: 70.0,
          decoration: BoxDecoration(
            color: Colors.white,
            boxShadow: [
              BoxShadow(
                color: Colors.black12.withOpacity(0.1),
                blurRadius: 3.5,
                spreadRadius: 0.4,
              )
            ],
          ),
          child: Column(
            // crossAxisAlignment: CrossAxisAlignment.end,
            // mainAxisAlignment: MainAxisAlignment.center,
            children: <Widget>[
              Row(
                children: <Widget>[
                  Row(
                    mainAxisAlignment: MainAxisAlignment.start,
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: <Widget>[
                      Padding(
                          padding: EdgeInsets.all(10.0),

                          /// Image item
                          child: Center(
                            child: Container(
                              decoration: BoxDecoration(
                                  color: Colors.white.withOpacity(0.1),
                                  boxShadow: [
                                    BoxShadow(
                                        color: Colors.black12.withOpacity(0.1),
                                        blurRadius: 0.5,
                                        spreadRadius: 0.1)
                                  ]),
                              child: Image.network(
                                item.imageLink!,
                                // height: 50.0,
                                width: 50.0,
                                fit: BoxFit.contain,
                              ),
                            ),
                          )),
                      Padding(
                        padding: const EdgeInsets.only(
                            top: 15.0, left: 10.0, right: 5.0),
                        child: Column(
                          /// Text Information Item
                          crossAxisAlignment: CrossAxisAlignment.start,
                          mainAxisAlignment: MainAxisAlignment.start,
                          children: <Widget>[
                            Text(
                              item.productName == null
                                  ? ""
                                  : item.productName! + ' - ' + item.typeName!,
                              maxLines: 2,
                              style: TextStyle(
                                fontWeight: FontWeight.w700,
                                // fontFamily: "Sans",
                                color: Colors.black87,
                              ),
                              overflow: TextOverflow.ellipsis,
                            ),
                            Padding(padding: EdgeInsets.only(top: 10.0)),
                            Row(
                              crossAxisAlignment: CrossAxisAlignment.center,
                              mainAxisAlignment: MainAxisAlignment.spaceBetween,
                              children: <Widget>[
                                Row(
                                  // crossAxisAlignment: CrossAxisAlignment.center,
                                  mainAxisAlignment:
                                      MainAxisAlignment.spaceBetween,
                                  children: <Widget>[
                                    Align(
                                      alignment: Alignment.centerLeft,
                                      child: Row(
                                        children: <Widget>[
                                          Text(
                                            'Quantity : ',
                                            maxLines: 1,
                                            style: TextStyle(
                                              fontSize: 12,
                                              fontWeight: FontWeight.normal,
                                              // fontFamily: "Sans",
                                              color: MyColors.grey_80,
                                            ),
                                            overflow: TextOverflow.ellipsis,
                                          ),
                                          Text(
                                            item.quantity == null
                                                ? ""
                                                : item.quantity.toString(),
                                            maxLines: 1,
                                            style: TextStyle(
                                              fontSize: 16,
                                              fontWeight: FontWeight.w700,
                                              // fontFamily: "Sans",
                                              color: MyColors.grey_100_,
                                            ),
                                            overflow: TextOverflow.ellipsis,
                                          ),
                                        ],
                                      ),
                                    ),
                                    // Expanded( flex: 1, child: null),

                                    // Expanded(child: SizedBox(width: 5.0)),
                                  ],
                                ),
                                SizedBox(
                                  width: 5,
                                ),
                                Align(
                                  alignment: Alignment.center,
                                  child: Text(
                                    item.price == null
                                        ? ""
                                        : '  X   ₹ ' +
                                            item.price!.replaceFirst('.00', ""),
                                    textAlign: TextAlign.right,
                                    style: TextStyle(
                                        fontSize: 16.0,
                                        fontWeight: FontWeight.bold),
                                  ),
                                ),
                              ],
                            ),
                          ],
                        ),
                      ),
                    ],
                  ),
                  Expanded(
                      child: SizedBox(
                    width: 5.0,
                  )),
                  Padding(
                    padding: const EdgeInsets.only(right: 10.0, top: 15.0),
                    child: Align(
                      alignment: Alignment.centerRight,
                      child: Text(
                        // ignore: unnecessary_null_comparison
                        item.totalPrice.toString() == null
                            ? ""
                            : '₹ ' +
                                item.totalPrice
                                    .toString()
                                    .replaceFirst('.00', ""),
                        // (quantity * int.parse(price)).toString(),
                        maxLines: 1,
                        textAlign: TextAlign.right,
                        style: TextStyle(
                          fontSize: 16,
                          fontWeight: FontWeight.w700,
                          // fontFamily: "Sans",
                          color: MyColors.grey_100_,
                        ),
                      ),
                    ),
                  ),
                ],
              ),
            ],
          ),
        ),
      ),
    );
  }

  footer(BuildContext context, _cartCount, _subTotAmt, _delCharge, _tax,
      _totDisc, _totAmt) {
    return Container(
      height: 50,
      color: Colors.grey[10],
      //color: Colors.grey[70],
      decoration: BoxDecoration(
        border: Border.all(width: 0.1, color: Colors.grey),
        //borderRadius: BorderRadius.all(Radius.circular(12))
      ),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.center,
        mainAxisAlignment: MainAxisAlignment.end,
        children: <Widget>[
          Container(
            padding: EdgeInsets.fromLTRB(20.0, 0.0, 20.0, 0.0),
            width: MediaQuery.of(context).size.width,
            // ignore: deprecated_member_use
            child: RaisedButton(
              color: MyColors.primary,
              onPressed: () {
                Navigator.push(
                    context,
                    new MaterialPageRoute(
                        builder: (context) => MyOrdersPage()));
              },
              padding: EdgeInsets.only(top: 5, left: 60, right: 60, bottom: 5),
              child: Text(
                "BACK",
                style: MyText.subhead(context)!.copyWith(
                    color: Colors.white,
                    letterSpacing: 0.5,
                    fontWeight: FontWeight.bold),
              ),
            ),
          ),
        ],
      ),
    );
  }
}

class NoItemCart extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    return Container(
      // width: 500.0,
      height: MediaQuery.of(context).size.height,
      color: Colors.white,
      // height: double.infinity,
      child: Align(
        alignment: Alignment.center,
        child: Text(
          "Not Have an Item",
          textAlign: TextAlign.center,
          style: TextStyle(
              fontWeight: FontWeight.w500,
              fontSize: 18.5,
              color: Colors.black.withOpacity(0.2),
              fontFamily: "Popins"),
        ),
      ),
    );
  }
}
