import 'package:drssiddha/app/data/my_colors.dart';
import 'package:drssiddha/app/model/my_orders_model.dart';
import 'package:drssiddha/app/model/user_model.dart';
import 'package:drssiddha/app/pages/home/home.dart';
import 'package:drssiddha/app/pages/my_orders/order_detail_view.dart';
import 'package:drssiddha/app/utility/auth_utils.dart';
import 'package:drssiddha/app/utility/network_utils.dart';
import 'package:drssiddha/app/widget/my_text.dart';
import 'package:drssiddha/app/widgets/loader.dart';
import 'package:dio/dio.dart';
import 'package:flutter/material.dart';



class MyOrdersPage extends StatefulWidget {
  MyOrdersPage({Key? key}) : super(key: key);

  @override
  _MyOrdersPageState createState() => _MyOrdersPageState();
}

class _MyOrdersPageState extends State<MyOrdersPage> {
  GlobalKey<ScaffoldState> _scaffoldKey = new GlobalKey<ScaffoldState>();
  bool _load = true;
  User userData = User();
  List<Order>? orders;
  

  @override
  void initState() {
    super.initState();
    NetworkUtils.checkDataConnectivity(context, 'home');
    _fetchSessionAndNavigate();
  }

   _fetchSessionAndNavigate() async {
    userData = await AuthUtils.loadSharedPrefs();
    // print(userData.firstName);
    // print(userData.lastName);

    setState(() {
      _load = false;
    });
    fetchHome();
  }

  void fetchHome() async {
    setState(() {
      _load = true;
    });
    try {
      FormData formData = new FormData.fromMap({
        'post_data': "1",
        'apikey' : AuthUtils.api,
        'userId': userData.userId,
      });
      var responseJson =
          await NetworkUtils.insertData('my_order.php', formData);
      if (responseJson['result'] == 'success') {
        MyOrders allOrderData = MyOrders.fromJson(responseJson);
        print(responseJson);
        setState(() {
          orders= allOrderData.data;
          print(orders!.length);
          _load = false;
        });
      } else {
        setState(() {
          _load = false;
        });
        NetworkUtils.alertDlg(context, responseJson['msg']);
      }
    } catch (e) {
      setState(() {
        _load = false;
      });
      NetworkUtils.alertDlg(context, e.toString());

      print('Server Exception!!!');
      print(e);
      return null;
    }
  }


   _returnwillPop() {
    Navigator.of(context).pushReplacement(
        PageRouteBuilder(pageBuilder: (_, __, ___) => HomePage()));
  }


  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: () async {
        return _returnwillPop();
      },
      child: Scaffold(
        backgroundColor: Colors.grey[100],
        key: _scaffoldKey,
        appBar: AppBar(
          iconTheme: IconThemeData(
            color: MyColors.primary,
          ),
          // title: Image.asset("assets/images/logo-small.png", fit: BoxFit.cover),
          leading: InkWell(
              onTap: () {
                // Navigator.of(context).pop();
                Navigator.pushReplacement(
                    context,
                    MaterialPageRoute(
                        builder: (BuildContext ctx) => HomePage()));
              },
              child: Icon(Icons.arrow_back_ios, size: 16)),
          title: Text(
            'My Orders',
            style: TextStyle(color: MyColors.primary, fontSize: 18),
          ),
          centerTitle: true,
          elevation: 0,
        ),
        // drawer: new DrawerMenu(),
        body: _load
            ? LoaderWidget()
            : SingleChildScrollView(
                child: orders!.isNotEmpty
                    ? ListView.builder(
                        physics: NeverScrollableScrollPhysics(),
                        shrinkWrap: true,
                        padding: EdgeInsets.symmetric(
                            horizontal: 10.0, vertical: 10.0),
                        itemCount: orders!.length,
                        // Product product = _productsInfo[index];
                        itemBuilder: (BuildContext context, index) {
                          return itemGrid(context, orders![index]);
                        })
                    : Center(
                        child: Container(
                        child: Text('No more Orders...'),
                      )),
              ),
      ),
    );
  }

  Widget itemGrid(context, Order order) {
    // final cart = Provider.of<CartProvider>(context, listen: false);
    // quantity = cart.getQuantity(product.productId);

    return InkWell(
      onTap: () {},
      child: Padding(
        padding: const EdgeInsets.only(top: 0.0, bottom: 14.0),
        child: Container(
          decoration: BoxDecoration(
              color: Colors.white,
              borderRadius: BorderRadius.all(Radius.circular(10.0)),
              boxShadow: [
                BoxShadow(
                  color: Color(0xFF656565).withOpacity(0.15),
                  blurRadius: 4.0,
                  spreadRadius: 1.0,
//           offset: Offset(4.0, 10.0)
                )
              ]),
          child: Wrap(
            children: <Widget>[
              Container(
                // color: Colors.green,

                child: Padding(
                  padding:
                      const EdgeInsets.only(left: 8.0, right: 10.0, top: 5.0),
                  child: Column(
                    // crossAxisAlignment: CrossAxisAlignment.sp,
                    mainAxisAlignment: MainAxisAlignment.spaceAround,
                    children: <Widget>[
                      // Padding(padding: EdgeInsets.only(top: 7.0)),
                      Row(
                        children: <Widget>[
                          Container(
                            child: Text(order.orderId == null ? '' :
                              'Order No. : ' + order.orderId!,
                              overflow: TextOverflow.ellipsis,
                              maxLines: 3,
                              // textAlign: TextAlign.justify,
                              style: MyText.headline(context)!.copyWith(
                                  color: MyColors.grey_100_,
                                  letterSpacing: 0.5,
                                  fontSize: 16.0,
                                  fontWeight: FontWeight.bold),
                            ),
                          ),
                          Expanded(
                              child: SizedBox(
                            width: 10.0,
                          )),
                          Container(
                            child: Text(
                              order.orderDate == null ? '' : order.orderDate!,
                                maxLines: 2,
                                textAlign: TextAlign.justify,
                                style: MyText.subhead(context)!.copyWith(
                                    color: MyColors.grey_100_,
                                    letterSpacing: 0.5)),
                          ),
                        ],
                      ),
                      // Divider(
                      //   height: 1.0,
                      // ),
                      SizedBox(height: 5.0),
                      Row(
                        children: <Widget>[
                          Container(
                            child: Row(
                              children: <Widget>[
                                Text('Quantity : ',
                                    maxLines: 1,
                                    textAlign: TextAlign.justify,
                                    style: MyText.subhead(context)!.copyWith(
                                        color: MyColors.grey_100_,
                                        letterSpacing: 0.5)),
                                Text(order.numberOfProducts == null ? '' :order.numberOfProducts!,
                                    maxLines: 1,
                                    textAlign: TextAlign.justify,
                                    style: MyText.subhead(context)!.copyWith(
                                        color: MyColors.grey_100_,
                                        letterSpacing: 0.5,
                                        fontWeight: FontWeight.bold)),
                              ],
                            ),
                          ),
                          Expanded(
                              child: SizedBox(
                            width: 10.0,
                          )),
                          Container(
                            child: Row(
                              children: <Widget>[
                                Text('Amount : ',
                                    maxLines: 1,
                                    textAlign: TextAlign.justify,
                                    style: MyText.subhead(context)!.copyWith(
                                        color: MyColors.grey_100_,
                                        letterSpacing: 0.5)),
                                Text(order.totalAmount == null ? '' : '₹ ' + order.totalAmount!.replaceFirst('.00', ""),
                                    maxLines: 1,
                                    textAlign: TextAlign.justify,
                                    style: MyText.subhead(context)!.copyWith(
                                        color: MyColors.grey_100_,
                                        letterSpacing: 0.5,
                                        fontWeight: FontWeight.bold)),
                              ],
                            ),
                          ),
                        ],
                      ),
                      SizedBox(height: 5.0),
                      Row(
                        children: <Widget>[
                          Container(
                            child: Row(
                              children: <Widget>[
                                Text('Payment Mode : ',
                                    maxLines: 1,
                                    textAlign: TextAlign.justify,
                                    style: MyText.subhead(context)!.copyWith(
                                        color: MyColors.grey_100_,
                                        letterSpacing: 0.5)),
                                Text(order.paymentMode == null ? '' :order.paymentMode!,
                                    maxLines: 1,
                                    textAlign: TextAlign.justify,
                                    style: MyText.subhead(context)!.copyWith(
                                        color: MyColors.grey_100_,
                                        letterSpacing: 0.5,
                                        fontWeight: FontWeight.bold)),
                              ],
                            ),
                          ),
                          Expanded(
                              child: SizedBox(
                            width: 10.0,
                          )),
                          Container(
                            child: Row(
                              children: <Widget>[
                                Text(' ',
                                    maxLines: 1,
                                    textAlign: TextAlign.justify,
                                    style: MyText.subhead(context)!.copyWith(
                                        color: MyColors.grey_100_,
                                        letterSpacing: 0.5)),
                                Text('',
                                  // order.totalAmount == null ? '' : '₹ ' + order.totalAmount.replaceFirst('.00', ""),
                                    maxLines: 1,
                                    textAlign: TextAlign.justify,
                                    style: MyText.subhead(context)!.copyWith(
                                        color: MyColors.grey_100_,
                                        letterSpacing: 0.5,
                                        fontWeight: FontWeight.bold)),
                              ],
                            ),
                          ),
                        ],
                      ),
                      SizedBox(height: 5.0),
                    ],
                  ),
                ),
              ),
              Row(
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                children: [
                  Padding(
                     padding:
                          const EdgeInsets.only(left: 8.0, right: 10.0, top: 5.0),
                    child: Align(
                      alignment: Alignment.bottomLeft,
                        // ignore: deprecated_member_use
                        child: RaisedButton(
                            shape: RoundedRectangleBorder(
                                borderRadius: BorderRadius.circular(10.0),
                                side: BorderSide(color: MyColors.grey_20,)),
                            color: Colors.grey[50],
                            onPressed: () {
                              Navigator.push(
                                        context,
                                        new MaterialPageRoute(
                                            builder: (context) => OrderDetailView(order)));
                            },
                            child: Padding(
                              padding: const EdgeInsets.all(3.0),
                              child: Text(
                                'Details',
                                style: TextStyle(
                                    fontWeight: FontWeight.bold,
                                    color: MyColors.primary,
                                    letterSpacing: 0.5),
                              ),
                            ))),
                  ),
                  Align(
                      alignment: Alignment.bottomRight,
                                      child: Padding(
                      padding: EdgeInsets.only(left: 8.0, right: 10.0, top: 5.0),
                      child: Text(order.deliveryStatus!,
                                  maxLines: 1,
                                  textAlign: TextAlign.justify,
                                  style: MyText.subhead(context)!.copyWith(
                                      color: MyColors.primaryValue,
                                      letterSpacing: 0.5)),
                    ),
                  ),
                ],
              )
            ],
          ),
        ),
      ),
    );
  }
}
