import 'package:drssiddha/app/data/my_colors.dart';
import 'package:drssiddha/app/model/user_model.dart';
import 'package:drssiddha/app/model/user_role_data.dart';
// import 'package:drssiddha/app/pages/home/home.dart';
import 'package:drssiddha/app/pages/login/login.dart';
import 'package:drssiddha/app/provider/auth_provider.dart';
import 'package:drssiddha/app/utility/auth_utils.dart';
import 'package:drssiddha/app/utility/network_utils.dart';
import 'package:drssiddha/app/widget/my_text.dart';
import 'package:dio/dio.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_form_builder/flutter_form_builder.dart';
import 'package:provider/provider.dart';

Pattern pattern =
    r'^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$';

RegExp regex = new RegExp(pattern.toString());

class BecomeMemberPage extends StatefulWidget {
  @override
  _BecomeMemberPageState createState() => _BecomeMemberPageState();
}

class _BecomeMemberPageState extends State<BecomeMemberPage> {
  final GlobalKey<FormState> _fbKey = GlobalKey<FormState>();
  GlobalKey<ScaffoldState> _scaffoldKey = new GlobalKey<ScaffoldState>();
  final TextEditingController passwordController = new TextEditingController();
  String? member;
  bool enabled = true;
  bool _enableBtn = false;
  bool _load = true;
  bool _loadt = false;
  User regData = User();
  User? userData;

  // final focus1 = FocusNode();
  // final focus2 = FocusNode();
  // final focus3 = FocusNode();
  // final focus4 = FocusNode();
  // final focus5 = FocusNode();
  // final focus6 = FocusNode();
  // final focus7 = FocusNode();
  // final focus8 = FocusNode();
  // final focus9 = FocusNode();
  // final focus10 = FocusNode();
  // final focus11 = FocusNode();
  // final focus12 = FocusNode();
  // final focus13 = FocusNode();

  List<UserRole> roleTypes = [];

  @override
  void initState() {
    super.initState();
    _fetchHome();
  }

  _fetchHome() async {
    try {
      FormData formData = new FormData.fromMap({
        'post_data': "1",
        'apikey': AuthUtils.api,
      });
      var responseJson =
          await NetworkUtils.insertData('user_role.php', formData);
      if (responseJson['result'] == 'success') {
        UserRoleData roleTypesdata = UserRoleData.fromJson(responseJson);
        setState(() {
          roleTypes = roleTypesdata.data!;
          _load = false;
        });
      } else {
        NetworkUtils.alertDlg(context, responseJson['msg']);
        setState(() {
          _load = false;
        });
      }
    } catch (error) {
      setState(() {
          _load = false;
        });
      // NetworkUtils.alertDlg(context, error.toString());
    }
  }

  void showMessage(String message, [MaterialColor color = Colors.red]) {
    // ignore: deprecated_member_use
    _scaffoldKey.currentState!.showSnackBar(
        new SnackBar(backgroundColor: color, content: new Text(message)));
  }

  registerUserReg(User userReg) async {
    setState(() {
      _loadt = true;
    });
    try {
      FormData formData = new FormData.fromMap({
        'post_data': "1",
        'apikey': AuthUtils.api,
        'name': userReg.name,
        'user_name': userReg.userName,
        'user_email': userReg.userEmail,
        'user_phonenumber': userReg.userPhone,
        'user_address': userReg.userAddress,
        'user_landmark': userReg.userlandmark,
        'user_district': userReg.district,
        'user_state': userReg.state,
        'user_country': userReg.country,
        'user_pincode': userReg.pincode,
        'doctor_regno': userReg.doctorRegNo,
        'role_id': userReg.roleId,
      });
      var responseJson =
          await NetworkUtils.insertData('registration.php', formData);
      if (responseJson['result'] == 'success') {
        UserModel _userAllData = UserModel.fromJson(responseJson);
        userData = _userAllData.data;
        AuthUtils.save("userdata", userData);
        setState(() {
          _loadt = false;
        });
        NetworkUtils.alertDlgWithRedirect(
            context, "Welcome to Dr\'s.Siddha,", responseJson['msg'], 'home');
        // AuthUtils.insertDetails(_sharedPreferences, responseJson['data']);
        // Navigator.pushReplacementNamed(context, '/home');

      }
      if (responseJson['result'] == 'Doctor_success') {
        setState(() {
          _loadt = false;
        });
        NetworkUtils.alertDlgWithRedirect(
            context, "Welcome to Dr\'s.Siddha,", responseJson['msg'], 'login');
      }
      if (responseJson['result'] == 'error') {
        setState(() {
          _loadt = false;
        });
        NetworkUtils.alertDlg(context, responseJson['msg']);
      }
    } catch (error) {
      setState(() {
        _loadt = false;
      });
      // NetworkUtils.alertDlg(context, error.toString());
    }
  }

  // void _submitForm() async {
  //   final FormBuilderState form = _fbKey.currentState;

  //   if (!form.validate()) {
  //     showMessage('Form is not valid!  Please review and correct.');
  //   } else {
  //     form.save(); //This invokes each onSaved event

  //     print("Form Saved Datas:");
  //     print(regData.name);
  //     print(regData.userName);

  //     Navigator.push(context,
  //         MaterialPageRoute(builder: (BuildContext context) => HomePage()));
  //   }
  // }

  _returnwillPop() {
    Navigator.of(context).pushReplacement(
        PageRouteBuilder(pageBuilder: (_, __, ___) => LoginPage()));
  }

  @override
  Widget build(BuildContext context) {
    final authprov = Provider.of<AuthProvider>(context, listen: false);
    return WillPopScope(
      onWillPop: () async {
        return _returnwillPop();
      },
      child: Scaffold(
        key: _scaffoldKey,
        backgroundColor: Colors.white,
        appBar: AppBar(
          backgroundColor: MyColors.primaryValue,
          automaticallyImplyLeading: false,
          centerTitle: true,
          title: Text(
            "REGISTER",
            style: TextStyle(
              letterSpacing: 0.5,
              // fontFamily: "Gotik",
              fontSize: 18.0,
              color: MyColors.primary,
              // fontWeight: FontWeight.w700
            ),
          ),
          elevation: 0.0,
        ),
        body: SingleChildScrollView(
          padding: EdgeInsets.all(20),
          scrollDirection: Axis.vertical,
          child: Align(
            alignment: Alignment.topCenter,
            child: Container(
              child: Form(
                key: _fbKey,
                // skipDisabled: false,
                // onChanged: () {
                //   setState(() {
                //     _fbKey.currentState!.validate();
                //   });
                // },
                // autovalidate: true,
                autovalidateMode: AutovalidateMode.always,
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: <Widget>[
                    Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: <Widget>[
                        Text("I AM A",
                            style: MyText.body1(context)!
                                .copyWith(color: MyColors.grey_60)),
                        Container(height: 5),
                        Card(
                          shape: RoundedRectangleBorder(
                            borderRadius: BorderRadius.circular(3),
                          ),
                          clipBehavior: Clip.antiAliasWithSaveLayer,
                          margin: EdgeInsets.all(0),
                          elevation: 0,
                          child: Container(
                            // height: 60,
                            alignment: Alignment.centerLeft,
                            padding: EdgeInsets.symmetric(
                                horizontal: 0, vertical: 0.0),
                            child: FormBuilderDropdown(
                              name: "type",
                              decoration: InputDecoration(
                                  contentPadding: EdgeInsets.symmetric(
                                      horizontal: 10.0, vertical: 0),
                                  border: OutlineInputBorder(
                                      borderRadius:
                                          BorderRadius.circular(0.0))),
                              // initialValue: 'Male',
                              // hint: Text('Select Gender'),
                              validator: FormBuilderValidators.compose([
                                FormBuilderValidators.required(context),
                                // FormBuilderValidators.required(
                                //     errorText: "Please select member type");
                              ]),
                              items: roleTypes
                                  .map((ftype) => DropdownMenuItem(
                                      value: ftype, child: Text(ftype.role!)))
                                  .toList(),
                              onChanged: (UserRole? val) {
                                // FocusScope.of(context).requestFocus(focus1);
                                setState(() {
                                  member = val!.role;
                                  regData.roleId = val.roleId;
                                  print(member);
                                });
                              },
                            ),
                          ),
                        ),
                      ],
                    ),
                    member == 'Doctor' ? Container(height: 15) : Container(),
                    member == 'Doctor'
                        ? Align(
                            alignment: Alignment.bottomLeft,
                            child: Text("REGISTER NUMBER",
                                style: MyText.body1(context)!
                                    .copyWith(color: MyColors.grey_60)))
                        : Container(),
                    member == 'Doctor' ? Container(height: 5) : Container(),
                    member == 'Doctor'
                        ? Card(
                            shape: RoundedRectangleBorder(
                              borderRadius: BorderRadius.circular(3),
                            ),
                            clipBehavior: Clip.antiAliasWithSaveLayer,
                            margin: EdgeInsets.all(0.0),
                            elevation: 0,
                            child: Padding(
                              padding:
                                  const EdgeInsets.only(top: 0.0, bottom: 0.0),
                              child: Container(
                                alignment: Alignment.centerLeft,
                                padding: EdgeInsets.symmetric(
                                    horizontal: 0, vertical: 0.0),
                                child: FormBuilderTextField(
                                  // onFieldSubmitted: (val) {
                                  //   FocusScope.of(context).requestFocus(focus2);
                                  // },
                                  // focusNode: focus1,
                                  name: "REGISTER NUMBER",
                                  decoration: InputDecoration(
                                      contentPadding: EdgeInsets.symmetric(
                                          horizontal: 10.0, vertical: 0),
                                      hintText: "REGISTER NUMBER",
                                      //  labelText: "REGISTER NUMBER",
                                      border: OutlineInputBorder(
                                          borderRadius:
                                              BorderRadius.circular(3.0))),
                                  // validator: FormBuilderValidators.compose([
                                  //   FormBuilderValidators.required(context,
                                  //       errorText: "Register Number required"),
                                  //   // FormBuilderValidators.required(
                                  //   //     errorText: "Register Number required"),
                                  //   FormBuilderValidators.numeric(context),
                                  //   FormBuilderValidators.minLength(context, 15),
                                  //   FormBuilderValidators.maxLength(context, 20),
                                  // ]),
                                  onChanged: (value) {
                                    setState(() {
                                      regData.doctorRegNo = value;
                                    });
                                  },
                                ),
                              ),
                            ),
                          )
                        : Container(),
                    Container(height: 15),
                    
                    Align(
                        alignment: Alignment.bottomLeft,
                        child: Text("NAME",
                            style: MyText.body1(context)!
                                .copyWith(color: MyColors.grey_60))),
                    Container(height: 5),
                    Card(
                      shape: RoundedRectangleBorder(
                        borderRadius: BorderRadius.circular(3),
                      ),
                      clipBehavior: Clip.antiAliasWithSaveLayer,
                      margin: EdgeInsets.all(0),
                      elevation: 0,
                      child: Padding(
                        padding: const EdgeInsets.only(top: 0.0, bottom: 0.0),
                        child: Container(
                          alignment: Alignment.centerLeft,
                          padding: EdgeInsets.symmetric(
                              horizontal: 0, vertical: 0.0),
                          child: FormBuilderTextField(
                            // onFieldSubmitted: (val) {
                            //   FocusScope.of(context).requestFocus(focus3);
                            // },
                            // focusNode: focus2,
                            name: "Name",
                            decoration: InputDecoration(
                                contentPadding: EdgeInsets.symmetric(
                                    horizontal: 10.0, vertical: 0),
                                hintText: "NAME",
                                //  labelText: "REGISTER NUMBER",
                                border: OutlineInputBorder(
                                    borderRadius: BorderRadius.circular(3.0))),
                            validator: FormBuilderValidators.compose([
                              FormBuilderValidators.required(context,
                                  errorText: "Name required"),

                              // FormBuilderValidators.numeric(),
                              // FormBuilderValidators.max(6),
                            ]),
                            onSaved: (value) {
                              setState(() {
                                regData.name = value;
                              });
                            },
                          ),
                        ),
                      ),
                    ),
                    Container(height: 15),
                    Align(
                        alignment: Alignment.bottomLeft,
                        child: Text("USER NAME",
                            style: MyText.body1(context)!
                                .copyWith(color: MyColors.grey_60))),
                    Container(height: 5),
                    Card(
                      shape: RoundedRectangleBorder(
                        borderRadius: BorderRadius.circular(3),
                      ),
                      clipBehavior: Clip.antiAliasWithSaveLayer,
                      margin: EdgeInsets.all(0),
                      elevation: 0,
                      child: Padding(
                        padding: const EdgeInsets.only(top: 0.0, bottom: 0.0),
                        child: Container(
                          alignment: Alignment.centerLeft,
                          padding: EdgeInsets.symmetric(
                              horizontal: 0, vertical: 0.0),
                          child: FormBuilderTextField(
                            // onFieldSubmitted: (val) {
                            //   FocusScope.of(context).requestFocus(focus4);
                            // },
                            // focusNode: focus3,
                            name: "UserName",
                            decoration: InputDecoration(
                                contentPadding: EdgeInsets.symmetric(
                                    horizontal: 10.0, vertical: 0),
                                hintText: "USER NAME",
                                //  labelText: "REGISTER NUMBER",
                                border: OutlineInputBorder(
                                    borderRadius: BorderRadius.circular(3.0))),
                            validator: FormBuilderValidators.compose([
                              FormBuilderValidators.required(context,
                                  errorText: "User Name required"),
                              // FormBuilderValidators.numeric(),
                              // FormBuilderValidators.max(6),
                            ]),
                            onSaved: (value) {
                              setState(() {
                                regData.userName = value;
                              });
                            },
                          ),
                        ),
                      ),
                    ),
                    Container(height: 15),
                    Align(
                        alignment: Alignment.bottomLeft,
                        child: Text("MOBILE",
                            style: MyText.body1(context)!
                                .copyWith(color: MyColors.grey_60))),
                    Container(height: 5),
                    Card(
                      shape: RoundedRectangleBorder(
                        borderRadius: BorderRadius.circular(3),
                      ),
                      clipBehavior: Clip.antiAliasWithSaveLayer,
                      margin: EdgeInsets.all(0),
                      elevation: 0,
                      child: Padding(
                        padding: const EdgeInsets.only(top: 0.0, bottom: 0.0),
                        child: Container(
                          alignment: Alignment.centerLeft,
                          padding: EdgeInsets.symmetric(
                              horizontal: 0, vertical: 0.0),
                          child: FormBuilderTextField(
                            keyboardType: TextInputType.number,
                            // onFieldSubmitted: (val) {
                            //   FocusScope.of(context).requestFocus(focus5);
                            // },
                            // focusNode: focus4,
                            name: "Mobile",
                            decoration: InputDecoration(
                                contentPadding: EdgeInsets.symmetric(
                                    horizontal: 10.0, vertical: 0),
                                hintText: "MOBILE NUMBER",
                                //  labelText: "REGISTER NUMBER",
                                border: OutlineInputBorder(
                                    borderRadius: BorderRadius.circular(3.0))),
                            validator: FormBuilderValidators.compose([
                              FormBuilderValidators.required(context,
                                  errorText: "Mobile number required"),
                              FormBuilderValidators.numeric(context),
                              FormBuilderValidators.minLength(context, 10),
                              FormBuilderValidators.maxLength(context, 10),
                            ]),
                            onSaved: (value) {
                              setState(() {
                                regData.userPhone = value;
                              });
                            },
                          ),
                        ),
                      ),
                    ),
                    Container(height: 15),
                    Align(
                        alignment: Alignment.bottomLeft,
                        child: Text("EMAIL",
                            style: MyText.body1(context)!
                                .copyWith(color: MyColors.grey_60))),
                    Container(height: 5),
                    Card(
                      shape: RoundedRectangleBorder(
                        borderRadius: BorderRadius.circular(3),
                      ),
                      clipBehavior: Clip.antiAliasWithSaveLayer,
                      margin: EdgeInsets.all(0),
                      elevation: 0,
                      child: Padding(
                        padding: const EdgeInsets.only(top: 0.0, bottom: 0.0),
                        child: Container(
                          alignment: Alignment.centerLeft,
                          padding: EdgeInsets.symmetric(
                              horizontal: 0, vertical: 0.0),
                          child: FormBuilderTextField(
                            keyboardType: TextInputType.emailAddress,
                            // onFieldSubmitted: (val) {
                            //   FocusScope.of(context).requestFocus(focus6);
                            // },
                            // focusNode: focus5,
                            name: "Email",
                            decoration: InputDecoration(
                                contentPadding: EdgeInsets.symmetric(
                                    horizontal: 10.0, vertical: 0),
                                hintText: "EMAIL",
                                //  labelText: "REGISTER NUMBER",
                                border: OutlineInputBorder(
                                    borderRadius: BorderRadius.circular(3.0))),
                            validator: FormBuilderValidators.compose([
                              FormBuilderValidators.required(context,
                                  errorText: "Email required"),
                              FormBuilderValidators.email(context),
                              // FormBuilderValidators.max(6),
                            ]),
                            onSaved: (value) {
                              setState(() {
                                regData.userEmail = value;
                              });
                            },
                          ),
                        ),
                      ),
                    ),
                    Container(height: 15),
                    Align(
                        alignment: Alignment.bottomLeft,
                        child: Text("ADDRESS",
                            style: MyText.body1(context)!
                                .copyWith(color: MyColors.grey_60))),
                    Container(height: 5),
                    Card(
                      shape: RoundedRectangleBorder(
                        borderRadius: BorderRadius.circular(3),
                      ),
                      clipBehavior: Clip.antiAliasWithSaveLayer,
                      margin: EdgeInsets.all(0),
                      elevation: 0,
                      child: Padding(
                        padding: const EdgeInsets.only(top: 0.0, bottom: 0.0),
                        child: Container(
                          alignment: Alignment.centerLeft,
                          padding: EdgeInsets.symmetric(
                              horizontal: 0, vertical: 0.0),
                          child: FormBuilderTextField(
                            maxLines: 6,
                            // onFieldSubmitted: (val) {
                            //   FocusScope.of(context).requestFocus(focus7);
                            // },
                            // focusNode: focus6,
                            name: "address",
                            decoration: InputDecoration(
                                contentPadding: EdgeInsets.symmetric(
                                    horizontal: 10.0, vertical: 10),
                                hintText: "ADDRESS",
                                //  labelText: "REGISTER NUMBER",
                                border: OutlineInputBorder(
                                    borderRadius: BorderRadius.circular(3.0))),
                            validator: FormBuilderValidators.compose([
                              FormBuilderValidators.required(context,
                                  errorText: "Address required"),
                              // FormBuilderValidators.numeric(),
                              // FormBuilderValidators.max(6),
                            ]),
                            onSaved: (value) {
                              setState(() {
                                regData.userAddress = value;
                              });
                            },
                          ),
                        ),
                      ),
                    ),
                    Container(height: 15),
                    Align(
                        alignment: Alignment.bottomLeft,
                        child: Text("LANDMARK",
                            style: MyText.body1(context)!
                                .copyWith(color: MyColors.grey_60))),
                    Container(height: 5),
                    Card(
                      shape: RoundedRectangleBorder(
                        borderRadius: BorderRadius.circular(3),
                      ),
                      clipBehavior: Clip.antiAliasWithSaveLayer,
                      margin: EdgeInsets.all(0),
                      elevation: 0,
                      child: Padding(
                        padding: const EdgeInsets.only(top: 0.0, bottom: 0.0),
                        child: Container(
                          alignment: Alignment.centerLeft,
                          padding: EdgeInsets.symmetric(
                              horizontal: 0, vertical: 0.0),
                          child: FormBuilderTextField(
                            // onFieldSubmitted: (val) {
                            //   FocusScope.of(context).requestFocus(focus8);
                            // },
                            // focusNode: focus7,
                            name: "Landmark",
                            decoration: InputDecoration(
                                contentPadding: EdgeInsets.symmetric(
                                    horizontal: 10.0, vertical: 0),
                                hintText: "LANDMARK",
                                //  labelText: "REGISTER NUMBER",
                                border: OutlineInputBorder(
                                    borderRadius: BorderRadius.circular(3.0))),
                            validator: FormBuilderValidators.compose([
                              FormBuilderValidators.required(context,
                                  errorText: "Landmark required"),
                              // FormBuilderValidators.numeric(),
                              // FormBuilderValidators.max(6),
                            ]),
                            onSaved: (value) {
                              setState(() {
                                regData.userlandmark = value;
                              });
                            },
                          ),
                        ),
                      ),
                    ),
                    Container(height: 15),
                    Align(
                        alignment: Alignment.bottomLeft,
                        child: Text("DISTRICT",
                            style: MyText.body1(context)!
                                .copyWith(color: MyColors.grey_60))),
                    Container(height: 5),
                    Card(
                      shape: RoundedRectangleBorder(
                        borderRadius: BorderRadius.circular(3),
                      ),
                      clipBehavior: Clip.antiAliasWithSaveLayer,
                      margin: EdgeInsets.all(0),
                      elevation: 0,
                      child: Padding(
                        padding: const EdgeInsets.only(top: 0.0, bottom: 0.0),
                        child: Container(
                          alignment: Alignment.centerLeft,
                          padding: EdgeInsets.symmetric(
                              horizontal: 0, vertical: 0.0),
                          child: FormBuilderTextField(
                            // onFieldSubmitted: (val) {
                            //   FocusScope.of(context).requestFocus(focus9);
                            // },
                            // focusNode: focus8,
                            name: "District",
                            decoration: InputDecoration(
                                contentPadding: EdgeInsets.symmetric(
                                    horizontal: 10.0, vertical: 0),
                                hintText: "DISTRICT",
                                //  labelText: "REGISTER NUMBER",
                                border: OutlineInputBorder(
                                    borderRadius: BorderRadius.circular(3.0))),
                            validator: FormBuilderValidators.compose([
                              FormBuilderValidators.required(context,
                                  errorText: "District required"),
                              // FormBuilderValidators.numeric(),
                              // FormBuilderValidators.max(6),
                            ]),
                            onSaved: (value) {
                              setState(() {
                                regData.district = value;
                              });
                            },
                          ),
                        ),
                      ),
                    ),
                    Container(height: 15),
                    Align(
                        alignment: Alignment.bottomLeft,
                        child: Text("STATE",
                            style: MyText.body1(context)!
                                .copyWith(color: MyColors.grey_60))),
                    Container(height: 5),
                    Card(
                      shape: RoundedRectangleBorder(
                        borderRadius: BorderRadius.circular(3),
                      ),
                      clipBehavior: Clip.antiAliasWithSaveLayer,
                      margin: EdgeInsets.all(0),
                      elevation: 0,
                      child: Padding(
                        padding: const EdgeInsets.only(top: 0.0, bottom: 0.0),
                        child: Container(
                          alignment: Alignment.centerLeft,
                          padding: EdgeInsets.symmetric(
                              horizontal: 0, vertical: 0.0),
                          child: FormBuilderTextField(
                            // onFieldSubmitted: (val) {
                            //   FocusScope.of(context).requestFocus(focus10);
                            // },
                            // focusNode: focus9,
                            name: "State",
                            decoration: InputDecoration(
                                contentPadding: EdgeInsets.symmetric(
                                    horizontal: 10.0, vertical: 0),
                                hintText: "STATE",
                                //  labelText: "REGISTER NUMBER",
                                border: OutlineInputBorder(
                                    borderRadius: BorderRadius.circular(3.0))),
                            validator: FormBuilderValidators.compose([
                              FormBuilderValidators.required(context,
                                  errorText: "State required"),
                              // FormBuilderValidators.numeric(),
                              // FormBuilderValidators.max(6),
                            ]),
                            onSaved: (value) {
                              setState(() {
                                regData.state = value;
                              });
                            },
                          ),
                        ),
                      ),
                    ),
                    Container(height: 15),
                    Align(
                        alignment: Alignment.bottomLeft,
                        child: Text("COUNTRY",
                            style: MyText.body1(context)!
                                .copyWith(color: MyColors.grey_60))),
                    Container(height: 5),
                    Card(
                      shape: RoundedRectangleBorder(
                        borderRadius: BorderRadius.circular(3),
                      ),
                      clipBehavior: Clip.antiAliasWithSaveLayer,
                      margin: EdgeInsets.all(0),
                      elevation: 0,
                      child: Padding(
                        padding: const EdgeInsets.only(top: 0.0, bottom: 0.0),
                        child: Container(
                          alignment: Alignment.centerLeft,
                          padding: EdgeInsets.symmetric(
                              horizontal: 0, vertical: 0.0),
                          child: FormBuilderTextField(
                            // onFieldSubmitted: (val) {
                            //   FocusScope.of(context).requestFocus(focus11);
                            // },
                            // focusNode: focus10,
                            name: "Country",
                            decoration: InputDecoration(
                                contentPadding: EdgeInsets.symmetric(
                                    horizontal: 10.0, vertical: 0),
                                hintText: "COUNTRY",
                                //  labelText: "REGISTER NUMBER",
                                border: OutlineInputBorder(
                                    borderRadius: BorderRadius.circular(3.0))),
                            validator: FormBuilderValidators.compose([
                              FormBuilderValidators.required(context,
                                  errorText: "Country required"),
                              // FormBuilderValidators.numeric(),
                              // FormBuilderValidators.max(6),
                            ]),
                            onSaved: (value) {
                              setState(() {
                                regData.country = value;
                              });
                            },
                          ),
                        ),
                      ),
                    ),
                    Container(height: 15),
                    Align(
                        alignment: Alignment.bottomLeft,
                        child: Text("ZIPCODE",
                            style: MyText.body1(context)!
                                .copyWith(color: MyColors.grey_60))),
                    Container(height: 5),
                    Card(
                      shape: RoundedRectangleBorder(
                        borderRadius: BorderRadius.circular(3),
                      ),
                      clipBehavior: Clip.antiAliasWithSaveLayer,
                      margin: EdgeInsets.all(0),
                      elevation: 0,
                      child: Padding(
                        padding: const EdgeInsets.only(top: 0.0, bottom: 0.0),
                        child: Container(
                          alignment: Alignment.centerLeft,
                          padding: EdgeInsets.symmetric(
                              horizontal: 0, vertical: 0.0),
                          child: FormBuilderTextField(
                            // focusNode: focus12,
                            name: "Zipcode",
                            keyboardType: TextInputType.number,
                            decoration: InputDecoration(
                                contentPadding: EdgeInsets.symmetric(
                                    horizontal: 10.0, vertical: 0),
                                hintText: "ZIPCODE",
                                //  labelText: "REGISTER NUMBER",
                                border: OutlineInputBorder(
                                    borderRadius: BorderRadius.circular(3.0))),
                            validator: FormBuilderValidators.compose([
                              FormBuilderValidators.required(context,
                                  errorText: "Postal code required"),
                              FormBuilderValidators.numeric(context),
                              FormBuilderValidators.minLength(context, 6),
                              FormBuilderValidators.maxLength(context, 6),
                            ]),
                            onSaved: (value) {
                              setState(() {
                                regData.pincode = value;
                              });
                            },
                          ),
                        ),
                      ),
                    ),
                    Container(height: 30),
                    _loadt == true
                        ? Container(
                            height: 50,
                            child: Center(
                              child: CircularProgressIndicator(),
                            ))
                        : Container(
                            width: double.infinity,
                            height: 45,
                            // ignore: deprecated_member_use
                            child: FlatButton(
                              child: Text("REGISTER",
                                  style: MyText.subhead(context)!.copyWith(
                                      fontWeight: FontWeight.bold,
                                      color: Colors.white,
                                      letterSpacing: 0.5)),
                              color: MyColors.primary,
                              onPressed: () {
                                      setState(() {
                                        enabled = false;
                                      });
                                      print(regData.name);
                                      final FormState form =
                                          _fbKey.currentState!;

                                      if (!form.validate()) {
                                        showMessage(
                                            'Form is not valid!  Please review and correct.');
                                      } else {
                                        form.save(); //This invokes each onSaved event

                                        print("Form Saved Datas:");

                                        form.save(); //This invokes each onSaved event
                                        print(
                                            '========================================');
                                        print('Submitting to back end...');

                                        registerUserReg(regData);
                                      }
                                    },
                            ),
                          ),
                    SizedBox(height: 20.0),
                    Container(
                      width: double.infinity,
                      // ignore: deprecated_member_use
                      child: FlatButton(
                        child: Text(
                          "Already have an Account? Please Signin",
                          textAlign: TextAlign.center,
                          style: TextStyle(
                              color: MyColors.primary,
                              letterSpacing: 1.0,
                              fontSize: 16.0),
                        ),
                        color: Colors.transparent,
                        onPressed: () {
                          Navigator.pushReplacement(
                              context,
                              MaterialPageRoute(
                                  builder: (BuildContext ctx) => LoginPage()));
                        },
                      ),
                    ),
                  ],
                ),
              ),
            ),
          ),
        ),
      ),
    );
  }
}
