import 'package:drssiddha/app/pages/login/login.dart';
import 'package:drssiddha/app/utility/auth_utils.dart';
import 'package:flutter/material.dart';
import 'package:shared_preferences/shared_preferences.dart';

class Logout extends StatefulWidget {

  @override
  State<StatefulWidget> createState() {
    return new _LogoutPage();
  }
}

class _LogoutPage extends State<Logout> {
  @override
  void initState() {
    super.initState();
    _fetchSessionAndNavigate();
  }

  _fetchSessionAndNavigate() async {
    SharedPreferences prefs = await SharedPreferences.getInstance();
    AuthUtils.remove("userdata");
    prefs.remove('sameAddress');
    prefs.clear();
    SharedPreferences pref = await SharedPreferences.getInstance();
    await pref.setBool('seen', true);
    Navigator.pushReplacement(
        context, MaterialPageRoute(builder: (BuildContext ctx) => LoginPage()));
  }

  @override
  Widget build(BuildContext context) {
    return new Scaffold(
        //	key: _scaffoldKey,
        body: new Container(
      margin: const EdgeInsets.symmetric(horizontal: 16.0),
      child: new Column(
        crossAxisAlignment: CrossAxisAlignment.stretch,
      ),
    ));
  }
}
