import 'package:dio/dio.dart';
import 'package:drssiddha/app/model/user_model.dart';
import 'package:drssiddha/app/pages/home/home.dart';
import 'package:drssiddha/app/pages/login/forgot_password.dart';
import 'package:drssiddha/app/pages/login/register_user.dart';
import 'package:drssiddha/app/utility/auth_utils.dart';
import 'package:drssiddha/app/utility/network_utils.dart';
import 'package:flutter/material.dart';
import 'package:drssiddha/app/data/my_colors.dart';
import 'package:drssiddha/app/widget/my_text.dart';
import 'package:flutter/services.dart';
import 'package:drssiddha/app/provider/auth_provider.dart';
import 'package:package_info/package_info.dart';
import 'package:shared_preferences/shared_preferences.dart';

Pattern pattern =
    r'^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$';

RegExp regex = new RegExp(pattern.toString());

class LoginPage extends StatefulWidget {
  LoginPage();

  @override
  LoginPageState createState() => new LoginPageState();
}

class LoginPageState extends State<LoginPage> {
  final GlobalKey<FormState> _formKey = new GlobalKey<FormState>();
  GlobalKey<ScaffoldState> _scaffoldKey = new GlobalKey<ScaffoldState>();

  LoginData _loginUser = LoginData();
  User? userData;
  bool _load = false;
  String textValue = '';
  String customerId = '0';
  //  if (!(regex.hasMatch(value)))
  //     return "Invalid Email";
  PackageInfo _packageInfo = PackageInfo(
    appName: 'Unknown',
    packageName: 'Unknown',
    version: 'Unknown',
    buildNumber: 'Unknown',
  );

  @override
  void initState() {
    super.initState();
    NetworkUtils.checkDataConnectivity(context, 'home');
    _fetchSessionAndNavigate();
  }

  _fetchSessionAndNavigate() async {
    userData = await AuthUtils.loadSharedPrefs();
    // print(userData.userId);
    // print(userData.userName);
    // ignore: unnecessary_null_comparison
    if (userData != null) {
      Navigator.pushReplacement(context,
          MaterialPageRoute(builder: (BuildContext ctx) => HomePage()));
    }
    // _load = false;
    SharedPreferences prefs = await SharedPreferences.getInstance();
    if(!prefs.containsKey('authtoken')) {
      //authToken = prefs.getString('authtoken')!;
      fetchHome();
    }
  }

  void fetchHome() async {
    final PackageInfo info = await PackageInfo.fromPlatform();
    setState(() {
      _packageInfo = info;
      _load = true;
    });
    try {
      FormData formData = new FormData.fromMap({
        'customer_id': 0,
        'post_data': 'drssiddha',
        'version': _packageInfo.version,
        'token': textValue
      });
      
      NetworkUtils.getAuthToken('/login', formData);
      setState(() {
        _load = false;
      });
      return null;
    } catch (e) {
      setState(() {
        _load = false;
      });
      // NetworkUtils.alertDlg(context, e.toString());

      print('Server Exception!!!');
      print(e);
      return null;
    }
  }

  void showMessage(String message, [MaterialColor color = Colors.red]) {
    // ignore: deprecated_member_use
    _scaffoldKey.currentState!.showSnackBar(
        new SnackBar(backgroundColor: color, content: new Text(message)));
  }

  loginUserSubmit(LoginData loginUser) async {
    final PackageInfo info = await PackageInfo.fromPlatform();
    setState(() {
      _packageInfo = info;
      _load = true;
    });
    
    try {
      FormData formData = new FormData.fromMap({
        'post_data': "1",
        'apikey': AuthUtils.api,
        'username': loginUser.email,
        'password': loginUser.password,
        'version': _packageInfo.version,
      });
      var responseJson = await NetworkUtils.insertData('login.php', formData);
      if(responseJson['result'] == 'TokenError') {
        setState(() {
          _load = true;
        });
        //NetworkUtils.alertDlg(context, responseJson['msg']);
        NetworkUtils.getAuthToken('/home', formData);
        return null; 
      }
      if (responseJson['result'] == 'success') {
        // final prefs = await SharedPreferences.getInstance();
        UserModel _userAllData = UserModel.fromJson(responseJson);
        userData = _userAllData.data!;
        AuthUtils.save("userdata", userData);
setState(() {
      _load = false;
    });
        Navigator.pushReplacement(context,
            MaterialPageRoute(builder: (BuildContext ctx) => HomePage()));
        // AuthUtils.insertDetails(_sharedPreferences, responseJson['data']);
        // Navigator.pushReplacementNamed(context, '/home');

      } else {
        setState(() {
      _load = false;
    });
        NetworkUtils.alertDlg(context, responseJson['msg']);
      }
    } catch (error) {
      setState(() {
      _load = false;
    });
      // NetworkUtils.alertDlg(context, error.toString());
    }
  }

  Future<bool> _onWillPop() async {
    bool result = await showDialog(
        context: context,
        builder: (context) => Dialog(
              backgroundColor: Colors.transparent,
              child: Container(
                child: Card(
                  shape: RoundedRectangleBorder(
                    borderRadius: BorderRadius.circular(4),
                  ),
                  color: Colors.white,
                  clipBehavior: Clip.antiAliasWithSaveLayer,
                  child: Column(
                    mainAxisSize: MainAxisSize.min,
                    children: <Widget>[
                      Container(
                        width: double.infinity,
                        color: MyColors.primaryValue,
                        child: Image.asset(
                          'assets/images/drs-logo.png', width: 150.0,
                          height: 50,
                          // color: Colors.white,
                        ),
                        // width: 150,
                        // height: 50,
                      ),
                      Container(
                        alignment: Alignment.centerLeft,
                        padding: EdgeInsets.symmetric(horizontal: 15),
                        width: double.infinity,
                        height: 50,
                        color: Colors.white,
                        child: Text("Confirm Exit?",
                            style: MyText.title(context)!
                                .copyWith(color: MyColors.primary)),
                      ),
                      Container(
                        padding: EdgeInsets.fromLTRB(15, 10, 15, 0),
                        child: Text(
                            'Are you sure you want to exit the app? Tap \'Yes\' to exit \'No\' to cancel.',
                            style: MyText.body1(context)!
                                .copyWith(color: MyColors.grey_100_)),
                      ),
                      Row(
                        mainAxisAlignment: MainAxisAlignment.end,
                        children: <Widget>[
                          // ignore: deprecated_member_use
                          new FlatButton(
                            child: Text("No"),
                            textColor: Colors.red[700],
                            color: Colors.transparent,
                            onPressed: () {
                              Navigator.pop(context);
                            },
                          ),
                          // ignore: deprecated_member_use
                          FlatButton(
                            child: Text("Yes"),
                            textColor: MyColors.primary,
                            color: Colors.transparent,
                            onPressed: () {
                              // bloc1.toStoreCartItems();
                              SystemChannels.platform
                                  .invokeMethod('SystemNavigator.pop');
                            },
                          )
                        ],
                      )
                    ],
                  ),
                ),
              ),
            ));
    return result;
  }

  

  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      // onWillPop: _onWillPop,
      onWillPop: _onWillPop,
      child: new Scaffold(
        key: _scaffoldKey,
        // resizeToAvoidBottomInset: true,
        // resizeToAvoidBottomPadding: true,
        backgroundColor: Colors.white,
        appBar: PreferredSize(
            preferredSize: Size.fromHeight(0),
            child: Container(color: MyColors.primary)),
        body: ListView(
          children: <Widget>[
            Stack(
              children: <Widget>[
                Container(
                    color: MyColors.primaryValue,
                    height: MediaQuery.of(context).size.height / 2.7),
                Column(
                  children: <Widget>[
                    Container(height: MediaQuery.of(context).size.height / 10),
                    Container(
                      child: Image.asset(
                        'assets/images/drs-logo.png',
                        // color: Colors.white,
                      ),
                      width: 150,
                      height: 80,
                    ),
                    Card(
                        // shape: RoundedRectangleBorder( borderRadius: BorderRadius.circular(6)),
                        margin: EdgeInsets.all(25),
                        // clipBehavior: Clip.antiAliasWithSaveLayer,
                        child: Container(
                          padding: EdgeInsets.symmetric(
                              vertical: 20, horizontal: 20),
                          child: Column(
                            mainAxisSize: MainAxisSize.min,
                            children: <Widget>[
                              Container(height: 15),
                              Text("SIGN IN",
                                  style: MyText.title(context)!.copyWith(
                                      color: MyColors.primary,
                                      letterSpacing: 1.2,
                                      fontWeight: FontWeight.bold)),
                              Form(
                                key: _formKey,
                                child: Column(
                                  children: [
                                    TextFormField(
                                      validator: (value) {
                                        if (value!.isEmpty) {
                                          return 'User name is required';
                                        }
                                        // if (!(regex.hasMatch(value))) {
                                        //   return 'Invalid Email';
                                        // }
                                        return null;
                                      },
                                      keyboardType: TextInputType.emailAddress,
                                      style: TextStyle(
                                          color: MyColors.grey_100_,
                                          fontWeight: FontWeight.bold),
                                      decoration: InputDecoration(
                                        labelText: "User Name",
                                        labelStyle: TextStyle(
                                          letterSpacing: 0.5,
                                          color: MyColors.grey_60,
                                        ),
                                        enabledBorder: UnderlineInputBorder(
                                          borderSide: BorderSide(
                                              color: MyColors.grey_60,
                                              width: 1),
                                        ),
                                        focusedBorder: UnderlineInputBorder(
                                          borderSide: BorderSide(
                                              color: MyColors.grey_60,
                                              width: 2),
                                        ),
                                      ),
                                      onChanged: (value) {
                                        setState(() {
                                          _loginUser.email = value;
                                        });
                                      },
                                    ),
                                    Container(height: 20),
                                    TextFormField(
                                      validator: (value) {
                                        if (value!.isEmpty) {
                                          return 'Password is required';
                                        }

                                        return null;
                                      },
                                      onChanged: (value) {
                                        setState(() {
                                          _loginUser.password = value;
                                        });
                                      },
                                      onFieldSubmitted: (value) {
                                        final FormState form =
                                            _formKey.currentState!;

                                        if (!form.validate()) {
                                          showMessage(
                                              'Form is not valid!  Please review and correct.');
                                        } else {
                                          form.save(); //This invokes each onSaved event

                                          print("Form Saved Datas:");
                                          loginUserSubmit(_loginUser);
                                        }
                                      },
                                      textInputAction: TextInputAction.go,
                                      obscureText: true,
                                      keyboardType: TextInputType.text,
                                      style: TextStyle(
                                          color: MyColors.grey_100_,
                                          fontWeight: FontWeight.bold),
                                      decoration: InputDecoration(
                                        labelText: "Password",
                                        labelStyle: TextStyle(
                                          letterSpacing: 0.5,
                                          color: MyColors.grey_60,
                                        ),
                                        enabledBorder: UnderlineInputBorder(
                                          borderSide: BorderSide(
                                              color: MyColors.grey_60,
                                              width: 1),
                                        ),
                                        focusedBorder: UnderlineInputBorder(
                                          borderSide: BorderSide(
                                              color: MyColors.grey_60,
                                              width: 2),
                                        ),
                                      ),
                                    ),
                                    Container(height: 40),
                                    _load == true
                                        ? Container(
                                            height: 50,
                                            child: Center(
                                              child:
                                                  CircularProgressIndicator(),
                                            ))
                                        : Container(
                                            width: double.infinity,
                                            height: 40,
                                            // ignore: deprecated_member_use
                                            child: FlatButton(
                                              child: Text(
                                                "SUBMIT",
                                                style: TextStyle(
                                                    letterSpacing: 1.5,
                                                    color: Colors.white,
                                                    fontSize: 16),
                                              ),
                                              color: MyColors.primary,
                                              // shape: RoundedRectangleBorder(
                                              //     borderRadius: new BorderRadius.circular(20)
                                              // ),
                                              onPressed: () {
                                                final FormState form =
                                                    _formKey.currentState!;

                                                if (!form.validate()) {
                                                  showMessage(
                                                      'Form is not valid!  Please review and correct.');
                                                } else {
                                                  form.save(); //This invokes each onSaved event

                                                  print("Form Saved Datas:");
                                                  loginUserSubmit(_loginUser);
                                                }
                                              },
                                            ),
                                          ),
                                  ],
                                ),
                              ),
                              Container(height: 10),
                              Container(
                                // alignment: Alignment.topRight,

                                width: MediaQuery.of(context).size.width,
                                // ignore: deprecated_member_use
                                child: FlatButton(
                                  padding: EdgeInsets.only(right: 0.0),
                                  child: Align(
                                    alignment: Alignment.topRight,
                                    child: Text(
                                      "Forgot Password",
                                      textAlign: TextAlign.right,
                                      style: TextStyle(
                                          color: MyColors.grey_60,
                                          letterSpacing: 1.5,
                                          fontWeight: FontWeight.w600),
                                    ),
                                  ),
                                  color: Colors.transparent,
                                  onPressed: () {
                                    Navigator.pushReplacement(
                                        context,
                                        MaterialPageRoute(
                                            builder: (BuildContext ctx) =>
                                                ForgotPasswordPage()));
                                  },
                                ),
                              ),
                              SizedBox(height: 0.0),
                              Container(
                                width: MediaQuery.of(context).size.width,
                                // ignore: deprecated_member_use
                                child: FlatButton(
                                  child: Text(
                                    "New user? Sign Up",
                                    style: TextStyle(
                                        color: MyColors.primary,
                                        letterSpacing: 1.0,
                                        fontSize: 16.0),
                                  ),
                                  color: Colors.transparent,
                                  onPressed: () {
                                    Navigator.pushReplacement(
                                        context,
                                        MaterialPageRoute(
                                            builder: (BuildContext ctx) =>
                                                BecomeMemberPage()));
                                  },
                                ),
                              ),
                            ],
                          ),
                        ))
                  ],
                )
              ],
            ),
          ],
        ),
      ),
    );
  }
}
