import 'package:drssiddha/app/utility/auth_utils.dart';
import 'package:drssiddha/app/utility/network_utils.dart';
import 'package:drssiddha/app/pages/login/login.dart';
import 'package:drssiddha/app/widget/my_text.dart';
import 'package:dio/dio.dart';
import 'package:flutter/material.dart';
import 'package:drssiddha/app/data/my_colors.dart';
import 'package:flutter/services.dart';

Pattern pattern =
    r'^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$';

RegExp regex = new RegExp(pattern.toString());

class ForgotPasswordPage extends StatefulWidget {
  ForgotPasswordPage();

  @override
  ForgotPasswordPageState createState() => new ForgotPasswordPageState();
}

class ForgotPasswordPageState extends State<ForgotPasswordPage> {
  final GlobalKey<FormState> _formKey = new GlobalKey<FormState>();
  GlobalKey<ScaffoldState> _scaffoldKey = new GlobalKey<ScaffoldState>();
  String? _email;
  //  if (!(regex.hasMatch(value)))
  //     return "Invalid Email";
  bool _load = true;
  @override
  void initState() {
    super.initState();
  }

  void showMessage(String message, [MaterialColor color = Colors.red]) {
    // ignore: deprecated_member_use
    _scaffoldKey.currentState!.showSnackBar(
        new SnackBar(backgroundColor: color, content: new Text(message)));
  }

  void _submitForm(_email) async {
    final FormState form = _formKey.currentState!;

    if (!form.validate()) {
      showMessage('Form is not valid!  Please review and correct.');
    } else {
      form.save(); //This invokes each onSaved event

      print("Form Saved Datas:");

      try {
        FormData formData = new FormData.fromMap({
          'post_data': "1",
          'apikey': AuthUtils.api,
          'email': _email,
        });
        var responseJson =
            await NetworkUtils.insertData('forget_password.php', formData);
        if (responseJson['result'] == 'success') {
          setState(() {
            _load = false;
          });
          NetworkUtils.alertDlg(context, responseJson['msg']);
          new Future.delayed(Duration(milliseconds: 3000), () {
            // onBackAction();

            Navigator.pushReplacementNamed(context, '/login');
          });
        } else {
          setState(() {
            _load = false;
          });
          NetworkUtils.alertDlg(context, responseJson['msg']);
        }
      } catch (e) {
        setState(() {
          _load = false;
        });
        NetworkUtils.alertDlg(context, e.toString());

        print('Server Exception!!!');
        print(e);
        return null;
      }
    }
  }

   _returnwillPop() {
    Navigator.of(context).pushReplacement(
        PageRouteBuilder(pageBuilder: (_, __, ___) => LoginPage()));
  }


  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: () async {
        return _returnwillPop();
      },
      child:  new Scaffold(
        // resizeToAvoidBottomPadding: true,
        key: _scaffoldKey,
        resizeToAvoidBottomInset: true,
        backgroundColor: Colors.white,
        appBar:
            PreferredSize(child: Container(), preferredSize: Size.fromHeight(0)),
        body: Form(
          key: _formKey,
          // ignore: deprecated_member_use
          autovalidate: true,
          child: Container(
            padding: EdgeInsets.symmetric(vertical: 10, horizontal: 40),
            width: double.infinity,
            height: double.infinity,
            child: ListView(
              // physics: NeverScrollableScrollPhysics(),
              // mainAxisSize: MainAxisSize.max,
              // mainAxisSize: MainAxisSize.min,
              children: <Widget>[
                // Container(height: 25),
                Container(height: MediaQuery.of(context).size.height / 8),
                Center(
                  child: Container(
                    child: Image.asset(
                      'assets/images/drs-logo.png',
                      // color: Colors.green[300],
                    ),
                    width: 120,
                    height: 60,
                  ),
                ),
                Container(height: 5),
                // Text("Dr\'s Siddha",
                //     textAlign: TextAlign.center,
                //     style: MyText.title(context).copyWith(
                //         color: MyColors.primary, fontWeight: FontWeight.bold)),
                // Container(height: 5),
                Text("Please enter your registered mail to recover password",
                    textAlign: TextAlign.center,
                    style: MyText.subhead(context)!.copyWith(
                      color: MyColors.grey_100_,
                    )),
                // Spacer(),
                Container(height: MediaQuery.of(context).size.height / 8),
                Align(
                  alignment: Alignment.centerLeft,
                  child: Text("EMAIL",
                      style: MyText.caption(context)!
                          .copyWith(color: MyColors.grey_100_)),
                ),
                TextFormField(
                  onFieldSubmitted: (value) {
                    // _submitForm(_email);
                  },
                  textInputAction: TextInputAction.go,
                  validator: (value) {
                    if (value!.isEmpty) {
                      return 'Email is required';
                    }
                    if (!(regex.hasMatch(value))) {
                      return 'Invalid Email';
                    }
                    return null;
                  },
                  onChanged: (value) {
                    setState(() {
                      _email = value;
                    });
                  },
                  keyboardType: TextInputType.emailAddress,
                  style: TextStyle(
                      color: MyColors.grey_100_, fontWeight: FontWeight.bold),
                  decoration: InputDecoration(
                    enabledBorder: UnderlineInputBorder(
                      borderSide:
                          BorderSide(color: Colors.blueGrey[400]!, width: 1),
                    ),
                    focusedBorder: UnderlineInputBorder(
                      borderSide:
                          BorderSide(color: Colors.blueGrey[400]!, width: 2),
                    ),
                  ),
                ),
                Container(height: 25),
               
                Container(height: 25),
                Container(
                  width: double.infinity,
                  height: 40,
                  // ignore: deprecated_member_use
                  child: FlatButton(
                    child: Text(
                      "SUBMIT",
                      style: TextStyle(
                          color: Colors.white,
                          fontWeight: FontWeight.bold,
                          letterSpacing: 0.5),
                    ),
                    color: MyColors.primary,
                    // shape: RoundedRectangleBorder(
                    //     borderRadius: new BorderRadius.circular(20)),
                    onPressed: () {
                      _submitForm(_email);
                    },
                  ),
                ),
                Container(height: 20),
                Align(
                  alignment: Alignment.center,
                  child: Container(
                    width: double.infinity,
                    // ignore: deprecated_member_use
                    child: FlatButton(
                      child: Row(
                        mainAxisAlignment: MainAxisAlignment.center,
                        children: <Widget>[
                          Icon(Icons.arrow_left,
                              size: 20, color: MyColors.grey_60),
                          Text(
                            "Signin",
                            style:
                                TextStyle(color: MyColors.grey_60, fontSize: 16),
                          ),
                        ],
                      ),
                      color: Colors.transparent,
                      onPressed: () {
                        Navigator.pushReplacement(context,
                  MaterialPageRoute(builder: (BuildContext ctx) => LoginPage()));
                      },
                    ),
                  ),
                ),
                // Container(height: 20),
              ],
            ),
          ),
        ),
      ),
    );
  }
}
