import 'package:drssiddha/app/data/my_colors.dart';
import 'package:drssiddha/app/pages/home/home.dart';
import 'package:drssiddha/app/widget/my_text.dart';
import 'package:flutter/material.dart';

class ChangePassword extends StatefulWidget {
  @override
  _ChangePasswordState createState() => new _ChangePasswordState();
}

class _ChangePasswordState extends State<ChangePassword> {
  final GlobalKey<FormState> _formKey = new GlobalKey<FormState>();
  GlobalKey<ScaffoldState> _scaffoldKey = new GlobalKey<ScaffoldState>();
  final TextEditingController passwordController = new TextEditingController();
  ConfirmPwdReg confirmPwdReg = new ConfirmPwdReg();

  // User userData = User();

  bool _load = true;
  bool _enableBtn = false;
  bool hideCurPassword = true;
  bool hidePassword = true;
  bool hideCPassword = true;
  bool enabled = true;

  @override
  void initState() {
    super.initState();
  }

  

  void showMessage(String message, [MaterialColor color = Colors.red]) {
    // ignore: deprecated_member_use
    _scaffoldKey.currentState!.showSnackBar(
        new SnackBar(backgroundColor: color, content: new Text(message)));
  }

  
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      key: _scaffoldKey,
      backgroundColor: Colors.white,
      appBar: AppBar(
        backgroundColor: MyColors.primaryValue,
        leading: InkWell(
            onTap: () {
              Navigator.pushReplacement(context,
                  MaterialPageRoute(builder: (BuildContext ctx) => HomePage()));
            },
            child:
                Icon(Icons.arrow_back_ios, color: MyColors.primary, size: 16)),
        title: Text(
          'Change Password',
          style: TextStyle(color: MyColors.primary, fontSize: 18),
          // style: TextStyle(
          //     fontFamily: "Gotik",
          //     fontSize: 18.0,
          //     color: Colors.black54,
          //     fontWeight: FontWeight.w700),
        ),
        elevation: 0.0,
      ),
      body:
      //  _load
      //     ? LoaderWidget()
      //     : 
          Align(
              alignment: Alignment.center,
              child: Padding(
                padding: const EdgeInsets.all(20.0),
                child: Column(
                  mainAxisAlignment: MainAxisAlignment.center,
                  crossAxisAlignment: CrossAxisAlignment.center,
                  children: <Widget>[
                    Form(
                      key: _formKey,
                      // ignore: deprecated_member_use
                      autovalidate: true,
                      onChanged: () => setState(
                          () => _enableBtn = _formKey.currentState!.validate()),
                      child: Column(
                        mainAxisAlignment: MainAxisAlignment.center,
                        crossAxisAlignment: CrossAxisAlignment.center,
                        children: <Widget>[
                          Align(
                              alignment: Alignment.bottomLeft,
                              child: Text("CURRENT PASSWORD",
                                  style: MyText.body2(context)!
                                      .copyWith(color: MyColors.grey_80))),
                          Container(height: 5),
                          Card(
                            shape: RoundedRectangleBorder(
                              borderRadius: BorderRadius.circular(3),
                            ),
                            clipBehavior: Clip.antiAliasWithSaveLayer,
                            margin: EdgeInsets.all(0),
                            elevation: 0,
                            child: Container(
                              // height: 60,
                              alignment: Alignment.centerLeft,
                              padding: EdgeInsets.symmetric(horizontal: 0),
                              child: TextFormField(
                                obscureText: hideCurPassword,
                                maxLines: 1,
                                validator: (val) {
                                  if (val!.isEmpty) {
                                    return 'Current Password is required';
                                  } else {
                                    return null;
                                  }
                                },
                                decoration: InputDecoration(
                                  suffixIcon: IconButton(
                                      icon: hideCurPassword
                                          ? Icon(Icons.visibility_off)
                                          : Icon(Icons.visibility),
                                      onPressed: () {
                                        setState(() {
                                          hideCurPassword = !hideCurPassword;
                                        });
                                      }),
                                  hintText: 'Current Password',
                                  contentPadding: EdgeInsets.all(10.0),
                                  border: OutlineInputBorder(),
                                ),
                                onChanged: (value) {
                                  setState(() {
                                    confirmPwdReg.currentpwd = value;
                                  });
                                },
                              ),
                            ),
                          ),
                          Container(height: 15),
                          Align(
                              alignment: Alignment.bottomLeft,
                              child: Text("PASSWORD",
                                  style: MyText.body2(context)!
                                      .copyWith(color: MyColors.grey_80))),
                          Container(height: 5),
                          Card(
                            shape: RoundedRectangleBorder(
                              borderRadius: BorderRadius.circular(3),
                            ),
                            clipBehavior: Clip.antiAliasWithSaveLayer,
                            margin: EdgeInsets.all(0),
                            elevation: 0,
                            child: Container(
                              // height: 60,
                              alignment: Alignment.centerLeft,
                              padding: EdgeInsets.symmetric(horizontal: 0),
                              child: TextFormField(
                                obscureText: hidePassword,
                                maxLines: 1,
                                controller: passwordController,
                                validator: (val) {
                                  if (val!.isEmpty) {
                                    return 'Password is required';
                                  }
                                  if (val.length < 6) {
                                    return 'Password length required morethan 6 characters';
                                  } else {
                                    return null;
                                  }
                                },
                                decoration: InputDecoration(
                                  suffixIcon: IconButton(
                                      icon: hidePassword
                                          ? Icon(Icons.visibility_off)
                                          : Icon(Icons.visibility),
                                      onPressed: () {
                                        setState(() {
                                          hidePassword = !hidePassword;
                                        });
                                      }),
                                  hintText: 'Password',
                                  contentPadding: EdgeInsets.all(10.0),
                                  border: OutlineInputBorder(),
                                ),
                                onChanged: (value) {
                                  setState(() {
                                    confirmPwdReg.newpwd = value;
                                  });
                                },
                              ),
                            ),
                          ),
                          Container(height: 15),
                          Align(
                              alignment: Alignment.bottomLeft,
                              child: Text("CONFIRM PASSWORD",
                                  style: MyText.body2(context)!
                                      .copyWith(color: MyColors.grey_80))),
                          Container(height: 5),
                          Card(
                            shape: RoundedRectangleBorder(
                              borderRadius: BorderRadius.circular(3),
                            ),
                            clipBehavior: Clip.antiAliasWithSaveLayer,
                            margin: EdgeInsets.all(0),
                            elevation: 0,
                            child: Container(
                              // height: 60,
                              alignment: Alignment.centerLeft,
                              padding: EdgeInsets.symmetric(horizontal: 0),
                              child: TextFormField(
                                obscureText: hideCPassword,
                                maxLines: 1,
                                validator: (val) {
                                  if (val!.isEmpty) return 'Re-type password';
                                  if (val != passwordController.text)
                                    return 'Password Not Match';
                                  return null;
                                },
                                // val.isEmpty ? 'Confirm Password is required' : null,
                                decoration: InputDecoration(
                                  suffixIcon: IconButton(
                                      icon: hideCPassword
                                          ? Icon(Icons.visibility_off)
                                          : Icon(Icons.visibility),
                                      onPressed: () {
                                        setState(() {
                                          hideCPassword = !hideCPassword;
                                        });
                                      }),
                                  hintText: 'Confirm Password',
                                  contentPadding: EdgeInsets.all(10.0),
                                  border: OutlineInputBorder(),
                                ),
                                onChanged: (value) {
                                  setState(() {
                                    confirmPwdReg.confirmpwd = value;
                                  });
                                },
                              ),
                            ),
                          ),
                        ],
                      ),
                    ),
                    Container(height: 15),
                    Container(height: 30),
                    Container(
                        width: double.infinity,
                        height: 45,
                        child: AbsorbPointer(
                            absorbing: !enabled,
                            // ignore: deprecated_member_use
                            child: FlatButton(
                                child: Text("SUBMIT",
                                    style: MyText.subhead(context)!.copyWith(
                                        color: 
                                             Colors.white,
                                           
                                        fontWeight: FontWeight.bold,
                                        letterSpacing: 1.0)),
                                color: MyColors.primary,
                                onPressed: !_enableBtn
                                    ? null
                                    : () async {
                                        setState(() {
                                          enabled = false;
                                        });
                                        final FormState form =
                                            _formKey.currentState!;

                                        if (!form.validate()) {
                                          showMessage(
                                              'Form is not valid!  Please review and correct.');
                                        } else {
                                          form.save(); //This invokes each onSaved event

                                          print("Form Saved Datas:");

                                          form.save(); //This invokes each onSaved event
                                          print(
                                              '========================================');
                                          print('Submitting to back end...');

                                          // _submitForm();
                                        }
                                      }))),
                  ],
                ),
              ),
            ),
    );
  }

  onBackAction() async {
    // Navigator.pushReplacement(
    //     context, MaterialPageRoute(builder: (BuildContext ctx) => Logout()));
  }
}

class ConfirmPwdReg {
  String? currentpwd;
  String? newpwd;
  String? confirmpwd;
}
