import 'package:drssiddha/app/data/my_colors.dart';
import 'package:drssiddha/app/pages/home/home.dart';
import 'package:flutter/material.dart';

class WhyDrSiddhaPage extends StatefulWidget {
  WhyDrSiddhaPage({Key? key}) : super(key: key);

  @override
  _WhyDrSiddhaPageState createState() => _WhyDrSiddhaPageState();
}

class _WhyDrSiddhaPageState extends State<WhyDrSiddhaPage> {
  var _moreinfo = [
    {
      'value': "1",
      'name': "Benefits",
      'navigatePage': "/benefits",
    },
    {
      'value': "2",
      'name': "Exclusive Offers",
      'navigatePage': "/execlusive_offer",
    },
     {
      'value': "3",
      'name': "Concept Clinic",
      'navigatePage': "/concept_clinic",
    },
      
    
  ];
   _returnwillPop() {
    Navigator.of(context).pushReplacement(
        PageRouteBuilder(pageBuilder: (_, __, ___) => HomePage()));
  }


  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: () async {
        return _returnwillPop();
      },
      child: Scaffold(
          backgroundColor: Colors.white,
          // key: _scaffoldKey,
          appBar: AppBar(
            backgroundColor: MyColors.primaryValue, //(0XFFBad600),
            iconTheme: IconThemeData(color: MyColors.primary),
            elevation: 0,
            leading: InkWell(
                onTap: () {
                  // Navigator.of(context).pop();
                  Navigator.pushNamed(
                                context, '/home');
                  // Navigator.pushReplacement(
                  //     context,
                  //     MaterialPageRoute(
                  //         builder: (BuildContext ctx) => HomePage()));
                },
                child: Icon(Icons.arrow_back_ios, size: 16)),
            title: Text(
              'Why Dr\'s Siddha?',
              style: TextStyle(color: MyColors.primary, fontSize: 18),
            ),
            centerTitle: true,
            // actions: <Widget>[
            //   Consumer<CartProvider>(
            //     builder: (_, cart, ch) => Badge(
            //       child: ch,
            //       value: cart.itemCount.toString(),
            //       color: MyColors.primaryDark,
            //     ),
            //     child: IconButton(
            //       icon: Icon(Icons.shopping_cart),
            //       onPressed: () {
            //         Navigator.pushReplacement(context,
            //           MaterialPageRoute(builder: (BuildContext ctx) => CartPage()));
            //         // Navigator.of(context).pushNamed(CartPage.routeName);
            //       },
            //     ),
            //   ),
            // ],
          ),
          body: SingleChildScrollView(
            child: ListView.builder(
              shrinkWrap: true,
              physics: NeverScrollableScrollPhysics(),
              itemCount: _moreinfo.length,
              itemBuilder: (context, i) {
                //  value = cartItems[position]["quantity"];
                ///
                /// Widget for list view slide delete
                ///
                return Padding(
                  padding: const EdgeInsets.all(8.0),
                  child: Card(
                    child: ListTile(
                      onTap: () {
                         Navigator.pushNamed(
                                context, _moreinfo[i]["navigatePage"]!);
                      },
                      title: Text(
                        _moreinfo[i]["name"]!,
                        style: TextStyle(
                            color: MyColors.titleTextColor,
                            letterSpacing: 0.5,
                            fontWeight: FontWeight.w800),
                      ),
                      trailing: Icon(
                        Icons.arrow_forward_ios, size: 16.0,
                        color: MyColors.buttonBGColor,
                      ),
                    ),
                  ),
                );
              },
            ),
          )),
    );
  }
}
