import 'package:drssiddha/app/data/my_colors.dart';
import 'package:drssiddha/app/model/user_model.dart';
import 'package:drssiddha/app/pages/home/join_as/join_as_sources.dart';
import 'package:drssiddha/app/utility/auth_utils.dart';
import 'package:drssiddha/app/utility/network_utils.dart';
import 'package:drssiddha/app/widget/my_text.dart';
import 'package:drssiddha/app/widgets/alert_dialog_form.dart';
import 'package:dio/dio.dart';
import 'package:flutter/material.dart';
import 'package:flutter_form_builder/flutter_form_builder.dart';
import 'package:drssiddha/app/widgets/loader.dart';

Pattern pattern =
    r'^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$';

RegExp regex = new RegExp(pattern.toString());

class JoinAsVendorPage extends StatefulWidget {
  @override
  _JoinAsVendorPageState createState() => _JoinAsVendorPageState();
}

class _JoinAsVendorPageState extends State<JoinAsVendorPage> {
  final GlobalKey<FormBuilderState> _fbKey = GlobalKey<FormBuilderState>();
  GlobalKey<ScaffoldState> _scaffoldKey = new GlobalKey<ScaffoldState>();

  final TextEditingController passwordController = new TextEditingController();

  String? member;
  bool enabled = true;
  bool _load = true;
  User userData = User();
  String? personName;
  String? companyName;
  String? contactNumber;
  String? address;
  String? serviceProvided;
  String? additionalNotes;

  String? name, email, location, message, title;

  final focus1 = FocusNode();
  final focus2 = FocusNode();
  final focus3 = FocusNode();
  final focus4 = FocusNode();
  final focus5 = FocusNode();
  final focus6 = FocusNode();

  @override
  void initState() {
    super.initState();
    NetworkUtils.checkDataConnectivity(context, 'home');
    _fetchHome();
  }

  _fetchHome() async {
    userData = await AuthUtils.loadSharedPrefs();
    setState(() {
      _load = false;
    });
  }

  void showMessage(String message, [MaterialColor color = Colors.red]) {
    // ignore: deprecated_member_use
    _scaffoldKey.currentState!.showSnackBar(
        new SnackBar(backgroundColor: color, content: new Text(message)));
  }

  updateProfile() async {
    setState(() {
      _load = true;
    });

    try {
      FormData formData = new FormData.fromMap({
        'post_data': "1",
        'apikey': AuthUtils.api,
        // 'user_id': userData.userId,
        // 'role_id': userData.roleId,
        'authorizedpersonName': name,
        'contactNumber': contactNumber,
        'companyName': email,
        'Address': title,
        'serviceProvided': location,
        'additionalNotes': message,
      });
      var responseJson =
          await NetworkUtils.insertData('joinus_form.php', formData);
      if (responseJson['result'] == 'success') {
        setState(() {
          _load = false;
        });
        // showMessage(responseJson['msg']);
        NetworkUtils.alertDlg(context, responseJson['msg']);
        _fbKey.currentState?.reset();

        // Navigator.pushReplacement(
        //     context,
        //     MaterialPageRoute(
        //         builder: (BuildContext ctx) => JoinAsVendorPage()));
      } else {
        NetworkUtils.alertDlg(context, responseJson['msg']);
      }
    } catch (error) {
      NetworkUtils.alertDlg(context, error.toString());
    }
  }

   _returnwillPop() {
    Navigator.of(context).pushReplacement(
        PageRouteBuilder(pageBuilder: (_, __, ___) => JoinAsResourcesPage()));
  }


  @override
  Widget build(BuildContext context) {
    Future<void> _alertFormDialogBox(String _title) {
      return showDialog<String>(
        context: context,
        barrierDismissible: false, // user must tap button!
        builder: (BuildContext context) {
          return DialogFormAlert(_title);
        },
      );
    }

    return WillPopScope(
      onWillPop: () async {
        return _returnwillPop();
      },
      child: Scaffold(
        key: _scaffoldKey,
        backgroundColor: Colors.white,
        appBar: AppBar(
          backgroundColor: MyColors.primaryValue,
          centerTitle: true,
          title: Text(
            "Dr\'s.Siddha",
            style: TextStyle(
                letterSpacing: 0.5,
                // fontFamily: "Gotik",
                fontSize: 18.0,
                color: MyColors.primary,
                fontWeight: FontWeight.normal),
          ),
          leading: InkWell(
              onTap: () {
                Navigator.pushReplacement(
                    context,
                    MaterialPageRoute(
                        builder: (BuildContext ctx) => JoinAsResourcesPage()));
              },
              child: Icon(
                Icons.arrow_back_ios,
                size: 16,
                color: MyColors.primary,
              )),
          elevation: 0.0,
        ),
        body: _load
            ? LoaderWidget()
            : SingleChildScrollView(
                scrollDirection: Axis.vertical,
                child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: <Widget>[
                      Container(
                        color: MyColors.primaryValue,
                        // color: Color(0xFFEF7D00),
                        height: 250,
                        width: double.infinity,
                        child: Center(
                            child: Container(
                                child: Image.asset('assets/images/drs-logo.png',
                                    fit: BoxFit.contain))),
                      ),
                      Container(
                          padding: EdgeInsets.symmetric(horizontal: 15),
                          transform: Matrix4.translationValues(0.0, -70.0, 0.0),
                          child: Card(
                              shape: RoundedRectangleBorder(
                                  borderRadius: BorderRadius.circular(2)),
                              elevation: 2,
                              clipBehavior: Clip.antiAliasWithSaveLayer,
                              child: Container(
                                  padding: EdgeInsets.all(20),
                                  child: Column(
                                      crossAxisAlignment:
                                          CrossAxisAlignment.start,
                                      children: <Widget>[
                                        Row(
                                          children: <Widget>[
                                            Column(
                                              crossAxisAlignment:
                                                  CrossAxisAlignment.start,
                                              children: <Widget>[
                                                Text('Join as Vendor',
                                                    style: MyText.title(context)!
                                                        .copyWith(
                                                            color: MyColors
                                                                .primaryValue)),
                                              ],
                                            ),
                                            Divider(),
                                          ],
                                        ),
                                        Divider(),
                                        Text(
                                          'Siddha Foods Tech is a pioneer in manufacturing Siddha  Medicine, Food Supplements, Healthcare Products, producing more than 200 products which provides many opportunities for vendors in various business domains. Join with Siddha Foods Tech to become a vendor.',
                                          textAlign: TextAlign.justify,
                                          style: MyText.body1(context)!.copyWith(
                                              letterSpacing: 0.5,
                                              fontSize: 15.0,
                                              height: 1.5,
                                              color: MyColors.allTextColor,
                                              fontWeight: FontWeight.normal),
                                        ),
                                        Container(height: 20),
                                        Align(
                                          alignment: Alignment.center,
                                          // ignore: deprecated_member_use
                                          child: FlatButton(
                                            child: Text("Enquire Now",
                                                style: MyText.subhead(context)!
                                                    .copyWith(
                                                        fontSize: 14,
                                                        fontWeight:
                                                            FontWeight.bold,
                                                        color: Colors.white,
                                                        letterSpacing: 0.5)),
                                            color: MyColors.primary,
                                            onPressed: () {
                                              _alertFormDialogBox(
                                                  'Join as Vendor');
                                              // alertDial('Join as Vendor');
                                            },
                                          ),
                                        ),
                                      ]))))
                    ])),
      ),
    );
  }
}
