import 'package:drssiddha/app/data/my_colors.dart';
import 'package:drssiddha/app/pages/home/home.dart';
import 'package:flutter/material.dart';

class JoinAsResourcesPage extends StatefulWidget {
  JoinAsResourcesPage({Key? key}) : super(key: key);

  @override
  _JoinAsResourcesPageState createState() => _JoinAsResourcesPageState();
}

class _JoinAsResourcesPageState extends State<JoinAsResourcesPage> {
  var _moreinfo = [
    {
      'value': "1",
      'name': "Vendor",
      'navigatePage': "/join_vendor",
    },
    {
      'value': "2",
      'name': "Part of Dr\'s Siddha",
      'navigatePage': '/partner_drs',
    },
     {
      'value': "3",
      'name': "Clinic Partner",
      'navigatePage': '/clinicpartner',
    },
    
  ];

   _returnwillPop() {
    Navigator.of(context).pushReplacement(
        PageRouteBuilder(pageBuilder: (_, __, ___) => HomePage()));
  }


  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: () async {
        return _returnwillPop();
      },
      child: Scaffold(
          backgroundColor: Colors.white,
          // key: _scaffoldKey,
          appBar: AppBar(
            backgroundColor: MyColors.primaryValue, //(0XFFBad600),
            iconTheme: IconThemeData(color: MyColors.primary),
            elevation: 0,
            leading: InkWell(
                onTap: () {
                  Navigator.pushNamed(
                                context, '/home');
                  
                },
                child: Icon(Icons.arrow_back_ios, size: 16)),
            title: Text(
              'Join as',
              style: TextStyle(color: MyColors.primary, fontSize: 18),
            ),
            centerTitle: true,
            
          ),
          body: SingleChildScrollView(
            child: ListView.builder(
              shrinkWrap: true,
              physics: NeverScrollableScrollPhysics(),
              itemCount: _moreinfo.length,
              itemBuilder: (context, i) {
                //  value = cartItems[position]["quantity"];
                ///
                /// Widget for list view slide delete
                ///
                return Padding(
                  padding: const EdgeInsets.all(8.0),
                  child: Card(
                    child: ListTile(
                      onTap: () {
                         Navigator.pushNamed(
                                context, _moreinfo[i]["navigatePage"]!);
                      },
                      title: Text(
                        _moreinfo[i]["name"]!,
                        style: TextStyle(
                            color: MyColors.titleTextColor,
                            letterSpacing: 0.5,
                            fontWeight: FontWeight.w800),
                      ),
                      trailing: Icon(
                        Icons.arrow_forward_ios, size: 16.0,
                        color: MyColors.buttonBGColor,
                      ),
                    ),
                  ),
                );
              },
            ),
          )),
    );
  }
}
