// import 'package:drssiddha/Library/carousel_pro/src/carousel_pro.dart';
import 'package:drssiddha/app/model/cart_model.dart';
import 'package:drssiddha/app/model/user_model.dart';
import 'package:drssiddha/app/pages/home/become_member.dart';
import 'package:drssiddha/app/pages/home/contact_us/contact_resources.dart';
import 'package:drssiddha/app/pages/home/dash_card.dart';
import 'package:drssiddha/app/pages/home/drs_siddha_groups/drs_siddha_groups.dart';
import 'package:drssiddha/app/pages/home/gallery/gallery.dart';
import 'package:drssiddha/app/pages/home/join_as/join_as_sources.dart';
import 'package:drssiddha/app/pages/home/news_events/news_events.dart';
import 'package:drssiddha/app/pages/products/product_category.dart';
import 'package:drssiddha/app/pages/home/resources/resources.dart';
import 'package:drssiddha/app/pages/home/why_drs_siddha/why_dr_siddha.dart';
import 'package:drssiddha/app/pages/services/local_notification_service.dart';
import 'package:drssiddha/app/provider/cart_provider.dart';
import 'package:drssiddha/app/utility/auth_utils.dart';
import 'package:drssiddha/app/utility/network_utils.dart';
import 'package:drssiddha/app/widget/my_text.dart';
import 'package:drssiddha/app/widgets/coming_soon.dart';
import 'package:drssiddha/app/widgets/common_appbar.dart';
import 'package:drssiddha/app/widgets/loader.dart';
import 'package:dio/dio.dart';
import 'package:flutter/material.dart';
import 'package:drssiddha/app/data/my_colors.dart';
import 'package:flutter/services.dart';
import 'package:getwidget/components/carousel/gf_carousel.dart';
import 'package:package_info/package_info.dart';
import 'package:provider/provider.dart';
import 'package:drssiddha/app/widgets/drawer.dart';
import 'package:flutter_staggered_grid_view/flutter_staggered_grid_view.dart';
import 'package:firebase_database/firebase_database.dart';
import 'package:firebase_messaging/firebase_messaging.dart';
import 'package:shared_preferences/shared_preferences.dart';

class HomePage extends StatefulWidget {
  @override
  State<StatefulWidget> createState() {
    return new _HomePageState();
  }
}

class _HomePageState extends State<HomePage> {
  GlobalKey<ScaffoldState> _scaffoldKey = new GlobalKey<ScaffoldState>();

  User userData = User();
  List<Cart> _cartData = [];
  PackageInfo _packageInfo = PackageInfo(
    appName: 'Unknown',
    packageName: 'Unknown',
    version: 'Unknown',
    buildNumber: 'Unknown',
  );
  String textValue = '';

  bool _load = true;
  @override
  void initState() {
    super.initState();
    NetworkUtils.checkDataConnectivity(context, 'home');

    LocalNotificationService.initialize(context);

    ///gives you the message on which user taps
    ///and it opened the app from terminated state
    FirebaseMessaging.instance.getInitialMessage().then((message) {
      if (message != null) {
      //  print(message);
        final routeFromMessage = message.data["route"]!;

        Navigator.of(context).pushNamed(routeFromMessage);
      }
    });

    ///forground work
    FirebaseMessaging.onMessage.listen((message) {
      if (message.notification != null) {
        //print(message.notification!.body);
        //print(message.notification!.title);
      }

      LocalNotificationService.display(message);
    });

    ///When the app is in background but opened and user taps
    ///on the notification
    /* FirebaseMessaging.onMessageOpenedApp.listen((message) {
      final routeFromMessage = message.data["route"];

      Navigator.of(context).pushNamed(routeFromMessage);
    }); */
    FirebaseMessaging.onMessageOpenedApp.listen((RemoteMessage message) async {
     // print("Amar Testing: $message");
     // print("onMessageOpenedApp: $message");
          
        /*         
        if (message.data["navigation"] == "/your_route") {
          //int _yourId = int.tryParse(message.data["id"]) ?? 0;
           Navigator.push(
                  navigatorKey.currentState!.context,
                  MaterialPageRoute(
                      builder: (context) => YourScreen(
                            yourId:_yourId,
                          )));  
        } */
    });

    FirebaseMessaging.instance.getToken().then((value) {
      print(value!);
      update(value.toString());
    });

    //_fetchSessionAndNavigate();


  }

  
  update(String token) async {
    print(token);
    DatabaseReference databaseReference = new FirebaseDatabase().reference();
    databaseReference.child('fcm-token/${token}').set({"token": token});
    setState(() {
      textValue = token;
    });
    await _initPackageInfo();
  }

  Future<void> _initPackageInfo() async {
    final PackageInfo info = await PackageInfo.fromPlatform();
    setState(() {
      _packageInfo = info;
    });
    print(_packageInfo.version);
    await checkFirstSeen();
  }

  checkFirstSeen() async {
    SharedPreferences prefs = await SharedPreferences.getInstance();
    bool _seen = (prefs.getBool('seen') ?? false);

    if (_seen) {
      // fetchSessionAndNavigate();
      _fetchSessionAndNavigate();
    } else {
      await prefs.setBool('seen', true);
      showHelloWorld();
    }
  }

  void showHelloWorld() {
    showDialog(
      barrierColor: Colors.white,
      context: context,
      builder: (context) => new AlertDialog(
        title: Text('Welcome you to Dr\'s.Siddha store!'),
        content: new Text('Thanks for Downloading Dr\'s.Siddha store App.'),
        actions: <Widget>[
          // ignore: deprecated_member_use
          new FlatButton(
              child: new Text('Continue'),
              onPressed: () {
                Navigator.pushReplacement(
                    context,
                    MaterialPageRoute(
                        builder: (BuildContext ctx) => HomePage()));
              })
        ],
      ),
    );
  }

  _fetchSessionAndNavigate() async {
    userData = await AuthUtils.loadSharedPrefs();
    final bloc = Provider.of<CartProvider>(context, listen: false);

    try {
      FormData formData = new FormData.fromMap({
        'post_data': "1",
        'apikey': AuthUtils.api,
        'version': _packageInfo.version,
        'user_id': userData.userId,
        'token': textValue
      });
      var responseJson = await NetworkUtils.insertData('cart.php', formData);
      if(responseJson['result'] == 'TokenError') {
        setState(() {
          _load = false;
        });
        //NetworkUtils.alertDlg(context, responseJson['msg']);
        NetworkUtils.getAuthToken('/home', formData);
        return null; 
      }
      if (responseJson['result'] == 'success') {
        // final prefs = await SharedPreferences.getInstance();
        CartModel _cartAllData = CartModel.fromJson(responseJson);
        print('cartData');
        print(_cartData);
        setState(() {
        _cartData = _cartAllData.data!;
          bloc.cartItems.clear();
        });

        if (_cartData.length > 0) {
          for (int i = 0; i < _cartData.length; i++) {
            bloc.addItemSess(
                _cartData[i].productId! + '-' + _cartData[i].typeId!,
                _cartData[i].productId!,
                _cartData[i].productName!,
                _cartData[i].imageLink!,
                _cartData[i].price!,
                _cartData[i].typeId!,
                _cartData[i].typeName!,
                _cartData[i].quantity!);
          }
        }
        setState(() {
          _load = false;
        });
      } else {
        NetworkUtils.alertDlg(context, responseJson['msg']);
      }
    } catch (error) {
      NetworkUtils.alertDlg(context, error.toString());
    }

    setState(() {
      _load = false;
    });
  }

  Future<bool> _onWillPop() async {
    bool result = await showDialog(
        context: context,
        builder: (context) => Dialog(
              backgroundColor: Colors.transparent,
              child: Container(
                child: Card(
                  shape: RoundedRectangleBorder(
                    borderRadius: BorderRadius.circular(4),
                  ),
                  color: Colors.white,
                  clipBehavior: Clip.antiAliasWithSaveLayer,
                  child: Column(
                    mainAxisSize: MainAxisSize.min,
                    children: <Widget>[
                      Container(
                        width: double.infinity,
                        color: MyColors.primaryValue,
                        child: Image.asset(
                          'assets/images/drs-logo.png', width: 150.0,
                          height: 50,
                          // color: Colors.white,
                        ),
                        // width: 150,
                        // height: 50,
                      ),
                      Container(
                        alignment: Alignment.centerLeft,
                        padding: EdgeInsets.symmetric(horizontal: 15),
                        width: double.infinity,
                        height: 50,
                        color: Colors.white,
                        child: Text("Confirm Exit?",
                            style: MyText.title(context)!
                                .copyWith(color: MyColors.titleTextColor)),
                      ),
                      Container(
                        padding: EdgeInsets.fromLTRB(15, 10, 15, 0),
                        child: Text(
                            'Are you sure you want to exit the app? Tap \'Yes\' to exit \'No\' to cancel.',
                            style: MyText.body1(context)!
                                .copyWith(color: MyColors.allTextColor)),
                      ),
                      Row(
                        mainAxisAlignment: MainAxisAlignment.end,
                        children: <Widget>[
                          // ignore: deprecated_member_use
                          new FlatButton(
                            child: Text("No"),
                            textColor: Colors.red[700],
                            color: Colors.transparent,
                            onPressed: () {
                              Navigator.pop(context);
                            },
                          ),
                          // ignore: deprecated_member_use
                          FlatButton(
                            child: Text("Yes"),
                            textColor: MyColors.titleTextColor,
                            color: Colors.transparent,
                            onPressed: () {
                              // bloc1.toStoreCartItems();
                              SystemChannels.platform
                                  .invokeMethod('SystemNavigator.pop');
                            },
                          )
                        ],
                      )
                    ],
                  ),
                ),
              ),
            ));
    return result;
  }

  /// ImageSlider in header
  // Widget imageSlider() {
  //   return Container(
  //     width: MediaQuery.of(context).size.width,
  //     height: MediaQuery.of(context).size.height / 2.5,
  //     child: new Carousel(
  //       boxFit: BoxFit.cover,
  //       dotColor: Color(0xFF6991C7).withOpacity(0.8),
  //       dotSize: 5.5,
  //       dotSpacing: 16.0,
  //       dotBgColor: Colors.transparent,
  //       showIndicator: true,
  //       overlayShadow: true,
  //       overlayShadowColors: Colors.white.withOpacity(0.9),
  //       overlayShadowSize: 0.9,
        // images: [
        //   AssetImage("assets/images/slide01.jpg"),
        //   // AssetImage("assets/images/baner1.jpg"),
        //   AssetImage("assets/images/slide02.jpg"),
        //   AssetImage("assets/images/slide03.jpg"),
        //   // AssetImage("assets/images/banner4.jpg"),
        // ],
  //     ),
  //   );
  // }

  // Widget _buildTile(Widget child, {Function() onTap}) {
  //   return Material(
  //       elevation: 5.0,
  //       color: MyColors.primary,
  //       // borderRadius: BorderRadius.circular(12.0),
  //       shadowColor: Colors.grey[200],
  //       // Color(0x802196F3),
  //       // borderOnForeground: true,
  //       child: child);
  // }

  Widget imageSlider() {
    return Container(
      height: MediaQuery.of(context).size.height / 3.25,
      child: new GFCarousel(
        height: MediaQuery.of(context).size.height / 3.5,

        autoPlay: true,
        activeIndicator: Colors.blueGrey,
        // aspectRatio: 1.0,
        viewportFraction: 1.0,
        pagination: true,
        items: [
          Image.asset("assets/images/slide01.jpg", fit: BoxFit.contain,),
          // AssetImage("assets/images/baner1.jpg"),
          Image.asset("assets/images/slide02.jpg", fit: BoxFit.contain,),
          Image.asset("assets/images/slide03.jpg", fit: BoxFit.contain,),
          // AssetImage("assets/images/banner4.jpg"),
        ],
        onPageChanged: (index) {
          setState(() {
            // ignore: unnecessary_statements
            index;
          });
        },
      ),
    );
  }

  @override
  Widget build(BuildContext context) {
    // MediaQueryData mediaQueryData = MediaQuery.of(context);
    // var deviceSize = MediaQuery.of(context).size;
    return _load
        ? LoaderWidget()
        : WillPopScope(
            onWillPop: _onWillPop,
            child: Scaffold(
              backgroundColor: Colors.white,
              key: _scaffoldKey,
              appBar: CommonAppBar(),
              endDrawer: new DrawerMenu(userData),
              body: _load
                  ? LoaderWidget()
                  : Stack(
                      children: <Widget>[
                        SingleChildScrollView(
                          child: Column(
                            children: <Widget>[
                              /// Call var imageSlider
                              imageSlider(),

                              Padding(
                                padding: const EdgeInsets.all(10.0),
                                child: StaggeredGridView.count(
                                  staggeredTiles: const <StaggeredTile>[
                                    const StaggeredTile.fit(1),
                                    const StaggeredTile.fit(1),
                                    const StaggeredTile.fit(1),
                                    const StaggeredTile.fit(1),
                                    const StaggeredTile.fit(1),
                                    const StaggeredTile.fit(1),
                                    const StaggeredTile.fit(1),
                                    const StaggeredTile.fit(1),
                                    const StaggeredTile.fit(1),
                                    const StaggeredTile.fit(1),
                                    // const StaggeredTile.fit(1),
                                    // const StaggeredTile.fit(1),
                                  ],
                                  mainAxisSpacing: 4.0,
                                  crossAxisSpacing: 4.0,
                                  shrinkWrap: true,
                                  scrollDirection: Axis.vertical,
                                  physics: ClampingScrollPhysics(),
                                  // childAspectRatio: 3 / 3,
                                  crossAxisCount: 2,
                                  children: <Widget>[
                                    DashCard(
                                        "assets/images/About_Drs.png",
                                        "About Dr\'s.Siddha",
                                        DrsSiddhaGroupsPage()),
                                    DashCard("assets/images/Buy_Products.png",
                                        "Buy Products", ProductsCategoryPage()),
                                    DashCard("assets/images/Why_Drs.png",
                                        "Why Dr\'s Siddha?", WhyDrSiddhaPage()),
                                    DashCard("assets/images/Be_a_Member.png",
                                        "Become a Member", BecomeAMemberPage()),
                                    DashCard("assets/images/News&Events.png",
                                        "News & Events", NewsEventsPage()),
                                    DashCard(
                                        "assets/images/Growth_Tip2.png",
                                        "Growth Tips",
                                        ComingSoonsPage("Growth Tips", "home")),
                                    DashCard("assets/images/Resources.png",
                                        "Resources", ResourcesPage()),
                                    DashCard("assets/images/Gallery.png",
                                        "Gallery", GalleryPage()),
                                    DashCard("assets/images/Contact_Us.png",
                                        "Contact Us", ContactsResourcesPage()),
                                    DashCard("assets/images/Join_Us.png",
                                        "Join As", JoinAsResourcesPage()),
                                  ],
                                ),
                              ),
                            ],
                          ),
                        ),
                      ],
                    ),
            ),
          );
  }
}
