import 'package:drssiddha/app/data/my_colors.dart';
import 'package:drssiddha/app/pages/home/home.dart';
import 'package:drssiddha/app/widgets/coming_soon.dart';
import 'package:flutter/material.dart';

class GalleryPage extends StatefulWidget {
  GalleryPage({Key? key}) : super(key: key);

  @override
  _GalleryPageState createState() => _GalleryPageState();
}

class _GalleryPageState extends State<GalleryPage> {
  String? _title;
  var _moreinfo = [
    {
      'value': "1",
      'name': "Images ",
      'navigatePage': "/coming_soon",
    },
    {
      'value': "2",
      'name': "Videos",
      'navigatePage': "/coming_soon",
    },
   
    
  ];

   _returnwillPop() {
    Navigator.of(context).pushReplacement(
        PageRouteBuilder(pageBuilder: (_, __, ___) => HomePage()));
  }


  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: () async {
        return _returnwillPop();
      },
      child: Scaffold(
          backgroundColor: Colors.white,
          // key: _scaffoldKey,
          appBar: AppBar(
            backgroundColor: MyColors.primaryValue, //(0XFFBad600),
            iconTheme: IconThemeData(color: MyColors.primary),
            elevation: 0,
            leading: InkWell(
                onTap: () {
                  // Navigator.of(context).pop();
                  Navigator.pushNamed(
                                context, '/home');
                  // Navigator.pushReplacement(
                  //     context,
                  //     MaterialPageRoute(
                  //         builder: (BuildContext ctx) => HomePage()));
                },
                child: Icon(Icons.arrow_back_ios, size: 16)),
            title: Text(
              'Gallery',
              style: TextStyle(color: MyColors.primary, fontSize: 18),
            ),
            centerTitle: true,
           
          ),
          body: SingleChildScrollView(
            child: ListView.builder(
              shrinkWrap: true,
              physics: NeverScrollableScrollPhysics(),
              itemCount: _moreinfo.length,
              itemBuilder: (context, i) {
                
                return Padding(
                  padding: const EdgeInsets.all(8.0),
                  child: Card(
                    child: ListTile(
                      onTap: () {
                          setState(() {
                          _title = _moreinfo[i]["name"];
                        });
                         Navigator.pushReplacement(
                      context,
                      MaterialPageRoute(
                          builder: (BuildContext ctx) => ComingSoonsPage( _title, "gallery" )));
                      },
                      title: Text(
                        _moreinfo[i]["name"]!,
                        style: TextStyle(
                            color: MyColors.titleTextColor,
                            letterSpacing: 0.5,
                            fontWeight: FontWeight.w800),
                      ),
                      trailing: Icon(
                        Icons.arrow_forward_ios, size: 16.0,
                        color: MyColors.buttonBGColor,
                      ),
                    ),
                  ),
                );
              },
            ),
          )),
    );
  }
}
