import 'package:drssiddha/app/data/my_colors.dart';
import 'package:drssiddha/app/model/user_model.dart';
import 'package:drssiddha/app/pages/home/drs_siddha_groups/drs_siddha_groups.dart';
import 'package:drssiddha/app/utility/auth_utils.dart';
import 'package:drssiddha/app/utility/network_utils.dart';
import 'package:drssiddha/app/widget/my_text.dart';
import 'package:drssiddha/app/widgets/loader.dart';
import 'package:dio/dio.dart';
import 'package:flutter/material.dart';
import 'package:flutter_html/flutter_html.dart';

class ReviewsPage extends StatefulWidget {
  ReviewsPage();

  @override
  ReviewsPageState createState() => new ReviewsPageState();
}

class ReviewsPageState extends State<ReviewsPage> {
  var infoData;
  bool _load = true;
  User userData = User();

  @override
  void initState() {
    super.initState();
    NetworkUtils.checkDataConnectivity(context, 'home');
    fetchHome();
  }

  void fetchHome() async {
    try {
      FormData formData = new FormData.fromMap({
        'post_data': "1",
        'apikey': AuthUtils.api,
      });
      var responseJson = await NetworkUtils.insertData('reviews.php', formData);
      if (responseJson['result'] == 'success') {
        infoData = responseJson['data'];

        setState(() {
          // orders= allOrderData.data;
          print(infoData[0]);
          _load = false;
        });
      } else {
        setState(() {
          _load = false;
        });
        NetworkUtils.alertDlg(context, responseJson['msg']);
      }
    } catch (e) {
      setState(() {
        _load = false;
      });
      NetworkUtils.alertDlg(context, e.toString());

      print('Server Exception!!!');
      print(e);
      return null;
    }
  }

   _returnwillPop() {
    Navigator.of(context).pushReplacement(
        PageRouteBuilder(pageBuilder: (_, __, ___) => DrsSiddhaGroupsPage()));
  }


  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: () async {
        return _returnwillPop();
      },
      child: new Scaffold(
          backgroundColor: Colors.white,
          appBar: AppBar(
            backgroundColor: MyColors.primaryValue,
            centerTitle: true,
            title: Text(
              "Dr\'s Siddha",
              style: TextStyle(color: MyColors.primary, fontSize: 18),
              // style: MyText.subhead(context).copyWith(
              //     color: MyColors.primary, fontWeight: FontWeight.bold)
            ),
            elevation: 0.0,
            leading: IconButton(
              icon: const Icon(Icons.arrow_back_ios,
                  size: 16, color: MyColors.primary),
              onPressed: () {
                Navigator.pushReplacement(
                    context,
                    MaterialPageRoute(
                        builder: (BuildContext ctx) => DrsSiddhaGroupsPage()));
              },
            ),
            automaticallyImplyLeading: true,
          ),
          body: _load
              ? LoaderWidget()
              : SingleChildScrollView(
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: <Widget>[
                      Container(
                        color: MyColors.primaryValue,
                        // color: Color(0xFFEF7D00),
                        height: 250,
                        width: double.infinity,
                        child: Center(
                            child: Container(
                                child: Image.asset('assets/images/drs-logo.png',
                                    fit: BoxFit.contain))),
                      ),
                      Container(
                        padding: EdgeInsets.symmetric(horizontal: 15),
                        transform: Matrix4.translationValues(0.0, -70.0, 0.0),
                        child: Card(
                            shape: RoundedRectangleBorder(
                                borderRadius: BorderRadius.circular(2)),
                            elevation: 2,
                            clipBehavior: Clip.antiAliasWithSaveLayer,
                            child: Container(
                              padding: EdgeInsets.all(20),
                              child: Column(
                                crossAxisAlignment: CrossAxisAlignment.start,
                                children: <Widget>[
                                  Row(
                                    children: <Widget>[
                                      Column(
                                        crossAxisAlignment:
                                            CrossAxisAlignment.start,
                                        children: <Widget>[
                                          Text(infoData[0]['subtitle'],
                                              style: MyText.title(context)!
                                                  .copyWith(
                                                      color: MyColors
                                                          .primaryValue)),
                                        ],
                                      ),
                                      Spacer(),
                                      IconButton(
                                        icon: Icon(Icons.favorite_border,
                                            color: MyColors.primary),
                                        onPressed: () {},
                                      )
                                    ],
                                  ),
                                  Divider(),
                                  Container(height: 10),
                                  Html(
                                    data: infoData[0]['content'],
                                    // defaultTextStyle: MyText.body1(context)
                                    //     .copyWith(
                                    //         letterSpacing: 0.5,
                                    //         fontSize: 15.0,
                                    //         height: 1.5,
                                    //         color: MyColors.allTextColor,
                                    //         fontWeight: FontWeight.normal),
                                  ),
                                  Container(height: 15),
                                ],
                              ),
                            )),
                      )
                    ],
                  ),
                )),
    );
  }
}
