import 'package:drssiddha/app/data/my_colors.dart';
import 'package:drssiddha/app/pages/home/home.dart';
import 'package:drssiddha/app/widgets/coming_soon.dart';
import 'package:flutter/material.dart';
// import 'package:url_launcher/url_launcher.dart';

class DrsSiddhaGroupsPage extends StatefulWidget {
  DrsSiddhaGroupsPage({Key? key}) : super(key: key);

  @override
  _DrsSiddhaGroupsPageState createState() => _DrsSiddhaGroupsPageState();
}

class _DrsSiddhaGroupsPageState extends State<DrsSiddhaGroupsPage> {
  var _moreinfo = [
    {
      'value': "1",
      'name': "Dr\'s Siddha",
      'navigatePage': "/aboutUs",
    },
    {
      'value': "2",
      'name': "Siddha Food Tech",
      'navigatePage': "/aboutFoodTech",
    },
    {
      'value': "3",
      'name': "The Core Team",
      'navigatePage': "/coreTeam",
    },
    {
      'value': "4",
      'name': "Accreditation & Certificate",
      'navigatePage': "/certificate",
    },
    {
      'value': "5",
      'name': "Manufacturing Process",
      'navigatePage': "/manufactureProcess",
    },
    // {
    //   'value': "6",
    //   'name': " Contact Us",
    //   'navigatePage': "",
    // },
    {
      'value': "7",
      'name': "Reviews",
      'navigatePage': "/reviews",
    },
    {
      'value': "8",
      'name': "Social Media Pages",
      'navigatePage': "/coming_soon",
    },

    // {
    //   'value': "9",
    //   'name': "Visit Our Website",
    //   'navigatePage': "/aboutUs",
    // },
  ];
  // _launchURL(String link) async {
  //   if (await canLaunch(link)) {
  //     await launch(link);
  //   } else {
  //     throw 'Could not launch $link';
  //   }
  // }

   _returnwillPop() {
    Navigator.of(context).pushReplacement(
        PageRouteBuilder(pageBuilder: (_, __, ___) => HomePage()));
  }


  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: () async {
        return _returnwillPop();
      },
      child: Scaffold(
          backgroundColor: Colors.white,
          // key: _scaffoldKey,
          appBar: AppBar(
            backgroundColor: MyColors.primaryValue, //(0XFFBad600),
            iconTheme: IconThemeData(color: MyColors.primary),
            elevation: 0,
            leading: InkWell(
                onTap: () {
                  // Navigator.of(context).pop();
                  Navigator.pushNamed(context, '/home');
                  // Navigator.pushReplacement(
                  //     context,
                  //     MaterialPageRoute(
                  //         builder: (BuildContext ctx) => HomePage()));
                },
                child: Icon(Icons.arrow_back_ios, size: 16)),
            title: Text(
              'Dr\'s.Siddha Group',
              style: TextStyle(color: MyColors.primary, fontSize: 18),
            ),
            centerTitle: true,
          ),
          body: SingleChildScrollView(
            child: ListView.builder(
              shrinkWrap: true,
              physics: NeverScrollableScrollPhysics(),
              itemCount: _moreinfo.length,
              itemBuilder: (context, i) {
                return Padding(
                  padding: const EdgeInsets.all(8.0),
                  child: Card(
                    child: ListTile(
                      onTap: () {
                        // _moreinfo[i]["value"] == "9"
                        //     ? _launchURL('http://drsiddha.com/')
                        //     :
                             _moreinfo[i]["navigatePage"] == "/coming_soon"
                                ? Navigator.pushReplacement(
                                    context,
                                    MaterialPageRoute(
                                        builder: (BuildContext ctx) =>
                                            ComingSoonsPage(
                                                "Social Media Pages",
                                                "drsSiddhaGroup")))
                                : Navigator.pushNamed(
                                    context, _moreinfo[i]["navigatePage"]!);
                      },
                      title: Text(
                        _moreinfo[i]["name"]!,
                        style: TextStyle(
                            color: MyColors.titleTextColor,
                            // fontSize: ,
                            letterSpacing: 0.5,
                            fontWeight: FontWeight.w800),
                      ),
                      trailing: Icon(
                        Icons.arrow_forward_ios,
                        size: 16.0,
                        color: MyColors.buttonBGColor,
                      ),
                    ),
                  ),
                );
              },
            ),
          )),
    );
  }
}
