import 'package:drssiddha/app/data/my_colors.dart';
import 'package:drssiddha/app/pages/home/drs_siddha_groups/drs_siddha_groups.dart';
import 'package:drssiddha/app/utility/auth_utils.dart';
import 'package:drssiddha/app/utility/network_utils.dart';
import 'package:drssiddha/app/widget/my_text.dart';
import 'package:drssiddha/app/widgets/loader.dart';
import 'package:dio/dio.dart';
import 'package:flutter/material.dart';
import 'package:flutter_html/flutter_html.dart';

class CoreTeamPage extends StatefulWidget {
  

  @override
  _CoreTeamState createState() => _CoreTeamState();
}

class _CoreTeamState extends State<CoreTeamPage> {
 var _infoData;
  bool _load = true;

  @override
  void initState() {
    super.initState();
    NetworkUtils.checkDataConnectivity(context, 'home');
    fetchHome();
  }

 

  void fetchHome() async {
    setState(() {
      _load = true;
    });
    try {
      FormData formData = new FormData.fromMap({
        'post_data': "1",
        'apikey': AuthUtils.api,
      });
      var responseJson =
          await NetworkUtils.insertData('core_team.php', formData);
      if (responseJson['result'] == 'success') {
        _infoData = responseJson['data'];

        setState(() {
          // orders= allOrderData.data;
          _load = false;
        });
      } else {
        setState(() {
          _load = false;
        });
        NetworkUtils.alertDlg(context, responseJson['msg']);
      }
    } catch (e) {
      setState(() {
        _load = false;
      });
      NetworkUtils.alertDlg(context, e.toString());

      print('Server Exception!!!');
      print(e);
      return null;
    }
  }

  _returnwillPop() {
    Navigator.of(context).pushReplacement(
        PageRouteBuilder(pageBuilder: (_, __, ___) => DrsSiddhaGroupsPage()));
  }


  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: () async {
        return _returnwillPop();
      },
      child: new Scaffold(
          backgroundColor: Colors.white,
          appBar: AppBar(
            backgroundColor: MyColors.primaryValue,
            centerTitle: true,
            title: Text(
              "Dr\'s Siddha",
              style: TextStyle(color: MyColors.primary, fontSize: 18),
              // style: MyText.subhead(context).copyWith(
              //     color: MyColors.primary, fontWeight: FontWeight.bold)
            ),
            leading: IconButton(
              icon: const Icon(Icons.arrow_back_ios,
                  size: 16, color: MyColors.primary),
              onPressed: () {
                Navigator.pushReplacement(
                    context,
                    MaterialPageRoute(
                        builder: (BuildContext ctx) => DrsSiddhaGroupsPage()));
              },
            ),
            automaticallyImplyLeading: true,
            elevation: 0.0,
          ),
          body:  _load
              ? LoaderWidget()
              : SingleChildScrollView(
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: <Widget>[
                      Container(
                        color: MyColors.primaryValue,
                        // color: Color(0xFFEF7D00),
                        height: 250,
                        width: double.infinity,
                        child:
                            Center(child: Container(child: Image.asset('assets/images/drs-logo.png', fit: BoxFit.contain))),
                      ),
                      Container(
                        padding: EdgeInsets.symmetric(horizontal: 15),
                        transform: Matrix4.translationValues(0.0, -70.0, 0.0),
                        child: Card(
                            shape: RoundedRectangleBorder(
                                borderRadius: BorderRadius.circular(2)),
                            elevation: 2,
                            clipBehavior: Clip.antiAliasWithSaveLayer,
                            child: Container(
                              padding: EdgeInsets.all(20),
                              child: Column(
                                crossAxisAlignment: CrossAxisAlignment.start,
                                children: <Widget>[
                                  Row(
                                    children: <Widget>[
                                      Column(
                                        crossAxisAlignment:
                                            CrossAxisAlignment.start,
                                        children: <Widget>[
                                          Text(_infoData[0]['title'],
                                              style: MyText.title(context)!
                                                  .copyWith(
                                                      color: MyColors.primaryValue)),
                                        ],
                                      ),
                                      Divider(),
                                    ],
                                  ),
                                  Divider(),
                                 
                                  Container(height: 15),

                                  ListView.builder(
                                      shrinkWrap: true,
                                      physics: NeverScrollableScrollPhysics(),
                                      itemCount: _infoData[0]['detail'].length,
                                      itemBuilder: (BuildContext context, i) {
                                        var _iData = _infoData[0]['detail'][i];
                                        return Column(
                                            crossAxisAlignment:
                                                CrossAxisAlignment.start,
                                            children: <Widget>[
                                              Container(height: 10),
                                              Text(_iData["name"] == null ? '' :_iData["name"],
                                                  style: MyText.title(context)!
                                                      .copyWith(letterSpacing: 1.0,
                                                          color: MyColors
                                                              .titleTextColor)),
                                              Container(height: 1),
                                              
                                              Html(
                                                data: _iData["position"] == null ? '' : _iData["position"] ,
                                                // defaultTextStyle: MyText.body1(
                                                //         context)
                                                //     .copyWith(
                                                //         letterSpacing: 1.0,
                                                //         fontSize: 15.0,
                                                //         height: 1.5,
                                                //         color: MyColors.allTextColor,
                                                //         fontWeight:
                                                //             FontWeight.normal),
                                              ),
                                              Container(height: 10),
                                              Container(
                                                  width: 25,
                                                  color: MyColors.subTitleTextColor,
                                                  height: 2),
                                              Container(height: 10),
                                              
                                              
                                            ]);
                                      }),
                                ],
                              ),
                            )),
                      )
                    ],
                  ),
                )),
    );
  }
}
