import 'package:drssiddha/app/data/my_colors.dart';
import 'package:drssiddha/app/model/user_model.dart';
import 'package:drssiddha/app/pages/home/drs_siddha_groups/drs_siddha_groups.dart';
import 'package:drssiddha/app/utility/auth_utils.dart';
import 'package:drssiddha/app/utility/network_utils.dart';
import 'package:drssiddha/app/widget/my_text.dart';
import 'package:drssiddha/app/widgets/loader.dart';
import 'package:dio/dio.dart';
import 'package:flutter/material.dart';

class AboutUsFoodTechPage extends StatefulWidget {
  @override
  AboutUsFoodTechPageState createState() => new AboutUsFoodTechPageState();
}

class AboutUsFoodTechPageState extends State<AboutUsFoodTechPage> {
  var infoData;
  bool _load = true;
  User userData = User();

  @override
  void initState() {
    super.initState();
    NetworkUtils.checkDataConnectivity(context, 'home');
    _fetchSessionAndNavigate();
  }

  _fetchSessionAndNavigate() async {
    userData = await AuthUtils.loadSharedPrefs();
    // print(userData.firstName);
    // print(userData.lastName);

    setState(() {
      _load = false;
    });
    fetchHome();
  }

  void fetchHome() async {
    setState(() {
      _load = true;
    });
    try {
      FormData formData = new FormData.fromMap({
        'post_data': "1",
        'apikey': AuthUtils.api,
      });
      var responseJson =
          await NetworkUtils.insertData('siddha_food_tech.php', formData);
      if (responseJson['result'] == 'success') {
        infoData = responseJson['data'];

        setState(() {
          // orders= allOrderData.data;
          _load = false;
        });
      } else {
        setState(() {
          _load = false;
        });
        NetworkUtils.alertDlg(context, responseJson['msg']);
      }
    } catch (e) {
      setState(() {
        _load = false;
      });
      NetworkUtils.alertDlg(context, e.toString());

      print('Server Exception!!!');
      print(e);
      return null;
    }
  }

  _returnwillPop() {
    Navigator.of(context).pushReplacement(
        PageRouteBuilder(pageBuilder: (_, __, ___) => DrsSiddhaGroupsPage()));
  }


  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: () async {
        return _returnwillPop();
      },
      child: new Scaffold(
          backgroundColor: Colors.white,
          appBar: AppBar(
            backgroundColor: MyColors.primaryValue,
            centerTitle: true,
            title: Text(
              "Dr\'s Siddha",
              style: TextStyle(color: MyColors.primary, fontSize: 18),
              // style: MyText.subhead(context).copyWith(
              //     color: MyColors.primary, fontWeight: FontWeight.bold)
            ),
            leading: IconButton(
              icon: const Icon(Icons.arrow_back_ios,
                  size: 16, color: MyColors.primary),
              onPressed: () {
                Navigator.pushReplacement(
                    context,
                    MaterialPageRoute(
                        builder: (BuildContext ctx) => DrsSiddhaGroupsPage()));
              },
            ),
            elevation: 0.0,
            automaticallyImplyLeading: true,
          ),
          body: _load
              ? LoaderWidget()
              : SingleChildScrollView(
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: <Widget>[
                      Container(
                        color: MyColors.primaryValue,
                        // color: Color(0xFFEF7D00),
                        height: 250,
                        width: double.infinity,
                        child: Center(
                            child: Container(
                                child: Image.asset('assets/images/drs-logo.png',
                                    fit: BoxFit.contain))),
                      ),
                      Container(
                        padding: EdgeInsets.symmetric(horizontal: 15),
                        transform: Matrix4.translationValues(0.0, -60.0, 0.0),
                        child: Card(
                            shape: RoundedRectangleBorder(
                                borderRadius: BorderRadius.circular(2)),
                            elevation: 2,
                            clipBehavior: Clip.antiAliasWithSaveLayer,
                            child: Container(
                              padding: EdgeInsets.all(20),
                              child: Column(
                                crossAxisAlignment: CrossAxisAlignment.start,
                                children: <Widget>[
                                  Row(
                                    children: <Widget>[
                                      Column(
                                        crossAxisAlignment:
                                            CrossAxisAlignment.start,
                                        children: <Widget>[
                                          Text(infoData[0]["title"],
                                              style: MyText.title(context)!
                                                  .copyWith(
                                                      color: MyColors.primaryValue)),
                                          
                                        ],
                                      ),
                                      Divider(),
                                      Spacer(),
                                      IconButton(
                                        icon: Icon(Icons.favorite_border,
                                            color: MyColors.primary),
                                        onPressed: () {},
                                      )
                                    ],
                                  ),
                                  Divider(),
                                  Container(height: 10),
                                  Text(infoData[0]["content"],
                                      textAlign: TextAlign.justify,
                                      style: MyText.body1(context)!.copyWith(
                                          letterSpacing: 0.5,
                                          fontSize: 15.0,
                                          height: 1.5,
                                          color: MyColors.allTextColor,
                                          fontWeight: FontWeight.normal)),
                                  Container(height: 15),
                                ],
                              ),
                            )),
                      )
                    ],
                  ),
                )),
    );
  }
}
