import 'package:drssiddha/app/data/my_colors.dart';
import 'package:drssiddha/app/model/user_model.dart';
import 'package:drssiddha/app/pages/cart/cart_page.dart';
import 'package:drssiddha/app/utility/auth_utils.dart';
import 'package:drssiddha/app/utility/network_utils.dart';
import 'package:drssiddha/app/widget/my_text.dart';
import 'package:drssiddha/app/widgets/loader.dart';
import 'package:dio/dio.dart';
import 'package:flutter/material.dart';
import 'package:flutter_form_builder/flutter_form_builder.dart';
import 'package:shared_preferences/shared_preferences.dart';
import 'package:drssiddha/app/pages/webview/webview.dart';

// import 'dart:math' as math;

Pattern pattern =
    r'^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$';

RegExp regex = new RegExp(pattern.toString());

class AddressPage extends StatefulWidget {
  final _cartAmount;
  AddressPage(this._cartAmount);
  @override
  _AddressPageState createState() => _AddressPageState(this._cartAmount);
}

class _AddressPageState extends State<AddressPage> {
  final _cartAmount;
  _AddressPageState(this._cartAmount);
  final GlobalKey<FormState> _fbKey = GlobalKey<FormState>();
  GlobalKey<ScaffoldState> _scaffoldKey = new GlobalKey<ScaffoldState>();
  final TextEditingController firstController = new TextEditingController();
  String sameAddress = 'false';
  SharedPreferences? prefs;
  bool _enableBtn = false;
  User? userData;
  User newAddress = User();
  bool _load = true;
  String? payURL;

  final focus1 = FocusNode();
  final focus2 = FocusNode();
  final focus3 = FocusNode();
  final focus4 = FocusNode();
  final focus5 = FocusNode();
  final focus6 = FocusNode();
  final focus7 = FocusNode();
  final focus8 = FocusNode();
  final focus9 = FocusNode();

  @override
  void initState() {
    super.initState();
    NetworkUtils.checkDataConnectivity(context, 'home');
    print('_cartAmount');
    print(_cartAmount);
    _fetchSessionAndNavigate();
  }

  _fetchSessionAndNavigate() async {
    userData = await AuthUtils.loadSharedPrefs();
    prefs = await SharedPreferences.getInstance();
    if(prefs!.containsKey('SameAddress')) {
      sameAddress = prefs!.getString('SameAddress')!;
    }  
    // print(userData.firstName);
    // print(userData.lastName);
    print(userData!.district!);
    print(sameAddress);
    if (sameAddress == 'true') {
      setState(() {
        _enableBtn = true;
        newAddress = userData!;
        print(newAddress.district);
      });
    }
    setState(() {
      _load = false;
    });
  }

  void showMessage(String message, [MaterialColor color = Colors.red]) {
    // ignore: deprecated_member_use
    _scaffoldKey.currentState!.showSnackBar(
        new SnackBar(backgroundColor: color, content: new Text(message)));
  }

  void _submitForm() async {
    final FormState form = _fbKey.currentState!;

    if (!form.validate()) {
      showMessage('Form is not valid!  Please review and correct.');
    } else {
      form.save(); //This invokes each onSaved event

      print("Form Saved Datas:");

      setState(() {
        _load = true;
      });

      try {
        FormData formData = new FormData.fromMap({
          'post_data': "1",
          'apikey': AuthUtils.api,
          'user_id': userData!.userId,
          'role_id': userData!.roleId,
          'ship_name': newAddress.name,
          'ship_landmark': newAddress.userlandmark,
          'ship_address': newAddress.userAddress,
          'ship_mobile': newAddress.userPhone,
          'ship_email': newAddress.userEmail,
          'ship_district': newAddress.district,
          'ship_state': newAddress.state,
          'ship_country': newAddress.country,
          'ship_postal_code': newAddress.pincode,
          'total_amount': _cartAmount,
        });
        var responseJson =
            await NetworkUtils.insertData('temp_order.php', formData);
        if (responseJson['result'] == 'success') {
          setState(() {
            payURL = responseJson['url'];
            _load = false;
          });
          Navigator.pushReplacement(
              context,
              MaterialPageRoute(
                  builder: (BuildContext ctx) => Webview('Payment', payURL)));

          // NetworkUtils.alertDlg(context, responseJson['msg']);
        } else {
          NetworkUtils.alertDlg(context, responseJson['msg']);
        }
      } catch (error) {
        NetworkUtils.alertDlg(context, error.toString());
      }

      // Navigator.push(
      //     context,
      //     MaterialPageRoute(
      //         builder: (BuildContext context) =>
      //             PaymentSelectPage(newAddress, sameAddress)));
    }
  }

  @override
  Widget build(BuildContext context) {
    return _load
        ? LoaderWidget()
        : Scaffold(
            key: _scaffoldKey,
            backgroundColor: Colors.white,
            appBar: AppBar(
              backgroundColor: MyColors.primaryValue,
              leading: InkWell(
                  onTap: () {
                    Navigator.pushReplacement(
                        context,
                        MaterialPageRoute(
                            builder: (BuildContext ctx) => CartPage()));
                  },
                  child: Icon(Icons.arrow_back_ios,
                      size: 16, color: MyColors.primary)),
              title: Text(
                'Shipping Address',
                style: TextStyle(
                    color: MyColors.primary,
                    fontSize: 18,
                    fontWeight: FontWeight.w700),
                // style: TextStyle(
                //     fontFamily: "Gotik",
                //     fontSize: 18.0,
                //     color: Colors.black54,
                //     fontWeight: FontWeight.w700),
              ),
              centerTitle: true,
              elevation: 0.0,
            ),
            body: SingleChildScrollView(
              padding: EdgeInsets.all(20),
              scrollDirection: Axis.vertical,
              child: Align(
                alignment: Alignment.topCenter,
                child: Container(
                  color: Colors.white,
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: <Widget>[
                      Row(
                        // crossAxisAlignment: CrossAxisAlignment.start,
                        mainAxisAlignment: MainAxisAlignment.start,
                        children: <Widget>[
                          Checkbox(
                            activeColor: MyColors.primary,
                            value: sameAddress == 'true' ? true : false,
                            onChanged: (value) async {
                              setState(() {
                                // sameAddress = value;
                                print(sameAddress);
                                if (value == true) {
                                  sameAddress = 'true';
                                  prefs!.setString('SameAddress', sameAddress);
                                  newAddress = userData!;
                                  // print(newAddress.firstName);
                                  Navigator.pushReplacement(
                                      context,
                                      MaterialPageRoute(
                                          builder: (BuildContext ctx) =>
                                              AddressPage(_cartAmount)));
                                } else {
                                  sameAddress = 'false';
                                  prefs!.setString('SameAddress', sameAddress);
                                  newAddress = User();
                                  Navigator.pushReplacement(
                                      context,
                                      MaterialPageRoute(
                                          builder: (BuildContext ctx) =>
                                              AddressPage(_cartAmount)));
                                }
                              });
                            },
                            // materialTapTargetSize:
                            //     MaterialTapTargetSize.padded
                          ),
                          Text("Same address as registered.",
                              style: MyText.subtitle(context)!
                                  .copyWith(color: Colors.grey[800])),
                        ],
                      ),
                      Form(
                        key: _fbKey,
                        // autovalidate: true,
                        onChanged: () {
                          setState(() {
                            _enableBtn = _fbKey.currentState!.validate();
                          });
                        },
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: <Widget>[
                            Align(
                                alignment: Alignment.bottomLeft,
                                child: Text("NAME",
                                    style: MyText.body1(context)!
                                        .copyWith(color: MyColors.grey_60))),
                            Container(height: 5),
                            Card(
                              shape: RoundedRectangleBorder(
                                borderRadius: BorderRadius.circular(3),
                              ),
                              clipBehavior: Clip.antiAliasWithSaveLayer,
                              margin: EdgeInsets.all(0),
                              elevation: 0,
                              child: Padding(
                                padding: const EdgeInsets.only(
                                    top: 0.0, bottom: 0.0),
                                child: Container(
                                  alignment: Alignment.centerLeft,
                                  padding: EdgeInsets.symmetric(
                                      horizontal: 0, vertical: 0.0),
                                  child: FormBuilderTextField(
                                    maxLines: 1,
                                    initialValue: sameAddress == 'true'
                                        ? '${userData!.name}'
                                        : "",
                                    // onFieldSubmitted: (val) {
                                    //   FocusScope.of(context)
                                    //       .requestFocus(focus2);
                                    // },
                                    focusNode: focus1,
                                    name: "Name",
                                    decoration: InputDecoration(
                                        hintText: "NAME",
                                        //  labelText: "REGISTER NUMBER",
                                        border: OutlineInputBorder(
                                            borderRadius:
                                                BorderRadius.circular(3.0))),
                                   validator: FormBuilderValidators.compose([
                                FormBuilderValidators.required(context,
                                          errorText: "Name required"),
                                      // FormBuilderValidators.numeric(),
                                      // FormBuilderValidators.max(6),
                                    ]),
                                    onSaved: (value) {
                                      setState(() {
                                        if (sameAddress == 'true') {
                                          newAddress.name = userData!.name;
                                        } else {
                                          newAddress.name = value;
                                        }
                                      });
                                    },
                                  ),
                                ),
                              ),
                            ),
                            Container(height: 15),
                            Align(
                                alignment: Alignment.bottomLeft,
                                child: Text("MOBILE",
                                    style: MyText.body1(context)!
                                        .copyWith(color: MyColors.grey_60))),
                            Container(height: 5),
                            Card(
                              shape: RoundedRectangleBorder(
                                borderRadius: BorderRadius.circular(3),
                              ),
                              clipBehavior: Clip.antiAliasWithSaveLayer,
                              margin: EdgeInsets.all(0),
                              elevation: 0,
                              child: Padding(
                                padding: const EdgeInsets.only(
                                    top: 0.0, bottom: 0.0),
                                child: Container(
                                  alignment: Alignment.centerLeft,
                                  padding: EdgeInsets.symmetric(
                                      horizontal: 0, vertical: 0.0),
                                  child: FormBuilderTextField(
                                    initialValue: sameAddress == 'true'
                                        ? '${userData!.userPhone}'
                                        : "",
                                    keyboardType: TextInputType.number,
                                    // onFieldSubmitted: (val) {
                                    //   FocusScope.of(context)
                                    //       .requestFocus(focus3);
                                    // },
                                    focusNode: focus2,
                                    name: "Mobile",
                                    decoration: InputDecoration(
                                        hintText: "MOBILE NUMBER",
                                        //  labelText: "REGISTER NUMBER",
                                        border: OutlineInputBorder(
                                            borderRadius:
                                                BorderRadius.circular(3.0))),
                                    validator: FormBuilderValidators.compose([
                                FormBuilderValidators.required(context,
                                          errorText: "Mobile number required"),
                                      FormBuilderValidators.numeric(context),
                                      FormBuilderValidators.min(context, 10),
                                      // FormBuilderValidators.max(10),
                                    ]),
                                    onSaved: (value) {
                                      setState(() {
                                        if (sameAddress == 'true') {
                                          newAddress.userPhone =
                                              userData!.userPhone;
                                        } else {
                                          newAddress.userPhone = value;
                                        }
                                      });
                                    },
                                  ),
                                ),
                              ),
                            ),
                            Container(height: 15),
                            Align(
                                alignment: Alignment.bottomLeft,
                                child: Text("EMAIL",
                                    style: MyText.body1(context)!
                                        .copyWith(color: MyColors.grey_60))),
                            Container(height: 5),
                            Card(
                              shape: RoundedRectangleBorder(
                                borderRadius: BorderRadius.circular(3),
                              ),
                              clipBehavior: Clip.antiAliasWithSaveLayer,
                              margin: EdgeInsets.all(0),
                              elevation: 0,
                              child: Padding(
                                padding: const EdgeInsets.only(
                                    top: 0.0, bottom: 0.0),
                                child: Container(
                                  alignment: Alignment.centerLeft,
                                  padding: EdgeInsets.symmetric(
                                      horizontal: 0, vertical: 0.0),
                                  child: FormBuilderTextField(
                                    initialValue: sameAddress == 'true'
                                        ? '${userData!.userEmail}'
                                        : "",
                                    keyboardType: TextInputType.emailAddress,
                                    // onFieldSubmitted: (val) {
                                    //   FocusScope.of(context)
                                    //       .requestFocus(focus4);
                                    // },
                                    focusNode: focus3,
                                    name: "Email",
                                    decoration: InputDecoration(
                                        hintText: "EMAIL",
                                        //  labelText: "REGISTER NUMBER",
                                        border: OutlineInputBorder(
                                            borderRadius:
                                                BorderRadius.circular(3.0))),
                                    validator: FormBuilderValidators.compose([
                                FormBuilderValidators.required(context,
                                          errorText: "Email required"),
                                      FormBuilderValidators.email(context),
                                      // FormBuilderValidators.max(6),
                                    ]),
                                    onSaved: (value) {
                                      setState(() {
                                        if (sameAddress == 'true') {
                                          newAddress.userEmail =
                                              userData!.userEmail;
                                        } else {
                                          newAddress.userEmail = value;
                                        }
                                      });
                                    },
                                  ),
                                ),
                              ),
                            ),
                            Container(height: 15),
                            Align(
                                alignment: Alignment.bottomLeft,
                                child: Text("ADDRESS",
                                    style: MyText.body1(context)!
                                        .copyWith(color: MyColors.grey_60))),
                            Container(height: 5),
                            Card(
                              shape: RoundedRectangleBorder(
                                borderRadius: BorderRadius.circular(3),
                              ),
                              clipBehavior: Clip.antiAliasWithSaveLayer,
                              margin: EdgeInsets.all(0),
                              elevation: 0,
                              child: Padding(
                                padding: const EdgeInsets.only(
                                    top: 0.0, bottom: 0.0),
                                child: Container(
                                  alignment: Alignment.centerLeft,
                                  padding: EdgeInsets.symmetric(
                                      horizontal: 0, vertical: 0.0),
                                  child: FormBuilderTextField(
                                    initialValue: sameAddress == 'true'
                                        ? '${userData!.userAddress}'
                                        : "",
                                    maxLines: 6,
                                    // onFieldSubmitted: (val) {
                                    //   FocusScope.of(context)
                                    //       .requestFocus(focus5);
                                    // },
                                    focusNode: focus4,
                                    name: "address",
                                    decoration: InputDecoration(
                                        hintText: "ADDRESS",
                                        //  labelText: "REGISTER NUMBER",
                                        border: OutlineInputBorder(
                                            borderRadius:
                                                BorderRadius.circular(3.0))),
                                    validator: FormBuilderValidators.compose([
                                FormBuilderValidators.required(context,
                                          errorText: "Address required"),
                                      // FormBuilderValidators.numeric(),
                                      // FormBuilderValidators.max(6),
                                    ]),
                                    onSaved: (value) {
                                      setState(() {
                                        if (sameAddress == 'true') {
                                          newAddress.userAddress =
                                              userData!.userAddress;
                                        } else {
                                          newAddress.userAddress = value;
                                        }
                                      });
                                    },
                                  ),
                                ),
                              ),
                            ),
                            Container(height: 15),
                            Align(
                                alignment: Alignment.bottomLeft,
                                child: Text("LANDMARK",
                                    style: MyText.body1(context)!
                                        .copyWith(color: MyColors.grey_60))),
                            Container(height: 5),
                            Card(
                              shape: RoundedRectangleBorder(
                                borderRadius: BorderRadius.circular(3),
                              ),
                              clipBehavior: Clip.antiAliasWithSaveLayer,
                              margin: EdgeInsets.all(0),
                              elevation: 0,
                              child: Padding(
                                padding: const EdgeInsets.only(
                                    top: 0.0, bottom: 0.0),
                                child: Container(
                                  alignment: Alignment.centerLeft,
                                  padding: EdgeInsets.symmetric(
                                      horizontal: 0, vertical: 0.0),
                                  child: FormBuilderTextField(
                                    initialValue: sameAddress == 'true'
                                        ? '${userData!.userlandmark}'
                                        : "",
                                    // onFieldSubmitted: (val) {
                                    //   FocusScope.of(context)
                                    //       .requestFocus(focus6);
                                    // },
                                    focusNode: focus5,
                                    name: "Landmark",
                                    decoration: InputDecoration(
                                        hintText: "LANDMARK",
                                        //  labelText: "REGISTER NUMBER",
                                        border: OutlineInputBorder(
                                            borderRadius:
                                                BorderRadius.circular(3.0))),
                                    validator: FormBuilderValidators.compose([
                                FormBuilderValidators.required(context,
                                          errorText: "Landmark required"),
                                      // FormBuilderValidators.numeric(),
                                      // FormBuilderValidators.max(6),
                                    ]),
                                    onSaved: (value) {
                                      setState(() {
                                        if (sameAddress == 'true') {
                                          newAddress.userlandmark =
                                              userData!.userlandmark;
                                        } else {
                                          newAddress.userlandmark = value;
                                        }
                                      });
                                    },
                                  ),
                                ),
                              ),
                            ),
                            Container(height: 15),
                            Align(
                                alignment: Alignment.bottomLeft,
                                child: Text("DISTRICT",
                                    style: MyText.body1(context)!
                                        .copyWith(color: MyColors.grey_60))),
                            Container(height: 5),
                            Card(
                              shape: RoundedRectangleBorder(
                                borderRadius: BorderRadius.circular(3),
                              ),
                              clipBehavior: Clip.antiAliasWithSaveLayer,
                              margin: EdgeInsets.all(0),
                              elevation: 0,
                              child: Padding(
                                padding: const EdgeInsets.only(
                                    top: 0.0, bottom: 0.0),
                                child: Container(
                                  alignment: Alignment.centerLeft,
                                  padding: EdgeInsets.symmetric(
                                      horizontal: 0, vertical: 0.0),
                                  child: FormBuilderTextField(
                                    initialValue: sameAddress == 'true'
                                        ? '${userData!.district}'
                                        : "",
                                    // onFieldSubmitted: (val) {
                                    //   FocusScope.of(context)
                                    //       .requestFocus(focus7);
                                    // },
                                    focusNode: focus6,
                                    name: "District",
                                    decoration: InputDecoration(
                                        hintText: "DISTRICT",
                                        //  labelText: "REGISTER NUMBER",
                                        border: OutlineInputBorder(
                                            borderRadius:
                                                BorderRadius.circular(3.0))),
                                   validator: FormBuilderValidators.compose([
                                FormBuilderValidators.required(context),
                                      // FormBuilderValidators.numeric(),
                                      // FormBuilderValidators.max(6),
                                    ]),
                                    onSaved: (value) {
                                      setState(() {
                                        if (sameAddress == 'true') {
                                          newAddress.district =
                                              userData!.district;
                                        } else {
                                          newAddress.district = value;
                                        }
                                      });
                                    },
                                  ),
                                ),
                              ),
                            ),
                            Container(height: 15),
                            Align(
                                alignment: Alignment.bottomLeft,
                                child: Text("STATE",
                                    style: MyText.body1(context)!
                                        .copyWith(color: MyColors.grey_60))),
                            Container(height: 5),
                            Card(
                              shape: RoundedRectangleBorder(
                                borderRadius: BorderRadius.circular(3),
                              ),
                              clipBehavior: Clip.antiAliasWithSaveLayer,
                              margin: EdgeInsets.all(0),
                              elevation: 0,
                              child: Padding(
                                padding: const EdgeInsets.only(
                                    top: 0.0, bottom: 0.0),
                                child: Container(
                                  alignment: Alignment.centerLeft,
                                  padding: EdgeInsets.symmetric(
                                      horizontal: 0, vertical: 0.0),
                                  child: FormBuilderTextField(
                                    initialValue: sameAddress == 'true'
                                        ? '${userData!.state}'
                                        : "",
                                    // onFieldSubmitted: (val) {
                                    //   FocusScope.of(context)
                                    //       .requestFocus(focus8);
                                    // },
                                    focusNode: focus7,
                                    name: "State",
                                    decoration: InputDecoration(
                                        hintText: "STATE",
                                        //  labelText: "REGISTER NUMBER",
                                        border: OutlineInputBorder(
                                            borderRadius:
                                                BorderRadius.circular(3.0))),
                                    validator: FormBuilderValidators.compose([
                                FormBuilderValidators.required(context,),
                                      // FormBuilderValidators.numeric(),
                                      // FormBuilderValidators.max(6),
                                    ]),
                                    onSaved: (value) {
                                      setState(() {
                                        if (sameAddress == 'true') {
                                          newAddress.state = userData!.state;
                                        } else {
                                          newAddress.state = value;
                                        }
                                      });
                                    },
                                  ),
                                ),
                              ),
                            ),
                            Container(height: 15),
                            Align(
                                alignment: Alignment.bottomLeft,
                                child: Text("COUNTRY",
                                    style: MyText.body1(context)!
                                        .copyWith(color: MyColors.grey_60))),
                            Container(height: 5),
                            Card(
                              shape: RoundedRectangleBorder(
                                borderRadius: BorderRadius.circular(3),
                              ),
                              clipBehavior: Clip.antiAliasWithSaveLayer,
                              margin: EdgeInsets.all(0),
                              elevation: 0,
                              child: Padding(
                                padding: const EdgeInsets.only(
                                    top: 0.0, bottom: 0.0),
                                child: Container(
                                  alignment: Alignment.centerLeft,
                                  padding: EdgeInsets.symmetric(
                                      horizontal: 0, vertical: 0.0),
                                  child: FormBuilderTextField(
                                    initialValue: sameAddress == 'true'
                                        ? '${userData!.country}'
                                        : "",
                                    // onFieldSubmitted: (val) {
                                    //   FocusScope.of(context)
                                    //       .requestFocus(focus9);
                                    // },
                                    focusNode: focus8,
                                    name: "Country",
                                    decoration: InputDecoration(
                                        hintText: "COUNTRY",
                                        //  labelText: "REGISTER NUMBER",
                                        border: OutlineInputBorder(
                                            borderRadius:
                                                BorderRadius.circular(3.0))),
                                    validator: FormBuilderValidators.compose([
                                FormBuilderValidators.required(context,),
                                      // FormBuilderValidators.numeric(),
                                      // FormBuilderValidators.max(6),
                                    ]),
                                    onSaved: (value) {
                                      setState(() {
                                        if (sameAddress == 'true') {
                                          newAddress.country = userData!.country;
                                        } else {
                                          newAddress.country = value;
                                        }
                                      });
                                    },
                                  ),
                                ),
                              ),
                            ),
                            Container(height: 15),
                            Align(
                                alignment: Alignment.bottomLeft,
                                child: Text("ZIPCODE",
                                    style: MyText.body1(context)!
                                        .copyWith(color: MyColors.grey_60))),
                            Container(height: 5),
                            Card(
                              shape: RoundedRectangleBorder(
                                borderRadius: BorderRadius.circular(3),
                              ),
                              clipBehavior: Clip.antiAliasWithSaveLayer,
                              margin: EdgeInsets.all(0),
                              elevation: 0,
                              child: Padding(
                                padding: const EdgeInsets.only(
                                    top: 0.0, bottom: 0.0),
                                child: Container(
                                  alignment: Alignment.centerLeft,
                                  padding: EdgeInsets.symmetric(
                                      horizontal: 0, vertical: 0.0),
                                  child: FormBuilderTextField(
                                    initialValue: sameAddress == 'true'
                                        ? '${userData!.pincode}'
                                        : "",
                                    focusNode: focus9,
                                    name: "Zipcode",
                                    keyboardType: TextInputType.number,
                                    decoration: InputDecoration(
                                        hintText: "ZIPCODE",
                                        //  labelText: "REGISTER NUMBER",
                                        border: OutlineInputBorder(
                                            borderRadius:
                                                BorderRadius.circular(3.0))),
                                    validator: FormBuilderValidators.compose([
                                FormBuilderValidators.required(context,
                                          errorText: "Postal code required"),
                                      FormBuilderValidators.numeric(context),
                                      FormBuilderValidators.min(context, 6),
                                    ]),
                                    onSaved: (value) {
                                      setState(() {
                                        if (sameAddress == 'true') {
                                          newAddress.pincode = userData!.pincode;
                                        } else {
                                          newAddress.pincode = value;
                                        }
                                      });
                                    },
                                  ),
                                ),
                              ),
                            ),
                          ],
                        ),
                      ),
                      Container(height: 20),
                      Container(
                        width: double.infinity,
                        height: 45,
                        // ignore: deprecated_member_use
                        child: FlatButton(
                          child: Text("Next",
                              style: MyText.subhead(context)!.copyWith(
                                  color:
                                      !_enableBtn ? Colors.white : Colors.white,
                                  fontWeight: FontWeight.bold,
                                  letterSpacing: 1.5)),
                          color: MyColors.primary,
                          onPressed: !_enableBtn
                              ? null
                              : () {
                                  // print(newAddress.firstName);
                                  _submitForm();
                                },
                        ),
                      )
                    ],
                  ),
                ),
              ),
            ),
          );
  }
}
