import 'dart:convert';

import 'package:drssiddha/app/data/my_colors.dart';
import 'package:drssiddha/app/model/cart_model.dart';
import 'package:drssiddha/app/model/user_model.dart';
import 'package:drssiddha/app/pages/home/home.dart';
import 'package:drssiddha/app/provider/cart_provider.dart';
import 'package:drssiddha/app/utility/auth_utils.dart';
import 'package:drssiddha/app/utility/network_utils.dart';
import 'package:drssiddha/app/widget/my_text.dart';
// import 'package:drssiddha/app/widgets/badge.dart';
import 'package:drssiddha/app/widgets/loader.dart';
import 'package:dio/dio.dart';
import 'package:flutter/material.dart';
import 'package:drssiddha/app/pages/cart/shipping_address.dart';
import 'package:flutter_slidable/flutter_slidable.dart';
import 'package:provider/provider.dart';

class CartPage extends StatefulWidget {
  @override
  _CartPageState createState() => _CartPageState();
}

class _CartPageState extends State<CartPage> {
  // final List<cartItem> items = new List();
  TextEditingController myController = TextEditingController();

  User userData = User();
  bool _load = true;

  var productIDList = [];
  var unitTypeList = [];
  var quantityList = [];
  var priceList = [];

  int cartDataItemsCount = 0;
  int tempcartItemsCount = 0;

  List<Cart> _cartData = [];
  List<Total> _cartTotal = [];
  String? _cartTotalAmount;
  int getQTY = 0;
  

  @override
  void initState() {
    super.initState();
    NetworkUtils.checkDataConnectivity(context, 'home');
    _fetchSessionAndNavigate();
    // setState(() {

    // });
  }

  _fetchSessionAndNavigate() async {
    userData = await AuthUtils.loadSharedPrefs();
    try {
      FormData formData = new FormData.fromMap({
        'post_data': "1",
        'apikey': AuthUtils.api,
        'user_id': userData.userId,
      });
      var responseJson = await NetworkUtils.insertData('cart.php', formData);
      if (responseJson['result'] == 'success') {
        CartModel _cartAllData = CartModel.fromJson(responseJson);
        setState(() {
          _cartData = _cartAllData.data!;
          _cartTotal = _cartAllData.total!;
          for (int i = 0; i < _cartTotal.length; i++) {
            if (_cartTotal[i].title == 'Total') {
              _cartTotalAmount = _cartTotal[i].value;
              print(_cartTotalAmount);
            }
          }
          cartDataItemsCount = 0;
          for (int k = 0; k < _cartData.length; k++) {
            cartDataItemsCount =
                cartDataItemsCount + int.parse(_cartData[k].quantity!);
            print(cartDataItemsCount);
          }

          _load = false;
        });
      } else {
        NetworkUtils.alertDlg(context, responseJson['msg']);
      }
    } catch (error) {
      NetworkUtils.alertDlg(context, error.toString());
    }
  }

  _updateCart() async {
    setState(() {
      _load = true;
    });
    if (productIDList.isEmpty &&
        quantityList.isEmpty &&
        priceList.isEmpty &&
        unitTypeList.isEmpty) {
      setState(() {
        productIDList = [0];
        quantityList = [0];
        priceList = [0];
        unitTypeList = [0];
      });
    }

    try {
      FormData formData = new FormData.fromMap({
        'post_data': "1",
        'apikey': AuthUtils.api,
        'user_id': userData.userId,
        'role_id': userData.roleId,
        'product_id': jsonEncode(productIDList),
        'quantity': jsonEncode(quantityList),
        'price': jsonEncode(priceList),
        'unittype_id': jsonEncode(unitTypeList),
      });
      var responseJson =
          await NetworkUtils.insertData('cart_update.php', formData);
      if (responseJson['result'] == 'success') {
        Navigator.pushReplacement(context,
            MaterialPageRoute(builder: (BuildContext ctx) => CartPage()));
      } else if (responseJson['result'] == "empty_cart") {
        Navigator.pushReplacement(context,
            MaterialPageRoute(builder: (BuildContext ctx) => CartPage()));
      }
    } catch (error) {
      NetworkUtils.alertDlg(context, error.toString());
    }
  }

  
  @override
  Widget build(BuildContext context) {
    final bloc = Provider.of<CartProvider>(context, listen: false);
    // bloc.toStoreCartItems();
    // final cart = bloc.cartItems;
    tempcartItemsCount = bloc.getTotalQuantity;
    // qetQty = bloc.getQuantity(bloc.cartItems.values.toList()[i].tProductid!+'-'+bloc.cartItems.values.toList()[i].unitTypeID!);

    return Scaffold(
      // key: _scffoldKey,
      appBar: AppBar(
        // iconTheme: IconThemeData(color: Colors.white),
        // centerTitle: true,
        backgroundColor: MyColors.primaryValue,
        leading: InkWell(
            onTap: () {
              // Navigator.of(context).pop();
              // Navigator.of(context, rootNavigator: true).pop(context);
              // Navigator.pop(context);
              Navigator.pushReplacement(context,
                  MaterialPageRoute(builder: (BuildContext ctx) => HomePage()));
            },
            child:
                Icon(Icons.arrow_back_ios, size: 16, color: MyColors.primary)),
        title: Text(
          'Cart',
          style: TextStyle(
              color: MyColors.primary,
              fontSize: 18,
              fontWeight: FontWeight.w800,
              letterSpacing: 1.5),
          // style: TextStyle(
          //     fontFamily: "Gotik",
          //     fontSize: 18.0,
          //     color: Colors.black54,
          //     fontWeight: FontWeight.w700),
        ),
        centerTitle: true,
        elevation: 0.0,
        actions: <Widget>[
          Consumer<CartProvider>(
            builder: (_, cart, ch) {
              return cart.getTotalQuantity > 0
                  ? Padding(
                      padding: const EdgeInsets.only(right: 20.0),
                      child: IconButton(
                        hoverColor: Colors.red,
                        tooltip: 'Clear Cart',
                        icon: Icon(
                          Icons.delete_forever_outlined,
                          size: 30,
                          color: MyColors.primary,
                        ),
                        onPressed: () {
                          cart.clear();
                        },
                      ),
                    )
                  : Container();
            },
          ),
        ],
      ),

      ///
      ///
      /// Checking item value of cart
      ///
      ///
      body: _load
          ? LoaderWidget()
          : SingleChildScrollView(
              child: bloc.cartItems.length > 0
                  ? Column(
                      children: <Widget>[
                        Container(
                          height: MediaQuery.of(context).size.height / 1.75,
                          child: ListView.builder(
                            shrinkWrap: true,
                            physics: ScrollPhysics(),
                            itemCount: bloc.cartItems.length,
                            itemBuilder: (context, i) {
                              return Padding(
                                padding:
                                    const EdgeInsets.only(top: 1, bottom: 1.0),
                                child: Slidable(
                                  // delegate: new SlidableDrawerDelegate(),
                                  actionPane: SlidableDrawerActionPane(),
                                  actionExtentRatio: 0.25,
                                  secondaryActions: <Widget>[
                                    new IconSlideAction(
                                      key: Key(bloc.cartItems.values
                                          .toList()[i]
                                          .id!
                                          .toString()),
                                      caption: 'Delete',
                                      color: Colors.redAccent,
                                      icon: Icons.delete,
                                      onTap: () {
                                        setState(() {
                                          print(bloc.cartItems.values
                                              .toList()[i]
                                              .tProductid!);
                                          bloc.removeItem(bloc.cartItems.values
                                                  .toList()[i]
                                                  .tProductid! +
                                              '-' +
                                              bloc.cartItems.values
                                                  .toList()[i]
                                                  .unitTypeID!);
                                        });

                                        ///
                                        /// SnackBar show if cart delet
                                        ///
                                        // ignore: deprecated_member_use
                                        Scaffold.of(context)
                                            .showSnackBar(SnackBar(
                                          content: Text("Items Cart Deleted"),
                                          duration: Duration(seconds: 2),
                                          backgroundColor: Colors.redAccent,
                                        ));
                                      },
                                    ),
                                  ],
                                  child: Padding(
                                    padding: const EdgeInsets.only(
                                        top: 1.0, left: 0.0, right: 0.0),

                                    /// Background Constructor for card
                                    child: Container(
                                      height: 150.0,
                                      decoration: BoxDecoration(
                                        color: Colors.white,
                                        boxShadow: [
                                          BoxShadow(
                                            color:
                                                Colors.black12.withOpacity(0.1),
                                            blurRadius: 3.5,
                                            spreadRadius: 0.4,
                                          )
                                        ],
                                      ),
                                      child: Column(
                                        crossAxisAlignment:
                                            CrossAxisAlignment.start,
                                        children: <Widget>[
                                          Row(
                                            mainAxisAlignment:
                                                MainAxisAlignment.start,
                                            crossAxisAlignment:
                                                CrossAxisAlignment.center,
                                            children: <Widget>[
                                              Padding(
                                                  padding: EdgeInsets.only(
                                                      left: 10.0, right: 10.0),

                                                  /// Image item
                                                  child: Center(
                                                    child: Container(
                                                      decoration: BoxDecoration(
                                                          color: Colors.white
                                                              .withOpacity(0.1),
                                                          boxShadow: [
                                                            BoxShadow(
                                                                color: Colors
                                                                    .black12
                                                                    .withOpacity(
                                                                        0.1),
                                                                blurRadius: 0.5,
                                                                spreadRadius:
                                                                    0.1)
                                                          ]),
                                                      child: Image.network(
                                                        bloc.cartItems.values
                                                            .toList()[i]
                                                            .img!,
                                                        height: 100.0,
                                                        width: 75.0,
                                                        fit: BoxFit.cover,
                                                      ),
                                                    ),
                                                  )),
                                              Flexible(
                                                child: Padding(
                                                  padding:
                                                      const EdgeInsets.only(
                                                          top: 10.0,
                                                          left: 10.0,
                                                          right: 5.0),
                                                  child: Column(
                                                    /// Text Information Item
                                                    crossAxisAlignment:
                                                        CrossAxisAlignment
                                                            .start,
                                                    mainAxisAlignment:
                                                        MainAxisAlignment.start,
                                                    children: <Widget>[
                                                      Row(
                                                        mainAxisAlignment:
                                                            MainAxisAlignment
                                                                .spaceBetween,
                                                        children: [
                                                          Container(
                                                            width: MediaQuery.of(
                                                                        context)
                                                                    .size
                                                                    .width -
                                                                175,
                                                            child: Text(
                                                              bloc.cartItems
                                                                      .values
                                                                      .toList()[
                                                                          i]
                                                                      .productTitle! +
                                                                  ' - ' +
                                                                  bloc.cartItems
                                                                      .values
                                                                      .toList()[
                                                                          i]
                                                                      .unitTypeName!,
                                                              maxLines: 2,
                                                              style: TextStyle(
                                                                fontWeight:
                                                                    FontWeight
                                                                        .w700,
                                                                // fontFamily: "Sans",
                                                                color: Colors
                                                                    .black87,
                                                              ),
                                                              overflow:
                                                                  TextOverflow
                                                                      .ellipsis,
                                                            ),
                                                          ),
                                                          Align(
                                                            alignment: Alignment
                                                                .topRight,
                                                            child: Padding(
                                                              padding:
                                                                  const EdgeInsets
                                                                      .all(8.0),
                                                              child: IconButton(
                                                                hoverColor:
                                                                    Colors.red,
                                                                tooltip:
                                                                    'Remove Item',
                                                                icon: Icon(
                                                                  Icons
                                                                      .delete_forever_outlined,
                                                                  size: 30,
                                                                  color: Colors
                                                                      .red,
                                                                ),
                                                                onPressed: () {
                                                                  bloc.removeItem(bloc
                                                                          .cartItems
                                                                          .values
                                                                          .toList()[
                                                                              i]
                                                                          .tProductid! +
                                                                      '-' +
                                                                      bloc.cartItems
                                                                          .values
                                                                          .toList()[
                                                                              i]
                                                                          .unitTypeID!);
                                                                },
                                                              ),
                                                            ),
                                                          ),
                                                        ],
                                                      ),
                                                      Padding(
                                                          padding:
                                                              EdgeInsets.only(
                                                                  top: 5.0)),
                                                      Row(
                                                        crossAxisAlignment:
                                                            CrossAxisAlignment
                                                                .center,
                                                        mainAxisAlignment:
                                                            MainAxisAlignment
                                                                .start,
                                                        children: <Widget>[
                                                          Consumer<
                                                              CartProvider>(
                                                            builder: (context,
                                                                cart, child) {
                                                              return Text(
                                                                'quantity : ' +
                                                                    bloc
                                                                        .getQuantity(cart.cartItems.values.toList()[i].tProductid! +
                                                                            '-' +
                                                                            cart.cartItems.values
                                                                                .toList()[
                                                                                    i]
                                                                                .unitTypeID!)
                                                                        .toString() +
                                                                    ' X ' +
                                                                    '₹ ' +
                                                                    bloc.cartItems
                                                                        .values
                                                                        .toList()[
                                                                            i]
                                                                        .price!,
                                                                style: TextStyle(
                                                                    color: MyColors
                                                                        .grey_60,
                                                                    fontSize:
                                                                        14.0,
                                                                    fontWeight:
                                                                        FontWeight
                                                                            .bold),
                                                              );
                                                            },
                                                          ),
                                                          Expanded(
                                                              child: SizedBox(
                                                                  width: 5.0)),
                                                          Padding(
                                                            padding:
                                                                const EdgeInsets
                                                                        .only(
                                                                    right:
                                                                        10.0),
                                                            child: Consumer<
                                                                CartProvider>(
                                                              builder: (context,
                                                                  cart, child) {
                                                                return Text(
                                                                  '₹ ' +
                                                                      (int.parse(cart.cartItems.values.toList()[i].price!) *
                                                                              cart.cartItems.values.toList()[i].quantity!)
                                                                          .toString(),
                                                                  style: TextStyle(
                                                                      fontSize:
                                                                          14.0,
                                                                      fontWeight:
                                                                          FontWeight
                                                                              .bold),
                                                                );
                                                              },
                                                            ),
                                                          ),
                                                        ],
                                                      ),
                                                      Padding(
                                                          padding:
                                                              EdgeInsets.only(
                                                                  top: 5.0)),
                                                      Row(
                                                        crossAxisAlignment:
                                                            CrossAxisAlignment
                                                                .center,
                                                        mainAxisAlignment:
                                                            MainAxisAlignment
                                                                .center,
                                                        children: <Widget>[
                                                          Padding(
                                                            padding:
                                                                const EdgeInsets
                                                                        .only(
                                                                    top: 10.0,
                                                                    right:
                                                                        10.0),
                                                            child: Container(
                                                              width: 130.0,
                                                              decoration: BoxDecoration(
                                                                  color: Colors
                                                                      .white70,
                                                                  border: Border.all(
                                                                      color: Colors
                                                                          .black12
                                                                          .withOpacity(
                                                                              0.1))),
                                                              child: Row(
                                                                mainAxisAlignment:
                                                                    MainAxisAlignment
                                                                        .spaceAround,
                                                                children: <
                                                                    Widget>[
                                                                  /// Decrease of value item
                                                                  InkWell(
                                                                    onTap: () {
                                                                      bloc.removeSingleItem(bloc
                                                                              .cartItems
                                                                              .values
                                                                              .toList()[
                                                                                  i]
                                                                              .tProductid! +
                                                                          '-' +
                                                                          bloc.cartItems
                                                                              .values
                                                                              .toList()[i]
                                                                              .unitTypeID!);
                                                                    },
                                                                    child:
                                                                        Container(
                                                                      height:
                                                                          30.0,
                                                                      width:
                                                                          30.0,
                                                                      decoration:
                                                                          BoxDecoration(
                                                                              border: Border(right: BorderSide(color: Colors.black12.withOpacity(0.1)))),
                                                                      child: Center(
                                                                          child: Text(
                                                                        "-",
                                                                        style: TextStyle(
                                                                            fontWeight:
                                                                                FontWeight.bold),
                                                                      )),
                                                                    ),
                                                                  ),
                                                                  Padding(
                                                                    padding: const EdgeInsets
                                                                            .symmetric(
                                                                        horizontal:
                                                                            18.0),
                                                                    child: 
                                                                    Consumer<
                                                                CartProvider>(
                                                              builder: (context,
                                                                  cart, child) {
                                                                return Text(
                                                                      cart.cartItems
                                                                          .values
                                                                          .toList()[
                                                                              i]
                                                                          .quantity
                                                                          .toString(),
                                                                      style: TextStyle(
                                                                          fontWeight:
                                                                              FontWeight.bold),
                                                                    );
                                                              },
                                                            ),
                                                                    
                                                                    
                                                                  ),

                                                                  /// Increasing value of item
                                                                  InkWell(
                                                                    onTap: () {
                                                                      // print(_productId);
                                                                      //  cart.addItem(
                                                                      //                 product.productId,
                                                                      //                 product.productName,
                                                                      //                 product.images[0],
                                                                      //                 product.productMrp);
                                                                      bloc.addItem(
                                                                          bloc.cartItems.values.toList()[i].tProductid! +
                                                                              '-' +
                                                                              bloc.cartItems.values
                                                                                  .toList()[
                                                                                      i]
                                                                                  .unitTypeID!,
                                                                          bloc.cartItems
                                                                              .values
                                                                              .toList()[
                                                                                  i]
                                                                              .tProductid!,
                                                                          bloc.cartItems
                                                                              .values
                                                                              .toList()[
                                                                                  i]
                                                                              .productTitle!,
                                                                          bloc.cartItems
                                                                              .values
                                                                              .toList()[
                                                                                  i]
                                                                              .img!,
                                                                          bloc.cartItems
                                                                              .values
                                                                              .toList()[
                                                                                  i]
                                                                              .unitTypeID!,
                                                                          bloc.cartItems
                                                                              .values
                                                                              .toList()[
                                                                                  i]
                                                                              .unitTypeName!,
                                                                          bloc.cartItems
                                                                              .values
                                                                              .toList()[i]
                                                                              .price!);
                                                                    },
                                                                    child:
                                                                        Container(
                                                                      height:
                                                                          30.0,
                                                                      width:
                                                                          30.0,
                                                                      decoration:
                                                                          BoxDecoration(
                                                                              border: Border(left: BorderSide(color: Colors.black12.withOpacity(0.1)))),
                                                                      child: Center(
                                                                          child: Text(
                                                                        "+",
                                                                        style: TextStyle(
                                                                            fontWeight:
                                                                                FontWeight.bold),
                                                                      )),
                                                                    ),
                                                                  ),
                                                                ],
                                                              ),
                                                            ),
                                                          ),
                                                        ],
                                                      ),
                                                    ],
                                                  ),
                                                ),
                                              ),
                                            ],
                                          ),
                                          SizedBox(height: 5.0)
                                        ],
                                      ),
                                    ),
                                  ),
                                ),
                              );

                              // individualCartItem(
                              //   context,
                              //   bloc.cartItems.values.toList()[i].id!,
                              //   bloc.cartItems.values.toList()[i].tProductid!,
                              //   bloc.cartItems.values.toList()[i].price!,
                              //   bloc.cartItems.values.toList()[i].quantity!,
                              //   bloc.cartItems.values.toList()[i].productTitle!,
                              //   bloc.cartItems.values.toList()[i].unitTypeID!,
                              //   bloc.cartItems.values.toList()[i].unitTypeName!,
                              //   bloc.cartItems.values.toList()[i].img!,
                              // );
                            },
                            scrollDirection: Axis.vertical,
                          ),
                        ),
                        //  Expanded(child: SizedBox(height: 5)),
                        cartAmountTag(context, _cartTotal)
                      ],
                    )
                  : NoItemCart(),
            ),

      bottomNavigationBar: footer(),
    );
  }

  cartAmountTag(BuildContext context, List<Total> _cartAmtData) {
    return Container(
      height: 140,
      child: Column(
        children: [
          Expanded(child: SizedBox(height: 5.0)),
          ListView.builder(
            shrinkWrap: true,
            physics: ScrollPhysics(),
            itemCount: _cartAmtData.length,
            itemBuilder: (BuildContext contxt, int i) {
              return Row(
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                children: <Widget>[
                  Container(
                    margin: EdgeInsets.only(left: 30),
                    child: Text(
                      _cartAmtData[i].title!,
                      // style: CustomTextStyle.textFormFieldMedium
                      //     .copyWith(color: Colors.grey, fontSize: 15),
                    ),
                  ),
                  Container(
                    margin: EdgeInsets.only(right: 20),
                    child: Text(
                      '₹ ' + _cartAmtData[i].value.toString(),
                      style: TextStyle(
                          color: Colors.black,
                          fontSize: 17,
                          fontWeight: FontWeight.bold),

                      // style: CustomTextStyle.textFormFieldBlack
                      //     .copyWith(color: Colors.black, fontSize: 15),
                    ),
                  ),
                ],
              );
            },
          ),
        ],
      ),
    );
  }

  footer() {
    CartProvider bloc = Provider.of<CartProvider>(context, listen: false);
    return Row(
      crossAxisAlignment: CrossAxisAlignment.center,
      mainAxisAlignment: MainAxisAlignment.center,
      children: [
        Container(
          padding: EdgeInsets.fromLTRB(5.0, 0.0, 5.0, 0.0),
          width: MediaQuery.of(context).size.width / 2.5,
         
          child: Consumer<CartProvider>(
            builder: (_, cart, ch) {
               // ignore: deprecated_member_use
              return RaisedButton(
            color: MyColors.primary,
            onPressed: cartDataItemsCount != cart.getTotalQuantity
                ? () {
                    cart.cartItems.forEach((key, value) {
                      setState(() {
                        productIDList.add(value.tProductid);
                        unitTypeList.add(value.unitTypeID);
                        quantityList.add(value.quantity);
                        priceList.add(value.price);
                      });

                      print(value.unitTypeID);
                      print(value.unitTypeName);
                      print(key);
                    });

                    print(unitTypeList);
                    print(productIDList);

                    _updateCart();
                  }
                : null,
            padding: EdgeInsets.only(top: 5, left: 10, right: 10, bottom: 5),
            child: Text(
              "Update Cart",
              style: MyText.subhead(context)!.copyWith(
                  color: Colors.white,
                  letterSpacing: 1.0,
                  fontWeight: FontWeight.bold),
            ),
          );}),
        ),
        Container(
          padding: EdgeInsets.fromLTRB(5.0, 0.0, 5.0, 0.0),
          width: MediaQuery.of(context).size.width / 2.5,
          // ignore: deprecated_member_use
          child:  Consumer<CartProvider>(
            builder: (_, cart, ch) {
               // ignore: deprecated_member_use
              return RaisedButton(
            color: MyColors.primary,
            onPressed: cartDataItemsCount == cart.getTotalQuantity &&
                    cart.getTotalQuantity != 0 &&
                    cartDataItemsCount != 0
                ? () {
                    Navigator.push(
                        context,
                        new MaterialPageRoute(
                            builder: (context) =>
                                AddressPage(_cartTotalAmount)));
                  }
                : null,
            padding: EdgeInsets.only(top: 5, left: 10, right: 10, bottom: 5),
            child: Text(
              "Confirm",
              style: MyText.subhead(context)!.copyWith(
                  color: Colors.white,
                  letterSpacing: 1.0,
                  fontWeight: FontWeight.bold),
            ),
          );}),
        ),
      ],
    );
  }
}

///
///
/// If no item cart this class showing
///
class NoItemCart extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    return Container(
      // width: 500.0,
      height: MediaQuery.of(context).size.height,
      color: Colors.white,
      // height: double.infinity,
      child: Align(
        alignment: Alignment.center,
        child: Text(
          "Not Have an Item",
          textAlign: TextAlign.center,
          style: TextStyle(
            fontWeight: FontWeight.w500,
            fontSize: 18.5,
            color: Colors.black.withOpacity(0.2),
          ),
        ),
      ),
    );
  }
}
