// To parse this JSON data, do
//
//     final userRoleData = userRoleDataFromJson(jsonString);

import 'dart:convert';

UserRoleData userRoleDataFromJson(String str) => UserRoleData.fromJson(json.decode(str));

String userRoleDataToJson(UserRoleData data) => json.encode(data.toJson());

class UserRoleData {
    UserRoleData({
        this.result,
        this.msg,
        this.data,
    });

    String? result;
    String? msg;
    List<UserRole>? data;

    factory UserRoleData.fromJson(Map<String, dynamic> json) => UserRoleData(
        result: json["result"] == null ? null : json["result"],
        msg: json["msg"] == null ? null : json["msg"],
        data: json["data"] == null ? null : List<UserRole>.from(json["data"].map((x) => UserRole.fromJson(x))),
    );

    Map<String, dynamic> toJson() => {
        "result": result == null ? null : result,
        "msg": msg == null ? null : msg,
        "data": data == null ? null : List<dynamic>.from(data!.map((x) => x.toJson())),
    };
}

class UserRole {
    UserRole({
        this.role,
        this.roleId,
    });

    String? role;
    String? roleId;

    factory UserRole.fromJson(Map<String, dynamic> json) => UserRole(
        role: json["role"] == null ? null : json["role"],
        roleId: json["role_id"] == null ? null : json["role_id"],
    );

    Map<String, dynamic> toJson() => {
        "role": role == null ? null : role,
        "role_id": roleId == null ? null : roleId,
    };
}
