// To parse this JSON data, do
//
//     final userModel = userModelFromJson(jsonString);

import 'dart:convert';

UserModel userModelFromJson(String str) => UserModel.fromJson(json.decode(str));

String userModelToJson(UserModel data) => json.encode(data.toJson());

class UserModel {
    UserModel({
        this.result,
        this.msg,
        this.data,
    });

    String? result;
    String? msg;
    User? data;

    factory UserModel.fromJson(Map<String, dynamic> json) => UserModel(
        result: json["result"] == null ? null : json["result"],
        msg: json["msg"] == null ? null : json["msg"],
        data: json["data"] == null ? null : User.fromJson(json["data"]),
    );

    Map<String, dynamic> toJson() => {
        "result": result == null ? null : result,
        "msg": msg == null ? null : msg,
        "data": data == null ? null : data!.toJson(),
    };
}

class User {
    User({
        this.userId,
        this.name,
        this.userName,
        this.userEmail,
        this.userPhone,
        this.userAddress,
        this.userlandmark,
        this.district,
        this.state,
        this.country,
        this.pincode,
        this.roleId,
        this.doctorRegNo,
        this.discount,
    });

    String? userId;
    String? name;
    String? userName;
    String? userEmail;
    String? userPhone;
    String? userAddress;
    String? userlandmark;
    String? district;
    String? state;
    String? country;
    String? pincode;
    String? roleId;
    String? doctorRegNo;
    String? discount;

    factory User.fromJson(Map<String, dynamic> json) => User(
        userId: json["userId"] == null ? null : json["userId"],
        name: json["name"] == null ? null : json["name"],
        userName: json["userName"] == null ? null : json["userName"],
        userEmail: json["userEmail"] == null ? null : json["userEmail"],
        userPhone: json["userPhone"] == null ? null : json["userPhone"],
        userAddress: json["userAddress"] == null ? null : json["userAddress"],
        userlandmark: json["userlandmark"] == null ? null : json["userlandmark"],
        district: json["district"] == null ? null : json["district"],
        state: json["state"] == null ? null : json["state"],
        country: json["country"] == null ? null : json["country"],
        pincode: json["pincode"] == null ? null : json["pincode"],
        roleId: json["roleId"] == null ? null : json["roleId"],
        doctorRegNo: json["doctorRegnumber"] == null ? null : json["doctorRegnumber"],
        discount: json["discount"] == null ? null : json["discount"],
    );

    Map<String, dynamic> toJson() => {
        "userId": userId == null ? null : userId,
        "name": name == null ? null : name,
        "userName": userName == null ? null : userName,
        "userEmail": userEmail == null ? null : userEmail,
        "userPhone": userPhone == null ? null : userPhone,
        "userAddress": userAddress == null ? null : userAddress,
        "userlandmark": userlandmark == null ? null : userlandmark,
        "district": district == null ? null : district,
        "state": state == null ? null : state,
        "country": country == null ? null : country,
        "pincode": pincode == null ? null : pincode,
        "roleId": roleId == null ? null : roleId,
        "doctorRegnumber": doctorRegNo == null ? null : doctorRegNo,
        "discount": discount == null ? null : discount,
    };
}
