// To parse this JSON data, do
//
//     final materialProductsModel = materialProductsModelFromJson(jsonString);

import 'dart:convert';

MaterialProductsModel materialProductsModelFromJson(String str) => MaterialProductsModel.fromJson(json.decode(str));

String materialProductsModelToJson(MaterialProductsModel data) => json.encode(data.toJson());

class MaterialProductsModel {
    MaterialProductsModel({
        this.result,
        this.msg,
        this.data,
    });

    String? result;
    String? msg;
    List<MaterialProduct>? data;

    factory MaterialProductsModel.fromJson(Map<String, dynamic> json) => MaterialProductsModel(
        result: json["result"] == null ? null : json["result"],
        msg: json["msg"] == null ? null : json["msg"],
        data: json["data"] == null ? null : List<MaterialProduct>.from(json["data"].map((x) => MaterialProduct.fromJson(x))),
    );

    Map<String, dynamic> toJson() => {
        "result": result == null ? null : result,
        "msg": msg == null ? null : msg,
        "data": data == null ? null : List<dynamic>.from(data!.map((x) => x.toJson())),
    };
}

class MaterialProduct {
    MaterialProduct({
        this.productId,
        this.hsnCode,
        this.productCode,
        this.categoryId,
        this.productName,
        this.productImage,
        this.availableQuantity,
        this.referenceBook,
        this.dosage,
        this.productUsage,
        this.indication,
        this.presentation,
        this.productType,
        this.usefullFor,
        this.productCgst,
        this.productSgst,
        this.productUtgst,
        this.productIgst,
        this.createdTime,
        this.updatedTime,
        this.imageLink,
        this.productIngredients,
        this.productPackage,
    });

    String? productId;
    String? hsnCode;
    String? productCode;
    String? categoryId;
    String? productName;
    String? productImage;
    String? availableQuantity;
    String? referenceBook;
    String? dosage;
    String? productUsage;
    String? indication;
    String? presentation;
    String? productType;
    String? usefullFor;
    String? productCgst;
    String? productSgst;
    String? productUtgst;
    String? productIgst;
    String? createdTime;
    AtedTime? updatedTime;
    String? imageLink;
    List<ProductIngredient>? productIngredients;
    List<ProductPackage>? productPackage;

    factory MaterialProduct.fromJson(Map<String, dynamic> json) => MaterialProduct(
        productId: json["productId"] == null ? null : json["productId"],
        hsnCode: json["hsnCode"] == null ? null : json["hsnCode"],
        productCode: json["productCode"] == null ? null : json["productCode"],
        categoryId: json["categoryId"] == null ? null : json["categoryId"],
        productName: json["productName"] == null ? null : json["productName"],
        productImage: json["productImage"] == null ? null : json["productImage"],
        availableQuantity: json["availableQuantity"] == null ? null : json["availableQuantity"],
        referenceBook: json["referenceBook"] == null ? null : json["referenceBook"],
        dosage: json["dosage"] == null ? null : json["dosage"],
        productUsage: json["productUsage"] == null ? null : json["productUsage"],
        indication: json["indication"] == null ? null : json["indication"],
        presentation: json["presentation"] == null ? null : json["presentation"],
        productType: json["productType"] == null ? null : json["productType"],
        usefullFor: json["usefullFor"] == null ? null : json["usefullFor"],
        productCgst: json["productCgst"] == null ? null : json["productCgst"],
        productSgst: json["productSgst"] == null ? null : json["productSgst"],
        productUtgst: json["productUtgst"] == null ? null : json["productUtgst"],
        productIgst: json["productIgst"] == null ? null : json["productIgst"],
        createdTime: json["createdTime"] == null ? null : json["createdTime"],
        updatedTime: json["updatedTime"] == null ? null : atedTimeValues.map![json["updatedTime"]],
        imageLink: json["image_link"] == null ? null : json["image_link"],
        productIngredients: json["product_ingredients"] == null ? null : List<ProductIngredient>.from(json["product_ingredients"].map((x) => ProductIngredient.fromJson(x))),
        productPackage: json["product_package"] == null ? null : List<ProductPackage>.from(json["product_package"].map((x) => ProductPackage.fromJson(x))),
    );

    Map<String, dynamic> toJson() => {
        "productId": productId == null ? null : productId,
        "hsnCode": hsnCode == null ? null : hsnCode,
        "productCode": productCode == null ? null : productCode,
        "categoryId": categoryId == null ? null : categoryId,
        "productName": productName == null ? null : productName,
        "productImage": productImage == null ? null : productImage,
        "availableQuantity": availableQuantity == null ? null : availableQuantity,
        "referenceBook": referenceBook == null ? null : referenceBook,
        "dosage": dosage == null ? null : dosage,
        "productUsage": productUsage == null ? null : productUsage,
        "indication": indication == null ? null : indication,
        "presentation": presentation == null ? null : presentation,
        "productType": productType == null ? null : productType,
        "usefullFor": usefullFor == null ? null : usefullFor,
        "productCgst": productCgst == null ? null : productCgst,
        "productSgst": productSgst == null ? null : productSgst,
        "productUtgst": productUtgst == null ? null : productUtgst,
        "productIgst": productIgst == null ? null : productIgst,
        "createdTime": createdTime == null ? null : createdTime,
        "updatedTime": updatedTime == null ? null : atedTimeValues.reverse[updatedTime],
        "image_link": imageLink == null ? null : imageLink,
        "product_ingredients": productIngredients == null ? null : List<dynamic>.from(productIngredients!.map((x) => x.toJson())),
        "product_package": productPackage == null ? null : List<dynamic>.from(productPackage!.map((x) => x.toJson())),
    };
}

class ProductIngredient {
    ProductIngredient({
        this.productIngredientid,
        this.productId,
        this.ingredientsId,
        this.ingredientsQuantity,
        this.createdTime,
        this.updatedTime,
        this.sanskritName,
        this.botanicalName,
        this.partUsed,
    });

    String? productIngredientid;
    String? productId;
    String? ingredientsId;
    String? ingredientsQuantity;
    String? createdTime;
    AtedTime? updatedTime;
    String? sanskritName;
    String? botanicalName;
    String? partUsed;

    factory ProductIngredient.fromJson(Map<String, dynamic> json) => ProductIngredient(
        productIngredientid: json["productIngredientid"] == null ? null : json["productIngredientid"],
        productId: json["productId"] == null ? null : json["productId"],
        ingredientsId: json["ingredientsId"] == null ? null : json["ingredientsId"],
        ingredientsQuantity: json["ingredientsQuantity"] == null ? null : json["ingredientsQuantity"],
        createdTime: json["createdTime"] == null ? null : json["createdTime"],
        updatedTime: json["updatedTime"] == null ? null : atedTimeValues.map![json["updatedTime"]],
        sanskritName: json["sanskritName"] == null ? null : json["sanskritName"],
        botanicalName: json["botanicalName"] == null ? null : json["botanicalName"],
        partUsed: json["partUsed"] == null ? null : json["partUsed"],
    );

    Map<String, dynamic> toJson() => {
        "productIngredientid": productIngredientid == null ? null : productIngredientid,
        "productId": productId == null ? null : productId,
        "ingredientsId": ingredientsId == null ? null : ingredientsId,
        "ingredientsQuantity": ingredientsQuantity == null ? null : ingredientsQuantity,
        "createdTime": createdTime == null ? null : createdTime,
        "updatedTime": updatedTime == null ? null : atedTimeValues.reverse[updatedTime],
        "sanskritName": sanskritName == null ? null : sanskritName,
        "botanicalName": botanicalName == null ? null : botanicalName,
        "partUsed": partUsed == null ? null : partUsed,
    };
}

enum AtedTime { THE_00000000000000 }

final atedTimeValues = EnumValues({
    "0000-00-00 00:00:00": AtedTime.THE_00000000000000
});

class ProductPackage {
    ProductPackage({
        this.categoryunitId,
        this.categoryId,
        this.typeId,
        this.typeName,
        this.categoryName,
        this.categoryImage,
        this.categoryStatus,
        this.createdTime,
        this.updatedTime,
        this.priceId,
        this.productId,
        this.unittypeId,
        this.price,
        this.stockQty,
    });

    String? categoryunitId;
    String? categoryId;
    String? typeId;
    String? typeName;
    String? categoryName;
    String? categoryImage;
    String? categoryStatus;
    AtedTime? createdTime;
    AtedTime? updatedTime;
    String? priceId;
    String? productId;
    String? unittypeId;
    String? price;
    String? stockQty;

    factory ProductPackage.fromJson(Map<String, dynamic> json) => ProductPackage(
        categoryunitId: json["categoryunitId"] == null ? null : json["categoryunitId"],
        categoryId: json["categoryId"] == null ? null : json["categoryId"],
        typeId: json["typeId"] == null ? null : json["typeId"],
        typeName: json["typeName"] == null ? null : json["typeName"],
        categoryName: json["categoryName"] == null ? null : json["categoryName"],
        categoryImage: json["categoryImage"] == null ? null : json["categoryImage"],
        categoryStatus: json["categoryStatus"] == null ? null : json["categoryStatus"],
        createdTime: json["createdTime"] == null ? null : atedTimeValues.map![json["createdTime"]],
        updatedTime: json["updatedTime"] == null ? null : atedTimeValues.map![json["updatedTime"]],
        priceId: json["priceId"] == null ? null : json["priceId"],
        productId: json["productId"] == null ? null : json["productId"],
        unittypeId: json["unittypeId"] == null ? null : json["unittypeId"],
        price: json["price"] == null ? null : json["price"],
        stockQty: json["stockQty"] == null ? null : json["stockQty"],
    );

    Map<String, dynamic> toJson() => {
        "categoryunitId": categoryunitId == null ? null : categoryunitId,
        "categoryId": categoryId == null ? null : categoryId,
        "typeId": typeId == null ? null : typeId,
        "typeName": typeName == null ? null : typeName,
        "categoryName": categoryName == null ? null : categoryName,
        "categoryImage": categoryImage == null ? null : categoryImage,
        "categoryStatus": categoryStatus == null ? null : categoryStatus,
        "createdTime": createdTime == null ? null : atedTimeValues.reverse[createdTime],
        "updatedTime": updatedTime == null ? null : atedTimeValues.reverse[updatedTime],
        "priceId": priceId == null ? null : priceId,
        "productId": productId == null ? null : productId,
        "unittypeId": unittypeId == null ? null : unittypeId,
        "price": price == null ? null : price,
        "stockQty": stockQty == null ? null : stockQty,
    };
}

class EnumValues<T> {
    Map<String, T>? map;
    Map<T, String>? reverseMap;

    EnumValues(this.map);

    Map<T, String> get reverse {
        if (reverseMap == null) {
            reverseMap = map!.map((k, v) => new MapEntry(v, k));
        }
        return reverseMap!;
    }
}
