// To parse this JSON data, do
//
//     final cartModel = cartModelFromJson(jsonString);

import 'dart:convert';

CartModel cartModelFromJson(String str) => CartModel.fromJson(json.decode(str));

String cartModelToJson(CartModel data) => json.encode(data.toJson());

class CartModel {
  CartModel({
    this.result,
    this.msg,
    this.data,
    this.total,
  });

  String? result;
  String? msg;
  List<Cart>? data;
  List<Total>? total;

  factory CartModel.fromJson(Map<String, dynamic> json) => CartModel(
        result: json["result"] == null ? null : json["result"],
        msg: json["msg"] == null ? null : json["msg"],
        data: json["data"] == null
            ? null
            : List<Cart>.from(json["data"].map((x) => Cart.fromJson(x))),
        total: json["total"] == null ? null : List<Total>.from(json["total"].map((x) => Total.fromJson(x))),    
      );

  Map<String, dynamic> toJson() => {
        "result": result == null ? null : result,
        "msg": msg == null ? null : msg,
        "data": data == null
            ? null
            : List<dynamic>.from(data!.map((x) => x.toJson())),
        "total": total == null ? null : List<dynamic>.from(total!.map((x) => x.toJson())),
      };
}

class Cart {
  Cart({
    this.cartId,
    this.userId,
    this.roleId,
    this.productId,
    this.unitTypeId,
    this.productUnittype,
    this.quantity,
    this.price,
    this.createdTime,
    this.updatedTime,
    this.hsnCode,
    this.productCode,
    this.categoryId,
    this.productName,
    this.productImage,
    this.availableQuantity,
    this.referenceBook,
    this.dosage,
    this.productUsage,
    this.indication,
    this.presentation,
    this.productType,
    this.usefullFor,
    this.productCgst,
    this.productSgst,
    this.productUtgst,
    this.productIgst,
    this.typeId,
    this.typeName,
    this.imageLink,
  });

  String? cartId;
  String? userId;
  String? roleId;
  String? productId;
  String? unitTypeId;
  String? productUnittype;
  String? quantity;
  String? price;
  String? createdTime;
  String? updatedTime;
  String? hsnCode;
  String? productCode;
  String? categoryId;
  String? productName;
  String? productImage;
  String? availableQuantity;
  String? referenceBook;
  String? dosage;
  String? productUsage;
  String? indication;
  String? presentation;
  String? productType;
  String? usefullFor;
  String? productCgst;
  String? productSgst;
  String? productUtgst;
  String? productIgst;
  String? typeId;
  String? typeName;
  String? imageLink;

  factory Cart.fromJson(Map<String, dynamic> json) => Cart(
        cartId: json["cartId"] == null ? null : json["cartId"],
        userId: json["userId"] == null ? null : json["userId"],
        roleId: json["roleId"] == null ? null : json["roleId"],
        productId: json["productId"] == null ? null : json["productId"],
        unitTypeId: json["unitTypeId"] == null ? null : json["unitTypeId"],
        productUnittype:
            json["productUnittype"] == null ? null : json["productUnittype"],
        quantity: json["quantity"] == null ? null : json["quantity"],
        price: json["price"] == null ? null : json["price"],
        createdTime: json["createdTime"] == null ? null : json["createdTime"],
        updatedTime: json["updatedTime"] == null ? null : json["updatedTime"],
        hsnCode: json["hsnCode"] == null ? null : json["hsnCode"],
        productCode: json["productCode"] == null ? null : json["productCode"],
        categoryId: json["categoryId"] == null ? null : json["categoryId"],
        productName: json["productName"] == null ? null : json["productName"],
        productImage:
            json["productImage"] == null ? null : json["productImage"],
        availableQuantity: json["availableQuantity"] == null
            ? null
            : json["availableQuantity"],
        referenceBook:
            json["referenceBook"] == null ? null : json["referenceBook"],
        dosage: json["dosage"] == null ? null : json["dosage"],
        productUsage:
            json["productUsage"] == null ? null : json["productUsage"],
        indication: json["indication"] == null ? null : json["indication"],
        presentation:
            json["presentation"] == null ? null : json["presentation"],
        productType: json["productType"] == null ? null : json["productType"],
        usefullFor: json["usefullFor"] == null ? null : json["usefullFor"],
        productCgst: json["productCgst"] == null ? null : json["productCgst"],
        productSgst: json["productSgst"] == null ? null : json["productSgst"],
        productUtgst:
            json["productUtgst"] == null ? null : json["productUtgst"],
        productIgst: json["productIgst"] == null ? null : json["productIgst"],
        typeId: json["typeId"] == null ? null : json["typeId"],
        typeName: json["typeName"] == null ? null : json["typeName"],
        imageLink: json["image_link"] == null ? null : json["image_link"],
      );

  Map<String, dynamic> toJson() => {
        "cartId": cartId == null ? null : cartId,
        "userId": userId == null ? null : userId,
        "roleId": roleId == null ? null : roleId,
        "productId": productId == null ? null : productId,
        "unitTypeId": unitTypeId == null ? null : unitTypeId,
        "productUnittype": productUnittype == null ? null : productUnittype,
        "quantity": quantity == null ? null : quantity,
        "price": price == null ? null : price,
        "createdTime": createdTime == null ? null : createdTime,
        "updatedTime": updatedTime == null ? null : updatedTime,
        "hsnCode": hsnCode == null ? null : hsnCode,
        "productCode": productCode == null ? null : productCode,
        "categoryId": categoryId == null ? null : categoryId,
        "productName": productName == null ? null : productName,
        "productImage": productImage == null ? null : productImage,
        "availableQuantity":
            availableQuantity == null ? null : availableQuantity,
        "referenceBook": referenceBook == null ? null : referenceBook,
        "dosage": dosage == null ? null : dosage,
        "productUsage": productUsage == null ? null : productUsage,
        "indication": indication == null ? null : indication,
        "presentation": presentation == null ? null : presentation,
        "productType": productType == null ? null : productType,
        "usefullFor": usefullFor == null ? null : usefullFor,
        "productCgst": productCgst == null ? null : productCgst,
        "productSgst": productSgst == null ? null : productSgst,
        "productUtgst": productUtgst == null ? null : productUtgst,
        "productIgst": productIgst == null ? null : productIgst,
        "typeId": typeId == null ? null : typeId,
        "typeName": typeName == null ? null : typeName,
        "image_link": imageLink == null ? null : imageLink,
      };
}

class Total {
  Total({
    this.title,
    this.value,
  });

  String? title;
  String? value;

  factory Total.fromJson(Map<String, dynamic> json) => Total(
        title: json["title"] == null ? null : json["title"],
        value: json["value"] == null ? null : json["value"],
      );

  Map<String, dynamic> toJson() => {
        "title": title == null ? null : title,
        "value": value == null ? null : value,
      };
}
