import 'package:drssiddha/app/pages/home/drs_siddha_groups/about_food_tech.dart';
import 'package:drssiddha/app/pages/home/drs_siddha_groups/accreditation_and_certificate.dart';
import 'package:drssiddha/app/pages/home/drs_siddha_groups/core_team.dart';
import 'package:drssiddha/app/pages/home/drs_siddha_groups/manufacture_process.dart';
import 'package:drssiddha/app/pages/home/drs_siddha_groups/reviews.dart';
import 'package:drssiddha/app/pages/home/join_as/clinic_partner.dart';
import 'package:drssiddha/app/pages/home/join_as/join_vendor.dart';
import 'package:drssiddha/app/pages/home/join_as/part_drs_siddha.dart';
import 'package:drssiddha/app/pages/home/news_events/events.dart';
import 'package:drssiddha/app/pages/home/why_drs_siddha/benefits.dart';
import 'package:drssiddha/app/pages/home/why_drs_siddha/concept_clinic.dart';
import 'package:drssiddha/app/pages/home/why_drs_siddha/exclusive_offer.dart';
import 'package:drssiddha/app/pages/login/forgot_password.dart';
import 'package:drssiddha/app/pages/login/login.dart';
import 'package:drssiddha/app/pages/home/drs_siddha_groups/about_us.dart';
import 'package:drssiddha/app/provider/cart_provider.dart';
import 'package:drssiddha/locator.dart';
import 'package:firebase_analytics/firebase_analytics.dart';
import 'package:firebase_analytics/observer.dart';
import 'package:flutter/material.dart';
import 'package:drssiddha/app/pages/home/home.dart';
import 'package:provider/provider.dart';
import 'package:drssiddha/app/provider/auth_provider.dart';


GlobalKey<NavigatorState> navigatorKey = GlobalKey<NavigatorState>();
class AnalyticsService {
  final FirebaseAnalytics _analytics = FirebaseAnalytics();

  FirebaseAnalyticsObserver getAnalyticsObserver() =>
      FirebaseAnalyticsObserver(analytics: _analytics);

  // User properties tells us what the user is
  Future setUserProperties({@required String? userId, String? userRole}) async {
    await _analytics.setUserId(userId);
    await _analytics.setUserProperty(name: 'name', value: userRole);
    // property to indicate if it's a pro paying member
    // property that might tell us it's a regular poster, etc
  }

  Future logLogin() async {
    await _analytics.logLogin(loginMethod: 'email');
  }

  Future<void> _testSetCurrentScreen(String screenName, String screenClass) async {
    await _analytics.setCurrentScreen(
      screenName: screenName,
      screenClassOverride: screenClass,
    );
  }

  Future logSignUp() async {
    await _analytics.logSignUp(signUpMethod: 'email');
  }

  /* Future logPostCreated({bool hasImage}) async {
    await _analytics.logEvent(
      name: 'create_post',
      parameters: {'has_image': hasImage},
    );
  } */
}
class NavigationService {
  final GlobalKey<NavigatorState> navigatorKey =
      new GlobalKey<NavigatorState>();

  Future<dynamic> navigateTo(String routeName) {
    return navigatorKey.currentState!.pushNamed(routeName);
  }

  /* bool?? goBack() {
    return navigatorKey.currentState!.pop();
  } */
}


class AuthFlow extends StatefulWidget {
  static const primaryValue = 0xFF004023;
  // static const primaryValue = 0xFF699e01;

  @override
  _AuthFlowState createState() => _AuthFlowState();
}

//class AuthFlow extends StatelessWidget {
class _AuthFlowState extends State<AuthFlow> {
  static const primaryValue = 0xFF003C22;

  static FirebaseAnalytics analytics = FirebaseAnalytics();
  static FirebaseAnalyticsObserver observer =
      FirebaseAnalyticsObserver(analytics: analytics);


  final AnalyticsService _analyticsService = locator<AnalyticsService>();
          
  Route routes(RouteSettings settings) {
    if (settings.name == "/") {
      _analyticsService._testSetCurrentScreen('HomePage','HomePage');
      return MaterialPageRoute(
        builder: (_) => HomePage(),
      );
    } else if (settings.name == "/coreTeam") {
      _analyticsService._testSetCurrentScreen('CoreTeamPage','CoreTeamPage');
      return MaterialPageRoute(
        builder: (_) => CoreTeamPage(),
      );
    } else if (settings.name == "/envents") {
      _analyticsService._testSetCurrentScreen('EventsPage','EventsPage');
      return MaterialPageRoute(
        builder: (_) => EventsPage(),
      );
    } else if (settings.name == "/forgotPassword") {
      _analyticsService._testSetCurrentScreen('ForgotPasswordPage','ForgotPasswordPage');
      return MaterialPageRoute(
        builder: (_) => ForgotPasswordPage(),
      );
    } else if (settings.name == "/concept_clinic") {
      _analyticsService._testSetCurrentScreen('ConceptClinicPage','ConceptClinicPage');
      return MaterialPageRoute(
        builder: (_) => ConceptClinicPage(),
      );
    } else if (settings.name == "/execlusive_offer") {
      _analyticsService._testSetCurrentScreen('ExclusiveOfferPage','ExclusiveOfferPage');
      return MaterialPageRoute(
        builder: (_) => ExclusiveOfferPage(),
      );
    } else if (settings.name == "/benefits") {
      _analyticsService._testSetCurrentScreen('BenefitsPage','BenefitsPage');
      return MaterialPageRoute(
        builder: (_) => BenefitsPage(),
      );
    } else if (settings.name == "/partner_drs") {
      _analyticsService._testSetCurrentScreen('DRSPartnerPage','DRSPartnerPage');
      return MaterialPageRoute(
        builder: (_) => DRSPartnerPage(),
      );
    } else if (settings.name == "/clinicpartner") {
      _analyticsService._testSetCurrentScreen('ClinicPartnerPage','ClinicPartnerPage');
      return MaterialPageRoute(
        builder: (_) => ClinicPartnerPage(),
      );
    } else if (settings.name == "/join_vendor") {
      _analyticsService._testSetCurrentScreen('JoinAsVendorPage','JoinAsVendorPage');
      return MaterialPageRoute(
        builder: (_) => JoinAsVendorPage(),
      );
    } else if (settings.name == "/manufactureProcess") {
      _analyticsService._testSetCurrentScreen('ManufactureProcessPage','ManufactureProcessPage');
      return MaterialPageRoute(
        builder: (_) => ManufactureProcessPage(),
      );
    } else if (settings.name == "/reviews") {
      _analyticsService._testSetCurrentScreen('ReviewsPage','ReviewsPage');
      return MaterialPageRoute(
        builder: (_) => ReviewsPage(),
      );
    } else if (settings.name == "/certificate") {
      _analyticsService._testSetCurrentScreen('AcceriditationPage','AcceriditationPage');
      return MaterialPageRoute(
        builder: (_) => AcceriditationPage(),
      );
    } else if (settings.name == "/aboutFoodTech") {
      _analyticsService._testSetCurrentScreen('AboutUsFoodTechPage','AboutUsFoodTechPage');
      return MaterialPageRoute(
        builder: (_) => AboutUsFoodTechPage(),
      );
    } else if (settings.name == "/aboutUs") {
      _analyticsService._testSetCurrentScreen('AboutUs Page','AboutUsPage');
      return MaterialPageRoute(
        builder: (_) => AboutUsPage(),
      );
    } else if (settings.name == "/login") {
      _analyticsService._testSetCurrentScreen('Login Page','LoginPage');
      return MaterialPageRoute(
        builder: (_) => LoginPage(),
      );
    } else if (settings.name == "/home") {
      _analyticsService._testSetCurrentScreen('HomePage','HomePage');
      return MaterialPageRoute(
        builder: (_) => HomePage(),
      );
    } else if (settings.name!.startsWith("/productDetail")) {
      try {
        String id = settings.name!.split("/")[2];
        _analyticsService._testSetCurrentScreen('Product Detail Page - '+id,'ProductDetail');
        /* return MaterialPageRoute(
          builder: (_) => ProductDetail(id),
        ); */
        return MaterialPageRoute(
          builder: (_) => HomePage(),
        );
      } catch (e) {
        _analyticsService._testSetCurrentScreen('HomePage','HomePage');
        return MaterialPageRoute(
          builder: (_) => HomePage(),
        );
      }
    } else {
      _analyticsService._testSetCurrentScreen('Home Page','homepage');
      return MaterialPageRoute(
        builder: (_) => HomePage(),
      );
    }
  }

  @override
  Widget build(BuildContext context) {
    return new MultiProvider(
      providers: [
        ChangeNotifierProvider.value(value: AuthProvider()),
        ChangeNotifierProvider.value(value: CartProvider()),
      ],
      child: MaterialApp(
        navigatorKey: locator<NavigationService>().navigatorKey,
        //navigatorKey: navigatorKey,
        initialRoute: "/",
        onGenerateRoute: routes,
        debugShowCheckedModeBanner: false,
        title: 'Dr\'s.Siddha',
        theme: ThemeData(
          fontFamily: 'SF Pro Display',
          primaryColor: Color(primaryValue),
        ),
        navigatorObservers: [locator<AnalyticsService>().getAnalyticsObserver()],
        home: new LoginPage(),
        routes: <String, WidgetBuilder>{
          '/home': (BuildContext context) => HomePage(),
          '/login': (BuildContext context) => LoginPage(),
          // '/register': (BuildContext context) => BecomeMemberPage(),
          '/aboutUs': (BuildContext context) => AboutUsPage(),
          '/aboutFoodTech': (BuildContext context) => AboutUsFoodTechPage(),
          '/certificate': (BuildContext context) => AcceriditationPage(),
          '/reviews': (BuildContext context) => ReviewsPage(),
          '/manufactureProcess': (BuildContext context) =>
              ManufactureProcessPage(),
          '/join_vendor': (BuildContext context) => JoinAsVendorPage(),
          '/clinicpartner': (BuildContext context) => ClinicPartnerPage(),
          '/partner_drs': (BuildContext context) => DRSPartnerPage(),
          '/benefits': (BuildContext context) => BenefitsPage(),
          '/execlusive_offer': (BuildContext context) => ExclusiveOfferPage(),
          '/concept_clinic': (BuildContext context) => ConceptClinicPage(),
          '/forgotPassword': (BuildContext context) => ForgotPasswordPage(),
          '/envents': (BuildContext context) => EventsPage(),
          '/coreTeam': (BuildContext context) => CoreTeamPage(),
        },
      ),
    );
  }
}
